/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.parser.JavaParser;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.UnresolvedEntity;
import bluej.parser.lexer.LocatableToken;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CodepadImportParser
extends JavaParser {
    private EntityResolver resolver;
    private boolean importIsStatic = false;
    private boolean importIsWildcard = false;
    private JavaEntity importEntity;
    private String memberName;

    public CodepadImportParser(EntityResolver resolver, Reader r) {
        super(r);
        this.resolver = resolver;
    }

    public boolean isStaticImport() {
        return this.importIsStatic;
    }

    public boolean isWildcardImport() {
        return this.importIsWildcard;
    }

    public JavaEntity getImportEntity() {
        return this.importEntity;
    }

    public String getMemberName() {
        return this.memberName;
    }

    @Override
    protected void gotImport(List<LocatableToken> tokens, boolean isStatic) {
        this.importIsStatic = isStatic;
        if (isStatic) {
            int newSize;
            this.memberName = tokens.get(newSize + 1).getText();
            ArrayList<LocatableToken> newList = new ArrayList<LocatableToken>(newSize);
            Iterator<LocatableToken> i = tokens.iterator();
            for (newSize = tokens.size() - 2; newSize > 0; --newSize) {
                newList.add(i.next());
            }
            tokens = newList;
        } else {
            this.memberName = tokens.get(tokens.size() - 1).getText();
        }
        this.importEntity = this.getEntityForTokens(tokens);
    }

    @Override
    protected void gotWildcardImport(List<LocatableToken> tokens, boolean isStatic) {
        this.importEntity = this.getEntityForTokens(tokens);
        this.importIsWildcard = true;
        this.importIsStatic = isStatic;
    }

    protected JavaEntity getEntityForTokens(List<LocatableToken> tokens) {
        JavaEntity entity;
        Iterator<LocatableToken> i = tokens.iterator();
        String name = i.next().getText();
        for (entity = UnresolvedEntity.getEntity(this.resolver, name, null); entity != null && i.hasNext(); entity = entity.getSubentity(name, null)) {
            i.next();
            name = i.next().getText();
        }
        return entity;
    }
}

