/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.lexer;

import bluej.parser.EscapedUnicodeReader;
import bluej.parser.TokenStream;
import bluej.parser.lexer.LocatableToken;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public final class JavaLexer
implements TokenStream {
    private StringBuffer textBuffer;
    private EscapedUnicodeReader reader;
    private int rChar;
    private int beginColumn;
    private int beginLine;
    private int beginPosition;
    private int endColumn;
    private int endLine;
    private int endPosition;
    private boolean generateWhitespaceTokens = false;
    private static Map<String, Integer> keywords = new HashMap<String, Integer>();

    public JavaLexer(Reader in) {
        this(in, 1, 1, 0);
    }

    public JavaLexer(Reader in, int line, int col, int position) {
        this.reader = new EscapedUnicodeReader(in);
        this.reader.setLineColPos(line, col, position);
        this.endColumn = this.beginColumn = col;
        this.endLine = this.beginLine = line;
        this.endPosition = this.beginPosition = position;
        try {
            this.rChar = this.reader.read();
        }
        catch (IOException ioe) {
            this.rChar = -1;
        }
    }

    @Override
    public LocatableToken nextToken() {
        this.textBuffer = new StringBuffer();
        if (this.generateWhitespaceTokens && Character.isWhitespace((char)this.rChar)) {
            StringBuilder whitespaceBuffer = new StringBuilder();
            while (Character.isWhitespace((char)this.rChar)) {
                whitespaceBuffer.append((char)this.rChar);
                this.readNextChar();
            }
            return this.makeToken(167, whitespaceBuffer.toString());
        }
        while (Character.isWhitespace((char)this.rChar)) {
            this.beginLine = this.reader.getLine();
            this.beginColumn = this.reader.getColumn();
            this.beginPosition = this.reader.getPosition();
            this.readNextChar();
        }
        if (this.rChar == -1) {
            return this.makeToken(1, null);
        }
        char nextChar = (char)this.rChar;
        if (Character.isJavaIdentifierStart(nextChar)) {
            return this.createWordToken(nextChar);
        }
        if (Character.isDigit(nextChar)) {
            return this.makeToken(this.readDigitToken(nextChar, false), this.textBuffer.toString());
        }
        return this.makeToken(this.getSymbolType(nextChar), this.textBuffer.toString());
    }

    private LocatableToken makeToken(int type, String txt) {
        LocatableToken tok = new LocatableToken(type, txt);
        tok.setPosition(this.beginLine, this.beginColumn, this.endLine, this.endColumn, this.beginPosition, this.endPosition - this.beginPosition);
        this.beginColumn = this.endColumn;
        this.beginLine = this.endLine;
        this.beginPosition = this.endPosition;
        return tok;
    }

    private LocatableToken createWordToken(char nextChar) {
        this.populateTextBuffer(nextChar);
        return this.makeToken(this.getWordType(), this.textBuffer.toString());
    }

    private void populateTextBuffer(char ch) {
        int rval;
        char thisChar = ch;
        do {
            this.textBuffer.append(thisChar);
            rval = this.readNextChar();
            if (rval != -1) continue;
            return;
        } while (Character.isJavaIdentifierPart(thisChar = (char)rval));
    }

    private boolean getTokenText(char endChar) {
        char thisChar = endChar;
        int rval = 0;
        boolean complete = false;
        boolean escape = false;
        while (!complete) {
            rval = this.readNextChar();
            if (rval == -1) {
                return false;
            }
            thisChar = (char)rval;
            if (thisChar == '\n') {
                return false;
            }
            this.textBuffer.append(thisChar);
            if (!escape) {
                if (thisChar == '\\') {
                    escape = true;
                }
                if (thisChar != endChar) continue;
                this.readNextChar();
                return true;
            }
            escape = false;
        }
        return complete;
    }

    private boolean isHexDigit(char ch) {
        if (Character.isDigit(ch)) {
            return true;
        }
        if (ch >= 'a' && ch <= 'f') {
            return true;
        }
        return ch >= 'A' && ch <= 'F';
    }

    private int readDigitToken(char ch, boolean dot) {
        int rval = ch;
        this.textBuffer.append((char)ch);
        int type = dot ? 164 : 159;
        boolean fpValid = true;
        if (ch == 48) {
            rval = this.readNextChar();
            if (rval == 120 || rval == 88) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
                if (!this.isHexDigit((char)rval)) {
                    return 173;
                }
                do {
                    this.textBuffer.append((char)rval);
                } while (this.isHexDigit((char)(rval = this.readNextChar())) || rval == 95);
                fpValid = false;
            } else if (rval == 98 || rval == 66) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
                if (rval != 48 && rval != 49) {
                    return 173;
                }
                do {
                    this.textBuffer.append((char)rval);
                } while ((rval = this.readNextChar()) == 48 || rval == 49 || rval == 95);
                fpValid = false;
            } else if (Character.isDigit((char)rval)) {
                do {
                    this.textBuffer.append((char)rval);
                } while (Character.isDigit((char)(rval = this.readNextChar())) || rval == 95);
                fpValid = false;
            }
            ch = (char)rval;
        } else {
            rval = this.readNextChar();
            while (Character.isDigit((char)rval) || rval == 95) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
            }
        }
        if (rval == 46 && fpValid) {
            this.textBuffer.append((char)rval);
            rval = this.readNextChar();
            while (Character.isDigit((char)rval) || rval == 95) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
            }
            if (rval == 101 || rval == 69) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
                while (Character.isDigit((char)rval) || rval == 95) {
                    this.textBuffer.append((char)rval);
                    rval = this.readNextChar();
                }
            }
            if (rval == 102 || rval == 70) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
                return 162;
            }
            if (rval == 100 || rval == 68) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
            }
            return 164;
        }
        if ((rval == 101 || rval == 69) && fpValid) {
            this.textBuffer.append((char)rval);
            rval = this.readNextChar();
            while (Character.isDigit((char)rval) || rval == 95) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
            }
            type = 164;
        } else if (rval == 108 || rval == 76) {
            this.textBuffer.append((char)rval);
            rval = this.readNextChar();
            return 163;
        }
        if (fpValid) {
            if (rval == 102 || rval == 70) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
                return 162;
            }
            if (rval == 100 || rval == 68) {
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
                return 164;
            }
        }
        return type;
    }

    private int getMLCommentType(char ch) {
        block0: while (true) {
            this.textBuffer.append(ch);
            int rval = this.readNextChar();
            if (rval == -1) {
                return 173;
            }
            ch = (char)rval;
            while (true) {
                if (ch != '*') continue block0;
                this.textBuffer.append((char)rval);
                rval = this.readNextChar();
                if (rval == -1) {
                    return 173;
                }
                if (rval == 47) {
                    this.textBuffer.append((char)rval);
                    this.readNextChar();
                    return 61;
                }
                ch = (char)rval;
            }
            break;
        }
    }

    private int getSLCommentType(char ch) {
        int rval = 0;
        do {
            this.textBuffer.append(ch);
        } while ((rval = this.readNextChar()) != -1 && rval != 10);
        return 166;
    }

    private int getSymbolType(char ch) {
        int type = 173;
        this.textBuffer.append(ch);
        if ('\"' == ch) {
            return this.getStringLiteral();
        }
        if ('\'' == ch) {
            return this.getCharLiteral();
        }
        if ('?' == ch) {
            this.readNextChar();
            return 70;
        }
        if (',' == ch) {
            this.readNextChar();
            return 74;
        }
        if (';' == ch) {
            this.readNextChar();
            return 63;
        }
        if (':' == ch) {
            this.readNextChar();
            return 110;
        }
        if ('^' == ch) {
            return this.getBXORType();
        }
        if ('~' == ch) {
            this.readNextChar();
            return 153;
        }
        if ('(' == ch) {
            this.readNextChar();
            return 96;
        }
        if (')' == ch) {
            this.readNextChar();
            return 97;
        }
        if ('[' == ch) {
            this.readNextChar();
            return 66;
        }
        if (']' == ch) {
            this.readNextChar();
            return 67;
        }
        if ('{' == ch) {
            this.readNextChar();
            return 99;
        }
        if ('}' == ch) {
            this.readNextChar();
            return 100;
        }
        if ('@' == ch) {
            this.readNextChar();
            return 95;
        }
        if ('&' == ch) {
            return this.getAndType();
        }
        if ('|' == ch) {
            return this.getOrType();
        }
        if ('!' == ch) {
            return this.getExclamationType();
        }
        if ('+' == ch) {
            return this.getPlusType();
        }
        if ('-' == ch) {
            return this.getMinusType();
        }
        if ('=' == ch) {
            return this.getEqualType();
        }
        if ('%' == ch) {
            return this.getModType();
        }
        if ('/' == ch) {
            return this.getForwardSlashType();
        }
        if ('.' == ch) {
            return this.getDotToken();
        }
        if ('*' == ch) {
            return this.getStarType();
        }
        if ('>' == ch) {
            return this.getGTType();
        }
        if ('<' == ch) {
            return this.getLTType();
        }
        this.readNextChar();
        return type;
    }

    private int getBXORType() {
        char[] validChars = new char[]{'='};
        int rval = this.readNextChar();
        if (rval != 61) {
            return 140;
        }
        char thisChar = (char)rval;
        this.textBuffer.append(thisChar);
        this.readNextChar();
        return 135;
    }

    private int getAndType() {
        char[] validChars = new char[]{'=', '&'};
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 134;
        }
        if (thisChar == '&') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 138;
        }
        return 104;
    }

    private int getStringLiteral() {
        boolean success = this.getTokenText('\"');
        if (success) {
            return 161;
        }
        return 173;
    }

    private int getCharLiteral() {
        boolean success = this.getTokenText('\'');
        if (success) {
            return 160;
        }
        return 173;
    }

    private int getOrType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 136;
        }
        if (thisChar == '|') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 137;
        }
        return 139;
    }

    private int getPlusType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 126;
        }
        if (thisChar == '+') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 151;
        }
        return 147;
    }

    private int getMinusType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 127;
        }
        if (thisChar == '-') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 152;
        }
        if (thisChar == '>') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 172;
        }
        return 148;
    }

    private int getEqualType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 142;
        }
        return 98;
    }

    private int getStarType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 128;
        }
        return 87;
    }

    private int getModType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 130;
        }
        return 150;
    }

    private int getForwardSlashType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 129;
        }
        if (thisChar == '/') {
            return this.getSLCommentType(thisChar);
        }
        if (thisChar == '*') {
            return this.getMLCommentType(thisChar);
        }
        return 149;
    }

    private int getGTType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 144;
        }
        if (thisChar == '>') {
            this.textBuffer.append(thisChar);
            rval = this.readNextChar();
            thisChar = (char)rval;
            if (thisChar == '>') {
                this.textBuffer.append(thisChar);
                rval = this.readNextChar();
                thisChar = (char)rval;
                if (thisChar == '=') {
                    this.textBuffer.append(thisChar);
                    this.readNextChar();
                    return 132;
                }
                return 77;
            }
            if (thisChar == '=') {
                this.textBuffer.append(thisChar);
                this.readNextChar();
                return 131;
            }
            return 76;
        }
        return 75;
    }

    private int getLTType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 143;
        }
        if (thisChar == '<') {
            this.textBuffer.append(thisChar);
            rval = this.readNextChar();
            thisChar = (char)rval;
            if (thisChar == '=') {
                this.textBuffer.append(thisChar);
                this.readNextChar();
                return 133;
            }
            return 146;
        }
        return 73;
    }

    private int getExclamationType() {
        int rval = this.readNextChar();
        char thisChar = (char)rval;
        if (thisChar == '=') {
            this.textBuffer.append(thisChar);
            this.readNextChar();
            return 141;
        }
        return 154;
    }

    private int getDotToken() {
        int rval = this.readNextChar();
        char ch = (char)rval;
        if (Character.isDigit(ch)) {
            return this.readDigitToken(ch, true);
        }
        if (ch == '.') {
            this.textBuffer.append(ch);
            rval = this.readNextChar();
            if (rval == -1) {
                return 173;
            }
            ch = (char)rval;
            if (ch == '.') {
                this.textBuffer.append(ch);
                this.readNextChar();
                return 109;
            }
            return 173;
        }
        return 68;
    }

    private int readNextChar() {
        this.endColumn = this.reader.getColumn();
        this.endLine = this.reader.getLine();
        this.endPosition = this.reader.getPosition();
        try {
            this.rChar = this.reader.read();
        }
        catch (IOException e) {
            this.rChar = -1;
        }
        return this.rChar;
    }

    private int getWordType() {
        String text = this.textBuffer.toString();
        Integer i = keywords.get(text);
        if (i == null) {
            return 69;
        }
        return i;
    }

    public void setGenerateWhitespaceTokens(boolean generateWhitespaceTokens) {
        this.generateWhitespaceTokens = generateWhitespaceTokens;
    }

    static {
        keywords.put("abstract", 40);
        keywords.put("assert", 120);
        keywords.put("boolean", 79);
        keywords.put("break", 115);
        keywords.put("byte", 80);
        keywords.put("case", 122);
        keywords.put("catch", 125);
        keywords.put("char", 81);
        keywords.put("class", 101);
        keywords.put("continue", 116);
        keywords.put("default", 105);
        keywords.put("do", 114);
        keywords.put("double", 86);
        keywords.put("else", 112);
        keywords.put("enum", 103);
        keywords.put("extends", 71);
        keywords.put("false", 156);
        keywords.put("final", 39);
        keywords.put("finally", 124);
        keywords.put("float", 84);
        keywords.put("for", 121);
        keywords.put("goto", 171);
        keywords.put("if", 111);
        keywords.put("implements", 106);
        keywords.put("import", 64);
        keywords.put("instanceof", 145);
        keywords.put("int", 83);
        keywords.put("interface", 102);
        keywords.put("long", 85);
        keywords.put("native", 92);
        keywords.put("new", 158);
        keywords.put("null", 157);
        keywords.put("package", 62);
        keywords.put("private", 88);
        keywords.put("protected", 90);
        keywords.put("public", 89);
        keywords.put("return", 117);
        keywords.put("short", 82);
        keywords.put("static", 65);
        keywords.put("strictfp", 41);
        keywords.put("super", 72);
        keywords.put("switch", 118);
        keywords.put("synchronized", 93);
        keywords.put("this", 107);
        keywords.put("throw", 119);
        keywords.put("throws", 108);
        keywords.put("transient", 91);
        keywords.put("true", 155);
        keywords.put("try", 123);
        keywords.put("volatile", 94);
        keywords.put("while", 113);
        keywords.put("void", 78);
    }
}

