/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.target.DependentTarget;
import java.util.Comparator;

public class LayoutComparer
implements Comparator<Dependency> {
    DependentTarget centre;
    boolean in;

    public LayoutComparer(DependentTarget centre, boolean in) {
        this.centre = centre;
        this.in = in;
    }

    @Override
    public int compare(Dependency a, Dependency b) {
        DependentTarget ta = this.in ? a.getFrom() : a.getTo();
        DependentTarget tb = this.in ? b.getFrom() : b.getTo();
        int ax = ta.getX() + ta.getWidth() / 2;
        int ay = ta.getY() + ta.getHeight() / 2;
        int bx = tb.getX() + tb.getWidth() / 2;
        int by = tb.getY() + tb.getHeight() / 2;
        if (ax == bx && ay == by) {
            return 0;
        }
        int cx = this.centre.getX() + this.centre.getWidth() / 2;
        int cy = this.centre.getY() + this.centre.getHeight() / 2;
        return this.compare(ax, ay, bx, by, cx, cy);
    }

    protected int compare(int ax, int ay, int bx, int by, int cx, int cy) {
        boolean b_left;
        boolean b_above;
        int b_quad;
        boolean a_left;
        boolean a_above = ay < cy;
        int a_quad = (a_above ? 0 : 2) + ((a_left = ax < cx) ? 0 : 1);
        if (a_quad != (b_quad = ((b_above = by < cy) ? 0 : 2) + ((b_left = bx < cx) ? 0 : 1))) {
            return a_quad > b_quad ? 1 : -1;
        }
        int x_comp = new Integer(ax).compareTo(bx);
        int y_comp = new Integer(ay).compareTo(by);
        if (this.in) {
            if (x_comp != 0) {
                return x_comp;
            }
            return y_comp;
        }
        if (y_comp != 0) {
            return y_comp;
        }
        return x_comp;
    }
}

