/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.classmgr.ClassMgrPrefPanel;
import bluej.editor.moe.EditorPrefPanel;
import bluej.editor.moe.KeyBindingsPanel;
import bluej.extmgr.ExtensionPrefManager;
import bluej.extmgr.ExtensionsManager;
import bluej.prefmgr.InterfacePanel;
import bluej.prefmgr.MiscPrefPanel;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PrefMgrDialog
extends JFrame {
    private static PrefMgrDialog dialog = null;
    private boolean prepared = false;
    private KeyBindingsPanel kbPanel;
    private ArrayList<PrefPanelListener> listeners = new ArrayList();
    private ArrayList<JPanel> tabs = new ArrayList();
    private ArrayList<String> titles = new ArrayList();
    private JTabbedPane tabbedPane = null;
    private ClassMgrPrefPanel userConfigLibPanel;

    public static void showDialog() {
        PrefMgrDialog.getInstance().prepareDialog();
        dialog.setVisible(true);
    }

    public static void showDialog(int paneNumber) {
        dialog.prepareDialog();
        dialog.selectTab(paneNumber);
        dialog.setVisible(true);
    }

    private synchronized void prepareDialog() {
        if (!this.prepared) {
            this.makeDialog();
            this.prepared = true;
        }
        dialog.startEditing();
    }

    public static final PrefMgrDialog getInstance() {
        if (dialog == null) {
            dialog = new PrefMgrDialog();
        }
        return dialog;
    }

    private PrefMgrDialog() {
        this.createPrefPanes();
    }

    private void createPrefPanes() {
        EditorPrefPanel panel = new EditorPrefPanel();
        this.add((JPanel)panel, Config.getString("prefmgr.edit.prefpaneltitle"), (PrefPanelListener)panel);
        this.kbPanel = new KeyBindingsPanel();
        this.add(this.kbPanel.makePanel(), Config.getString("prefmgr.edit.keybindingstitle"), (PrefPanelListener)this.kbPanel);
        MiscPrefPanel panel2 = new MiscPrefPanel();
        this.add(panel2, Config.getString("prefmgr.misc.prefpaneltitle"), panel2);
        InterfacePanel panel3 = new InterfacePanel();
        this.add(panel3, Config.getString("prefmgr.interface.title"), panel3);
        this.userConfigLibPanel = new ClassMgrPrefPanel();
        this.add(this.userConfigLibPanel, Config.getString("classmgr.prefpaneltitle"), this.userConfigLibPanel);
        if (!Config.isGreenfoot()) {
            ExtensionPrefManager mgr = ExtensionsManager.getInstance().getPrefManager();
            this.add(mgr.getPanel(), Config.getString("extmgr.extensions"), mgr);
        }
    }

    public ClassMgrPrefPanel getUserConfigLibPanel() {
        return this.userConfigLibPanel;
    }

    public void add(JPanel panel, String title, PrefPanelListener listener) {
        this.tabs.add(panel);
        this.listeners.add(listener);
        this.titles.add(title);
    }

    private void startEditing() {
        for (PrefPanelListener ppl : this.listeners) {
            ppl.beginEditing();
        }
    }

    private void selectTab(int tabNumber) {
        this.tabbedPane.setSelectedIndex(tabNumber);
    }

    private void makeDialog() {
        Image icon = BlueJTheme.getIconImage();
        if (icon != null) {
            this.setIconImage(icon);
        }
        this.setTitle(Config.getApplicationName() + ": " + Config.getString("prefmgr.title"));
        this.tabbedPane = new JTabbedPane();
        ListIterator<JPanel> i = this.tabs.listIterator();
        while (i.hasNext()) {
            int index = i.nextIndex();
            JPanel p = i.next();
            this.tabbedPane.addTab(this.titles.get(index), null, p);
        }
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.setBorder(BlueJTheme.dialogBorder);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PrefPanelListener ppl : PrefMgrDialog.this.listeners) {
                    ppl.commitEditing();
                }
                PrefMgrDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PrefPanelListener ppl : PrefMgrDialog.this.listeners) {
                    ppl.revertEditing();
                }
                PrefMgrDialog.this.setVisible(false);
            }
        });
        DialogManager.addOKCancelButtons(buttonPanel, okButton, cancelButton);
        contentPanel.add((Component)this.tabbedPane, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.preferences", PrefMgrDialog.this.getLocation());
            }
        });
        this.setLocation(Config.getLocation("bluej.preferences"));
        this.pack();
    }
}

