/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.light.impl;

import com.pi4j.component.light.LightBase;
import com.pi4j.component.light.LightStateChangeEvent;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;

public class GpioLightComponent
extends LightBase {
    GpioPinDigitalOutput pin = null;
    PinState onState = PinState.HIGH;
    PinState offState = PinState.LOW;
    private GpioPinListenerDigital listener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            if (event.getState() == GpioLightComponent.this.onState) {
                GpioLightComponent.this.notifyListeners(new LightStateChangeEvent(GpioLightComponent.this, true));
            }
            if (event.getState() == GpioLightComponent.this.offState) {
                GpioLightComponent.this.notifyListeners(new LightStateChangeEvent(GpioLightComponent.this, false));
            }
        }
    };

    public GpioLightComponent(GpioPinDigitalOutput pin, PinState onState, PinState offState) {
        this(pin);
        this.onState = onState;
        this.offState = offState;
    }

    public GpioLightComponent(GpioPinDigitalOutput pin) {
        this.pin = pin;
        this.pin.addListener(new GpioPinListener[]{this.listener});
    }

    @Override
    public void on() {
        this.pin.setState(this.onState);
    }

    @Override
    public void off() {
        this.pin.setState(this.offState);
    }

    @Override
    public boolean isOn() {
        return this.pin.isState(this.onState);
    }
}

