/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.sensor;

import com.pi4j.component.ComponentListener;
import com.pi4j.component.ObserveableComponentBase;
import com.pi4j.component.sensor.MotionSensor;
import com.pi4j.component.sensor.MotionSensorChangeEvent;
import com.pi4j.component.sensor.MotionSensorListener;
import java.util.Date;

public abstract class MotionSensorBase
extends ObserveableComponentBase
implements MotionSensor {
    protected Date lastMotionTimestamp = null;
    protected Date lastInactivityTimestamp = null;

    @Override
    public Date getLastMotionTimestamp() {
        return this.lastMotionTimestamp;
    }

    @Override
    public Date getLastInactivityTimestamp() {
        return this.lastInactivityTimestamp;
    }

    @Override
    public abstract boolean isMotionDetected();

    @Override
    public void addListener(MotionSensorListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(MotionSensorListener ... listener) {
        super.removeListener(listener);
    }

    protected synchronized void notifyListeners(MotionSensorChangeEvent event) {
        if (event.isMotionDetected()) {
            this.lastMotionTimestamp = event.timestamp;
        } else {
            this.lastInactivityTimestamp = event.timestamp;
        }
        for (ComponentListener listener : this.listeners) {
            ((MotionSensorListener)listener).onMotionStateChange(event);
        }
    }
}

