/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.sensor.impl;

import com.pi4j.component.sensor.MotionSensor;
import com.pi4j.component.sensor.MotionSensorBase;
import com.pi4j.component.sensor.MotionSensorChangeEvent;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;

public class GpioMotionSensorComponent
extends MotionSensorBase {
    private GpioPinDigitalInput pin = null;
    private PinState motionDetectedState = PinState.HIGH;
    private final MotionSensor sensor = this;
    private GpioPinListenerDigital pinListener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            GpioMotionSensorComponent.this.notifyListeners(new MotionSensorChangeEvent(GpioMotionSensorComponent.this.sensor, event.getState() == GpioMotionSensorComponent.this.motionDetectedState));
        }
    };

    public GpioMotionSensorComponent(GpioPinDigitalInput pin, PinState motionDetectedState) {
        this.pin = pin;
        this.motionDetectedState = motionDetectedState;
        this.pin.addListener(new GpioPinListener[]{this.pinListener});
    }

    public GpioMotionSensorComponent(GpioPinDigitalInput pin) {
        this.pin = pin;
        this.pin.addListener(new GpioPinListener[]{this.pinListener});
    }

    @Override
    public boolean isMotionDetected() {
        return this.pin.isState(this.motionDetectedState);
    }
}

