/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device.access.impl;

import com.pi4j.component.relay.Relay;
import com.pi4j.component.sensor.Sensor;
import com.pi4j.component.sensor.SensorListener;
import com.pi4j.component.sensor.SensorState;
import com.pi4j.component.sensor.SensorStateChangeEvent;
import com.pi4j.component.switches.Switch;
import com.pi4j.component.switches.SwitchListener;
import com.pi4j.component.switches.SwitchStateChangeEvent;
import com.pi4j.device.access.Opener;
import com.pi4j.device.access.OpenerBase;
import com.pi4j.device.access.OpenerLockChangeEvent;
import com.pi4j.device.access.OpenerLockedException;
import com.pi4j.device.access.OpenerState;
import com.pi4j.device.access.OpenerStateChangeEvent;

public class OpenerDevice
extends OpenerBase
implements Opener {
    private Relay relay;
    private Sensor sensor;
    private SensorState openSensorState;
    private Switch lock = null;
    private final OpenerDevice opener = this;
    private SensorListener sensorListener = new SensorListener(){

        @Override
        public void onStateChange(SensorStateChangeEvent event) {
            OpenerState oldState = OpenerDevice.this.getState(event.getOldState());
            OpenerState newState = OpenerDevice.this.getState(event.getNewState());
            OpenerDevice.this.opener.notifyListeners(new OpenerStateChangeEvent(OpenerDevice.this.opener, oldState, newState));
        }
    };
    private SwitchListener lockSwitchListener = new SwitchListener(){

        @Override
        public void onStateChange(SwitchStateChangeEvent event) {
            OpenerDevice.this.opener.notifyListeners(new OpenerLockChangeEvent(OpenerDevice.this.opener, event.getSwitch().isOn()));
        }
    };

    public OpenerDevice(Relay relay, Sensor sensor, SensorState openSensorState) {
        this.relay = relay;
        this.sensor = sensor;
        this.openSensorState = openSensorState;
        this.sensor.addListener(this.sensorListener);
    }

    public OpenerDevice(Relay relay, Sensor sensor, SensorState openSensorState, Switch lock) {
        this(relay, sensor, openSensorState);
        this.lock = lock;
        this.lock.addListener(this.lockSwitchListener);
    }

    @Override
    public void open() throws OpenerLockedException {
        if (this.isLocked()) {
            throw new OpenerLockedException(this);
        }
        if (!this.sensor.isState(this.openSensorState)) {
            this.relay.pulse();
        }
    }

    @Override
    public void close() throws OpenerLockedException {
        if (this.isLocked()) {
            throw new OpenerLockedException(this);
        }
        if (this.sensor.isState(this.openSensorState)) {
            this.relay.pulse();
        }
    }

    @Override
    public OpenerState getState() {
        if (this.sensor.getState().equals((Object)this.openSensorState)) {
            return OpenerState.OPEN;
        }
        return OpenerState.CLOSED;
    }

    @Override
    public boolean isLocked() {
        if (this.lock == null) {
            return false;
        }
        return this.lock.isOn();
    }

    protected OpenerState getState(SensorState sensorState) {
        if (sensorState.equals((Object)this.openSensorState)) {
            return OpenerState.OPEN;
        }
        return OpenerState.CLOSED;
    }
}

