/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html;

import bluej.doclet.doclets.formats.html.ConfigurationImpl;
import bluej.doclet.doclets.formats.html.HtmlDocletWriter;
import bluej.doclet.doclets.internal.toolkit.util.ClassTree;
import bluej.doclet.doclets.internal.toolkit.util.DirectoryManager;
import bluej.doclet.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTreeWriter
extends HtmlDocletWriter {
    protected final ClassTree classtree;

    protected AbstractTreeWriter(ConfigurationImpl configuration, String filename, ClassTree classtree) throws IOException {
        super(configuration, filename);
        this.classtree = classtree;
    }

    protected AbstractTreeWriter(ConfigurationImpl configuration, String path, String filename, ClassTree classtree, PackageDoc pkg) throws IOException {
        super(configuration, path, filename, DirectoryManager.getRelativePath(pkg.name()));
        this.classtree = classtree;
    }

    protected void generateLevelInfo(ClassDoc parent, List list, boolean isEnum) {
        if (list.size() > 0) {
            this.ul();
            for (int i = 0; i < list.size(); ++i) {
                ClassDoc local = (ClassDoc)list.get(i);
                this.printPartialInfo(local);
                this.printExtendsImplements(parent, local);
                this.generateLevelInfo(local, this.classtree.subs(local, isEnum), isEnum);
            }
            this.ulEnd();
        }
    }

    protected void generateTree(List list, String heading) {
        if (list.size() > 0) {
            ClassDoc firstClassDoc = (ClassDoc)list.get(0);
            this.printTreeHeading(heading);
            this.generateLevelInfo((ClassDoc)(!firstClassDoc.isInterface() ? firstClassDoc : null), list, list == this.classtree.baseEnums());
        }
    }

    protected void printExtendsImplements(ClassDoc parent, ClassDoc cd) {
        Object[] interfaces = cd.interfaces();
        if (interfaces.length > (cd.isInterface() ? 1 : 0)) {
            Arrays.sort(interfaces);
            int counter = 0;
            for (int i = 0; i < interfaces.length; ++i) {
                if (parent == interfaces[i] || !interfaces[i].isPublic() && !Util.isLinkable((ClassDoc)interfaces[i], this.configuration())) continue;
                if (counter == 0) {
                    if (cd.isInterface()) {
                        this.print(" (" + this.configuration.getText("doclet.also") + " extends ");
                    } else {
                        this.print(" (implements ");
                    }
                } else {
                    this.print(", ");
                }
                this.printPreQualifiedClassLink(12, (ClassDoc)interfaces[i]);
                ++counter;
            }
            if (counter > 0) {
                this.println(")");
            }
        }
    }

    protected void printPartialInfo(ClassDoc cd) {
        this.li("circle");
        this.printPreQualifiedBoldClassLink(12, cd);
    }

    protected void printTreeHeading(String heading) {
        this.h2();
        this.println(this.configuration.getText(heading));
        this.h2End();
    }

    @Override
    protected void navLinkTree() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Tree");
        this.fontEnd();
        this.navCellEnd();
    }
}

