/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.util;

import bluej.doclet.doclets.internal.toolkit.Configuration;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexBuilder {
    private Map indexmap = new HashMap();
    private boolean noDeprecated;
    private boolean classesOnly;
    protected final Object[] elements;

    public IndexBuilder(Configuration configuration, boolean noDeprecated) {
        this(configuration, noDeprecated, false);
    }

    public IndexBuilder(Configuration configuration, boolean noDeprecated, boolean classesOnly) {
        if (classesOnly) {
            configuration.message.notice("doclet.Building_Index_For_All_Classes", new Object[0]);
        } else {
            configuration.message.notice("doclet.Building_Index", new Object[0]);
        }
        this.noDeprecated = noDeprecated;
        this.classesOnly = classesOnly;
        this.buildIndexMap(configuration.root);
        Set set = this.indexmap.keySet();
        this.elements = set.toArray();
        Arrays.sort(this.elements);
    }

    protected void sortIndexMap() {
        Iterator it = this.indexmap.values().iterator();
        while (it.hasNext()) {
            Collections.sort((List)it.next(), new DocComparator());
        }
    }

    protected void buildIndexMap(RootDoc root) {
        PackageDoc[] packages = root.specifiedPackages();
        ClassDoc[] classes = root.classes();
        if (!this.classesOnly) {
            if (packages.length == 0) {
                HashSet<PackageDoc> set = new HashSet<PackageDoc>();
                for (int i = 0; i < classes.length; ++i) {
                    PackageDoc pd = classes[i].containingPackage();
                    if (pd == null || pd.name().length() <= 0) continue;
                    set.add(pd);
                }
                this.adjustIndexMap((Doc[])set.toArray(packages));
            } else {
                this.adjustIndexMap((Doc[])packages);
            }
        }
        this.adjustIndexMap((Doc[])classes);
        if (!this.classesOnly) {
            for (int i = 0; i < classes.length; ++i) {
                if (!this.shouldAddToIndexMap((Doc)classes[i])) continue;
                this.putMembersInIndexMap(classes[i]);
            }
        }
        this.sortIndexMap();
    }

    protected void putMembersInIndexMap(ClassDoc classdoc) {
        this.adjustIndexMap((Doc[])classdoc.fields());
        this.adjustIndexMap((Doc[])classdoc.methods());
        this.adjustIndexMap((Doc[])classdoc.constructors());
    }

    protected void adjustIndexMap(Doc[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (!this.shouldAddToIndexMap(elements[i])) continue;
            String name = elements[i].name();
            char ch = name.length() == 0 ? (char)'*' : (char)Character.toUpperCase(name.charAt(0));
            Character unicode = new Character(ch);
            ArrayList<Doc> list = (ArrayList<Doc>)this.indexmap.get(unicode);
            if (list == null) {
                list = new ArrayList<Doc>();
                this.indexmap.put(unicode, list);
            }
            list.add(elements[i]);
        }
    }

    protected boolean shouldAddToIndexMap(Doc element) {
        return !this.noDeprecated || element.tags("deprecated").length <= 0;
    }

    public Map getIndexMap() {
        return this.indexmap;
    }

    public List getMemberList(Character index) {
        return (List)this.indexmap.get(index);
    }

    public Object[] elements() {
        return this.elements;
    }

    private class DocComparator
    implements Comparator {
        private DocComparator() {
        }

        public int compare(Object d1, Object d2) {
            String doc2;
            String doc1 = ((Doc)d1).name();
            int compareResult = doc1.compareToIgnoreCase(doc2 = ((Doc)d2).name());
            if (compareResult != 0) {
                return compareResult;
            }
            if (d1 instanceof ProgramElementDoc && d2 instanceof ProgramElementDoc) {
                doc1 = ((ProgramElementDoc)d1).qualifiedName();
                doc2 = ((ProgramElementDoc)d2).qualifiedName();
                return doc1.compareToIgnoreCase(doc2);
            }
            return 0;
        }
    }
}

