/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import com.fourthpass.runtimehelp.a;
import ice.pilots.html4.DDocument;
import ice.scripters.WindowObj;
import ice.scripters.js.TheScripter;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.e;
import org.mozilla.javascript.f;

public class NativeJavaObject
implements Function,
Wrapper,
Scriptable {
    static Method b;
    static Constructor c;
    static Class d;
    private Hashtable e;
    protected f members;
    protected TheScripter scripter;
    protected DynamicObject dynamic;
    protected Object javaObject;
    protected Scriptable parent;
    protected Scriptable prototype;
    private static final Object a;
    public static final byte CONVERSION_NONE = 99;
    public static final byte CONVERSION_NONTRIVIAL = 0;
    public static final byte CONVERSION_TRIVIAL = 1;
    static final int h = 8;
    static final int m = 7;
    static final int k = 6;
    static final int l = 5;
    static final int g = 4;
    static final int i = 3;
    static final int n = 2;
    static final int j = 1;
    static final int f = 0;

    static {
        a = new Object();
    }

    public String toString() {
        return this.javaObject.toString();
    }

    public static void initJSObject() {
    }

    static void a(Object object, Class clazz) {
        Object[] objectArray = new Object[]{object.toString(), NativeJavaMethod.a(clazz)};
        throw Context.reportRuntimeError(Context.a("msg.conversion.not.allowed", objectArray));
    }

    static long a(Object object, Class clazz, long l2, long l3) {
        double d2 = NativeJavaObject.b(object);
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            NativeJavaObject.a(ScriptRuntime.toString(object), clazz);
        }
        if ((d2 = d2 > 0.0 ? Math.floor(d2) : Math.ceil(d2)) < (double)l2 || d2 > (double)l3) {
            NativeJavaObject.a(ScriptRuntime.toString(object), clazz);
        }
        return (long)d2;
    }

    static double b(Object object) {
        Method method;
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Scriptable) {
            if (object instanceof Wrapper) {
                return NativeJavaObject.b(((Wrapper)object).unwrap());
            }
            return ScriptRuntime.toNumber(object);
        }
        double d2 = Double.NaN;
        try {
            method = com.fourthpass.runtimehelp.a.b(object.getClass(), "doubleValue", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        if (method != null) {
            try {
                double d3 = ((Number)method.invoke(object, null)).doubleValue();
                return d3;
            }
            catch (IllegalAccessException illegalAccessException) {
                NativeJavaObject.a(object, Double.TYPE);
            }
            catch (InvocationTargetException invocationTargetException) {
                NativeJavaObject.a(object, Double.TYPE);
            }
        }
        return ScriptRuntime.toNumber(object.toString());
    }

    static Object a(Class clazz, Object object) {
        Class<?> clazz2 = object.getClass();
        if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
            if (clazz2 == ScriptRuntime.CharacterClass) {
                return object;
            }
            return new Character((char)NativeJavaObject.a(object, ScriptRuntime.CharacterClass, 0L, 65535L));
        }
        if (clazz == ScriptRuntime.ObjectClass || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            return clazz2 == ScriptRuntime.DoubleClass ? object : new Double(NativeJavaObject.b(object));
        }
        if (clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE) {
            if (clazz2 == ScriptRuntime.FloatClass) {
                return object;
            }
            double d2 = NativeJavaObject.b(object);
            if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 == 0.0) {
                return new Float((float)d2);
            }
            double d3 = Math.abs(d2);
            if (d3 < (double)1.4E-45f) {
                return new Float(d2 > 0.0 ? 0.0 : -0.0);
            }
            if (d3 > 3.4028234663852886E38) {
                return new Float(d2 > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            }
            return new Float((float)d2);
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            if (clazz2 == ScriptRuntime.IntegerClass) {
                return object;
            }
            return new Integer((int)NativeJavaObject.a(object, ScriptRuntime.IntegerClass, Integer.MIN_VALUE, Integer.MAX_VALUE));
        }
        if (clazz == ScriptRuntime.LongClass || clazz == Long.TYPE) {
            if (clazz2 == ScriptRuntime.LongClass) {
                return object;
            }
            return new Long(NativeJavaObject.a(object, ScriptRuntime.LongClass, Long.MIN_VALUE, Long.MAX_VALUE));
        }
        if (clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE) {
            if (clazz2 == ScriptRuntime.ShortClass) {
                return object;
            }
            return new Short((short)NativeJavaObject.a(object, ScriptRuntime.ShortClass, -32768L, 32767L));
        }
        if (clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE) {
            if (clazz2 == ScriptRuntime.ByteClass) {
                return object;
            }
            return new Byte((byte)NativeJavaObject.a(object, ScriptRuntime.ByteClass, -128L, 127L));
        }
        return new Double(NativeJavaObject.b(object));
    }

    static Object a(Class clazz, Scriptable scriptable) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
            return scriptable;
        }
        try {
            Object[] objectArray = new Object[]{scriptable};
            Object t2 = c.newInstance(objectArray);
            return t2;
        }
        catch (InstantiationException instantiationException) {
            throw new EvaluatorException("error generating JSObject wrapper for ".concat(String.valueOf(scriptable)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EvaluatorException("JSObject constructor doesn't want [Scriptable]!");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EvaluatorException("JSObject constructor is protected/private!");
        }
    }

    public static Object coerceType(Class clazz, Object object) {
        if (object != null && object.getClass() == clazz) {
            return object;
        }
        switch (NativeJavaObject.a(object)) {
            case 1: {
                if (clazz.isPrimitive()) {
                    NativeJavaObject.a(object, clazz);
                }
                return null;
            }
            case 0: {
                if (clazz == ScriptRuntime.StringClass || clazz == ScriptRuntime.ObjectClass) {
                    return "undefined";
                }
                NativeJavaObject.a("undefined", clazz);
                break;
            }
            case 2: {
                if (clazz == Boolean.TYPE || clazz == ScriptRuntime.BooleanClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.a(object, clazz);
                break;
            }
            case 3: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return NativeJavaObject.a(Double.TYPE, object);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.a(clazz, object);
                }
                NativeJavaObject.a(object, clazz);
                break;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
                    if (((String)object).length() == 1) {
                        return new Character(((String)object).charAt(0));
                    }
                    return NativeJavaObject.a(clazz, object);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.a(clazz, object);
                }
                NativeJavaObject.a(object, clazz);
                break;
            }
            case 5: {
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz == ScriptRuntime.ClassClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.a(object, clazz);
                break;
            }
            case 6: 
            case 7: {
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.a(object, clazz);
                    }
                    return NativeJavaObject.a(clazz, object);
                }
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                NativeJavaObject.a(object, clazz);
                break;
            }
            case 8: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.a(object, clazz);
                    }
                    return NativeJavaObject.a(clazz, object);
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                if (clazz.isArray() && object instanceof NativeArray) {
                    NativeArray nativeArray = (NativeArray)object;
                    long l2 = nativeArray.jsGet_length();
                    Class<?> clazz2 = clazz.getComponentType();
                    Object object2 = Array.newInstance(clazz2, (int)l2);
                    int n2 = 0;
                    while ((long)n2 < l2) {
                        try {
                            Array.set(object2, n2, NativeJavaObject.coerceType(clazz2, nativeArray.get(n2, (Scriptable)nativeArray)));
                        }
                        catch (EvaluatorException evaluatorException) {
                            NativeJavaObject.a(object, clazz);
                        }
                        ++n2;
                    }
                    return object2;
                }
                NativeJavaObject.a(object, clazz);
            }
        }
        return object;
    }

    static int a(Object object) {
        if (object == null) {
            return 1;
        }
        if (object == Undefined.instance) {
            return 0;
        }
        if (object instanceof Scriptable) {
            if (object instanceof NativeJavaClass) {
                return 5;
            }
            if (object instanceof NativeJavaArray) {
                return 7;
            }
            if (object instanceof NativeJavaObject) {
                return 6;
            }
            return 8;
        }
        Class<?> clazz = object.getClass();
        if (clazz == ScriptRuntime.StringClass) {
            return 4;
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return 2;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (clazz == ScriptRuntime.ClassClass) {
            return 5;
        }
        if (clazz.isArray()) {
            return 7;
        }
        return 6;
    }

    static int a(Class clazz) {
        if (clazz == Double.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 2;
        }
        if (clazz == Long.TYPE) {
            return 3;
        }
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Short.TYPE) {
            return 5;
        }
        if (clazz == Character.TYPE) {
            return 6;
        }
        if (clazz == Byte.TYPE) {
            return 7;
        }
        if (clazz == Boolean.TYPE) {
            return 99;
        }
        return 8;
    }

    public static int getConversionWeight(Object object, Class clazz) {
        int n2 = NativeJavaObject.a(object);
        int n3 = 99;
        switch (n2) {
            case 0: {
                if (clazz != ScriptRuntime.StringClass && clazz != ScriptRuntime.ObjectClass) break;
                n3 = 1;
                break;
            }
            case 1: {
                if (clazz.isPrimitive()) break;
                n3 = 1;
                break;
            }
            case 2: {
                if (clazz == Boolean.TYPE) {
                    n3 = 1;
                    break;
                }
                if (clazz == ScriptRuntime.BooleanClass) {
                    n3 = 2;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    n3 = 3;
                    break;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                n3 = 4;
                break;
            }
            case 3: {
                if (clazz.isPrimitive()) {
                    if (clazz == Double.TYPE) {
                        n3 = 1;
                        break;
                    }
                    if (clazz == Boolean.TYPE) break;
                    n3 = 1 + NativeJavaObject.a(clazz);
                    break;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    n3 = 9;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    n3 = 10;
                    break;
                }
                if (!ScriptRuntime.NumberClass.isAssignableFrom(clazz)) break;
                n3 = 2;
                break;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass) {
                    n3 = 1;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    n3 = 2;
                    break;
                }
                if (!clazz.isPrimitive() || clazz == Boolean.TYPE) break;
                if (clazz == Character.TYPE) {
                    n3 = 3;
                    break;
                }
                n3 = 4;
                break;
            }
            case 5: {
                if (clazz == ScriptRuntime.ClassClass) {
                    n3 = 1;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    n3 = 3;
                    break;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                n3 = 4;
                break;
            }
            case 6: 
            case 7: {
                if (clazz == ScriptRuntime.StringClass) {
                    n3 = 2;
                    break;
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE) {
                    n3 = n2 == 7 ? 0 : 2 + NativeJavaObject.a(clazz);
                    break;
                }
                Object object2 = object;
                if (object2 instanceof NativeJavaObject) {
                    object2 = ((NativeJavaObject)object2).unwrap();
                }
                if (!clazz.isInstance(object2)) break;
                n3 = 0;
                break;
            }
            case 8: {
                if (object instanceof NativeArray && clazz.isArray()) {
                    n3 = 1;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    n3 = 2;
                    break;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    n3 = 3;
                    break;
                }
                if (!clazz.isPrimitive() && clazz == Boolean.TYPE) break;
                n3 = 3 + NativeJavaObject.a(clazz);
                break;
            }
        }
        return n3;
    }

    public static boolean canConvert(Object object, Class clazz) {
        int n2 = NativeJavaObject.getConversionWeight(object, clazz);
        return n2 < 99;
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.javaObject.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass && this.dynamic != null) {
            return Boolean.TRUE;
        }
        try {
            if (clazz == ScriptRuntime.BooleanClass) {
                Object object = this.b("booleanValue");
                return object;
            }
            if (clazz == ScriptRuntime.NumberClass) {
                Object object = this.b("doubleValue");
                return object;
            }
        }
        catch (JavaScriptException javaScriptException) {
            // empty catch block
        }
        throw Context.reportRuntimeError(Context.a("msg.default.value", null));
    }

    Object b(String string) throws JavaScriptException {
        Function function = this.c(string);
        if (function == null) {
            Object[] objectArray = new Object[]{string, this.javaObject.getClass().getName()};
            throw Context.reportRuntimeError(Context.a("msg.java.conversion.implicit_method", objectArray));
        }
        return this.a(function);
    }

    Object a(Function function) throws JavaScriptException {
        Function function2 = function;
        return function2.call(Context.b(), function2.getParentScope(), this, new Object[0]);
    }

    Function c(String string) {
        Object object = this.get(string, (Scriptable)this);
        if (object instanceof Function) {
            return (Function)object;
        }
        return null;
    }

    public String getClassName() {
        return "JavaObject";
    }

    public Object unwrap() {
        return this.javaObject;
    }

    private Object c(Object object) {
        return this.scripter.wrapDynamicResult(this, object);
    }

    public static Object wrap(Scriptable scriptable, Object object, Class clazz) {
        if (object == null) {
            return object;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz != null && clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return Undefined.instance;
            }
            if (clazz == Character.TYPE) {
                return new Integer(((Character)object).charValue());
            }
            return object;
        }
        if (clazz2 == ScriptRuntime.StringClass || clazz2 == ScriptRuntime.BooleanClass) {
            return object;
        }
        if (clazz2.isArray()) {
            return NativeJavaArray.wrap(scriptable, object);
        }
        if (object instanceof Scriptable) {
            return object;
        }
        if (object instanceof DynamicObject) {
            return TheScripter.currentScripter().getWrap((DynamicObject)object);
        }
        if (object instanceof URL) {
            URL uRL = (URL)object;
            return uRL.toString();
        }
        return new NativeJavaObject(scriptable, object, clazz);
    }

    private void a(Scriptable scriptable) throws JavaScriptException {
        Object[] objectArray = new Object[]{this.toString()};
        throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.isnt.function", objectArray), scriptable);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        this.a(scriptable);
        return null;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object;
        if (objectArray.length == 1 && (object = objectArray[0]) != null) {
            String string = object.toString();
            Object object2 = this.get(string, (Scriptable)this);
            if (object2 == Scriptable.NOT_FOUND) {
                object2 = Undefined.instance;
            }
            return object2;
        }
        this.a(scriptable);
        return null;
    }

    public Object[] getIds() {
        Object[] objectArray = this.members.b(false);
        if (this.dynamic != null) {
            // empty if block
        }
        return objectArray;
    }

    public void setParentScope(Scriptable scriptable) {
        if (scriptable instanceof e) {
            return;
        }
        this.parent = scriptable;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    public Scriptable getPrototype() {
        if (this.prototype == null && this.javaObject.getClass() == ScriptRuntime.StringClass) {
            return ScriptableObject.getClassPrototype(this.parent, "String");
        }
        return this.prototype;
    }

    public void delete(int n2) {
        if (this.dynamic != null) {
            this.dynamic.deleteSlot(n2);
        }
    }

    public void delete(String string) {
        if (this.dynamic != null) {
            this.dynamic.setDynamicValue(string, null, this.scripter.env);
            this.dynamic.deleteSlot(string);
        }
    }

    public boolean hasInstance(Scriptable scriptable) {
        return false;
    }

    public void put(int n2, Scriptable scriptable, Object object) {
        if (this != scriptable && !this.has(n2, (Scriptable)this)) {
            scriptable.put(n2, scriptable, object);
            return;
        }
        if (this.dynamic != null) {
            this.dynamic.setSlot(n2, object, (DynEnv)this.scripter.env);
        }
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n2;
        NativeJavaObject nativeJavaObject;
        if (this != scriptable && !this.has(string, (Scriptable)this)) {
            scriptable.put(string, scriptable, object);
            return;
        }
        if (this.dynamic instanceof DDocument && string.equals("location") && (nativeJavaObject = this.a()) != null) {
            nativeJavaObject.put(string, (Scriptable)nativeJavaObject, object);
        }
        if (this.dynamic != null && (n2 = this.dynamic.setDynamicValue(string, object, this.scripter.env)) != 0) {
            return;
        }
        if (this.members.b(string, false)) {
            try {
                this.members.put(string, this.javaObject, object, false);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dynamic != null) {
            this.dynamic.setSlot(string, object, (DynEnv)this.scripter.env);
        }
    }

    public Object get(int n2, Scriptable scriptable) {
        Object object = Scriptable.NOT_FOUND;
        if (this.dynamic != null) {
            object = this.dynamic.getSlot(n2);
            object = object == DynamicObject.NOT_FOUND ? Scriptable.NOT_FOUND : this.c(object);
        }
        return object;
    }

    private Object a(String string) {
        Object v2;
        if (this.e != null && (v2 = this.e.get(string)) != null) {
            if (v2 instanceof NativeJavaMethod) {
                return ((NativeJavaMethod)v2).getDefaultValue(null);
            }
            return v2;
        }
        return this.members.a(this, string, this.javaObject, false);
    }

    private NativeJavaObject a() {
        for (Scriptable scriptable = this.getParentScope(); scriptable != null; scriptable = scriptable.getParentScope()) {
            Object object = scriptable.get("window", scriptable);
            if (!(object instanceof NativeJavaObject)) continue;
            NativeJavaObject nativeJavaObject = (NativeJavaObject)object;
            if (!(nativeJavaObject.dynamic instanceof WindowObj)) break;
            return nativeJavaObject;
        }
        return null;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object;
        Object object2 = null;
        if (string.equals("Function")) {
            return Scriptable.NOT_FOUND;
        }
        if (this.dynamic != null && !string.equals("Function")) {
            object2 = this.dynamic.getDynamicValue(string);
            if (object2 != DynamicObject.NOT_FOUND) {
                if (object2 == DynamicObject.METHOD_MARK) {
                    return this.scripter.wrapDynamicMethod(this.dynamic, string);
                }
                object2 = this.c(object2);
                return object2;
            }
            object2 = Scriptable.NOT_FOUND;
        }
        if (string.equals("toSource")) {
            return "@toSource() NOT IMPLEMENTED@";
        }
        object2 = this.a(string);
        if (object2 != Scriptable.NOT_FOUND) {
            return object2;
        }
        if (string.length() >= 2 && Character.isLowerCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1)) && (object2 = this.a((String)(object = String.valueOf(Character.toUpperCase(string.charAt(0))).concat(String.valueOf(string.substring(1)))))) != Scriptable.NOT_FOUND) {
            return object2;
        }
        if (this.dynamic != null) {
            object2 = this.dynamic.getSlot(string);
            if (object2 != DynamicObject.NOT_FOUND) {
                object2 = this.c(object2);
                return object2;
            }
            object2 = Scriptable.NOT_FOUND;
        }
        if (object2 == Scriptable.NOT_FOUND && this.dynamic instanceof DDocument && string.equals("location") && (object = this.a()) != null) {
            return ((NativeJavaObject)object).get(string, (Scriptable)object);
        }
        return object2;
    }

    public boolean has(int n2, Scriptable scriptable) {
        boolean bl = false;
        if (this.dynamic != null) {
            bl = this.dynamic.hasSlot(n2);
        }
        return bl;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        if (!bl) {
            if (this.dynamic != null && !(bl = this.dynamic.hasDynamicValue(string))) {
                bl = this.dynamic.hasSlot(string);
            }
            bl = this.members.b(string, false);
        }
        return bl;
    }

    public NativeJavaObject(Scriptable scriptable, DynamicObject dynamicObject, TheScripter theScripter) {
        this(scriptable, dynamicObject.javaReflectionTarget(), dynamicObject.getClass());
        this.dynamic = dynamicObject;
        this.scripter = theScripter;
    }

    public NativeJavaObject(Scriptable scriptable, Object object, Class clazz) {
        this.parent = scriptable;
        this.javaObject = object;
        Class<?> clazz2 = object != null ? object.getClass() : clazz;
        this.members = org.mozilla.javascript.f.a(scriptable, clazz2, clazz);
        this.e = this.members.a(this, object, false);
    }

    public NativeJavaObject(Scriptable scriptable, Object object, f f2) {
        this.parent = scriptable;
        this.javaObject = object;
        if (object instanceof DynamicObject) {
            this.dynamic = (DynamicObject)object;
        }
        this.members = f2;
    }
}

