/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.TextComponent;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextArea
extends TextComponent {
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    private int scrollbarVisibility = 0;
    private JTextArea textArea = new JTextArea();
    private JScrollPane scroller = new JScrollPane(this.textArea);

    public TextArea() {
        this.textArea = new JTextArea();
        this.scroller.setViewportView(this.textArea);
        this.scroller.setHorizontalScrollBarPolicy(32);
        this.scroller.setVerticalScrollBarPolicy(22);
        this.scroller.setBorder(BorderFactory.createBevelBorder(1));
        this.setLayout(new BorderLayout());
        this.add(this.scroller);
    }

    public TextArea(int rows, int columns) {
        this();
        this.textArea.setRows(rows);
        this.textArea.setColumns(columns);
    }

    public TextArea(String text) {
        this();
        this.textArea.setText(text);
    }

    public TextArea(String text, int rows, int columns) {
        this();
        this.textArea.setText(text);
        this.textArea.setRows(rows);
        this.textArea.setColumns(columns);
    }

    public TextArea(String text, int rows, int columns, int scrollbars) {
        this(text, rows, columns);
        this.setScrollbarVisibility(scrollbars);
    }

    public void append(String str) {
        this.textArea.append(str);
    }

    public void appendText(String str) {
        this.append(str);
    }

    public Color getBackground() {
        return this.textArea.getBackground();
    }

    public void setBackground(Color c) {
        this.textArea.setBackground(c);
    }

    public Color getForeground() {
        return this.textArea.getForeground();
    }

    public void setForeground(Color c) {
        this.textArea.setForeground(c);
    }

    public Font getFont() {
        return this.textArea.getFont();
    }

    public void setFont(Font f) {
        this.textArea.setFont(f);
    }

    public int getCaretPosition() {
        return this.textArea.getCaretPosition();
    }

    public int getColumns() {
        return this.textArea.getColumns();
    }

    public EventListener[] getListeners(Class listenerType) {
        return null;
    }

    public Dimension getMinimumSize(int rows, int columns) {
        return this.scroller.getMinimumSize();
    }

    public Dimension getPreferredSize(int rows, int columns) {
        return this.scroller.getPreferredSize();
    }

    public int getRows() {
        return this.textArea.getRows();
    }

    public int getScrollbarVisibility() {
        return this.scrollbarVisibility;
    }

    public String getSelectedText() {
        return this.textArea.getSelectedText();
    }

    public int getSelectionEnd() {
        return this.textArea.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.textArea.getSelectionStart();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void insert(String str, int pos) {
        this.textArea.insert(str, pos);
    }

    public void insertText(String str, int pos) {
        this.insert(str, pos);
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public Dimension minimumSize(int rows, int columns) {
        return this.scroller.getMinimumSize();
    }

    public Dimension preferredSize(int rows, int columns) {
        return this.scroller.getPreferredSize();
    }

    public void replaceRange(String str, int start, int end) {
        this.textArea.replaceRange(str, start, end);
    }

    public void replaceText(String str, int start, int end) {
        this.replaceRange(str, start, end);
    }

    public void select(int selectionStart, int selectionEnd) {
        this.textArea.select(selectionStart, selectionEnd);
    }

    public void selectAll() {
        this.textArea.selectAll();
    }

    public void setCaretPosition(int caretPosition) {
        this.textArea.setCaretPosition(caretPosition);
    }

    public void setColumns(int columns) {
        this.textArea.setColumns(columns);
    }

    public void setEditable(boolean bEditable) {
        if (this.textArea != null) {
            this.textArea.setEditable(bEditable);
        }
    }

    public void setScrollbarVisibility(int scrollbarVisibility) {
        if (scrollbarVisibility != this.scrollbarVisibility) {
            this.scrollbarVisibility = scrollbarVisibility;
            switch (scrollbarVisibility) {
                case 0: {
                    this.scroller.setVerticalScrollBarPolicy(22);
                    this.scroller.setHorizontalScrollBarPolicy(32);
                    break;
                }
                case 2: {
                    this.scroller.setVerticalScrollBarPolicy(21);
                    this.scroller.setHorizontalScrollBarPolicy(32);
                    break;
                }
                case 1: {
                    this.scroller.setVerticalScrollBarPolicy(22);
                    this.scroller.setHorizontalScrollBarPolicy(31);
                    break;
                }
                case 3: {
                    this.scroller.setVerticalScrollBarPolicy(21);
                    this.scroller.setHorizontalScrollBarPolicy(31);
                }
            }
        }
    }

    public void setSelectionEnd(int end) {
        this.textArea.setSelectionEnd(end);
    }

    public void setSelectionStart(int start) {
        this.textArea.setSelectionStart(start);
    }

    public void setRows(int rows) {
        this.textArea.setRows(rows);
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    static {
        SCROLLBARS_BOTH = 0;
        SCROLLBARS_VERTICAL_ONLY = 1;
        SCROLLBARS_HORIZONTAL_ONLY = 2;
        SCROLLBARS_NONE = 3;
    }
}

