/*
 * Decompiled with CFR 0.152.
 */
package com.borland.install;

import com.borland.install.DOS2UnixConverter;
import com.borland.install.IniFile;
import com.borland.install.IniFileSection;
import com.borland.install.JBInstallException;
import com.borland.install.OSTextConverter;
import com.borland.install.Res;
import com.borland.install.Unix2DOSConverter;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class Util {
    private String osName;
    private String osType;
    private String userName;
    private String jbVersion = "5";
    private String jbUserHome = ".jbuilder5";
    private String MSVersion = "1";
    private Properties sysprop = System.getProperties();
    private InstallerProxy ip = null;
    private OSTextConverter converter = null;
    private Hashtable extensions;
    private static final String COPY_FILE_LIST = "resources/copy.list";
    private static final String RENAME_SOURCE_VAR = "$REN_SOURCE$";
    private static final String RENAME_TARGET_VAR = "$REN_TARGET$";
    protected static final String MIN_JDK_VERSION = "1.3";
    protected static final String JB_INSTALL_PROPERTIES = "install.properties";
    protected static final String JB_INSTALL_DIR_KEY = "jbuilder.dir";
    protected static final String CONFIG_FILE_HEADER = Res.getString(33);
    static Class class$com$borland$install$Util;

    public Util() {
        this.collectOSInfo();
    }

    private void collectOSInfo() {
        this.osName = this.sysprop.getProperty("os.name").toLowerCase();
        this.userName = this.sysprop.getProperty("user.name");
        String tmp = this.sysprop.getProperty("os.name.real");
        if (tmp != null) {
            this.osName = tmp;
            System.out.println("OS real name : ".concat(String.valueOf(this.osName)));
        }
        this.osType = File.separatorChar == '/' && File.pathSeparatorChar == ':' ? "unix" : (File.separatorChar == '\\' ? "windows" : (File.separatorChar == ':' && File.pathSeparatorChar == ':' ? "macintosh" : "unknown"));
        System.out.println("OS type : ".concat(String.valueOf(this.osType)));
    }

    public String getOSName() {
        return this.osName;
    }

    public String getOSType() {
        return this.osType;
    }

    public String getJBVersion() {
        return this.jbVersion;
    }

    public String getJBUserHome() {
        return this.jbUserHome;
    }

    public void setVersion(String inVersion) {
        if (inVersion.equals("6")) {
            this.jbVersion = "6";
            this.jbUserHome = ".jbuilder6";
        } else {
            this.jbVersion = "5";
            this.jbUserHome = ".jbuilder5";
        }
    }

    public boolean checkVersionNumber(InstallerProxy ip) {
        String versionFive = "005";
        String versionSix = "006";
        String sep = File.separator;
        try {
            String jbJarFileName = String.valueOf(new StringBuffer(String.valueOf(ip.substitute("$JBUILDER_HOME$"))).append(sep).append("lib").append(sep).append("jbuilder.jar"));
            System.out.println("checkVersionNumber: ".concat(String.valueOf(jbJarFileName)));
            JarFile jbJarFile = new JarFile(jbJarFileName);
            Attributes attrs = jbJarFile.getManifest().getMainAttributes();
            String implVersionStr = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            if (implVersionStr == null) {
                System.out.println(Res.getString(13));
                boolean bl = false;
                return bl;
            }
            if ((implVersionStr = implVersionStr.substring(0, 3)).equals(versionFive)) {
                this.setVersion("5");
            } else if (implVersionStr.equals(versionSix)) {
                this.setVersion("6");
            }
        }
        catch (IOException ioe) {
            System.out.println("checkVersionNumber: ".concat(String.valueOf(ioe)));
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public int chmodFromListFile(InstallerProxy ip) {
        try {
            BufferedReader listFile = new BufferedReader(new InputStreamReader((class$com$borland$install$Util == null ? (class$com$borland$install$Util = Util.class$("com.borland.install.Util")) : class$com$borland$install$Util).getResourceAsStream("resources/chmod.list")));
            String fileName = "";
            String attribs = "";
            DataOutput logFile = ip.getLogOutput();
            while (listFile.ready()) {
                int blankPos;
                String aLine = listFile.readLine();
                if (ip != null) {
                    aLine = ip.substitute(aLine);
                }
                if ((blankPos = aLine.indexOf(32)) == -1) continue;
                attribs = aLine.substring(0, blankPos);
                fileName = aLine.substring(blankPos + 1);
                System.out.println(this.format("Setting {0} for {1}", attribs, fileName));
                int retval = this.chmod(fileName, attribs);
                if (retval == 0) continue;
                int n = retval;
                return n;
            }
            listFile.close();
        }
        catch (IOException ioe) {
            System.out.println(String.valueOf(Res.getString(14)).concat(String.valueOf(ioe)));
        }
        catch (JBInstallException jbie) {
            System.out.println(String.valueOf(Res.getString(14)).concat(String.valueOf(jbie)));
        }
        return 0;
    }

    public int chmod(String file, String mode) throws JBInstallException {
        if (new File(file).exists()) {
            try {
                Process chmodProc = Runtime.getRuntime().exec(String.valueOf(new StringBuffer("chmod ").append(mode).append(" ").append(file)));
                chmodProc.waitFor();
                int n = chmodProc.exitValue();
                return n;
            }
            catch (InterruptedException chmodProc) {
            }
            catch (IOException e) {
                throw new JBInstallException(Res.getString(16));
            }
        }
        return -1;
    }

    public void DOS2Unix(InstallerProxy ip) {
        this.ip = ip;
        this.converter = new DOS2UnixConverter();
        this.textFileConvert();
    }

    public void Unix2DOS(InstallerProxy ip) {
        this.ip = ip;
        this.converter = new Unix2DOSConverter();
        this.textFileConvert();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void textFileConvert() {
        this.extensions = new Hashtable();
        try {
            File rootDir;
            BufferedReader listFile = new BufferedReader(new InputStreamReader((class$com$borland$install$Util == null ? (class$com$borland$install$Util = Util.class$("com.borland.install.Util")) : class$com$borland$install$Util).getResourceAsStream("resources/".concat(String.valueOf(this.converter.getListFileName())))));
            while (listFile.ready()) {
                String aLine = listFile.readLine();
                this.extensions.put(aLine, "");
            }
            listFile.close();
            if (this.ip != null) {
                String rootDirName = this.ip.substitute("$USER_INSTALL_DIR$");
                if (rootDirName == null) {
                    System.out.println(Res.getString(11));
                    return;
                }
                rootDir = new File(rootDirName);
            } else {
                rootDir = new File(System.getProperties().getProperty("user.dir"));
            }
            this.textFileConvertDirScanner(rootDir);
            return;
        }
        catch (IOException ioe) {
            System.out.println("textFileConvert: ".concat(String.valueOf(ioe)));
        }
    }

    private void textFileConvertDirScanner(File rootDir) {
        String[] files = rootDir.list();
        for (int i = 0; i < files.length; ++i) {
            File aFile;
            String extension;
            boolean processed = false;
            String fileName = files[i];
            int extIndex = fileName.lastIndexOf(46);
            if (extIndex != -1 && this.extensions.get(extension = fileName.substring(extIndex + 1)) != null) {
                processed = true;
                this.converter.convert(new File(String.valueOf(new StringBuffer(String.valueOf(rootDir.toString())).append(File.separator).append(fileName))));
            }
            if (processed || !(aFile = new File(String.valueOf(new StringBuffer(String.valueOf(rootDir)).append(File.separator).append(fileName)))).isDirectory()) continue;
            this.textFileConvertDirScanner(aFile);
        }
    }

    public void copyFiles(InstallerProxy ip) {
        String fileName = "";
        String dirName = "";
        String osName = "";
        String aLine = "";
        DataOutput myDO = ip.getLogOutput();
        try {
            int blankPos;
            String thisOS = ip.substitute("$prop.os.name$");
            if (thisOS.equals("SunOS")) {
                thisOS = "Solaris";
            }
            if ((blankPos = thisOS.indexOf(32)) != -1) {
                thisOS = thisOS.substring(0, blankPos);
            }
            this.ip = ip;
            BufferedReader listFile = new BufferedReader(new InputStreamReader((class$com$borland$install$Util == null ? (class$com$borland$install$Util = Util.class$("com.borland.install.Util")) : class$com$borland$install$Util).getResourceAsStream(COPY_FILE_LIST)));
            while (listFile.ready()) {
                fileName = "";
                dirName = "";
                osName = "";
                aLine = listFile.readLine();
                blankPos = aLine.indexOf(32);
                if (blankPos != -1) {
                    fileName = aLine.substring(0, blankPos);
                    dirName = aLine.substring(blankPos + 1);
                    if ((blankPos = dirName.indexOf(32)) != -1) {
                        osName = dirName.substring(blankPos + 1);
                        dirName = dirName.substring(0, blankPos);
                    }
                }
                if (ip != null) {
                    fileName = ip.substitute(fileName);
                    dirName = ip.substitute(dirName);
                }
                System.out.println("fileName is ".concat(String.valueOf(fileName)));
                System.out.println("dirName is ".concat(String.valueOf(dirName)));
                System.out.println("osName is ".concat(String.valueOf(osName)));
                File origFile = new File(fileName);
                File targetDir = new File(dirName);
                File targetFile = new File(String.valueOf(new StringBuffer(String.valueOf(dirName)).append(File.separator).append(origFile.getName())));
                myDO.writeUTF(targetFile.toString());
                if (!osName.equals("") && !osName.equals(thisOS)) continue;
                if (!origFile.exists()) {
                    System.err.println(this.format(Res.getString(18), fileName));
                    continue;
                }
                if (!targetDir.isDirectory()) {
                    System.err.println(this.format(Res.getString(21), dirName, fileName));
                    continue;
                }
                byte[] buffer = new byte[(int)origFile.length()];
                FileInputStream inFile = new FileInputStream(origFile);
                inFile.read(buffer, 0, buffer.length);
                inFile.close();
                FileOutputStream outFile = new FileOutputStream(targetFile);
                outFile.write(buffer, 0, buffer.length);
            }
        }
        catch (IOException ioe) {
            System.out.println(String.valueOf(Res.getString(17)).concat(String.valueOf(ioe)));
        }
    }

    public void removeFiles(UninstallerProxy up) {
        DataInput myDI = up.getLogInput();
        boolean theEnd = false;
        try {
            while (!theEnd) {
                String currFileName = myDI.readUTF();
                File currFile = new File(currFileName);
                if (!currFile.exists()) continue;
                currFile.delete();
            }
        }
        catch (IOException eof) {
            System.err.println("EOF reached on log input".concat(String.valueOf(eof.toString())));
        }
    }

    public void rename(InstallerProxy ip) throws JBInstallException {
        String origFileName = ip.substitute(RENAME_SOURCE_VAR);
        String targetFileName = ip.substitute(RENAME_TARGET_VAR);
        System.out.println(String.valueOf(new StringBuffer("Rename : ").append(origFileName).append(" => ").append(targetFileName)));
        if (File.separatorChar != '/') {
            origFileName = origFileName.replace('/', File.separatorChar);
            targetFileName = targetFileName.replace('/', File.separatorChar);
        }
        File origFile = new File(origFileName);
        File targetFile = new File(targetFileName);
        if (targetFile.exists()) {
            throw new JBInstallException(this.format(Res.getString(19), targetFileName));
        }
        if (!origFile.exists()) {
            throw new JBInstallException(this.format(Res.getString(20), origFileName));
        }
        if (!origFile.renameTo(targetFile)) {
            throw new JBInstallException(this.format(Res.getString(15), origFileName, targetFileName));
        }
    }

    public void findJVM(InstallerProxy ip) {
        System.out.println(Res.getString(9));
        System.out.println(Res.getString(23));
        String bundledJVM = ip.substitute("$BUNDLED_VM$");
        if (!bundledJVM.equals("")) {
            if (bundledJVM.equals("true")) {
                System.out.println(Res.getString(63));
                ip.setVariable("IS_JDK_OK", "true");
                System.out.println("IS_JDK_OK set to: true");
            } else {
                ip.setVariable("IS_JDK_OK", "false");
                System.out.println("IS_JDK_OK set to: false");
            }
        } else {
            String jvmVersion = System.getProperties().getProperty("java.version", "1.0.0");
            System.out.println(String.valueOf(Res.getString(24)).concat(String.valueOf(jvmVersion)));
            if (jvmVersion.compareTo(MIN_JDK_VERSION) >= 0) {
                ip.setVariable("IS_JDK_OK", "true");
                System.out.println("IS_JDK_OK set to: true");
                System.out.println(Res.getString(37));
            } else {
                ip.setVariable("IS_JDK_OK", "false");
                System.out.println("IS_JDK_OK set to: false");
                System.out.println(Res.getString(36));
            }
        }
        System.out.println(Res.getString(39));
    }

    public void resetJDKPath(InstallerProxy ip) {
        String oldJDKPath;
        String jdkPath = oldJDKPath = ip.substitute("$JAVA_HOME$");
        System.out.println(Res.getString(10));
        System.out.println("resetJDKPath: oldJDKPath => ".concat(String.valueOf(oldJDKPath)));
        int jrePos = jdkPath.lastIndexOf(String.valueOf(File.separator).concat("jre"));
        if (jrePos != -1) {
            System.out.println("resetJDKPath: JDK path points to JRE");
            jdkPath = jdkPath.substring(0, jrePos);
            System.out.println("resetJDKPath: jdkPath => ".concat(String.valueOf(jdkPath)));
            String javacName = this.getOSType().equals("windows") ? "javac.exe" : "javac";
            File javaCompiler = new File(String.valueOf(new StringBuffer(String.valueOf(jdkPath)).append(File.separator).append("bin").append(File.separator).append(javacName)));
            if (javaCompiler.exists()) {
                ip.setVariable("JAVA_HOME2", jdkPath);
                System.out.println("JAVA_HOME2 set to: ".concat(String.valueOf(jdkPath)));
                return;
            }
            System.out.println(Res.getString(8));
        }
        ip.setVariable("JAVA_HOME2", oldJDKPath);
        System.out.println("JAVA_HOME2 set to: ".concat(String.valueOf(oldJDKPath)));
        System.out.println(Res.getString(38));
    }

    public void saveJBuilderInstallInfo(String jbuilderLocation) {
        File installCfgFile;
        System.out.println(String.valueOf(Res.getString(64)).concat(String.valueOf(jbuilderLocation)));
        if (this.userName.equals("root")) {
            File etcJBuilder = new File("/etc/jbuilder");
            if (!etcJBuilder.exists() && !etcJBuilder.mkdir()) {
                return;
            }
            installCfgFile = new File(String.valueOf(new StringBuffer(String.valueOf(etcJBuilder.toString())).append(File.separator).append(JB_INSTALL_PROPERTIES)));
        } else {
            File homeJBuilder = new File(String.valueOf(new StringBuffer(String.valueOf(this.sysprop.getProperty("user.home"))).append("/").append(this.jbUserHome)));
            if (!homeJBuilder.exists() && !homeJBuilder.mkdir()) {
                return;
            }
            installCfgFile = new File(String.valueOf(new StringBuffer(String.valueOf(homeJBuilder)).append("/").append(JB_INSTALL_PROPERTIES)));
        }
        try {
            Properties jbProps = new Properties();
            ((Hashtable)jbProps).put(JB_INSTALL_DIR_KEY, jbuilderLocation);
            FileOutputStream fos = new FileOutputStream(installCfgFile);
            jbProps.store(fos, CONFIG_FILE_HEADER);
            fos.close();
        }
        catch (IOException ioe) {
            System.out.println("saveJBuilderInstallInfo: ".concat(String.valueOf(ioe)));
        }
    }

    public String findJBuilder(InstallerProxy ip) {
        String jbuilderHome = (String)ip.getVariable("JBUILDER_HOME");
        if (jbuilderHome != null) {
            return jbuilderHome;
        }
        if (this.userName.equals("root")) {
            File userLocal;
            File etcJBuilder = new File("/etc/jbuilder/install.properties");
            if (etcJBuilder.exists()) {
                try {
                    Properties jbProps = new Properties();
                    FileInputStream fis = new FileInputStream(etcJBuilder);
                    jbProps.load(fis);
                    String string = jbProps.getProperty(JB_INSTALL_DIR_KEY);
                    return string;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if ((userLocal = new File("/opt")).isDirectory()) {
                String[] fileList = userLocal.list();
                for (int i = 0; i < fileList.length; ++i) {
                    if (!fileList[i].startsWith("jbuilder")) continue;
                    return fileList[i];
                }
            }
            return null;
        }
        String homeDir = this.sysprop.getProperty("user.home");
        File installFile = new File(String.valueOf(new StringBuffer(String.valueOf(homeDir)).append(File.separator).append(this.jbUserHome).append(File.separator).append(JB_INSTALL_PROPERTIES)));
        if (installFile.exists()) {
            try {
                FileInputStream instPropFile = new FileInputStream(installFile);
                Properties instProp = new Properties();
                instProp.load(instPropFile);
                String string = instProp.getProperty(JB_INSTALL_DIR_KEY);
                return string;
            }
            catch (IOException ioe) {
                System.out.println("findJBuilder: ".concat(String.valueOf(ioe)));
            }
        }
        return null;
    }

    public void makeJDKConfig(InstallerProxy ip) {
        String sep = File.separator;
        boolean isWindows = File.separatorChar == '\\' && File.pathSeparatorChar == ';';
        String jvmExecutable = "java".concat(String.valueOf(isWindows ? ".exe" : ""));
        String jbuilderHome = ip.substitute("$JBUILDER_HOME$");
        DataOutput myDataOutput = ip.getLogOutput();
        System.out.println("In makeJDKConfig");
        String osName = ip.substitute("$prop.os.name$");
        boolean isMac = osName.equals("Mac OS X");
        try {
            myDataOutput.writeChars("JBUILDER_HOME=".concat(String.valueOf(jbuilderHome)));
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(Res.getString(67)).concat(String.valueOf(ex)));
        }
        if (jbuilderHome == null) {
            System.err.println(Res.getString(27));
            return;
        }
        String jdkDir = ip.substitute("$JDK_DIR$");
        if (jdkDir == null) {
            System.err.println(Res.getString(34));
            return;
        }
        File jdkConfig = new File(String.valueOf(new StringBuffer(String.valueOf(jbuilderHome)).append(sep).append("bin").append(sep).append("jdk.config")));
        try {
            PrintWriter cfgFile = new PrintWriter(new FileWriter(jdkConfig));
            if (isMac) {
                cfgFile.println(Res.getString(47));
                cfgFile.println(Res.getString(49));
                cfgFile.println(Res.getString(50));
                cfgFile.println(Res.getString(51));
                cfgFile.println(Res.getString(52));
                cfgFile.println(Res.getString(53));
                cfgFile.println(Res.getString(54));
                cfgFile.println(Res.getString(55));
                cfgFile.println(Res.getString(56));
                cfgFile.println(Res.getString(48));
                cfgFile.println("");
                cfgFile.println(Res.getString(57));
                cfgFile.println(Res.getString(58));
                cfgFile.println("vmparam -Xmaxf0.2");
                cfgFile.println("vmparam -Xminf0.2");
                cfgFile.println("");
                cfgFile.println(Res.getString(40));
                cfgFile.println(Res.getString(41));
                cfgFile.println(Res.getString(42));
                cfgFile.println(Res.getString(43));
                cfgFile.println(Res.getString(44));
                cfgFile.println(Res.getString(45));
                cfgFile.println(Res.getString(46));
                cfgFile.println("vmparam -Dcom.apple.macos.useScreenMenuBar=true");
            } else {
                cfgFile.println("#");
                cfgFile.println(Res.getString(35));
                cfgFile.println(String.valueOf(new StringBuffer("javapath ").append(jdkDir).append(sep).append("bin").append(sep).append(jvmExecutable)));
                cfgFile.println(Res.getString(65));
                cfgFile.println(String.valueOf(new StringBuffer("addpath ").append(jdkDir).append(sep).append("lib").append(sep).append("tools.jar")));
                cfgFile.println("");
            }
            cfgFile.println(Res.getString(25));
            cfgFile.println("vmparam -Xverify:none");
            cfgFile.println("");
            cfgFile.println(Res.getString(1));
            cfgFile.println(Res.getString(2));
            cfgFile.println(Res.getString(3));
            cfgFile.println(Res.getString(4));
            cfgFile.println(Res.getString(5));
            cfgFile.println(Res.getString(6));
            cfgFile.println(Res.getString(7));
            cfgFile.println("#vmparam -Dfile.encoding=ISO8859_1");
            cfgFile.close();
        }
        catch (Exception ex) {
            System.out.println("makeJDKConfig: ".concat(String.valueOf(ex)));
        }
    }

    public void makeCVSConfigMod(InstallerProxy ip) {
        String sccServerPath = ip.substitute("$SCC_SERVER_PATH$");
        String sccServerPathDir = new File(sccServerPath).getParent();
        String sccCurrentDatabase = ip.substitute("$SCC_CURRENT_DATABASE$");
        String sep = File.separator;
        String jbuilderHome = ip.substitute("$JBUILDER_HOME$");
        if (jbuilderHome == null) {
            System.err.println(Res.getString(26));
            return;
        }
        while (sccServerPathDir.lastIndexOf("\\") == sccServerPathDir.length() - 1) {
            sccServerPathDir = sccServerPathDir.substring(0, sccServerPathDir.length() - 1);
        }
        while (sccCurrentDatabase.lastIndexOf("\\") == sccCurrentDatabase.length() - 1) {
            sccCurrentDatabase = sccCurrentDatabase.substring(0, sccCurrentDatabase.length() - 1);
        }
        String jbConfigFileName = String.valueOf(new StringBuffer(String.valueOf(jbuilderHome)).append(sep).append("bin").append(sep).append("jbuilder.config"));
        try {
            OutputStreamWriter cfgWriter = new OutputStreamWriter(new FileOutputStream(jbConfigFileName, true));
            cfgWriter.write(Res.getString(29));
            cfgWriter.write(String.valueOf(new StringBuffer("vmparam -DVSSLocation=\"").append(sccServerPathDir).append("\"\r\n")));
            cfgWriter.write(String.valueOf(new StringBuffer("vmparam -DVSSCurrentDBase=\"").append(sccCurrentDatabase).append("\"\r\n")));
            cfgWriter.close();
        }
        catch (Exception ex) {
            System.out.println("makeCVSConfigMod: ".concat(String.valueOf(ex)));
        }
    }

    public void makeWirelessPackMod(InstallerProxy ip) {
        String sep = File.separator;
        boolean isWindows = File.separatorChar == '\\' && File.pathSeparatorChar == ';';
        String jbuilderHome = ip.substitute("$JBUILDER_HOME$");
        this.MSVersion = ip.substitute("$MS_VERSION$").substring(0, 1);
        DataOutput myDataOutput = ip.getLogOutput();
        try {
            myDataOutput.writeChars("JBUILDER_HOME=".concat(String.valueOf(jbuilderHome)));
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(Res.getString(66)).concat(String.valueOf(ex)));
        }
        if (jbuilderHome == null) {
            System.err.println(Res.getString(30));
            return;
        }
        String userHome = String.valueOf(new StringBuffer(String.valueOf(this.sysprop.getProperty("user.home"))).append("/").append(this.jbUserHome));
        String defPaletteIniName = String.valueOf(new StringBuffer(String.valueOf(jbuilderHome)).append(sep).append("defaults").append(sep).append("palette.ini"));
        String userPaletteIniName = String.valueOf(new StringBuffer(String.valueOf(userHome)).append(sep).append("palette.ini"));
        File defPalette = new File(defPaletteIniName);
        File userPalette = new File(userPaletteIniName);
        File userHomeDir = new File(userHome);
        if (!userHomeDir.isDirectory()) {
            try {
                userHomeDir.mkdir();
                byte[] buffer = new byte[(int)defPalette.length()];
                FileInputStream inFile = new FileInputStream(defPalette);
                inFile.read(buffer, 0, buffer.length);
                inFile.close();
                FileOutputStream outFile = new FileOutputStream(userPalette);
                outFile.write(buffer, 0, buffer.length);
                outFile.close();
            }
            catch (Exception ex) {
                System.out.println("makeWirelessPackMod: ".concat(String.valueOf(ex)));
            }
        }
        if (userPalette.exists()) {
            this.addWirelessPackInfo(userPaletteIniName);
        }
    }

    public void addWirelessPackInfo(String inputIniName) {
        IniFile inputIni = new IniFile();
        try {
            if (inputIni.read(inputIniName)) {
                IniFileSection iniPalettePagesSection = inputIni.getSection("Palette_Pages");
                if (iniPalettePagesSection.indexOf("MIDP=MIDP") != -1) {
                    iniPalettePagesSection.remove("MIDP=MIDP");
                    iniPalettePagesSection.remove("MIDP2=MIDP Screens");
                    inputIni.removeSection("Palette_MIDP");
                    inputIni.removeSection("Palette_MIDP2");
                }
                iniPalettePagesSection.set(0, "MIDP", "MIDP");
                iniPalettePagesSection.set(1, "MIDP2", "MIDP Screens");
                IniFileSection iniPaletteMIDPSection = inputIni.getSection("Palette_MIDP");
                if (this.MSVersion.equals("1")) {
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.ChoiceGroup", "*");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.DateField", "*");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.Gauge", "*");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.ImageItem", "*");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.StringItem", "*");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.TextField", "*");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.Ticker", "*");
                } else {
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.ChoiceGroup", "*;new ChoiceGroup(\"\",ChoiceGroup.EXCLUSIVE)");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.DateField", "*;new DateField(\"\",DateField.DATE_TIME)");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.Gauge", "*;new Gauge(\"\", true, 10, 0)");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.ImageItem", "*;new ImageItem(\"\", null,ImageItem.LAYOUT_DEFAULT, \"\")");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.StringItem", "*;new StringItem(\"\", \"\")");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.TextField", "*;new TextField(\"\", \"\", 15,TextField.ANY)");
                    iniPaletteMIDPSection.set("library,javax.microedition.lcdui.Ticker", "*;new Ticker(\"\")");
                }
                IniFileSection iniPaletteMIDP2Section = inputIni.getSection("Palette_MIDP2");
                if (this.MSVersion.equals("1")) {
                    iniPaletteMIDP2Section.set("library,javax.microedition.lcdui.Alert", "*");
                    iniPaletteMIDP2Section.set("library,javax.microedition.lcdui.Form", "*");
                    iniPaletteMIDP2Section.set("library,javax.microedition.lcdui.List", "*");
                    iniPaletteMIDP2Section.set("library,javax.microedition.lcdui.TextBox", "*");
                } else {
                    iniPaletteMIDP2Section.set("library,javax.microedition.lcdui.Alert", "*;new Alert(\"\")");
                    iniPaletteMIDP2Section.set("library,javax.microedition.lcdui.Form", "*;new Form(\"\")");
                    iniPaletteMIDP2Section.set("library,javax.microedition.lcdui.List", "*;new List(\"\", List.IMPLICIT)");
                    iniPaletteMIDP2Section.set("library,javax.microedition.lcdui.TextBox", "*;new TextBox(\"\", \"\", 30,TextField.ANY)");
                }
                inputIni.write(inputIniName);
            }
        }
        catch (Exception ex) {
            System.out.println("addWirelessPackInfo: ".concat(String.valueOf(ex)));
        }
    }

    public void removeWirelessPackMod(UninstallerProxy up) {
        String sep = File.separator;
        boolean isWindows = File.separatorChar == '\\' && File.pathSeparatorChar == ';';
        String userHome = String.valueOf(new StringBuffer(String.valueOf(this.sysprop.getProperty("user.home"))).append(sep).append(this.jbUserHome));
        String userPaletteIniName = String.valueOf(new StringBuffer(String.valueOf(userHome)).append(sep).append("palette.ini"));
        File userPalette = new File(userPaletteIniName);
        if (userPalette.exists()) {
            this.removeWirelessPackInfo(userPaletteIniName);
        }
    }

    public void removeWirelessPackInfo(String inputIniName) {
        IniFile inputIni = new IniFile();
        if (inputIni.read(inputIniName)) {
            IniFileSection iniPalettePagesSection = inputIni.getSection("Palette_Pages");
            iniPalettePagesSection.remove("MIDP=MIDP");
            iniPalettePagesSection.remove("MIDP2=MIDP Screens");
            inputIni.removeSection("Palette_MIDP");
            inputIni.removeSection("Palette_MIDP2");
        }
        inputIni.write(inputIniName);
    }

    public void makeSunWTKMod(InstallerProxy ip) {
        String sep = File.separator;
        String jbuilderHome = ip.substitute("$JBUILDER_HOME$");
        String javaHome = ip.substitute("$JAVA_HOME$");
        if (jbuilderHome == null) {
            System.err.println(Res.getString(31));
            return;
        }
        String javaExe = String.valueOf(new StringBuffer(String.valueOf(javaHome)).append(sep).append("java"));
        String wtk = String.valueOf(new StringBuffer(String.valueOf(jbuilderHome)).append(sep).append("j2mewtk"));
        String wtkBin = String.valueOf(new StringBuffer(String.valueOf(wtk)).append(sep).append("bin"));
        String wtkLib = String.valueOf(new StringBuffer(String.valueOf(wtk)).append(sep).append("wtklib"));
        String emulatorBat = String.valueOf(new StringBuffer(String.valueOf(wtkBin)).append(sep).append("emulator.bat"));
        String kToolBarBat = String.valueOf(new StringBuffer(String.valueOf(wtkBin)).append(sep).append("ktoolbar.bat"));
        String midletPrefBat = String.valueOf(new StringBuffer(String.valueOf(wtkBin)).append(sep).append("MidletPref.bat"));
        String runMidletBat = String.valueOf(new StringBuffer(String.valueOf(wtkBin)).append(sep).append("RunMidlet.bat"));
        try {
            OutputStreamWriter emulatorBatWriter = new OutputStreamWriter(new FileOutputStream(emulatorBat, true));
            emulatorBatWriter.write(String.valueOf(new StringBuffer(String.valueOf(javaExe)).append(" -Dkvem.home=").append(wtk).append(" -cp ").append(wtkLib).append(sep).append("kenv.zip com.sun.kvem.environment.EmulatorWrapper\r\n")));
            emulatorBatWriter.close();
            OutputStreamWriter kToolBarBatWriter = new OutputStreamWriter(new FileOutputStream(kToolBarBat, true));
            kToolBarBatWriter.write(String.valueOf(new StringBuffer(String.valueOf(javaExe)).append(" -Dkvem.home=").append(wtk).append(" -cp ").append(wtkLib).append(sep).append("kenv.zip com.sun.kvem.toolbar.Main\r\n")));
            kToolBarBatWriter.close();
            OutputStreamWriter midletPrefBatWriter = new OutputStreamWriter(new FileOutputStream(midletPrefBat, true));
            midletPrefBatWriter.write(String.valueOf(new StringBuffer(String.valueOf(javaExe)).append(" -Dkvem.home=").append(wtk).append(" -cp ").append(wtkLib).append(sep).append("kenv.zip com.sun.kvem.toolbar.Preferences\r\n")));
            midletPrefBatWriter.close();
            OutputStreamWriter runMidletBatWriter = new OutputStreamWriter(new FileOutputStream(runMidletBat, true));
            runMidletBatWriter.write(String.valueOf(new StringBuffer(String.valueOf(javaExe)).append(" -Dkvem.home=").append(wtk).append(" -cp ").append(wtkLib).append(sep).append("kenv.zip com.sun.kvem.midp.Main -run\r\n")));
            runMidletBatWriter.close();
        }
        catch (Exception ex) {
            System.out.println("makeSunWTKMod: ".concat(String.valueOf(ex)));
        }
    }

    public void makeMacULB(InstallerProxy ip) {
        String sep = File.separator;
        String usrLocalBin = "/usr/local/bin";
        String jbBin = String.valueOf(ip.substitute("$USER_INSTALL_DIR$")).concat("/JBuilder.framework/bin");
        String jbuilderBinEntry = String.valueOf(usrLocalBin).concat("/jbuilder");
        String bcjBinEntry = String.valueOf(usrLocalBin).concat("/bcj");
        String bmjBinEntry = String.valueOf(usrLocalBin).concat("/bmj");
        String dbpilotBinEntry = String.valueOf(usrLocalBin).concat("/dbpilot");
        String jdsexplorerBinEntry = String.valueOf(usrLocalBin).concat("/jdsexplorer");
        String jdsserverBinEntry = String.valueOf(usrLocalBin).concat("/jdsserver");
        String jsqlBinEntry = String.valueOf(usrLocalBin).concat("/jsql");
        try {
            OutputStreamWriter jbuilderBinEntryWriter = new OutputStreamWriter(new FileOutputStream(jbuilderBinEntry, false));
            jbuilderBinEntryWriter.write("#!/bin/sh\n");
            jbuilderBinEntryWriter.write(String.valueOf(jbBin).concat("/jbuilder \"$@\"\n"));
            jbuilderBinEntryWriter.close();
            OutputStreamWriter bcjBinEntryWriter = new OutputStreamWriter(new FileOutputStream(bcjBinEntry, false));
            bcjBinEntryWriter.write("#!/bin/sh\n");
            bcjBinEntryWriter.write(String.valueOf(jbBin).concat("/bcj \"$@\"\n"));
            bcjBinEntryWriter.close();
            OutputStreamWriter bmjBinEntryWriter = new OutputStreamWriter(new FileOutputStream(bmjBinEntry, false));
            bmjBinEntryWriter.write("#!/bin/sh\n");
            bmjBinEntryWriter.write(String.valueOf(jbBin).concat("/bmj \"$@\"\n"));
            bmjBinEntryWriter.close();
            OutputStreamWriter dbpilotBinEntryWriter = new OutputStreamWriter(new FileOutputStream(dbpilotBinEntry, false));
            dbpilotBinEntryWriter.write("#!/bin/sh\n");
            dbpilotBinEntryWriter.write(String.valueOf(jbBin).concat("/dbpilot \"$@\"\n"));
            dbpilotBinEntryWriter.close();
            OutputStreamWriter jdsexplorerBinEntryWriter = new OutputStreamWriter(new FileOutputStream(jdsexplorerBinEntry, false));
            jdsexplorerBinEntryWriter.write("#!/bin/sh\n");
            jdsexplorerBinEntryWriter.write(String.valueOf(jbBin).concat("/jdsexplorer \"$@\"\n"));
            jdsexplorerBinEntryWriter.close();
            OutputStreamWriter jdsserverBinEntryWriter = new OutputStreamWriter(new FileOutputStream(jdsserverBinEntry, false));
            jdsserverBinEntryWriter.write("#!/bin/sh\n");
            jdsserverBinEntryWriter.write(String.valueOf(jbBin).concat("/jdsserver \"$@\"\n"));
            jdsserverBinEntryWriter.close();
            OutputStreamWriter jsqlBinEntryWriter = new OutputStreamWriter(new FileOutputStream(jsqlBinEntry, false));
            jsqlBinEntryWriter.write("#!/bin/sh\n");
            jsqlBinEntryWriter.write(String.valueOf(jbBin).concat("/jsql \"$@\"\n"));
            jsqlBinEntryWriter.close();
        }
        catch (Exception ex) {
            System.out.println("makeMacULB: ".concat(String.valueOf(ex)));
        }
    }

    public void removeMacULB(UninstallerProxy up) {
    }

    public void removeSunWTKMod(UninstallerProxy up) {
        String sep = File.separator;
        String jbuilderHome = this.ip.substitute("$JBUILDER_HOME$");
        String javaHome = this.ip.substitute("$JAVA_HOME$");
        if (jbuilderHome == null) {
            System.err.println(Res.getString(32));
            return;
        }
        String javaExe = String.valueOf(new StringBuffer(String.valueOf(javaHome)).append(sep).append("java"));
        String wtk = String.valueOf(new StringBuffer(String.valueOf(jbuilderHome)).append(sep).append("j2mewtk"));
        String wtkBin = String.valueOf(new StringBuffer(String.valueOf(wtk)).append(sep).append("bin"));
        String wtkLib = String.valueOf(new StringBuffer(String.valueOf(wtk)).append(sep).append("wtklib"));
        String emulatorBatName = String.valueOf(new StringBuffer(String.valueOf(wtkBin)).append(sep).append("emulator.bat"));
        String kToolBarBatName = String.valueOf(new StringBuffer(String.valueOf(wtkBin)).append(sep).append("ktoolbar.bat"));
        String midletPrefBatName = String.valueOf(new StringBuffer(String.valueOf(wtkBin)).append(sep).append("MidletPref.bat"));
        String runMidletBatName = String.valueOf(new StringBuffer(String.valueOf(wtkBin)).append(sep).append("RunMidlet.bat"));
        try {
            File emulatorBat = new File(emulatorBatName);
            emulatorBat.delete();
            File kToolBarBat = new File(kToolBarBatName);
            kToolBarBat.delete();
            File midletPrefBat = new File(midletPrefBatName);
            midletPrefBat.delete();
            File runMidletBat = new File(runMidletBatName);
            runMidletBat.delete();
        }
        catch (Exception ex) {
            System.out.println("removeSunWTKMod: ".concat(String.valueOf(ex)));
        }
    }

    public void refreshLicenseManager(InstallerProxy ip) {
        String sep = File.separator;
        System.out.println("refreshing license manager...");
        boolean isWindows = File.separatorChar == '\\' && File.pathSeparatorChar == ';';
        String userHome = String.valueOf(new StringBuffer(String.valueOf(this.sysprop.getProperty("user.home"))).append("/").append(this.jbUserHome));
        String showLicenseName = String.valueOf(new StringBuffer(String.valueOf(userHome)).append(sep).append("showlicense"));
        File showLicense = new File(showLicenseName);
        try {
            if (!showLicense.createNewFile()) {
                System.out.println(Res.getString(28));
            }
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(new StringBuffer("Error while creating file ").append(showLicense.getAbsolutePath()).append(": ").append(ex)));
        }
    }

    public boolean isInstalledJBuilderVersionOk(InstallerProxy ip) {
        String minVersion = ip.substitute("$JB_MIN_VERSION$");
        String sep = File.separator;
        if (minVersion.equals("")) {
            return false;
        }
        minVersion = minVersion.substring(0, 8);
        try {
            String jbJarFileName = String.valueOf(new StringBuffer(String.valueOf(ip.substitute("$JBUILDER_HOME$"))).append(sep).append("lib").append(sep).append("jbuilder.jar"));
            System.out.println("isInstalledJBuilderVersionOk: ".concat(String.valueOf(jbJarFileName)));
            JarFile jbJarFile = new JarFile(jbJarFileName);
            Attributes attrs = jbJarFile.getManifest().getMainAttributes();
            String implVersionStr = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            if (implVersionStr == null) {
                System.out.println(Res.getString(12));
                boolean bl = false;
                return bl;
            }
            boolean bl = (implVersionStr = implVersionStr.substring(0, 8)).compareTo(minVersion) >= 0;
            return bl;
        }
        catch (IOException ioe) {
            System.out.println("isInstalledJBuilderVersionOk: ".concat(String.valueOf(ioe)));
            boolean bl = false;
            return bl;
        }
    }

    String format(String fmtString, String arg) {
        return MessageFormat.format(fmtString, arg);
    }

    String format(String fmtString, String arg1, String arg2) {
        return MessageFormat.format(fmtString, arg1, arg2);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

