/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.IPWorksException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

class CAsn {
    static final int ASN_BOOLEAN = 1;
    static final int ASN_INTEGER = 2;
    static final int ASN_BIT_STR = 3;
    static final int ASN_OCTET_STR = 4;
    static final int ASN_NULL = 5;
    static final int ASN_OBJECT_ID = 6;
    static final int ASN_ENUMERATED = 10;
    static final int ASN_SEQUENCE = 16;
    static final int ASN_SET = 17;
    static final int ASN_UNIVERSAL = 0;
    static final int ASN_APPLICATION = 64;
    static final int ASN_CONTEXT = 128;
    static final int ASN_ = 192;
    static final int ASN_PRIMITIVE = 0;
    static final int ASN_CONSTRUCTOR = 32;
    static final int ASN_LONG_LEN = 128;
    static final int ASN_EXTENSION_ID = 31;
    static final int ASN_BIT8 = 128;
    static final int MAX_SUBID = -1;
    static final int MAX_OBJID = 255;
    private static final int sizeOfInt = 4;
    private static final int sizeOfUInt = 4;
    private static final int sizeOfInt64 = 8;
    private byte[] data;
    private int start = 0;
    private int lastStart = 0;
    private int lastIndex = 0;
    private int end;
    private ByteArrayOutputStream os;
    int type = 0;
    int typeLength = 0;
    boolean parsedBoolean;
    int parsedUInt;
    int parsedInt;
    long parsedInt64;
    byte[] parsedStr;
    byte[] parsedBitString;
    int[] parsedObjid;
    String parsedOid;
    CAsn parsedRaw;
    String parsedIPAddress;

    CAsn() {
        this.os = new ByteArrayOutputStream();
    }

    CAsn(byte[] byArray, int n) {
        this.data = byArray;
        this.type = n;
        this.end = byArray.length;
    }

    CAsn(byte[] byArray) {
        this.data = byArray;
        this.end = byArray.length;
    }

    void appendByteArray(byte[] byArray) {
        byte[] byArray2 = this.data;
        this.end += byArray.length;
        this.data = new byte[this.end];
        System.arraycopy(byArray2, 0, this.data, 0, byArray2.length);
        System.arraycopy(byArray, 0, this.data, byArray2.length, byArray.length);
    }

    boolean isComplete() throws IPWorksException {
        boolean bl;
        int n = this.start;
        int n2 = this.typeLength;
        int n3 = this.type;
        try {
            this.parseHeader();
            bl = this.start + this.typeLength - 1 < this.data.length;
        }
        catch (IPWorksException iPWorksException) {
            if (iPWorksException.getCode() == 447) {
                bl = false;
            }
            throw iPWorksException;
        }
        this.start = n;
        this.typeLength = n2;
        this.type = n3;
        return bl;
    }

    void pack() {
        this.end -= this.start;
        byte[] byArray = this.data;
        this.data = new byte[this.end];
        System.arraycopy(byArray, this.start, this.data, 0, this.end);
        this.start = 0;
    }

    void append(byte[] byArray) throws IPWorksException {
        try {
            this.os.write(byArray);
        }
        catch (IOException iOException) {
            throw new IPWorksException(iOException);
        }
    }

    void appendStr(byte[] byArray, int n) throws IPWorksException {
        this.type = n;
        this.buildString(byArray);
    }

    void appendStr(byte[] byArray) throws IPWorksException {
        this.type = 4;
        this.buildString(byArray);
    }

    void appendInt(int n, int n2) throws IPWorksException {
        this.type = n2;
        this.buildInt(n);
    }

    void appendInt(int n) throws IPWorksException {
        this.type = 2;
        this.buildInt(n);
    }

    void appendUInt(int n, int n2) throws IPWorksException {
        this.type = n2;
        this.buildUInt(n);
    }

    void appendUInt(int n) throws IPWorksException {
        this.type = 2;
        this.buildUInt(n);
    }

    void appendInt64(long l, int n) throws IPWorksException {
        this.type = n;
        this.buildInt64(l);
    }

    void appendInt64(long l) throws IPWorksException {
        this.type = 2;
        this.buildInt64(l);
    }

    void appendBool(boolean bl, int n) throws IPWorksException {
        this.type = n;
        this.buildInt(bl ? 255 : 0);
    }

    void appendBool(boolean bl) throws IPWorksException {
        this.type = 1;
        this.buildInt(bl ? 255 : 0);
    }

    void appendEnum(int n, int n2) throws IPWorksException {
        this.type = n2;
        this.buildInt(n);
    }

    void appendEnum(int n) throws IPWorksException {
        this.type = 10;
        this.buildUInt(n);
    }

    void appendRaw(byte[] byArray, int n) throws IPWorksException {
        this.type = n;
        this.buildString(byArray);
    }

    void appendRaw(byte[] byArray) throws IPWorksException {
        this.type = 4;
        this.buildString(byArray);
    }

    void appendIPAddress(String string, int n) throws IPWorksException {
        this.type = n;
        this.buildIPAddress(string);
    }

    void appendIPAddress(String string) throws IPWorksException {
        this.type = 4;
        this.buildIPAddress(string);
    }

    void appendNull(int n) throws IPWorksException {
        this.type = n;
        this.buildNull();
    }

    void appendNull() throws IPWorksException {
        this.type = 5;
        this.buildNull();
    }

    void appendOid(String string, int n) throws IPWorksException {
        this.type = n;
        this.buildObjid(CAsn.parseOidToIntArray(string));
    }

    void appendOid(String string) throws IPWorksException {
        this.type = 6;
        this.buildObjid(CAsn.parseOidToIntArray(string));
    }

    void makeSequence(int n) throws IPWorksException {
        this.type = n;
        this.buildSequence();
    }

    void makeSequence() throws IPWorksException {
        this.type = 48;
        this.buildSequence();
    }

    void unmakeSequence() throws IPWorksException {
        this.parseHeader();
        byte[] byArray = new byte[this.typeLength];
        System.arraycopy(this.data, this.start, byArray, 0, this.typeLength);
        this.data = byArray;
    }

    void makeSet(int n) throws IPWorksException {
        this.type = n;
        this.buildSequence();
    }

    void makeSet() throws IPWorksException {
        this.type = 17;
        this.buildSequence();
    }

    static int[] parseOidToIntArray(String string) {
        int[] nArray = new int[255];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n5 <= n4) {
            if (n5 < n4 && Character.isDigit(string.charAt(n5))) {
                ++n3;
            } else {
                try {
                    nArray[n] = Integer.parseInt(string.substring(n2, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    nArray[n] = 0;
                }
                ++n;
                n2 = n3 = n5 + 1;
            }
            ++n5;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    static String parseIntArrayToPointedOid(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(nArray[n2]);
            if (n2 < n - 1) {
                stringBuffer.append('.');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    void buildSequence() throws IPWorksException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = this.os.toByteArray();
        int n = byArray.length;
        byteArrayOutputStream.write(this.type);
        if (n < 128) {
            byteArrayOutputStream.write(n);
        } else {
            byteArrayOutputStream.write(130);
            byteArrayOutputStream.write(n >>> 8);
            byteArrayOutputStream.write(n);
        }
        try {
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new IPWorksException(iOException);
        }
        this.os = byteArrayOutputStream;
    }

    void buildInt(int n) throws IPWorksException {
        int n2 = -8388608;
        this.typeLength = 4;
        while (((n & n2) == 0 || (n & n2) == n2) && this.typeLength > 1) {
            --this.typeLength;
            n <<= 8;
        }
        this.buildHeader();
        n2 = -16777216;
        while (this.typeLength > 0) {
            this.os.write((byte)((n & n2) >>> 24));
            n <<= 8;
            --this.typeLength;
        }
    }

    void buildUInt(int n) throws IPWorksException {
        boolean bl = false;
        this.typeLength = 4;
        int n2 = -16777216;
        if (((n & n2) >>> 24 & 0x80) != 0) {
            bl = true;
            ++this.typeLength;
        }
        this.buildHeader();
        if (bl) {
            this.os.write(0);
            --this.typeLength;
        }
        n2 = -16777216;
        while (this.typeLength > 0) {
            this.os.write((byte)((n & n2) >>> 24));
            n <<= 8;
            --this.typeLength;
        }
    }

    void buildInt64(long l) throws IPWorksException {
        boolean bl = false;
        this.typeLength = 8;
        int n = (int)l & 0xFFFFFFFF;
        int n2 = (int)(l >>> 32);
        int n3 = -16777216;
        if (((n2 & n3) >>> 24 & 0x80) > 0) {
            bl = true;
            ++this.typeLength;
        }
        this.buildHeader();
        if (bl) {
            this.os.write(0);
            --this.typeLength;
        }
        while (this.typeLength > 0) {
            this.os.write((byte)((n2 & n3) >>> 24));
            n2 = n2 << 8 | (n & n3) >>> 24;
            n <<= 8;
            --this.typeLength;
        }
    }

    void buildString(byte[] byArray) throws IPWorksException {
        if (byArray == null) {
            throw new IPWorksException(445);
        }
        this.typeLength = byArray.length;
        this.buildHeader();
        try {
            this.os.write(byArray);
        }
        catch (IOException iOException) {
            throw new IPWorksException(iOException);
        }
    }

    void buildBitString(byte[] byArray) throws IPWorksException {
        if (byArray == null || byArray.length == 0 || byArray[0] > 7) {
            throw new IPWorksException(445);
        }
        this.buildString(byArray);
    }

    void buildIPAddress(String string) throws IPWorksException {
        try {
            this.buildString(InetAddress.getByName(string).getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            throw new IPWorksException(445);
        }
    }

    void buildNull() throws IPWorksException {
        this.typeLength = 0;
        this.buildHeader();
    }

    private void buildObjid(int[] nArray) throws IPWorksException {
        int n = nArray.length;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n < 2) {
            byteArrayOutputStream.write(0);
            ++n2;
        } else {
            byteArrayOutputStream.write(40 * nArray[0] + nArray[1]);
            n2 += 2;
        }
        while (n2 < n) {
            int n3;
            if ((n3 = nArray[n2++]) < 127) {
                byteArrayOutputStream.write(n3);
                continue;
            }
            int n4 = 127;
            int n5 = 0;
            int n6 = 127;
            int n7 = 0;
            while (n6 != 0) {
                if ((n3 & n6) != 0) {
                    n4 = n6;
                    n5 = n7;
                }
                n6 <<= 7;
                n7 += 7;
            }
            while (n4 != 127) {
                if (n4 == 0x1E00000) {
                    n4 = 0xFE00000;
                }
                byteArrayOutputStream.write((n3 & n4) >>> n5 | 0x80);
                n4 >>>= 7;
                n5 -= 7;
            }
            byteArrayOutputStream.write(n3 & n4);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.typeLength = byArray.length;
        this.buildHeader();
        try {
            this.os.write(byArray);
        }
        catch (IOException iOException) {
            throw new IPWorksException(iOException);
        }
    }

    CAsn pullElement() throws IPWorksException {
        CAsn cAsn = null;
        if (this.isComplete()) {
            this.parseStr();
            cAsn = new CAsn(this.parsedStr, this.type);
        }
        return cAsn;
    }

    void parseRaw(int n) throws IPWorksException {
        this.parseStr(n);
        this.parsedRaw = new CAsn(this.parsedStr, this.type);
    }

    void parseInteger(int n) throws IPWorksException {
        this.skipToIndex(n);
        this.parseHeader();
        if (this.typeLength > 4) {
            throw new IPWorksException(446);
        }
        this.parsedInt = this.nextByte() < 0 ? -1 : 0;
        int n2 = 0;
        while (n2 < this.typeLength) {
            this.parsedInt = this.parsedInt << 8 | this.getNextByte();
            ++n2;
        }
    }

    void parseUInt(int n) throws IPWorksException {
        this.skipToIndex(n);
        this.parseHeader();
        int n2 = this.nextByte();
        if (this.typeLength > 5 || this.typeLength == 5 && n2 != 0) {
            throw new IPWorksException(446);
        }
        this.parsedUInt = n2 < 0 ? -1 : 0;
        int n3 = 0;
        while (n3 < this.typeLength) {
            this.parsedUInt = this.parsedUInt << 8 | this.getNextByte();
            ++n3;
        }
    }

    void parseInt64(int n) throws IPWorksException {
        this.skipToIndex(n);
        this.parseHeader();
        int n2 = this.nextByte();
        if (this.typeLength > 9 || this.typeLength == 9 && n2 != 0) {
            throw new IPWorksException(446);
        }
        this.parsedInt64 = n2 < 0 ? -1L : 0L;
        int n3 = 0;
        while (n3 < this.typeLength) {
            this.parsedInt64 = this.parsedInt64 << 8 | (long)this.getNextByte() & 0xFFL;
            ++n3;
        }
    }

    void parseStr(int n) throws IPWorksException {
        this.skipToIndex(n);
        this.parseStr();
    }

    void parseStr() throws IPWorksException {
        this.parseHeader();
        this.parsedStr = new byte[this.typeLength];
        System.arraycopy(this.data, this.start, this.parsedStr, 0, this.typeLength);
        this.start += this.typeLength;
    }

    void parseIPAddress(int n) throws IPWorksException {
        this.parseStr(n);
        if (this.parsedStr.length != 4) {
            throw new IPWorksException(446);
        }
        this.parsedIPAddress = (this.parsedStr[0] & 0xFF) + "." + (this.parsedStr[1] & 0xFF) + "." + (this.parsedStr[2] & 0xFF) + "." + (this.parsedStr[3] & 0xFF);
    }

    void parseBitString() throws IPWorksException {
        this.parseStr();
        if (this.typeLength == 0 || this.parsedStr[0] > 7) {
            throw new IPWorksException(446);
        }
        this.parsedBitString = new byte[this.typeLength];
        System.arraycopy(this.parsedStr, 0, this.parsedBitString, 0, this.typeLength);
    }

    void parseObjid(int n) throws IPWorksException {
        int n2;
        int n3 = 1;
        int[] nArray = new int[255];
        this.skipToIndex(n);
        this.parseHeader();
        if (this.typeLength == 0) {
            throw new IPWorksException(446);
        }
        int n4 = this.typeLength;
        while (n4 > 0) {
            int n5;
            n2 = 0;
            do {
                n5 = this.getNextByte();
                if ((n2 & 0xFE000000) != 0) {
                    throw new IPWorksException(446);
                }
                n2 = (n2 << 7) + (n5 & 0xFFFFFF7F);
                --n4;
            } while ((n5 & 0x80) != 0);
            nArray[n3++] = n2;
        }
        this.parsedObjid = new int[n3];
        System.arraycopy(nArray, 0, this.parsedObjid, 0, n3);
        n2 = this.parsedObjid[1];
        this.parsedObjid[0] = n2 / 40;
        this.parsedObjid[1] = n2 % 40;
    }

    void parseOid(int n) throws IPWorksException {
        this.parseObjid(n);
        this.parsedOid = CAsn.parseIntArrayToPointedOid(this.parsedObjid);
    }

    void parseNull() throws IPWorksException {
        this.parseHeader();
        if (this.typeLength != 0) {
            throw new IPWorksException(446);
        }
    }

    void buildHeader() throws IPWorksException {
        this.os.write(this.type);
        this.buildLength();
    }

    void parseHeader() throws IPWorksException {
        this.type = this.getNextByte();
        if ((this.type & 0x1F) == 31) {
            throw new IPWorksException(305);
        }
        this.parseLength();
    }

    void buildLength() throws IPWorksException {
        if (this.typeLength < 128) {
            this.os.write(this.typeLength);
        } else if (this.typeLength < 255) {
            this.os.write(129);
            this.os.write(this.typeLength);
        } else {
            this.os.write(130);
            this.os.write(this.typeLength >>> 8);
            this.os.write(this.typeLength);
        }
    }

    void parseLength() throws IPWorksException {
        int n = this.getNextByte();
        if ((n & 0x80) > 0) {
            if ((n = (int)((byte)(n & 0xFFFFFF7F))) == 0) {
                throw new IPWorksException(446);
            }
            if (n > 4) {
                throw new IPWorksException(446);
            }
            this.typeLength = 0;
            int n2 = 0;
            while (n2 < n) {
                this.typeLength = this.typeLength << 8 | this.getNextByte();
                ++n2;
            }
        } else {
            this.typeLength = n;
        }
    }

    int nextByte() throws IPWorksException {
        if (this.start < this.end) {
            return this.data[this.start];
        }
        throw new IPWorksException(447);
    }

    int getNextByte() throws IPWorksException {
        if (this.start < this.end) {
            return this.data[this.start++] & 0xFF;
        }
        throw new IPWorksException(447);
    }

    void skipToIndex(int n) throws IPWorksException {
        if (n < this.lastIndex) {
            this.lastStart = 0;
            this.lastIndex = 0;
        }
        this.start = this.lastStart;
        while (this.lastIndex < n) {
            this.parseHeader();
            this.start += this.typeLength;
            ++this.lastIndex;
        }
        this.lastStart = this.start;
    }

    byte[] getBytes() {
        return this.os.toByteArray();
    }
}

