/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CIPPortNoFirewall;
import ipworks.CNetCode;
import ipworks.IPWorksException;
import ipworks.Ipport;
import java.net.Socket;
import java.util.StringTokenizer;

class CIPPort
extends CBase {
    private static final int FIREWALL_NONE = 0;
    private static final int FIREWALL_TUNNEL = 1;
    private static final int FIREWALL_SOCKS4 = 2;
    private static final int FIREWALL_SOCKS4A = 3;
    private static final int FIREWALL_SOCKS5 = 4;
    private static final int IPV4ID = 1;
    private static final int DOMAIN_NAME_ID = 3;
    private static final int IDLE = 0;
    private static final int CONNECTING = 1;
    private static final int CONNECTED = 2;
    private static final int DISCONNECTING = 3;
    private static final int NOT_PERTINENT = 0;
    private static final int WAITING_AUTHENTICATION_METHOD_TO_USE = 1;
    private static final int WAITING_AUTHENTICATION_RESULT = 2;
    private static final int WAITING_AUTHENTICATION_RESULT1 = 3;
    private static final int WAITING_AUTHENTICATION_RESULT2 = 4;
    private static final int BLOCKING = 1;
    private static final int NOT_BLOCKING = 2;
    private static final String httpVersion = "HTTP/1.0";
    private static final String[] socks5Error = new String[]{"", "General SOCKS server failure.", "Connection not allowed by ruleset.", "Network unreachable.", "Host unreachable.", "Connection refused.", "TTL expired.", "Command not supported.", "Address type not supported."};
    private static final int socks4BaseCode = 90;
    private static final String[] socks4Error = new String[]{"", "Request rejected or failed.", "Request rejected because SOCKS server cannot connect to identd on the client.", "Request rejected because the client program and identd report different user-ids."};
    private Ipport sink;
    private CIPPortNoFirewall ipportNoFirewall;
    private int connectionState = 0;
    private int firewallState = 0;
    private int flowingState;
    private boolean acceptData = true;
    private byte[] eol = CBase.BYTE0;
    private int maxLineLength = 2048;
    private int firewallPort = 0;
    private String firewallHost = "";
    private int remotePort = 0;
    private String remoteHost = "";
    private String firewallUser = "";
    private String firewallPassword = "";
    private String firewallAuthorization = "";
    private byte[] firewallData = CBase.BYTE0;
    private StringBuffer allDataIn = new StringBuffer();
    private String firewallStatusLine = null;
    private int firewallType = 0;

    CIPPort(Ipport ipport, Object object) {
        this(ipport, null, object);
    }

    CIPPort(Ipport ipport, Socket socket, Object object) {
        super(object);
        this.sink = ipport;
        this.ipportNoFirewall = new CIPPortNoFirewall(null, socket, object){

            void fireConnected(IPWorksException iPWorksException) {
                CIPPort.this.ipportNoFirewallFireConnected(iPWorksException);
            }

            void fireDisconnected(IPWorksException iPWorksException) {
                CIPPort.this.ipportNoFirewallFireDisconnected(iPWorksException);
            }

            void fireDataIn(byte[] byArray, boolean bl) {
                CIPPort.this.ipportNoFirewallFireDataIn(byArray, bl);
            }

            void fireError(IPWorksException iPWorksException) {
                CIPPort.this.ipportNoFirewallFireError(iPWorksException);
            }

            void fireReadyToSend() {
                CIPPort.this.ipportNoFirewallFireReadyToSend();
            }

            void fireDataOut(int n, byte[] byArray) {
                CIPPort.this.fireDataOut(n, byArray);
            }
        };
    }

    void do_Connect(String string, int n) throws IPWorksException {
        this.setRemoteHost(string);
        this.setRemotePort(n);
        this.setConnected(true);
    }

    void do_Disconnect() throws IPWorksException {
        this.setConnected(false);
    }

    void do_Events() throws IPWorksException {
    }

    void do_Send(byte[] byArray) throws IPWorksException {
        this.setDataToSend(byArray);
    }

    String getFirewallHost() {
        return this.firewallHost;
    }

    void setFirewallHost(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 0 && this.connectionState != 3) {
                throw new IPWorksException(502);
            }
            this.firewallHost = string != null ? string : "";
        }
    }

    int getFirewallPort() {
        return this.firewallPort;
    }

    void setFirewallPort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 0 && this.connectionState != 3) {
                throw new IPWorksException(503);
            }
            this.firewallPort = n;
        }
    }

    int getFirewallType() {
        return this.firewallType;
    }

    void setFirewallType(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState == 0 || this.connectionState == 3) {
                this.firewallType = n;
                if (this.firewallPort == 0) {
                    this.firewallPort = 1080;
                }
            } else {
                throw new IPWorksException(501);
            }
        }
    }

    private void updateFirewallAuthorization() {
        if (this.firewallUser.length() == 0 && this.firewallPassword.length() == 0) {
            this.firewallAuthorization = "";
        } else {
            CNetCode cNetCode = new CNetCode(null, new Object());
            cNetCode.format = 1;
            cNetCode.setDecodedData((this.firewallUser + ":" + this.firewallPassword).getBytes());
            try {
                cNetCode.setAction(4);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            this.firewallAuthorization = new String(cNetCode.getEncodedData());
        }
    }

    String getFirewallUser() {
        return this.firewallUser;
    }

    void setFirewallUser(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 0 && this.connectionState != 3) {
                throw new IPWorksException(504);
            }
            this.firewallUser = string != null ? string : "";
            this.updateFirewallAuthorization();
        }
    }

    String getFirewallPassword() {
        return this.firewallPassword;
    }

    void setFirewallPassword(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 0 && this.connectionState != 3) {
                throw new IPWorksException(505);
            }
            this.firewallPassword = string != null ? string : "";
            this.updateFirewallAuthorization();
        }
    }

    String getFirewallAuthorization() {
        return this.firewallAuthorization;
    }

    void setFirewallAuthorization(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 0 && this.connectionState != 3) {
                throw new IPWorksException(506);
            }
            this.firewallAuthorization = string != null ? string : "";
        }
    }

    byte[] getFirewallData() {
        return this.firewallData;
    }

    void setFirewallData(byte[] byArray, int n, int n2) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState == 0 || this.connectionState == 3) {
                if (byArray == null) {
                    this.firewallData = CBase.BYTE0;
                } else {
                    this.firewallData = new byte[n2];
                    System.arraycopy(byArray, n, this.firewallData, 0, n2);
                }
            } else {
                throw new IPWorksException(507);
            }
        }
    }

    void setFirewallData(byte[] byArray) throws IPWorksException {
        this.setFirewallData(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    void setLocalHost(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.ipportNoFirewall.setLocalHost(string);
        }
    }

    String getLocalHost() {
        return this.ipportNoFirewall.getLocalHost();
    }

    void setLocalPort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.ipportNoFirewall.setLocalPort(n);
        }
    }

    int getLocalPort() {
        return this.ipportNoFirewall.getLocalPort();
    }

    void setRemoteHost(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 0 && this.connectionState != 3) {
                throw new IPWorksException(101);
            }
            this.remoteHost = string != null ? string : "";
        }
    }

    String getRemoteHost() {
        return this.remoteHost;
    }

    void setRemotePort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 0 && this.connectionState != 3) {
                throw new IPWorksException(100);
            }
            this.remotePort = n;
        }
    }

    int getRemotePort() {
        return this.remotePort;
    }

    void setConnected(boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (bl) {
                if (this.connectionState == 1) {
                    throw new IPWorksException(1105);
                }
                if (this.connectionState == 2) {
                    throw new IPWorksException(104);
                }
            }
            long l = this.timeout == 0 ? 0L : System.currentTimeMillis();
            this.setConnected(bl, l);
        }
    }

    void setConnected(boolean bl, long l) throws IPWorksException {
        if (bl) {
            if (this.firewallType != 0) {
                this.ipportNoFirewall.setRemoteHost(this.firewallHost);
                this.ipportNoFirewall.setRemotePort(this.firewallPort);
            } else {
                this.ipportNoFirewall.setRemoteHost(this.remoteHost);
                this.ipportNoFirewall.setRemotePort(this.remotePort);
            }
            this.connectionState = 1;
            this.pendingException = null;
        } else {
            if (this.ipportNoFirewall.isIdle()) {
                return;
            }
            this.connectionState = 3;
        }
        this.flowingState = l == 0L ? 2 : 1;
        int n = this.connectionState;
        this.ipportNoFirewall.setTimeout(this.timeout);
        try {
            this.ipportNoFirewall.setConnected(bl, l);
        }
        catch (IPWorksException iPWorksException) {
            this.connectionState = 0;
            throw iPWorksException;
        }
        if (this.flowingState == 1) {
            while (n == this.connectionState) {
                try {
                    this.waitWhileProcessingEvents(l);
                }
                catch (IPWorksException iPWorksException) {
                    this.connectionState = 0;
                    this.ipportNoFirewall.setConnected(false, 0L);
                    throw iPWorksException;
                }
            }
        }
    }

    boolean getConnected() {
        return this.connectionState == 2;
    }

    void setAcceptData(boolean bl) {
        Object object = this.syncObj;
        synchronized (object) {
            this.acceptData = bl;
            if (this.connectionState == 2) {
                this.ipportNoFirewall.setAcceptData(bl);
            }
        }
    }

    boolean getAcceptData() {
        return this.acceptData;
    }

    void setEOL(byte[] byArray) {
        this.setEOL(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public void setEOL(byte[] byArray, int n, int n2) {
        Object object = this.syncObj;
        synchronized (object) {
            if (byArray == null) {
                this.eol = CBase.BYTE0;
            } else {
                this.eol = new byte[n2];
                System.arraycopy(byArray, n, this.eol, 0, n2);
            }
            if (this.connectionState == 2) {
                this.ipportNoFirewall.setEOL(this.eol);
            }
        }
    }

    byte[] getEOL() {
        return this.eol;
    }

    void setDataToSend(byte[] byArray) throws IPWorksException {
        this.setDataToSend(byArray, 0, byArray.length);
    }

    void setDataToSend(byte[] byArray, int n, int n2) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 2) {
                throw new IPWorksException(1117);
            }
            this.ipportNoFirewall.setDataToSend(byArray, n, n2);
        }
    }

    void setDataToSend(byte[] byArray, long l, int n) throws IPWorksException {
        this.setDataToSend(byArray, 0, byArray.length, l, n);
    }

    void setDataToSend(byte[] byArray, int n, int n2, long l, int n3) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 2) {
                throw new IPWorksException(1117);
            }
            this.ipportNoFirewall.setDataToSend(byArray, n, n2, l, n3);
        }
    }

    int getBytesSent() {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.connectionState == 2 ? this.ipportNoFirewall.getBytesSent() : 0;
            return n;
        }
    }

    void setMaxLineLength(int n) {
        Object object = this.syncObj;
        synchronized (object) {
            this.maxLineLength = n;
            if (this.connectionState == 2) {
                this.ipportNoFirewall.setMaxLineLength(n);
            }
        }
    }

    int getMaxLineLength() {
        return this.maxLineLength;
    }

    void setLinger(boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.ipportNoFirewall.setLinger(bl);
        }
    }

    boolean getLinger() {
        return this.ipportNoFirewall.getLinger();
    }

    void setKeepAlive(boolean bl) {
        Object object = this.syncObj;
        synchronized (object) {
            this.ipportNoFirewall.setKeepAlive(bl);
        }
    }

    boolean getKeepAlive() {
        return this.ipportNoFirewall.getKeepAlive();
    }

    void setInBufferSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.ipportNoFirewall.setInBufferSize(n);
        }
    }

    int getInBufferSize() {
        return this.ipportNoFirewall.getInBufferSize();
    }

    void setOutBufferSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.ipportNoFirewall.setOutBufferSize(n);
        }
    }

    int getOutBufferSize() {
        return this.ipportNoFirewall.getOutBufferSize();
    }

    void setTimeout(int n) {
        Object object = this.syncObj;
        synchronized (object) {
            this.timeout = n;
            if (n > 0 || this.connectionState == 2) {
                this.ipportNoFirewall.setTimeout(n);
            }
            this.syncObj.notifyAll();
        }
    }

    int getTimeout() {
        return this.timeout;
    }

    private void sendTunnelConnectSequence() throws IPWorksException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CONNECT " + this.remoteHost + ":" + this.remotePort);
        stringBuffer.append(" HTTP/1.0\r\n");
        if (this.firewallAuthorization != "") {
            stringBuffer.append("Proxy-authorization: basic " + this.firewallAuthorization + "\r\n");
        }
        if (this.firewallData != CBase.BYTE0) {
            stringBuffer.append(new String(this.firewallData));
        }
        stringBuffer.append("\r\n");
        this.ipportNoFirewall.setDataToSend(stringBuffer.toString().getBytes());
    }

    private void handleTunnelDataIn(byte[] byArray, boolean bl) throws IPWorksException {
        if (this.firewallStatusLine == null) {
            if (bl) {
                int n = byArray.length;
                if (byArray[byArray.length - 1] == 13) {
                    --n;
                }
                this.firewallStatusLine = this.allDataIn.length() == 0 ? new String(byArray, 0, n) : this.allDataIn.toString() + new String(byArray, 0, n);
            } else {
                this.allDataIn.append(new String(byArray));
            }
        } else if (bl && (byArray.length == 0 || byArray[0] == 13)) {
            try {
                if (this.firewallStatusLine.charAt(9) == '2') {
                    this.connectionState = 2;
                    this.reportConnected();
                } else if (this.firewallStatusLine.charAt(9) == '4') {
                    throw new IPWorksException(118, this.firewallStatusLine);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IPWorksException(508);
            }
        }
    }

    private void sendSocks4ConnectSequence() throws IPWorksException {
        byte[] byArray = this.getSocksRemoteAddress();
        if (byArray[0] != 1) {
            throw new IPWorksException(118, "Only regular ip addresses are accepted.");
        }
        byte[] byArray2 = new byte[this.firewallUser.length() + 9];
        byArray2[0] = 4;
        byArray2[1] = 1;
        byArray2[2] = (byte)(this.remotePort >> 8);
        byArray2[3] = (byte)(this.remotePort & 0xFF);
        System.arraycopy(byArray, 1, byArray2, 4, 4);
        System.arraycopy(this.firewallUser.getBytes(), 0, byArray2, 8, this.firewallUser.length());
        byArray2[byArray2.length - 1] = 0;
        this.ipportNoFirewall.setDataToSend(byArray2);
    }

    private void handleSocks4DataIn(byte[] byArray, boolean bl) throws IPWorksException {
        if (byArray[0] != 0) {
            this.firewallState = 0;
            throw new IPWorksException(508);
        }
        if (byArray[1] != 90) {
            String string;
            try {
                string = byArray[1] + ": " + socks4Error[byArray[1] - 90];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = byArray[1] + ": ";
            }
            throw new IPWorksException(118, string);
        }
        this.connectionState = 2;
        this.reportConnected();
    }

    private void sendSocks4AConnectSequence() throws IPWorksException {
        try {
            this.sendSocks4ConnectSequence();
        }
        catch (IPWorksException iPWorksException) {
            if (iPWorksException.getCode() == 118) {
                byte[] byArray = this.getSocksRemoteAddress();
                int n = byArray.length;
                byte[] byArray2 = new byte[8 + this.firewallUser.length() + 1 + (n - 2) + 1];
                byArray2[0] = 4;
                byArray2[1] = 1;
                byArray2[2] = (byte)(this.remotePort >> 8);
                byArray2[3] = (byte)(this.remotePort & 0xFF);
                byArray2[6] = 0;
                byArray2[5] = 0;
                byArray2[4] = 0;
                byArray2[7] = 1;
                System.arraycopy(this.firewallUser.getBytes(), 0, byArray2, 8, this.firewallUser.length());
                byArray2[8 + this.firewallUser.length()] = 0;
                System.arraycopy(byArray, 2, byArray2, 9 + this.firewallUser.length(), n - 2);
                byArray2[byArray2.length - 1] = 0;
                this.ipportNoFirewall.setDataToSend(byArray2);
            }
            throw iPWorksException;
        }
    }

    private void sendSocks5ImplementedAuthenticationMethodsSequence() throws IPWorksException {
        byte[] byArray = new byte[]{5, 2, 0, 2};
        this.ipportNoFirewall.setDataToSend(byArray);
    }

    private void sendSocks5UserPasswordAuthenticationSequence() throws IPWorksException {
        byte by = (byte)this.firewallUser.length();
        byte by2 = (byte)this.firewallPassword.length();
        byte[] byArray = new byte[3 + by + by2];
        byArray[0] = 5;
        byArray[1] = by;
        System.arraycopy(this.firewallUser.getBytes(), 0, byArray, 2, by);
        byArray[2 + by] = by2;
        System.arraycopy(this.firewallPassword.getBytes(), 0, byArray, 3 + by, by2);
        this.ipportNoFirewall.setDataToSend(byArray);
    }

    private byte[] getSocksRemoteAddress() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.remoteHost, ".");
        byte[] byArray = new byte[5];
        byArray[0] = 1;
        int n = 1;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                if (n > 4) {
                    n = 6;
                    break;
                }
                byArray[n++] = Byte.parseByte(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                n = 6;
            }
        }
        if (n == 6) {
            byte by = (byte)this.remoteHost.length();
            byArray = new byte[by + 2];
            byArray[0] = 3;
            byArray[1] = by;
            System.arraycopy(this.remoteHost.getBytes(), 0, byArray, 2, by);
        }
        return byArray;
    }

    private void sendSocks5ConnectSequence() throws IPWorksException {
        byte[] byArray = this.getSocksRemoteAddress();
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 5];
        byArray2[0] = 5;
        byArray2[1] = 1;
        byArray2[2] = 0;
        System.arraycopy(byArray, 0, byArray2, 3, n);
        byArray2[3 + n] = (byte)(this.remotePort >> 8);
        byArray2[4 + n] = (byte)(this.remotePort & 0xFF);
        this.ipportNoFirewall.setDataToSend(byArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleSocks5DataIn(byte[] byArray, boolean bl) throws IPWorksException {
        if (byArray[0] != 5 && this.firewallState != 4) {
            this.firewallState = 0;
            throw new IPWorksException(508);
        }
        if (this.firewallState == 1) {
            if (byArray[1] == 2) {
                this.firewallState = 2;
                this.sendSocks5UserPasswordAuthenticationSequence();
                return;
            }
            if (byArray[1] == 0) {
                this.firewallState = 3;
                this.ipportNoFirewall.setMaxLineLength(5);
                this.sendSocks5ConnectSequence();
                return;
            }
            if (byArray[1] != -1) throw new IPWorksException(508);
            this.firewallState = 0;
            throw new IPWorksException(118, "No acceptable authentication methods.");
        }
        if (this.firewallState == 2) {
            if (byArray[1] == 0) {
                this.firewallState = 3;
                this.ipportNoFirewall.setMaxLineLength(5);
                return;
            }
            this.firewallState = 0;
            throw new IPWorksException(118, "User " + this.firewallUser + " not accepted.");
        }
        if (this.firewallState == 3) {
            String string;
            if (byArray[1] == 0) {
                this.firewallState = 4;
                this.ipportNoFirewall.setMaxLineLength(byArray[3] == 1 ? 5 : byArray[4] + 2);
                return;
            }
            this.firewallState = 0;
            try {
                string = byArray[1] + ": " + socks5Error[byArray[1]];
                throw new IPWorksException(118, string);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = byArray[1] + ": Unassigned";
            }
            throw new IPWorksException(118, string);
        }
        if (this.firewallState != 4) return;
        this.connectionState = 2;
        this.reportConnected();
    }

    private void setWaitingProperties() {
        this.ipportNoFirewall.setTimeout(this.timeout);
        this.ipportNoFirewall.setEOL(this.eol);
        this.ipportNoFirewall.setMaxLineLength(this.maxLineLength);
        this.ipportNoFirewall.setAcceptData(this.acceptData);
        this.syncObj.notifyAll();
    }

    private void ipportNoFirewallFireConnected(IPWorksException iPWorksException) {
        if (iPWorksException != null) {
            this.connectionState = 0;
            if (this.pendingException == null) {
                this.pendingException = iPWorksException;
            }
            this.fireConnected(iPWorksException);
            return;
        }
        try {
            switch (this.firewallType) {
                case 0: {
                    this.connectionState = 2;
                    this.reportConnected();
                    break;
                }
                case 1: {
                    this.ipportNoFirewall.setEOL(CBase.LFB);
                    this.allDataIn.setLength(0);
                    this.firewallStatusLine = null;
                    this.sendTunnelConnectSequence();
                    break;
                }
                case 2: {
                    this.ipportNoFirewall.setMaxLineLength(8);
                    this.sendSocks4ConnectSequence();
                    break;
                }
                case 3: {
                    this.ipportNoFirewall.setMaxLineLength(8);
                    this.sendSocks4AConnectSequence();
                    break;
                }
                case 4: {
                    this.firewallState = 1;
                    this.ipportNoFirewall.setMaxLineLength(2);
                    this.sendSocks5ImplementedAuthenticationMethodsSequence();
                }
            }
        }
        catch (IPWorksException iPWorksException2) {
            if (this.pendingException == null) {
                this.pendingException = iPWorksException2;
            }
            if (this.flowingState == 1) {
                this.connectionState = 0;
            }
            try {
                this.ipportNoFirewall.setConnected(false, 0L);
            }
            catch (IPWorksException iPWorksException3) {
                // empty catch block
            }
        }
    }

    private void ipportNoFirewallFireDataIn(byte[] byArray, boolean bl) {
        if (this.connectionState == 2) {
            this.fireDataIn(byArray, bl);
            return;
        }
        if (this.pendingException != null) {
            return;
        }
        try {
            switch (this.firewallType) {
                case 0: {
                    break;
                }
                case 1: {
                    this.handleTunnelDataIn(byArray, bl);
                    break;
                }
                case 2: 
                case 3: {
                    this.handleSocks4DataIn(byArray, bl);
                    break;
                }
                case 4: {
                    this.handleSocks5DataIn(byArray, bl);
                }
            }
        }
        catch (IPWorksException iPWorksException) {
            if (this.pendingException == null) {
                this.pendingException = iPWorksException;
            }
            if (this.flowingState == 1) {
                this.connectionState = 0;
            }
            try {
                this.ipportNoFirewall.setConnected(false, 0L);
            }
            catch (IPWorksException iPWorksException2) {
                // empty catch block
            }
        }
    }

    private void ipportNoFirewallFireDisconnected(IPWorksException iPWorksException) {
        if (this.pendingException == null) {
            this.pendingException = iPWorksException;
        }
        if (this.connectionState == 1) {
            this.connectionState = 0;
            if (this.pendingException == null) {
                this.pendingException = new IPWorksException(508);
            }
            this.fireConnected(iPWorksException);
        } else if (this.connectionState != 0) {
            this.connectionState = 0;
            this.fireDisconnected(iPWorksException);
        }
    }

    private void ipportNoFirewallFireError(IPWorksException iPWorksException) {
        if (this.connectionState == 2) {
            this.fireError(iPWorksException);
        }
    }

    private void ipportNoFirewallFireReadyToSend() {
        if (this.connectionState == 2) {
            this.fireReadyToSend();
        }
    }

    private void reportConnected() {
        this.fireConnected(null);
        this.setWaitingProperties();
    }

    void fireDataOut(int n, byte[] byArray) {
    }

    void fireConnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireConnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireConnected(0, "OK");
            }
        }
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        if (this.sink != null) {
            this.sink.fireDataIn(byArray, bl);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }

    void fireReadyToSend() {
        if (this.sink != null) {
            this.sink.fireReadyToSend();
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireDisconnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireDisconnected(0, "OK");
            }
        }
    }
}

