/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CAsn;
import ipworks.CBase;
import ipworks.CIPPMsg;
import ipworks.IPWorksException;
import ipworks.Ldap;
import ipworks.LdapFilter;

class CLDAP
extends CIPPMsg {
    private static final int LDAP_REQ_BIND = 96;
    private static final int LDAP_REQ_UNBIND = 66;
    private static final int LDAP_REQ_SEARCH = 99;
    private static final int LDAP_REQ_MODIFY = 102;
    private static final int LDAP_REQ_ADD = 104;
    private static final int LDAP_REQ_DELETE = 74;
    private static final int LDAP_REQ_MODRDN = 108;
    private static final int LDAP_REQ_COMPARE = 110;
    private static final int LDAP_REQ_ABANDON = 80;
    private static final int LDAP_RES_BIND = 97;
    private static final int LDAP_RES_SEARCH_ENTRY = 100;
    private static final int LDAP_RES_SEARCH_RESULT = 101;
    private static final int LDAP_RES_MODIFY = 103;
    private static final int LDAP_RES_ADD = 105;
    private static final int LDAP_RES_DELETE = 107;
    private static final int LDAP_RES_MODRDN = 109;
    private static final int LDAP_RES_COMPARE = 111;
    private static final int LDAP_RES_ANY = -1;
    private static final int LDAP_AUTH_NONE = 0;
    private static final int LDAP_AUTH_SIMPLE = 128;
    private static final int LDAP_AUTH_KRBV4 = 255;
    private static final int LDAP_AUTH_KRBV41 = 129;
    private static final int LDAP_AUTH_KRBV42 = 130;
    private static final int a_Idle = 0;
    private static final int a_Bind = 1;
    private static final int a_Unbind = 2;
    private static final int a_Search = 3;
    private static final int a_Modify = 4;
    private static final int a_ModifyRDN = 5;
    private static final int a_Add = 6;
    private static final int a_Delete = 7;
    private static final int a_Compare = 8;
    private static final int a_Abandon = 9;
    private static final int amo_Add = 0;
    private static final int amo_Delete = 1;
    private static final int amo_Replace = 2;
    private static final int sda_Never = 0;
    private static final int sda_InSearching = 1;
    private static final int sda_FindingBaseObject = 2;
    private static final int sda_Always = 3;
    private static final int ss_BaseObject = 0;
    private static final int ss_SingleLevel = 1;
    private static final int ss_WholeSubtree = 2;
    private static final int defaultPort = 389;
    private static final int maxAttributes = 64;
    private int version = 2;
    private int action = 0;
    private int abandonMessageId = 0;
    private int messageId = 1;
    private int attrCount = 0;
    private int[] attrModOp = new int[64];
    private String[] attrType = new String[64];
    private String[] attrValue = new String[64];
    private String DN = "";
    private boolean deleteOldRDN = true;
    private String newRDN = "";
    private String password = "";
    private int resultCode = 0;
    private String resultDescription = "";
    private String resultDN = "";
    private int searchDerefAliases = 0;
    private String searchFilter = "";
    private boolean searchReturnValues = true;
    private int searchScope = 2;
    private int searchSizeLimit = 0;
    private int searchTimeLimit = 0;
    private CAsn inBuffer = new CAsn(CBase.BYTE0);
    Ldap sink = null;

    CLDAP(Ldap ldap, Object object) {
        super(null, object);
        this.sink = ldap;
        int n = 0;
        while (n < 64) {
            this.attrValue[n] = "";
            this.attrType[n] = "";
            ++n;
        }
        try {
            this.setRemotePort(389);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
    }

    void do_Abandon() throws IPWorksException {
        this.setAction(9);
    }

    void do_Add() throws IPWorksException {
        this.setAction(6);
    }

    void do_Bind() throws IPWorksException {
        this.setAction(1);
    }

    void do_Compare() throws IPWorksException {
        this.setAction(8);
    }

    void do_Delete() throws IPWorksException {
        this.setAction(7);
    }

    void do_Modify() throws IPWorksException {
        this.setAction(4);
    }

    void do_ModifyRDN() throws IPWorksException {
        this.setAction(5);
    }

    void do_Search() throws IPWorksException {
        this.setAction(3);
    }

    void do_Unbind() throws IPWorksException {
        this.setAction(2);
    }

    int getLDAPVersion() {
        return this.version;
    }

    void setLDAPVersion(int n) {
        this.version = n;
    }

    int getAbandonMessageId() {
        return this.abandonMessageId;
    }

    void setAbandonMessageId(int n) {
        this.abandonMessageId = n;
    }

    int getAction() {
        return this.action;
    }

    void setAction(int n) throws IPWorksException {
        this.setLDAPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setLDAPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0) {
                throw new IPWorksException(334);
            }
            this.restart();
            if (!this.getConnected() && n != 1 && n != 2) {
                this.setLDAPAction(1);
            }
            this.action = n;
        }
        this.resultDN = "";
        this.resultDescription = "";
        this.resultCode = 0;
        try {
            switch (n) {
                case 1: {
                    Object object3 = this.syncObj;
                    synchronized (object3) {
                        if (!this.getConnected()) {
                            boolean bl = this.getAcceptData();
                            this.blockConnect();
                            this.setAcceptData(bl);
                        }
                        this.sendLDAPRequest(n);
                        break;
                    }
                }
                case 2: {
                    Object object4 = this.syncObj;
                    synchronized (object4) {
                        if (this.getConnected()) {
                            this.sendLDAPRequest(n);
                            this.setConnected(false);
                        }
                        break;
                    }
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.sendLDAPRequest(n);
                    break;
                }
                default: {
                    throw new IPWorksException(333);
                }
            }
            Object var8_10 = null;
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            Object object5 = this.syncObj;
            synchronized (object5) {
                this.action = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.action = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 201) {
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                throw this.pendingException;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var8_11 = null;
                Object object6 = this.syncObj;
                synchronized (object6) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
        }
    }

    private void sendLDAPRequest(int n) throws IPWorksException {
        CAsn cAsn = new CAsn();
        CAsn cAsn2 = new CAsn();
        CAsn cAsn3 = new CAsn();
        cAsn.appendInt(this.messageId++);
        switch (n) {
            case 1: {
                cAsn2.appendInt(this.version);
                cAsn2.appendStr(this.DN.getBytes());
                cAsn2.appendStr(this.password.getBytes(), 128);
                cAsn2.makeSequence(96);
                break;
            }
            case 2: {
                cAsn2.appendStr(this.DN.getBytes());
                break;
            }
            case 3: {
                cAsn2.appendStr(this.DN.getBytes());
                cAsn2.appendEnum(this.searchScope);
                cAsn2.appendEnum(this.searchDerefAliases);
                cAsn2.appendInt(this.searchSizeLimit);
                cAsn2.appendInt(this.searchTimeLimit);
                cAsn2.appendBool(!this.searchReturnValues);
                byte[] byArray = this.searchFilter.getBytes();
                LdapFilter ldapFilter = new LdapFilter(byArray, 0);
                cAsn2.append(ldapFilter.getAsn().getBytes());
                int n2 = 0;
                while (n2 < this.attrCount) {
                    cAsn3.appendStr(this.attrType[n2].getBytes());
                    ++n2;
                }
                cAsn3.makeSequence();
                cAsn2.append(cAsn3.getBytes());
                cAsn2.makeSequence(99);
                break;
            }
            case 4: {
                cAsn2.appendStr(this.DN.getBytes());
                cAsn2.append(this.buildAVL(true).getBytes());
                cAsn2.makeSequence(102);
                break;
            }
            case 5: {
                cAsn2.appendStr(this.DN.getBytes());
                cAsn2.appendStr(this.newRDN.getBytes(), 128);
                cAsn2.appendBool(this.deleteOldRDN);
                cAsn2.makeSequence(108);
                break;
            }
            case 6: {
                cAsn2.appendStr(this.DN.getBytes());
                cAsn2.append(this.buildAVL(false).getBytes());
                cAsn2.makeSequence(104);
                break;
            }
            case 7: {
                cAsn2.appendStr(this.DN.getBytes(), 74);
                break;
            }
            case 8: {
                cAsn3.appendStr(this.attrType[0].getBytes());
                cAsn3.appendStr(this.attrValue[0].getBytes());
                cAsn3.makeSequence();
                cAsn2.appendStr(this.DN.getBytes());
                cAsn2.append(cAsn3.getBytes());
                cAsn2.makeSequence(110);
                break;
            }
            case 9: {
                cAsn2.appendInt(this.abandonMessageId, 80);
            }
        }
        cAsn.append(cAsn2.getBytes());
        cAsn.makeSequence();
        this.blockSend(cAsn.getBytes());
    }

    private CAsn buildAVL(boolean bl) throws IPWorksException {
        CAsn cAsn = new CAsn();
        CAsn cAsn2 = null;
        CAsn cAsn3 = null;
        int n = 0;
        while (n <= this.attrCount) {
            if (n == this.attrCount || this.attrType[n].length() > 0) {
                if (cAsn3 != null) {
                    cAsn3.makeSet();
                    cAsn2.append(cAsn3.getBytes());
                    cAsn2.makeSequence();
                    if (bl) {
                        CAsn cAsn4 = new CAsn();
                        cAsn4.appendInt(this.attrModOp[n]);
                        cAsn4.append(cAsn2.getBytes());
                        cAsn4.makeSequence();
                        cAsn.append(cAsn4.getBytes());
                    } else {
                        cAsn.append(cAsn2.getBytes());
                    }
                }
                cAsn2 = new CAsn();
                cAsn3 = new CAsn();
                if (n < this.attrCount) {
                    cAsn2.appendStr(this.attrType[n].getBytes());
                }
            }
            if (n < this.attrCount) {
                cAsn3.appendStr(this.attrValue[n].getBytes());
            }
            ++n;
        }
        cAsn.makeSequence();
        return cAsn;
    }

    private void parseAVL(CAsn cAsn) throws IPWorksException {
        this.attrCount = 0;
        block4: while (this.attrCount < 64) {
            try {
                cAsn.parseRaw(this.attrCount);
            }
            catch (IPWorksException iPWorksException) {
                if (iPWorksException.getCode() == 447) {
                    return;
                }
                throw iPWorksException;
            }
            CAsn cAsn2 = cAsn.parsedRaw;
            cAsn2.parseStr(0);
            this.attrType[this.attrCount] = new String(cAsn2.parsedStr);
            cAsn2.parseRaw(1);
            CAsn cAsn3 = cAsn2.parsedRaw;
            cAsn3.parseStr(0);
            this.attrValue[this.attrCount++] = new String(cAsn3.parsedStr);
            int n = 1;
            while (this.attrCount < 64) {
                try {
                    cAsn3.parseStr(n++);
                    this.attrType[this.attrCount] = "";
                    this.attrValue[this.attrCount++] = new String(cAsn3.parsedStr);
                }
                catch (IPWorksException iPWorksException) {
                    if (iPWorksException.getCode() == 447) continue block4;
                    throw iPWorksException;
                }
            }
        }
    }

    int getAttrCount() {
        return this.attrCount;
    }

    void setAttrCount(int n) throws IPWorksException {
        if (n > 64) {
            throw new IPWorksException(332);
        }
        this.attrCount = n;
        int n2 = n;
        while (n2 < 64) {
            this.attrModOp[n2] = 0;
            this.attrValue[n2] = "";
            this.attrType[n2] = "";
            ++n2;
        }
    }

    private boolean indexInRange(int n) {
        return n < this.attrCount;
    }

    private void checkIndex(int n) throws IPWorksException {
        if (n >= this.attrCount) {
            throw new IPWorksException(7301);
        }
    }

    int getAttrModOp(int n) {
        return this.indexInRange(n) ? this.attrModOp[n] : 0;
    }

    void setAttrModOp(int n, int n2) throws IPWorksException {
        this.checkIndex(n);
        this.attrModOp[n] = n2;
    }

    String getAttrType(int n) {
        return this.indexInRange(n) ? this.attrType[n] : "";
    }

    void setAttrType(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.attrType[n] = string != null ? string : "";
    }

    byte[] getAttrValue(int n) {
        return this.indexInRange(n) ? this.attrValue[n].getBytes() : CBase.BYTE0;
    }

    void setAttrValue(int n, byte[] byArray) throws IPWorksException {
        this.checkIndex(n);
        this.attrValue[n] = byArray != null ? new String(byArray) : "";
    }

    void setAttrValue(int n, byte[] byArray, int n2, int n3) throws IPWorksException {
        this.checkIndex(n);
        this.attrValue[n] = byArray != null ? new String(byArray, n2, n3) : "";
    }

    String getDN() {
        return this.DN;
    }

    void setDN(String string) {
        this.DN = string != null ? string : "";
    }

    boolean getDeleteOldRDN() {
        return this.deleteOldRDN;
    }

    void setDeleteOldRDN(boolean bl) {
        this.deleteOldRDN = bl;
    }

    int getMessageId() {
        return this.messageId;
    }

    void setMessageId(int n) {
        this.messageId = n;
    }

    String getNewRDN() {
        return this.newRDN;
    }

    void setNewRDN(String string) {
        this.newRDN = string != null ? string : "";
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String string) {
        this.password = string != null ? string : "";
    }

    int getResultCode() {
        return this.resultCode;
    }

    String getResultDescription() {
        return this.resultDescription;
    }

    String getResultDN() {
        return this.resultDN;
    }

    int getSearchDerefAliases() {
        return this.searchDerefAliases;
    }

    void setSearchDerefAliases(int n) {
        this.searchDerefAliases = n;
    }

    String getSearchFilter() {
        return this.searchFilter;
    }

    void setSearchFilter(String string) {
        this.searchFilter = string != null ? string : "";
    }

    boolean getSearchReturnValues() {
        return this.searchReturnValues;
    }

    void setSearchReturnValues(boolean bl) {
        this.searchReturnValues = bl;
    }

    int getSearchScope() {
        return this.searchScope;
    }

    void setSearchScope(int n) {
        this.searchScope = n;
    }

    int getSearchSizeLimit() {
        return this.searchSizeLimit;
    }

    void setSearchSizeLimit(int n) {
        this.searchSizeLimit = n;
    }

    int getSearchTimeLimit() {
        return this.searchTimeLimit;
    }

    void setSearchTimeLimit(int n) {
        this.searchTimeLimit = n;
    }

    String getServerName() {
        return this.getRemoteHost();
    }

    void setServerName(String string) throws IPWorksException {
        this.setRemoteHost(string);
    }

    int getServerPort() {
        return this.getRemotePort();
    }

    void setServerPort(int n) throws IPWorksException {
        this.setRemotePort(n);
    }

    static String translateResultCode(int n) {
        switch (n) {
            case 0: {
                return "[ok]";
            }
            case 1: {
                return "[operations error]";
            }
            case 2: {
                return "[protocol error]";
            }
            case 3: {
                return "[time limit exceeded]";
            }
            case 4: {
                return "[size limit exceeded]";
            }
            case 5: {
                return "[false]";
            }
            case 6: {
                return "[true]";
            }
            case 7: {
                return "[auth method not supported]";
            }
            case 8: {
                return "[strong auth required]";
            }
            case 16: {
                return "[no such attribute]";
            }
            case 17: {
                return "[undefined attribute type]";
            }
            case 18: {
                return "[inappropriate matching]";
            }
            case 19: {
                return "[constraint violation]";
            }
            case 20: {
                return "[attribute or value exists]";
            }
            case 21: {
                return "[invalid attribute syntax]";
            }
            case 32: {
                return "[no such object]";
            }
            case 33: {
                return "[alias problem]";
            }
            case 34: {
                return "[invalid dn syntax]";
            }
            case 35: {
                return "[is leaf]";
            }
            case 36: {
                return "[alias dereferencing problem]";
            }
            case 48: {
                return "[inappropriate authentication]";
            }
            case 49: {
                return "[invalid credentials]";
            }
            case 50: {
                return "[insufficient access rights]";
            }
            case 51: {
                return "[busy]";
            }
            case 52: {
                return "[unavailable]";
            }
            case 53: {
                return "[unwilling to perform]";
            }
            case 54: {
                return "[loop detect]";
            }
            case 64: {
                return "[naming violation]";
            }
            case 65: {
                return "[object class violation]";
            }
            case 66: {
                return "[not allowed on non leaf]";
            }
            case 67: {
                return "[not allowed on rdn]";
            }
            case 68: {
                return "[entry already exists]";
            }
            case 69: {
                return "[object class mods prohibited]";
            }
            case 80: {
                return "[other]";
            }
        }
        return "";
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        this.inBuffer.appendByteArray(byArray);
        try {
            while (this.inBuffer.isComplete()) {
                CAsn cAsn = this.inBuffer.pullElement();
                cAsn.parseInteger(0);
                int n = cAsn.parsedInt;
                cAsn.parseRaw(1);
                CAsn cAsn2 = cAsn.parsedRaw;
                int n2 = cAsn.type;
                switch (n2) {
                    case 97: 
                    case 103: 
                    case 105: 
                    case 107: 
                    case 109: 
                    case 111: {
                        cAsn2.parseInteger(0);
                        this.resultCode = cAsn2.parsedInt;
                        cAsn2.parseStr(1);
                        this.resultDN = new String(cAsn2.parsedStr);
                        cAsn2.parseStr(2);
                        this.resultDescription = new String(cAsn2.parsedStr);
                        if (this.resultDescription.length() == 0) {
                            this.resultDescription = CLDAP.translateResultCode(this.resultCode);
                        }
                        this.fireResult(n, this.resultDN, this.resultCode, this.resultDescription);
                        break;
                    }
                    case 100: {
                        cAsn2.parseStr(0);
                        this.resultDN = new String(cAsn2.parsedStr);
                        cAsn2.parseRaw(1);
                        CAsn cAsn3 = cAsn2.parsedRaw;
                        this.parseAVL(cAsn3);
                        this.fireSearchResult(n, this.resultDN);
                        break;
                    }
                    case 101: {
                        cAsn2.parseInteger(0);
                        this.resultCode = cAsn2.parsedInt;
                        cAsn2.parseStr(1);
                        this.resultDN = new String(cAsn2.parsedStr);
                        cAsn2.parseStr(2);
                        this.resultDescription = new String(cAsn2.parsedStr);
                        if (this.resultDescription.length() == 0) {
                            this.resultDescription = CLDAP.translateResultCode(this.resultCode);
                        }
                        this.fireSearchComplete(n, this.resultDN, this.resultCode, this.resultDescription);
                        break;
                    }
                    default: {
                        this.resultCode = 336;
                        this.resultDescription = "unknown response type: " + n2 + ".";
                        this.fireError(new IPWorksException(336, this.resultDescription));
                    }
                }
            }
        }
        catch (IPWorksException iPWorksException) {
            this.fireError(iPWorksException);
        }
        this.inBuffer.pack();
    }

    void fireResult(int n, String string, int n2, String string2) {
        if (this.sink != null) {
            this.sink.fireResult(n, string, n2, string2);
        }
    }

    void fireSearchResult(int n, String string) {
        if (this.sink != null) {
            this.sink.fireSearchResult(n, string);
        }
    }

    void fireSearchComplete(int n, String string, int n2, String string2) {
        if (this.sink != null) {
            this.sink.fireSearchComplete(n, string, n2, string2);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }
}

