/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CUDPPort;
import ipworks.IPWorksException;
import ipworks.Mx;

class CMX
extends CUDPPort {
    private static final int MIN_PRIORITY = 65535;
    private static final int PORT = 53;
    private String mailServer = "";
    private String emailAddress = "";
    private int requestId = 1;
    private int pendingRequestId = 0;
    private String status = "";
    Mx sink = null;

    CMX(Mx mx, Object object) {
        super(null, object);
        this.sink = mx;
        try {
            this.setDNSPort(53);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
    }

    void do_Resolve(String string) throws IPWorksException {
        this.setEmailAddress(string);
    }

    int getDNSPort() {
        return this.getRemotePort();
    }

    void setDNSPort(int n) throws IPWorksException {
        this.setRemotePort(n);
    }

    String getDNSServer() {
        return this.getRemoteHost();
    }

    void setDNSServer(String string) throws IPWorksException {
        this.setRemoteHost(string);
    }

    String getEmailAddress() {
        return this.emailAddress;
    }

    String getMailServer() {
        return this.mailServer;
    }

    int getRequestId() {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.requestId;
            return n;
        }
    }

    void setRequestId(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.requestId = n > 0 ? n & Short.MAX_VALUE : 1;
        }
    }

    String getStatus() {
        return this.status;
    }

    private int readCompressed(byte[] byArray, int n, StringBuffer stringBuffer) {
        if (n >= byArray.length) {
            return 0;
        }
        int n2 = 0;
        while (byArray[n] != 0) {
            if ((byArray[n] & 0xC0) > 0) {
                n2 = n + 2;
                n = ((byArray[n] & 0x3F) << 8) + byArray[n + 1];
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(new String(byArray, n + 1, (int)byArray[n]));
            n += byArray[n] + 1;
        }
        return n2 > 0 ? n2 : n + 1;
    }

    void fireDataIn(byte[] byArray, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray.length < 12) {
            return;
        }
        int n2 = (byArray[0] << 8) + byArray[1];
        int n3 = byArray[3] & 0xF;
        int n4 = 12;
        if (n3 != 0) {
            switch (n3) {
                case 1: {
                    this.status = "Format error";
                    break;
                }
                case 2: {
                    this.status = "Server failure";
                    break;
                }
                case 3: {
                    this.status = "Name error";
                    break;
                }
                case 4: {
                    this.status = "Not implemented";
                    break;
                }
                case 5: {
                    this.status = "Refused";
                    break;
                }
                default: {
                    this.status = "Unknown Error";
                }
            }
            this.readCompressed(byArray, n4, stringBuffer);
            this.fireResponse(n2, stringBuffer.toString(), "", 0, 0, n3, this.status);
            return;
        }
        int n5 = (byArray[4] << 8) + byArray[5];
        int n6 = (byArray[6] << 8) + byArray[7];
        int n7 = (byArray[8] << 8) + byArray[9];
        int n8 = (byArray[10] << 8) + byArray[11];
        if (n6 == 0) {
            this.status = "No mail servers were found.";
            this.fireResponse(n2, stringBuffer.toString(), "", 0, 0, 100, this.status);
            return;
        }
        int n9 = 0;
        while (n9 < n5) {
            n4 = this.readCompressed(byArray, n4, stringBuffer) + 4;
            ++n9;
        }
        String string2 = "";
        int n10 = 0;
        while (n10 < n6) {
            StringBuffer stringBuffer2 = new StringBuffer();
            n4 = this.readCompressed(byArray, n4, stringBuffer2);
            int n11 = (byArray[n4] << 8) + byArray[n4 + 1];
            int n12 = (byArray[n4 += 2] << 8) + byArray[n4 + 1];
            int n13 = (byArray[n4 += 2] << 24) + (byArray[n4 + 1] << 16) + (byArray[n4 + 2] << 8) + byArray[n4 + 3];
            int n14 = (byArray[n4 += 4] << 8) + byArray[n4 + 1];
            n4 += 2;
            if (n11 == 15 && n12 == 1) {
                int n15 = (byArray[n4] << 8) + byArray[n4 + 1];
                stringBuffer2 = new StringBuffer();
                this.readCompressed(byArray, n4 + 2, stringBuffer2);
                if (n15 < 65535) {
                    string2 = stringBuffer2.toString();
                }
                this.fireResponse(n2, stringBuffer.toString(), stringBuffer2.toString(), n15, n13, n3, "OK");
            }
            n4 += n14;
            ++n10;
        }
        this.mailServer = string2;
        this.status = "Ok";
    }

    void setEmailAddress(String string) throws IPWorksException {
        Object object;
        int n;
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (string == null || string.length() == 0) {
                this.mailServer = "";
                this.status = "";
                this.pendingRequestId = 0;
                try {
                    this.setActive(false);
                }
                catch (IPWorksException iPWorksException) {
                    // empty catch block
                }
                return;
            }
            if (this.pendingRequestId != 0) {
                throw new IPWorksException(530);
            }
            long l = 0L;
            if (this.timeout > 0) {
                this.pendingRequestId = this.requestId;
                l = System.currentTimeMillis();
            }
        }
        this.mailServer = "";
        this.status = "";
        this.emailAddress = string;
        byte[] byArray = string.getBytes();
        int n2 = string.lastIndexOf(64) + 1;
        byte[] byArray2 = new byte[13 + string.length() - n2 + 5];
        int n3 = 0;
        byArray2[n3++] = (byte)(this.pendingRequestId >> 8);
        byArray2[n3++] = (byte)(this.pendingRequestId & 0xFF);
        byArray2[n3++] = 1;
        byArray2[n3++] = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = 1;
        byArray2[n3++] = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = 0;
        do {
            int n4 = (n = string.indexOf(46, n2)) == -1 ? string.length() - n2 : n - n2;
            byArray2[n3++] = (byte)n4;
            System.arraycopy(byArray, n2, byArray2, n3, n4);
            n3 += n4;
            n2 = n + 1;
        } while (n != -1);
        byArray2[n3++] = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = 15;
        byArray2[n3++] = 0;
        byArray2[n3++] = 1;
        ++this.requestId;
        this.requestId &= Short.MAX_VALUE;
        if (this.requestId == 0) {
            ++this.requestId;
        }
        try {
            long l = System.currentTimeMillis();
            if (!this.getActive()) {
                this.setActive(true);
            }
            this.setDataToSend(byArray2);
            Object object3 = this.syncObj;
            synchronized (object3) {
                while (this.getActive() && this.pendingRequestId != 0) {
                    int n5 = (int)(l + (long)(this.timeout * 1000) - System.currentTimeMillis());
                    if (n5 <= 0) {
                        throw new IPWorksException(301, "Timed out.");
                    }
                    this.waitWhileProcessingEvents1(n5);
                }
            }
            Object var15_16 = null;
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            Object object4 = this.syncObj;
            synchronized (object4) {
                this.pendingRequestId = 0;
            }
            throw throwable;
        }
        synchronized (object) {
            this.pendingRequestId = 0;
        }
    }

    void fireResponse(int n, String string, String string2, int n2, int n3, int n4, String string3) {
        if (n == this.pendingRequestId) {
            this.pendingRequestId = 0;
            this.notifyAllAndEventsProcessor();
        }
        if (this.sink != null) {
            this.sink.fireResponse(n, string, string2, n2, n3, n4, string3);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        this.pendingRequestId = 0;
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }
}

