/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CAsn;
import ipworks.CBase;
import ipworks.CUDPPort;
import ipworks.IPWorksException;
import ipworks.Snmp;

class CSNMP
extends CUDPPort {
    static final int ASN_BOOLEAN = 1;
    static final int ASN_INTEGER = 2;
    static final int ASN_BIT_STR = 3;
    static final int ASN_OCTET_STR = 4;
    static final int ASN_NULL = 5;
    static final int ASN_ENUMERATED = 10;
    static final int ASN_OBJECT_ID = 6;
    static final int ASN_SEQUENCE = 16;
    static final int ASN_SET = 17;
    static final int ASN_UNIVERSAL = 0;
    static final int ASN_APPLICATION = 64;
    static final int ASN_CONTEXT = 128;
    static final int ASN_ = 192;
    static final int ASN_PRIMITIVE = 0;
    static final int ASN_CONSTRUCTOR = 32;
    static final int ASN_LONG_LEN = 128;
    static final int ASN_EXTENSION_ID = 31;
    static final int ASN_BIT8 = 128;
    static final int SNMP_VERSION_1 = 0;
    static final int SNMP_VERSION_2C = 1;
    static final int GET_REQ_MSG = 160;
    static final int GETNEXT_REQ_MSG = 161;
    static final int GET_RSP_MSG = 162;
    static final int SET_REQ_MSG = 163;
    static final int TRP_REQ_MSG = 164;
    static final int GETBULK_REQ_MSG = 165;
    static final int INFORM_REQ_MSG = 166;
    static final int TRP2_REQ_MSG = 167;
    static final int IPADDRESS = 64;
    static final int COUNTER = 65;
    static final int GAUGE = 66;
    static final int TIMETICKS = 67;
    static final int OPAQUE = 68;
    static final int NSAP = 69;
    static final int COUNTER64 = 70;
    static final int UINTEGER = 71;
    private static final int a_Reset = 0;
    private static final int a_SendGetRequest = 1;
    private static final int a_SendGetNextRequest = 2;
    private static final int a_SendSetRequest = 3;
    private static final int a_SendGetResponse = 4;
    private static final int a_SendTrap = 5;
    private static final int a_SendGetBulkRequest = 6;
    private static final int a_SendInformRequest = 7;
    private static final int ot_Integer = 2;
    private static final int ot_OctetString = 4;
    private static final int ot_Null = 5;
    private static final int ot_ObjectId = 6;
    private static final int ot_IPAddress = 64;
    private static final int ot_Counter32 = 65;
    private static final int ot_Gauge32 = 66;
    private static final int ot_TimeTicks = 67;
    private static final int ot_Opaque = 68;
    private static final int ot_NSAP = 69;
    private static final int ot_Counter64 = 70;
    private static final int ot_UnsignedInteger32 = 71;
    private static final int tgt_ColdStart = 0;
    private static final int tgt_WarmStart = 1;
    private static final int tgt_LinkDown = 2;
    private static final int tgt_LinkUp = 3;
    private static final int tgt_AuthenticationFailure = 4;
    private static final int tgt_EGPNeighborLoss = 5;
    private static final int tgt_EnterpriseSpecific = 6;
    private static final int MAX_OBJECTS = 64;
    private static final int SNMP_PORT = 161;
    private static final int SNMP_TRAP_PORT = 162;
    private int action = 0;
    private boolean active = false;
    private String community = "public";
    private int errorIndex = 0;
    private int errorStatus = 0;
    private int requestId = 0;
    private int objCount = 0;
    private String[] objId = new String[64];
    private int[] objType = new int[64];
    private byte[][] objValue = new byte[64][];
    private String trapAgentAddress = "";
    private String trapEnterprise = "";
    private int trapGenericType = 0;
    private int trapSpecificType = 0;
    private int trapTimeStamp = 0;
    private int version = 0;
    private int nonRepeaters = 0;
    private int maxRepetitions = 0;
    Snmp sink = null;

    CSNMP(Snmp snmp, Object object) {
        super(null, object);
        this.sink = snmp;
        try {
            this.setLocalPort(161);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        int n = 0;
        while (n < 64) {
            this.objId[n] = "";
            this.objType[n] = 4;
            this.objValue[n] = new byte[0];
            ++n;
        }
    }

    void do_Reset() throws IPWorksException {
        this.setAction(0);
    }

    void do_SendGetBulkRequest() throws IPWorksException {
        this.setAction(6);
    }

    void do_SendGetNextRequest() throws IPWorksException {
        this.setAction(2);
    }

    void do_SendGetRequest() throws IPWorksException {
        this.setAction(1);
    }

    void do_SendGetResponse() throws IPWorksException {
        this.setAction(4);
    }

    void do_SendInformRequest() throws IPWorksException {
        this.setAction(7);
    }

    void do_SendSetRequest() throws IPWorksException {
        this.setAction(3);
    }

    void do_SendTrap() throws IPWorksException {
        this.setAction(5);
    }

    int getSNMPVersion() {
        return this.version + 1;
    }

    void setSNMPVersion(int n) {
        if (n > 2) {
            n = 2;
        }
        if (n < 1) {
            n = 1;
        }
        this.version = n - 1;
    }

    int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    void setMaxRepetitions(int n) {
        this.maxRepetitions = n > 0 ? n : 0;
    }

    int getNonRepeaters() {
        return this.nonRepeaters;
    }

    void setNonRepeaters(int n) throws IPWorksException {
        this.nonRepeaters = n;
    }

    int getAction() {
        return this.action;
    }

    void setAction(int n) throws IPWorksException {
        this.setSNMPAction(n);
    }

    private void setSNMPAction(int n) throws IPWorksException {
        Object object4;
        block37: {
            Object object2 = this.syncObj;
            synchronized (object2) {
                if (this.action != 0) {
                    throw new IPWorksException(307);
                }
                this.action = n;
                if (n == 0) {
                    this.setObjCount(0);
                    this.errorStatus = 0;
                    this.errorIndex = 0;
                    this.trapAgentAddress = "";
                    this.trapEnterprise = "";
                    this.trapSpecificType = 0;
                    this.trapGenericType = 0;
                    this.trapTimeStamp = 0;
                    return;
                }
            }
            CAsn cAsn = new CAsn();
            CAsn cAsn2 = new CAsn();
            int n2 = 0;
            boolean bl = false;
            try {
                switch (n) {
                    case 1: {
                        int n3 = 0;
                        while (n3 < this.objCount) {
                            this.objType[n3] = 5;
                            ++n3;
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: {
                        if (this.getRemotePort() == 0) {
                            this.setRemotePort(161);
                            bl = true;
                        }
                        cAsn2.appendInt(this.requestId++);
                        cAsn2.appendInt(this.errorStatus);
                        cAsn2.appendInt(this.errorIndex);
                        break;
                    }
                    case 5: {
                        if (this.getRemotePort() == 0) {
                            this.setRemotePort(162);
                            bl = true;
                        }
                        if (this.version == 0) {
                            cAsn2.appendOid(this.trapEnterprise);
                            cAsn2.appendIPAddress(this.trapAgentAddress, 64);
                            cAsn2.appendInt(this.trapGenericType);
                            cAsn2.appendInt(this.trapSpecificType);
                            cAsn2.appendInt(this.trapTimeStamp, 67);
                            break;
                        }
                        cAsn2.appendInt(this.requestId++);
                        cAsn2.appendInt(this.errorStatus);
                        cAsn2.appendInt(this.errorIndex);
                        break;
                    }
                    case 6: {
                        if (this.getRemotePort() == 0) {
                            this.setRemotePort(161);
                            bl = true;
                        }
                        cAsn2.appendInt(this.requestId++);
                        cAsn2.appendInt(this.nonRepeaters);
                        cAsn2.appendInt(this.maxRepetitions);
                        break;
                    }
                    default: {
                        throw new IPWorksException(6304);
                    }
                }
                cAsn2.append(this.buildVarBindList().getBytes());
                cAsn.appendInt(this.version);
                cAsn.appendStr(this.community.getBytes());
                switch (n) {
                    case 1: {
                        n2 = 160;
                        break;
                    }
                    case 2: {
                        n2 = 161;
                        break;
                    }
                    case 3: {
                        n2 = 163;
                        break;
                    }
                    case 4: {
                        n2 = 162;
                        break;
                    }
                    case 5: {
                        n2 = this.version == 0 ? 164 : 167;
                    }
                    case 6: {
                        n2 = 165;
                        break;
                    }
                    case 7: {
                        n2 = 166;
                    }
                }
                cAsn.appendRaw(cAsn2.getBytes(), n2);
                cAsn.makeSequence();
                if (!this.getActive()) {
                    this.setActive(true);
                }
                this.setDataToSend(cAsn.getBytes());
                this.firePDUTrace(cAsn.getBytes(), "");
                Object var9_9 = null;
                if (!bl) break block37;
            }
            catch (Throwable throwable) {
                Object object32;
                Object var9_10 = null;
                if (bl) {
                    try {
                        this.setRemotePort(0);
                    }
                    catch (IPWorksException object32) {
                        // empty catch block
                    }
                }
                object32 = this.syncObj;
                synchronized (object32) {
                    this.action = 0;
                }
                throw throwable;
            }
            try {
                this.setRemotePort(0);
            }
            catch (IPWorksException object4) {
                // empty catch block
            }
        }
        object4 = this.syncObj;
        synchronized (object4) {
            this.action = 0;
        }
    }

    String getCommunity() {
        return this.community;
    }

    void setCommunity(String string) {
        this.community = string != null ? string : "";
    }

    int getErrorIndex() {
        return this.errorIndex;
    }

    void setErrorIndex(int n) {
        this.errorIndex = n;
    }

    int getErrorStatus() {
        return this.errorStatus;
    }

    void setErrorStatus(int n) {
        this.errorStatus = n;
    }

    int getObjCount() {
        return this.objCount;
    }

    void setObjCount(int n) throws IPWorksException {
        if (n > 64) {
            throw new IPWorksException(6302);
        }
        this.objCount = n;
        int n2 = n;
        while (n2 < 64) {
            this.objId[n2] = "";
            this.objType[n2] = 4;
            this.objValue[n2] = new byte[0];
            ++n2;
        }
    }

    private boolean indexInRange(int n) {
        return n > 0 && n <= this.objCount;
    }

    private void checkIndex(int n) throws IPWorksException {
        if (n > this.objCount || n < 1) {
            throw new IPWorksException(6301);
        }
    }

    String getObjId(int n) {
        return this.indexInRange(n) ? this.objId[--n] : "";
    }

    void setObjId(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.objId[--n] = string != null ? string : "";
    }

    int getObjType(int n) {
        return this.indexInRange(n) ? this.objType[--n] : 0;
    }

    void setObjType(int n, int n2) throws IPWorksException {
        this.checkIndex(n);
        this.objType[--n] = n2;
    }

    byte[] getObjValue(int n) {
        return this.indexInRange(n) ? this.objValue[--n] : CBase.BYTE0;
    }

    void setObjValue(int n, byte[] byArray) throws IPWorksException {
        this.checkIndex(n);
        if (byArray == null) {
            this.objValue[--n] = CBase.BYTE0;
        } else {
            this.objValue[--n] = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.objValue[n], 0, byArray.length);
        }
    }

    void setObjValue(int n, byte[] byArray, int n2, int n3) throws IPWorksException {
        this.checkIndex(n);
        if (byArray == null) {
            this.objValue[--n] = CBase.BYTE0;
        } else {
            this.objValue[--n] = new byte[n3];
            System.arraycopy(byArray, n2, this.objValue[n], 0, n3);
        }
    }

    int getRequestId() {
        return this.requestId;
    }

    void setRequestId(int n) throws IPWorksException {
        this.requestId = n;
    }

    String getTrapAgentAddress() {
        return this.trapAgentAddress;
    }

    void setTrapAgentAddress(String string) {
        this.trapAgentAddress = string != null ? string : "";
    }

    String getTrapEnterprise() {
        return this.trapEnterprise;
    }

    void setTrapEnterprise(String string) {
        this.trapEnterprise = string != null ? string : "";
    }

    int getTrapGenericType() {
        return this.trapGenericType;
    }

    void setTrapGenericType(int n) {
        this.trapGenericType = n;
    }

    int getTrapSpecificType() {
        return this.trapSpecificType;
    }

    void setTrapSpecificType(int n) {
        this.trapSpecificType = n;
    }

    int getTrapTimeStamp() {
        return this.trapTimeStamp;
    }

    void setTrapTimeStamp(int n) {
        this.trapTimeStamp = n;
    }

    boolean getShareLocalPort() {
        return false;
    }

    void setShareLocalPort(boolean bl) throws IPWorksException {
    }

    void fireDataIn(byte[] byArray, String string, int n) {
        CAsn cAsn = new CAsn(byArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        this.firePDUTrace(byArray, string);
        try {
            CAsn cAsn2;
            cAsn.unmakeSequence();
            cAsn.parseInteger(0);
            if (cAsn.parsedInt != 0 && cAsn.parsedInt != 1) {
                throw new IPWorksException(305);
            }
            int n10 = cAsn.parsedInt;
            cAsn.parseStr(1);
            string2 = new String(cAsn.parsedStr);
            cAsn.parseRaw(2);
            CAsn cAsn3 = cAsn.parsedRaw;
            int n11 = cAsn3.type;
            switch (n11) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: {
                    cAsn3.parseInteger(0);
                    n2 = cAsn3.parsedInt;
                    cAsn3.parseInteger(1);
                    n3 = cAsn3.parsedInt;
                    cAsn3.parseInteger(2);
                    n4 = cAsn3.parsedInt;
                    cAsn3.parseRaw(3);
                    cAsn2 = cAsn3.parsedRaw;
                    break;
                }
                case 165: {
                    cAsn3.parseInteger(0);
                    n2 = cAsn3.parsedInt;
                    cAsn3.parseInteger(1);
                    n8 = cAsn3.parsedInt;
                    cAsn3.parseInteger(2);
                    n9 = cAsn3.parsedInt;
                    cAsn3.parseRaw(3);
                    cAsn2 = cAsn3.parsedRaw;
                    break;
                }
                case 164: {
                    if (n10 == 0) {
                        cAsn3.parseOid(0);
                        string3 = new String(cAsn3.parsedOid);
                        cAsn3.parseIPAddress(1);
                        string4 = cAsn3.parsedIPAddress;
                        cAsn3.parseInteger(2);
                        n5 = cAsn3.parsedInt;
                        cAsn3.parseInteger(3);
                        n6 = cAsn3.parsedInt;
                        cAsn3.parseInteger(4);
                        n7 = cAsn3.parsedInt;
                        cAsn3.parseRaw(5);
                        cAsn2 = cAsn3.parsedRaw;
                        break;
                    }
                    cAsn3.parseInteger(0);
                    n2 = cAsn3.parsedInt;
                    cAsn3.parseInteger(1);
                    n3 = cAsn3.parsedInt;
                    cAsn3.parseInteger(2);
                    n4 = cAsn3.parsedInt;
                    cAsn3.parseRaw(3);
                    cAsn2 = cAsn3.parsedRaw;
                    break;
                }
                default: {
                    throw new IPWorksException(306);
                }
            }
            this.parseVarBindList(cAsn2);
            switch (n11) {
                case 160: {
                    this.fireGetRequest(n2, string2, string, n);
                    break;
                }
                case 161: {
                    this.fireGetNextRequest(n2, string2, string, n);
                    break;
                }
                case 162: {
                    this.fireGetResponse(n2, string2, n3, n4, string, n);
                    break;
                }
                case 166: {
                    this.fireInformRequest(n2, string2, n3, n4, string, n);
                    break;
                }
                case 163: {
                    this.fireSetRequest(n2, string2, string, n);
                    break;
                }
                case 165: {
                    this.fireGetBulkRequest(n2, string2, n8, n9, string, n);
                    break;
                }
                case 164: {
                    if (n10 == 0) {
                        this.fireTrap(string2, string3, string4, n5, n6, n7, string, n);
                        break;
                    }
                    this.fireTrap(string2, "", "", n3, n4, 0, string, n);
                }
            }
        }
        catch (IPWorksException iPWorksException) {
            this.fireError(iPWorksException);
        }
    }

    private static byte[] longToByteArray(long l) {
        return String.valueOf(l).getBytes();
    }

    private static long byteArrayToLong(byte[] byArray) throws IPWorksException {
        try {
            return Long.parseLong(new String(byArray));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IPWorksException(numberFormatException);
        }
    }

    private CAsn buildVarBindList() throws IPWorksException {
        CAsn cAsn = new CAsn();
        int n = 0;
        while (n < this.objCount) {
            CAsn cAsn2 = new CAsn();
            cAsn2.appendOid(this.objId[n]);
            int n2 = this.objType[n];
            byte[] byArray = this.objValue[n];
            switch (n2) {
                case 2: {
                    cAsn2.appendInt((int)CSNMP.byteArrayToLong(byArray), n2);
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 71: {
                    cAsn2.appendUInt((int)CSNMP.byteArrayToLong(byArray), n2);
                    break;
                }
                case 70: {
                    cAsn2.appendInt64(CSNMP.byteArrayToLong(byArray), n2);
                    break;
                }
                case 64: {
                    cAsn2.appendIPAddress(new String(byArray), n2);
                    break;
                }
                case 5: {
                    cAsn2.appendNull(n2);
                    break;
                }
                case 4: {
                    cAsn2.appendStr(byArray, n2);
                    break;
                }
                case 6: {
                    cAsn2.appendOid(new String(byArray), n2);
                    break;
                }
                default: {
                    cAsn2.appendRaw(byArray, n2);
                }
            }
            cAsn2.makeSequence();
            cAsn.append(cAsn2.getBytes());
            ++n;
        }
        cAsn.makeSequence();
        return cAsn;
    }

    void parseVarBindList(CAsn cAsn) throws IPWorksException {
        this.objCount = 0;
        while (this.objCount < 64) {
            CAsn cAsn2;
            try {
                cAsn.parseRaw(this.objCount);
                cAsn2 = cAsn.parsedRaw;
            }
            catch (IPWorksException iPWorksException) {
                if (iPWorksException.getCode() == 447) {
                    return;
                }
                throw iPWorksException;
            }
            cAsn2.parseOid(0);
            this.objId[this.objCount] = new String(cAsn2.parsedOid);
            cAsn2.parseStr(1);
            this.objType[this.objCount] = cAsn2.type;
            switch (cAsn2.type) {
                case 2: {
                    cAsn2.parseInteger(1);
                    this.objValue[this.objCount] = CSNMP.longToByteArray(cAsn2.parsedInt);
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 71: {
                    cAsn2.parseUInt(1);
                    this.objValue[this.objCount] = CSNMP.longToByteArray(cAsn2.parsedUInt);
                    break;
                }
                case 70: {
                    cAsn2.parseInt64(1);
                    this.objValue[this.objCount] = CSNMP.longToByteArray(cAsn2.parsedInt64);
                    break;
                }
                case 5: {
                    this.objValue[this.objCount] = new byte[0];
                    break;
                }
                case 6: {
                    cAsn2.parseOid(1);
                    this.objValue[this.objCount] = cAsn2.parsedOid.getBytes();
                    break;
                }
                case 64: {
                    if (cAsn2.typeLength != 4) {
                        throw new IPWorksException(6303);
                    }
                    cAsn2.parseIPAddress(1);
                    this.objValue[this.objCount] = cAsn2.parsedIPAddress.getBytes();
                    break;
                }
                default: {
                    this.objValue[this.objCount] = cAsn2.parsedStr;
                }
            }
            ++this.objCount;
        }
    }

    void firePDUTrace(byte[] byArray, String string) {
        if (this.sink != null) {
            this.sink.firePDUTrace(byArray, string);
        }
    }

    void fireInformRequest(int n, String string, int n2, int n3, String string2, int n4) {
        if (this.sink != null) {
            this.sink.fireInformRequest(n, string, n2, n3, string2, n4);
        }
    }

    void fireGetBulkRequest(int n, String string, int n2, int n3, String string2, int n4) {
        if (this.sink != null) {
            this.sink.fireGetBulkRequest(n, string, n2, n3, string2, n4);
        }
    }

    void fireGetNextRequest(int n, String string, String string2, int n2) {
        if (this.sink != null) {
            this.sink.fireGetNextRequest(n, string, string2, n2);
        }
    }

    void fireGetRequest(int n, String string, String string2, int n2) {
        if (this.sink != null) {
            this.sink.fireGetRequest(n, string, string2, n2);
        }
    }

    void fireGetResponse(int n, String string, int n2, int n3, String string2, int n4) {
        if (this.sink != null) {
            this.sink.fireGetResponse(n, string, n2, n3, string2, n4);
        }
    }

    void fireReadyToSend() {
        if (this.sink != null) {
            this.sink.fireReadyToSend();
        }
    }

    void fireSetRequest(int n, String string, String string2, int n2) {
        if (this.sink != null) {
            this.sink.fireSetRequest(n, string, string2, n2);
        }
    }

    void fireTrap(String string, String string2, String string3, int n, int n2, int n3, String string4, int n4) {
        if (this.sink != null) {
            this.sink.fireTrap(string, string2, string3, n, n2, n3, string4, n4);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }
}

