/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import java.io.IOException;
import java.io.InputStream;

class FragmentedInputStream
extends InputStream {
    private InputStream iStream;
    private long remainingBytes;
    private IOException ioe = null;

    FragmentedInputStream(InputStream inputStream, long l, long l2) {
        this.iStream = inputStream;
        try {
            if (inputStream.skip(l) != l) {
                this.ioe = new IOException();
            }
        }
        catch (IOException iOException) {
            this.ioe = iOException;
        }
        this.remainingBytes = l2;
    }

    FragmentedInputStream(InputStream inputStream, long l) {
        this.iStream = inputStream;
        this.remainingBytes = l;
    }

    public int read() throws IOException {
        if (this.ioe != null) {
            throw this.ioe;
        }
        if (this.remainingBytes == -1L) {
            return this.iStream.read();
        }
        if (this.remainingBytes > 0L) {
            --this.remainingBytes;
            return this.iStream.read();
        }
        return -1;
    }

    public void close() throws IOException {
        this.iStream.close();
    }
}

