/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CIMAP;

class ImapTokenizer {
    private static final char openParTag = '(';
    private static final char closeParTag = ')';
    private static final char spaceTag = ' ';
    private static final char openSwirlTag = '{';
    private static final char closeSwirlTag = '}';
    private static final char quoteTag = '\"';
    private static final String eol = "\r\n";
    private String imapString;
    private int index = 0;
    private int length;

    ImapTokenizer(String string) {
        this.imapString = string;
        this.length = string.length();
    }

    ImapTokenizer(String string, boolean bl) {
        this(string.substring(1, string.length() - 1));
    }

    String nextToken() {
        try {
            int n = this.index;
            char c = this.imapString.charAt(this.index++);
            if (c == '{') {
                int n2 = this.imapString.indexOf(125, this.index);
                int n3 = CIMAP.tryParseInt(this.imapString.substring(n + 1, n2));
                int n4 = this.index = n2 + 1 + eol.length() + n3;
                if (this.index < this.length && this.imapString.charAt(this.index) == ' ') {
                    ++this.index;
                }
                return this.imapString.substring(n2 + 1 + eol.length(), n4);
            }
            if (c == '\"') {
                this.index = this.imapString.indexOf(34, this.index) + 2;
                return this.imapString.substring(n + 1, this.index - 2);
            }
            if (c == '(') {
                int n5 = 1;
                while (this.index < this.length) {
                    switch (this.imapString.charAt(this.index++)) {
                        case '\"': {
                            this.index = this.imapString.indexOf(34, this.index) + 1;
                            break;
                        }
                        case '{': {
                            int n6 = this.imapString.indexOf(125, this.index);
                            int n7 = CIMAP.tryParseInt(this.imapString.substring(this.index, n6));
                            this.index = n6 + 1 + eol.length() + n7;
                            break;
                        }
                        case '(': {
                            ++n5;
                            break;
                        }
                        case ')': {
                            --n5;
                        }
                    }
                    if (n5 == 0) break;
                }
                int n8 = this.index;
                if (this.index < this.length && this.imapString.charAt(this.index) == ' ') {
                    ++this.index;
                }
                return this.imapString.substring(n, n8);
            }
            this.index = this.imapString.indexOf(32, this.index) + 1;
            if (this.index == 0) {
                this.index = this.length + 1;
            }
            return this.imapString.substring(n, this.index - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.index = this.length;
            return "";
        }
    }

    String lastToken() {
        int n = this.imapString.lastIndexOf(34);
        int n2 = this.imapString.lastIndexOf(34, n - 1);
        try {
            return this.imapString.substring(n2 + 1, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    boolean hasMoreTokens() {
        return this.index < this.length;
    }
}

