/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.JCDataInterpreter;
import com.klg.jclass.util.JCDebug;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;

public class JCDefaultDataInterpreter
extends JCDataInterpreter
implements Serializable {
    private StreamTokenizer tokenizer;
    private final char QUOTE = (char)39;

    public JCDefaultDataInterpreter() {
    }

    public JCDefaultDataInterpreter(BaseDataSource baseDataSource) {
        super(baseDataSource);
    }

    protected void ctor(Reader reader) throws IOException {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(39);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(true);
        this.tokenizer.parseNumbers();
        this.tokenizer.whitespaceChars(43, 43);
        this.init();
        this.tokenizer = null;
    }

    private void displayErrorMessage(int n) {
        boolean bl = true;
        String string = "Error reading data: line " + this.tokenizer.lineno() + ": ";
        switch (n) {
            case 1: {
                string = String.valueOf(string) + "Data must start with ARRAY or GENERAL and not";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "Expect either a hole or numeric value and not ";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "Expect a point label and not ";
                break;
            }
            default: {
                return;
            }
        }
        if (bl) {
            string = this.tokenizer.ttype == 39 ? String.valueOf(string) + "'" + this.tokenizer.sval + "'" : (this.tokenizer.ttype == -3 ? String.valueOf(string) + this.tokenizer.sval : (this.tokenizer.ttype == -2 ? String.valueOf(string) + this.tokenizer.nval : String.valueOf(string) + this.tokenizer.toString()));
        }
        System.err.println(string);
    }

    private double getNextDouble() throws IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -2) {
            String string;
            if (this.tokenizer.ttype == -3 && (string = this.tokenizer.sval).equalsIgnoreCase("HOLE")) {
                return this.baseDS.holeValue;
            }
            this.displayErrorMessage(2);
            throw new IOException("Error in data file format - " + this.tokenizer);
        }
        double d = this.tokenizer.nval;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -3 && this.tokenizer.sval != null && (this.tokenizer.sval.charAt(0) == 'e' || this.tokenizer.sval.charAt(0) == 'E')) {
            if (this.tokenizer.sval.length() == 1) {
                this.tokenizer.nextToken();
                if (this.tokenizer.ttype == -2) {
                    d *= Math.pow(10.0, this.tokenizer.nval);
                }
            } else {
                String string = this.tokenizer.sval;
                int n = Integer.valueOf(this.tokenizer.sval.substring(1));
                d *= Math.pow(10.0, n);
            }
        } else {
            this.tokenizer.pushBack();
        }
        return d;
    }

    private synchronized void init() throws IOException {
        boolean bl;
        boolean bl2 = false;
        if (this.tokenizer.nextToken() != -3) {
            bl2 = true;
        } else if (this.tokenizer.sval.equals("debug")) {
            JCDebug.setEnabled(true);
            JCDebug.setTag("data");
            if (this.tokenizer.nextToken() != -3) {
                bl2 = true;
            }
        }
        if (bl2 || !this.tokenizer.sval.equals("array") && !this.tokenizer.sval.equals("general")) {
            this.displayErrorMessage(1);
            throw new IOException("Data must start with ARRAY or GENERAL");
        }
        boolean bl3 = false;
        bl3 = this.tokenizer.sval.equals("array");
        if (this.tokenizer.nextToken() == 39) {
            this.baseDS.name = new String(this.tokenizer.sval);
        } else {
            this.tokenizer.pushBack();
        }
        int n = (int)this.getNextDouble();
        int n2 = (int)this.getNextDouble();
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("t")) {
            bl = true;
        } else {
            bl = false;
            this.tokenizer.pushBack();
        }
        JCDebug.println("data", "Reading in " + (bl3 ? "ARRAY" : "GENERAL") + " data with " + n + " series and " + n2 + " points. Data " + (bl ? "is" : "is not") + " transposed");
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("hole")) {
            this.baseDS.holeValue = this.getNextDouble();
            JCDebug.println("data", "Hole value is " + this.baseDS.holeValue);
        } else {
            this.tokenizer.pushBack();
        }
        if (bl3) {
            this.readArrayData(n, n2, bl);
        } else {
            this.readGeneralData(n, n2, bl);
        }
    }

    private void readArrayData(int n, int n2, boolean bl) throws IOException {
        this.baseDS.xvalues = new double[1][n2];
        this.baseDS.yvalues = new double[n][n2];
        this.baseDS.seriesLabels = new String[n];
        this.baseDS.pointLabels = new String[n2];
        if (bl) {
            int n3 = 0;
            while (n3 < n + 1) {
                if (this.tokenizer.nextToken() == 39) {
                    if (n3 > 0) {
                        this.baseDS.seriesLabels[n3 - 1] = new String(this.tokenizer.sval);
                        JCDebug.println("data", "Series Name " + (n3 - 1) + "-" + this.baseDS.seriesLabels[n3 - 1]);
                    }
                } else {
                    this.tokenizer.pushBack();
                    break;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                if (this.tokenizer.nextToken() == 39) {
                    this.baseDS.pointLabels[n3] = new String(this.tokenizer.sval);
                    JCDebug.println("data", "Point Label " + n3 + "-" + this.baseDS.pointLabels[n3]);
                } else {
                    this.tokenizer.pushBack();
                }
                this.baseDS.xvalues[0][n3] = this.getNextDouble();
                int n4 = 0;
                while (n4 < n) {
                    this.baseDS.yvalues[n4][n3] = this.getNextDouble();
                    JCDebug.println("data", "Value (" + n4 + "," + n3 + ") is (" + this.baseDS.xvalues[0][n3] + "," + this.baseDS.yvalues[n4][n3] + ")");
                    ++n4;
                }
                ++n3;
            }
        } else {
            Object var6_8 = null;
            int n5 = 0;
            while (n5 < n2) {
                if (this.tokenizer.nextToken() == 39) {
                    this.baseDS.pointLabels[n5] = new String(this.tokenizer.sval);
                    JCDebug.println("data", "Point Label " + n5 + "-" + this.baseDS.pointLabels[n5]);
                } else {
                    this.tokenizer.pushBack();
                }
                ++n5;
            }
            int n6 = 0;
            while (n6 < n + 1) {
                if (this.tokenizer.nextToken() == 39) {
                    if (n6 > 0) {
                        this.baseDS.seriesLabels[n6 - 1] = new String(this.tokenizer.sval);
                        JCDebug.println("data", "Series Name " + (n6 - 1) + "-" + this.baseDS.seriesLabels[n6 - 1]);
                    }
                } else {
                    this.tokenizer.pushBack();
                }
                n5 = 0;
                while (n5 < n2) {
                    double d = this.getNextDouble();
                    if (n6 == 0) {
                        this.baseDS.xvalues[0][n5] = d;
                    } else {
                        this.baseDS.yvalues[n6 - 1][n5] = d;
                        JCDebug.println("data", "Value (" + n6 + "," + n5 + ") is (" + this.baseDS.xvalues[0][n5] + "," + this.baseDS.yvalues[n6 - 1][n5] + ")");
                    }
                    ++n5;
                }
                ++n6;
            }
        }
    }

    private void readGeneralData(int n, int n2, boolean bl) throws IOException {
        int n3;
        this.baseDS.xvalues = new double[n][];
        this.baseDS.yvalues = new double[n][];
        this.baseDS.seriesLabels = new String[n];
        this.baseDS.pointLabels = new String[n2];
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("labels")) {
            n3 = 0;
            while (n3 < n2) {
                if (this.tokenizer.nextToken() != 39) {
                    this.displayErrorMessage(3);
                    throw new IOException("Error in reading point labels - " + this.tokenizer);
                }
                this.baseDS.pointLabels[n3] = new String(this.tokenizer.sval);
                JCDebug.println("data", "Point Label " + n3 + "-" + this.baseDS.pointLabels[n3]);
                ++n3;
            }
        } else {
            this.tokenizer.pushBack();
            this.baseDS.pointLabels = null;
        }
        if (bl) {
            int n4 = 0;
            while (n4 < n) {
                if (this.tokenizer.nextToken() == 39) {
                    this.baseDS.seriesLabels[n4] = new String(this.tokenizer.sval);
                    JCDebug.println("data", "Series Name " + n4 + "-" + this.baseDS.seriesLabels[n4]);
                } else {
                    this.tokenizer.pushBack();
                }
                n2 = (int)this.getNextDouble();
                JCDebug.println("data", "Number of points: " + n2);
                this.baseDS.xvalues[n4] = new double[n2];
                this.baseDS.yvalues[n4] = new double[n2];
                int n5 = 0;
                while (n5 < n2) {
                    this.baseDS.xvalues[n4][n5] = this.getNextDouble();
                    this.baseDS.yvalues[n4][n5] = this.getNextDouble();
                    JCDebug.println("data", "Value (" + n4 + "," + n5 + ") is (" + this.baseDS.xvalues[n4][n5] + "," + this.baseDS.yvalues[n4][n5] + ")");
                    ++n5;
                }
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < n) {
                if (this.tokenizer.nextToken() == 39) {
                    this.baseDS.seriesLabels[n6] = new String(this.tokenizer.sval);
                    JCDebug.println("data", "Series Name " + n6 + "-" + this.baseDS.seriesLabels[n6]);
                } else {
                    this.tokenizer.pushBack();
                }
                n2 = (int)this.getNextDouble();
                JCDebug.println("data", "Number of points: " + n2);
                this.baseDS.xvalues[n6] = new double[n2];
                this.baseDS.yvalues[n6] = new double[n2];
                n3 = 0;
                while (n3 < 2) {
                    int n7 = 0;
                    while (n7 < n2) {
                        double d = this.getNextDouble();
                        if (n3 == 0) {
                            this.baseDS.xvalues[n6][n7] = d;
                        } else {
                            this.baseDS.yvalues[n6][n7] = d;
                            JCDebug.println("data", "Value (" + n6 + "," + n7 + ") is (" + this.baseDS.xvalues[n6][n7] + "," + this.baseDS.yvalues[n6][n7] + ")");
                        }
                        ++n7;
                    }
                    ++n3;
                }
                ++n6;
            }
        }
    }
}

