/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellBorderModel;
import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCPrintEvent;
import com.klg.jclass.table.JCPrintListener;
import com.klg.jclass.table.JCPrintPreview;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.PrintCellAreaHandler;
import com.klg.jclass.table.PrintCellAreaRenderer;
import com.klg.jclass.table.PrintCellLayout;
import com.klg.jclass.table.SpanHandler;
import com.klg.jclass.table.TableLayout;
import com.klg.jclass.table.resources.LocaleBundle;
import com.klg.jclass.util.JCListenerList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class JCPrintTable
extends JCTable
implements Printable {
    public static final int MARGIN_IN_INCHES = 0;
    public static final int MARGIN_IN_PIXELS = 1;
    protected JCTable table;
    protected int page_width = 0;
    protected int page_height = 0;
    protected int page_resolution = 72;
    protected int table_width = 0;
    protected int table_height = 0;
    protected Insets margin = new Insets(72, 72, 72, 72);
    protected int margin_unit = 1;
    protected int current_page;
    public static final int ALL_PAGES = -1;
    protected int print_page = -1;
    protected PageFormat page_format;
    protected JCListenerList printListeners = null;

    public JCPrintTable(JCTable jCTable) {
        this.table = jCTable;
        this.loadSettings(jCTable);
    }

    public void addPrintListener(JCPrintListener jCPrintListener) {
        this.printListeners = JCListenerList.add(this.printListeners, jCPrintListener);
    }

    private void doPrintBody(Graphics graphics, int n) {
        if (this.printListeners != null) {
            Graphics graphics2 = graphics.create();
            graphics2.setColor(Color.black);
            graphics2.setFont(this.getFont());
            JCPrintEvent jCPrintEvent = new JCPrintEvent(this, graphics2, n + 1, this.getNumPages(), 2, this);
            this.fireJCPrintEvent(jCPrintEvent);
            graphics2.dispose();
        }
    }

    private void doPrintPageFooter(Graphics graphics, int n) {
        Graphics graphics2 = graphics.create();
        graphics2.setColor(Color.black);
        graphics2.setFont(this.getFont());
        int n2 = this.margin_unit == 0 ? this.page_resolution : 1;
        graphics2.setClip(n2 * this.margin.left, this.page_height - n2 * this.margin.bottom, this.table_width, n2 * this.margin.bottom);
        graphics2.translate(n2 * this.margin.left, this.page_height - n2 * this.margin.bottom);
        if (this.printListeners != null) {
            JCPrintEvent jCPrintEvent = new JCPrintEvent(this, graphics2, n + 1, this.getNumPages(), 3, this);
            this.fireJCPrintEvent(jCPrintEvent);
        } else {
            this.printPageFooter(graphics, n + 1);
        }
        graphics2.dispose();
    }

    private void doPrintPageHeader(Graphics graphics, int n) {
        if (this.printListeners != null) {
            Graphics graphics2 = graphics.create();
            graphics2.setColor(Color.black);
            graphics2.setFont(this.getFont());
            int n2 = this.margin_unit == 0 ? this.page_resolution : 1;
            graphics2.setClip(n2 * this.margin.left, 0, this.table_width, n2 * this.margin.top);
            graphics2.translate(n2 * this.margin.left, 0);
            JCPrintEvent jCPrintEvent = new JCPrintEvent(this, graphics2, n + 1, this.getNumPages(), 1, this);
            this.fireJCPrintEvent(jCPrintEvent);
            graphics2.dispose();
        }
    }

    protected void fireJCPrintEvent(JCPrintEvent jCPrintEvent) {
        Enumeration enumeration = JCListenerList.elements(this.printListeners);
        while (enumeration.hasMoreElements()) {
            JCPrintListener jCPrintListener = (JCPrintListener)enumeration.nextElement();
            switch (jCPrintEvent.getType()) {
                case 1: {
                    jCPrintListener.printPageHeader(jCPrintEvent);
                    break;
                }
                case 2: {
                    jCPrintListener.printPageBody(jCPrintEvent);
                    break;
                }
                case 3: {
                    jCPrintListener.printPageFooter(jCPrintEvent);
                    break;
                }
            }
        }
    }

    public Point getBounds(int n, int n2) {
        Point point = new Point(0, 0);
        JCCellRange jCCellRange = this.getPageCellRange(this.current_page);
        if (n == -1) {
            if (n2 < this.frozen_columns) {
                point.x = this.getRowLabelPlacement() == 2 ? (this.getFrozenColumnPlacement() == 2 ? this.getRowLabelWidth() + this.getRowLabelOffset() + 3 * this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getFrozenColumnWidth() - this.getFrameBorderWidth()) : (this.getFrozenColumnPlacement() == 2 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getRowLabelWidth() - this.getRowLabelOffset() - this.getFrozenColumnWidth() - 3 * this.getFrameBorderWidth());
                point.x += this.getColumnPosition(n2) - this.getColumnPosition(0);
            } else {
                point.x = this.getRowLabelPlacement() == 2 ? this.getRowLabelWidth() + this.getRowLabelOffset() + 3 * this.getFrameBorderWidth() : this.getFrameBorderWidth();
                if (this.frozen_columns > 0 && this.getFrozenColumnPlacement() == 2) {
                    point.x += this.getFrozenColumnWidth();
                }
                point.x += this.getColumnPosition(n2) - this.getColumnPosition(jCCellRange.start_column);
            }
            point.y = this.getColumnLabelPlacement() == 1 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - 2 * this.getFrameBorderWidth();
        } else if (n2 == -1) {
            point.x = this.getRowLabelPlacement() == 2 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getRowLabelWidth() - this.getRowLabelOffset() - 2 * this.getFrameBorderWidth();
            if (n < this.frozen_rows) {
                point.y = this.getColumnLabelPlacement() == 1 ? (this.getFrozenRowPlacement() == 1 ? this.getColumnLabelHeight() + this.getColumnLabelOffset() + 3 * this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getFrozenRowHeight() - this.getFrameBorderWidth()) : (this.getFrozenRowPlacement() == 1 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - this.getFrozenRowHeight() - 3 * this.getFrameBorderWidth());
                point.y += this.getRowPosition(n) - this.getRowPosition(0);
            } else {
                point.y = this.getColumnLabelPlacement() == 1 ? this.getColumnLabelHeight() + this.getColumnLabelOffset() + 3 * this.getFrameBorderWidth() : this.getFrameBorderWidth();
                if (this.frozen_rows > 0 && this.getFrozenRowPlacement() == 1) {
                    point.y += this.getFrozenRowHeight();
                }
                point.y += this.getRowPosition(n) - this.getRowPosition(jCCellRange.start_row);
            }
        } else {
            if (n2 < this.frozen_columns) {
                point.x = this.getRowLabelPlacement() == 2 ? (this.getFrozenColumnPlacement() == 2 ? this.getRowLabelWidth() + this.getRowLabelOffset() + 3 * this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getFrozenColumnWidth() - this.getFrameBorderWidth()) : (this.getFrozenColumnPlacement() == 2 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).width - this.getRowLabelWidth() - this.getRowLabelOffset() - this.getFrozenColumnWidth() - 3 * this.getFrameBorderWidth());
                point.x += this.getColumnPosition(n2) - this.getColumnPosition(0);
            } else {
                point.x = this.getRowLabelPlacement() == 2 ? this.getRowLabelWidth() + this.getRowLabelOffset() + 3 * this.getFrameBorderWidth() : this.getFrameBorderWidth();
                if (this.frozen_columns > 0 && this.getFrozenColumnPlacement() == 2) {
                    point.x += this.getFrozenColumnWidth();
                }
                point.x += this.getColumnPosition(n2) - this.getColumnPosition(jCCellRange.start_column);
            }
            if (n < this.frozen_rows) {
                point.y = this.getColumnLabelPlacement() == 1 ? (this.getFrozenRowPlacement() == 1 ? this.getColumnLabelHeight() + this.getColumnLabelOffset() + 3 * this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getFrozenRowHeight() - this.getFrameBorderWidth()) : (this.getFrozenRowPlacement() == 1 ? this.getFrameBorderWidth() : this.getTableDimensions((int)this.current_page).height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - this.getFrozenRowHeight() - 3 * this.getFrameBorderWidth());
                point.y += this.getRowPosition(n) - this.getRowPosition(0);
            } else {
                point.y = this.getColumnLabelPlacement() == 1 ? this.getColumnLabelHeight() + this.getColumnLabelOffset() + 3 * this.getFrameBorderWidth() : this.getFrameBorderWidth();
                if (this.frozen_rows > 0 && this.getFrozenRowPlacement() == 1) {
                    point.y += this.getFrozenRowHeight();
                }
                point.y += this.getRowPosition(n) - this.getRowPosition(jCCellRange.start_row);
            }
        }
        Point point2 = this.getTableOffset();
        point.x += point2.x;
        point.y += point2.y;
        return point;
    }

    private Rectangle getCellRangeBounds(JCCellRange jCCellRange) {
        return this.getCellLayout().getBounds(jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column);
    }

    private int getColumnLabelHeight() {
        if (this.column_label_display) {
            return this.getCellLayout().getHeight(-1);
        }
        return 0;
    }

    private int getColumnPosition(int n) {
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        return cellLayoutModel.getColumnPosition(n);
    }

    public Insets getDefaultPageMargins() {
        this.margin_unit = 1;
        this.margin = new Insets(72, 72, 72, 72);
        return this.margin;
    }

    private int getFrozenColumnWidth() {
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n = 0;
        int n2 = 0;
        while (n2 < this.getFrozenColumns()) {
            n += cellLayoutModel.getWidth(n2);
            ++n2;
        }
        return n;
    }

    private int getFrozenRowHeight() {
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n = 0;
        int n2 = 0;
        while (n2 < this.getFrozenRows()) {
            n += cellLayoutModel.getHeight(n2);
            ++n2;
        }
        return n;
    }

    public int getMarginUnits() {
        return this.margin_unit;
    }

    private int getNumColumnPages() throws IllegalSizeException {
        int n;
        int n2 = 1;
        int n3 = this.getRowLabelWidth();
        if (n3 + this.row_label_offset + (n = this.getFrozenColumnWidth()) + 4 * this.frame_border_width > this.table_width) {
            throw new IllegalSizeException("The total width of row labels and frozen columns is larger than the page width.");
        }
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n4 = n3 + this.row_label_offset + n + 4 * this.frame_border_width;
        int n5 = this.frozen_columns;
        while (n5 < this.getNumColumns()) {
            if ((n4 += cellLayoutModel.getWidth(n5)) > this.table_width) {
                n4 = n3 + this.row_label_offset + n + 4 * this.frame_border_width + cellLayoutModel.getWidth(n5);
                ++n2;
            }
            ++n5;
        }
        return n2;
    }

    public int getNumHorizontalPages() throws IllegalSizeException {
        return this.getNumColumnPages();
    }

    public int getNumPages() throws IllegalSizeException {
        if (this.page_width * this.page_height == 0) {
            return 0;
        }
        return this.getNumColumnPages() * this.getNumRowPages();
    }

    private int getNumRowPages() throws IllegalSizeException {
        int n;
        int n2 = 1;
        int n3 = this.getColumnLabelHeight();
        if (n3 + this.column_label_offset + (n = this.getFrozenRowHeight()) + 4 * this.frame_border_width > this.table_height) {
            throw new IllegalSizeException("The total height of column labels and frozen rows is larger than the page height.");
        }
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n4 = n3 + this.column_label_offset + n + 4 * this.frame_border_width;
        int n5 = this.getFrozenRows();
        while (n5 < this.getNumRows()) {
            if ((n4 += cellLayoutModel.getHeight(n5)) > this.table_height) {
                n4 = n3 + this.column_label_offset + n + 4 * this.frame_border_width + cellLayoutModel.getHeight(n5);
                ++n2;
            }
            ++n5;
        }
        return n2;
    }

    public int getNumVerticalPages() {
        return this.getNumRowPages();
    }

    public JCCellRange getPageCellRange(int n) throws IllegalSizeException {
        if (this.getNumPages() == 0) {
            return null;
        }
        JCCellPosition jCCellPosition = this.getPageStartCell(n);
        JCCellPosition jCCellPosition2 = this.getPageEndCell(n);
        return new JCCellRange(jCCellPosition.row, jCCellPosition.column, jCCellPosition2.row, jCCellPosition2.column);
    }

    public Dimension getPageDimensions() {
        return new Dimension(this.page_width, this.page_height);
    }

    private JCCellPosition getPageEndCell(int n) throws IllegalSizeException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getNumColumnPages();
        int n7 = this.getNumRowPages();
        int n8 = n / n6 + 1;
        int n9 = n % n6 + 1;
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n10 = this.frozen_columns;
        if (n9 == n6) {
            n10 = this.getNumColumns() - 1;
        } else {
            n5 = this.frozen_columns;
            if (n9 > 1) {
                n5 = this.getPageEndCell((int)(n - 1)).column + 1;
            }
            n4 = this.table_width - this.getRowLabelWidth() - this.getRowLabelOffset() - this.getFrozenColumnWidth() - 4 * this.getFrameBorderWidth();
            n3 = 0;
            n2 = n5;
            while (n2 < this.getNumColumns()) {
                if ((n3 += cellLayoutModel.getWidth(n2)) <= n4) {
                    n10 = n2;
                }
                ++n2;
            }
        }
        n5 = this.frozen_rows;
        if (n8 == n7) {
            n5 = this.getNumRows() - 1;
        } else {
            n4 = this.frozen_rows;
            if (n8 > 1 && n9 == 1) {
                n4 = this.getPageEndCell((int)(n - 1)).row + 1;
            } else if (n8 > 1 && n9 != 1) {
                n4 = this.getPageEndCell((int)(n6 * (n8 - 1) - 1)).row + 1;
            }
            n2 = this.table_height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - this.getFrozenRowHeight() - 4 * this.getFrameBorderWidth();
            n3 = 0;
            int n11 = n4;
            while (n11 < this.getNumRows()) {
                if ((n3 += cellLayoutModel.getHeight(n11)) <= n2) {
                    n5 = n11;
                }
                ++n11;
            }
        }
        return new JCCellPosition(n5, n10);
    }

    public PageFormat getPageFormat() {
        return this.page_format;
    }

    public int getPageHeight() {
        return this.page_height;
    }

    public Insets getPageMargins() {
        return this.margin;
    }

    public int getPageResolution() {
        return this.page_resolution;
    }

    private JCCellPosition getPageStartCell(int n) throws IllegalSizeException {
        int n2 = this.getNumColumnPages();
        int n3 = this.getNumRowPages();
        int n4 = n / n2 + 1;
        int n5 = n % n2 + 1;
        int n6 = this.frozen_columns;
        n6 = n5 == 1 ? this.frozen_columns : this.getPageEndCell((int)(n - 1)).column + 1;
        int n7 = this.frozen_rows;
        n7 = n4 == 1 ? this.frozen_rows : (n5 == 1 ? this.getPageEndCell((int)(n - 1)).row + 1 : this.getPageEndCell((int)(n2 * (n4 - 1) - 1)).row + 1);
        return new JCCellPosition(n7, n6);
    }

    public int getPageWidth() {
        return this.page_width;
    }

    private int getRowLabelWidth() {
        if (this.row_label_display) {
            return this.getCellLayout().getWidth(-1);
        }
        return 0;
    }

    private int getRowPosition(int n) {
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        return cellLayoutModel.getRowPosition(n);
    }

    public Dimension getTableDimensions(int n) {
        return this.getTablePageDimension(this.getPageCellRange(n));
    }

    private Point getTableOffset() {
        int n = 1;
        if (this.margin_unit == 0) {
            n = this.page_resolution;
        }
        return new Point(n * this.margin.left, n * this.margin.top);
    }

    private Dimension getTablePageDimension(JCCellRange jCCellRange) {
        Rectangle rectangle = this.getCellRangeBounds(jCCellRange);
        return new Dimension(this.getRowLabelWidth() + this.getRowLabelOffset() + 4 * this.getFrameBorderWidth() + this.getFrozenColumnWidth() + rectangle.width, this.getColumnLabelHeight() + this.getColumnLabelOffset() + 4 * this.getFrameBorderWidth() + this.getFrozenRowHeight() + rectangle.height);
    }

    protected void loadSettings(JCTable jCTable) {
        this.columnWidths = jCTable.columnWidths;
        this.cellStyles = jCTable.cellStyles;
        this.rowHeights = jCTable.rowHeights;
        if (this.cellRendererPane != null && this.cellRendererPane.getParent() == this) {
            this.remove(this.cellRendererPane);
        }
        this.cellRendererPane = jCTable.cellRendererPane;
        this.cellAreaHandler = new PrintCellAreaHandler(this);
        this.cellAreaHandler.cellAreaRenderer = new PrintCellAreaRenderer(this.cellAreaHandler);
        this.cellAreaHandler.cellAreaRenderer.borderColor = jCTable.cellAreaHandler.cellAreaRenderer.borderColor;
        this.cellAreaHandler.cellAreaRenderer.borderHighlightColor = jCTable.cellAreaHandler.cellAreaRenderer.borderHighlightColor;
        this.cellAreaHandler.cellAreaRenderer.borderShadowColor = jCTable.cellAreaHandler.cellAreaRenderer.borderShadowColor;
        this.cellAreaHandler.cellArea = jCTable.cellAreaHandler.cellArea;
        this.cellAreaHandler.frozenRowArea = jCTable.cellAreaHandler.frozenRowArea;
        this.cellAreaHandler.columnLabelArea = jCTable.cellAreaHandler.columnLabelArea;
        this.cellAreaHandler.frozenColumnArea = jCTable.cellAreaHandler.frozenColumnArea;
        this.cellAreaHandler.frozenCellArea = jCTable.cellAreaHandler.frozenCellArea;
        this.cellAreaHandler.frozenColumnLabelArea = jCTable.cellAreaHandler.frozenColumnLabelArea;
        this.cellAreaHandler.rowLabelArea = jCTable.cellAreaHandler.rowLabelArea;
        this.cellAreaHandler.frozenRowLabelArea = jCTable.cellAreaHandler.frozenRowLabelArea;
        this.cellAreaHandler.areas = jCTable.cellAreaHandler.areas;
        this.cellAreaHandler.cellInfo = jCTable.cellAreaHandler.cellInfo;
        this.cellAreaHandler.cellOrigin = jCTable.cellAreaHandler.cellOrigin;
        this.dataView = jCTable.dataView;
        int n = this.getNumRows();
        int n2 = this.getNumColumns();
        this.column_label_offset = jCTable.column_label_offset;
        this.row_label_offset = jCTable.row_label_offset;
        this.cellLayout = new PrintCellLayout(n, n2);
        this.cellLayout.setTable(this);
        int n3 = -1;
        while (n3 < n) {
            this.cellLayout.setHeight(n3, jCTable.cellLayout.getHeight(n3));
            ++n3;
        }
        int n4 = -1;
        while (n4 < n2) {
            this.cellLayout.setWidth(n4, jCTable.cellLayout.getWidth(n4));
            ++n4;
        }
        this.tableLayout = new TableLayout(this.cellAreaHandler);
        this.hsb_display = 2;
        this.vsb_display = 2;
        this.component_border_width = jCTable.component_border_width;
        this.componentHandler = jCTable.componentHandler;
        this.cell_border_width = jCTable.cell_border_width;
        this.column_label_display = jCTable.column_label_display;
        this.column_label_placement = jCTable.column_label_placement;
        this.focus_color = jCTable.focus_color;
        this.focus_indicator = jCTable.focus_indicator;
        this.frame_border = jCTable.frame_border;
        this.frame_border_width = jCTable.frame_border_width;
        this.frozen_columns = jCTable.frozen_columns;
        this.frozen_column_placement = jCTable.frozen_column_placement;
        this.frozen_rows = jCTable.frozen_rows;
        this.frozen_row_placement = jCTable.frozen_row_placement;
        this.margin_height = jCTable.margin_height;
        this.margin_width = jCTable.margin_width;
        this.row_label_display = jCTable.row_label_display;
        this.row_label_placement = jCTable.row_label_placement;
        this.selected_background = jCTable.selected_background;
        this.selected_foreground = jCTable.selected_foreground;
    }

    public void print() {
        block3: {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (printerJob == null) break block3;
            try {
                if (this.page_format == null) {
                    this.setPageFormat(printerJob.defaultPage());
                }
                printerJob.setPrintable(this, this.page_format);
                this.setPageDimensions((int)this.page_format.getWidth(), (int)this.page_format.getHeight());
                this.setPrintPage(-1);
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println(printerException.getMessage());
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n >= this.getNumPages() || this.print_page != -1 && n > 0) {
            return 1;
        }
        if (this.print_page == -1) {
            this.printPage(graphics, n);
        } else {
            this.printPage(graphics, this.print_page);
        }
        return 0;
    }

    public void printPage(Graphics graphics, int n) {
        JCCellRange jCCellRange;
        this.current_page = n;
        try {
            jCCellRange = this.getPageCellRange(n);
        }
        catch (IllegalSizeException illegalSizeException) {
            System.out.println(illegalSizeException.getMessage());
            return;
        }
        if (jCCellRange == null) {
            return;
        }
        Dimension dimension = this.getTablePageDimension(jCCellRange);
        this.printPage(graphics, jCCellRange);
    }

    public void printPage(Graphics graphics, JCCellRange jCCellRange) {
        int n;
        int n2;
        int n3;
        int n4;
        ((PrintCellAreaHandler)this.cellAreaHandler).page_range = jCCellRange;
        CellLayoutModel cellLayoutModel = this.table.getCellLayout();
        Dimension dimension = new Dimension(0, 0);
        dimension.width = cellLayoutModel.getWidth(-1) + this.getRowLabelOffset() + this.getFrozenColumnWidth() + this.getColumnPosition(jCCellRange.end_column) - this.getColumnPosition(jCCellRange.start_column) + cellLayoutModel.getWidth(jCCellRange.end_column);
        dimension.height = cellLayoutModel.getHeight(-1) + this.getColumnLabelOffset() + this.getFrozenRowHeight() + this.getRowPosition(jCCellRange.end_row) - this.getRowPosition(jCCellRange.start_row) + cellLayoutModel.getHeight(jCCellRange.end_row);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.page_width, this.page_height);
        Point point = this.getTableOffset();
        graphics.setClip(point.x, point.y, this.table_width, this.table_height);
        if (this.table.spanHandler != null) {
            this.spanHandler = new SpanHandler();
            this.spanHandler.setTable(this);
            Collection collection = this.table.getSpannedRanges();
            try {
                if (collection != null) {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        JCCellRange jCCellRange2 = (JCCellRange)iterator.next();
                        this.spanHandler.addSpannedRange(new JCCellRange(jCCellRange2.start_row, jCCellRange2.start_column, jCCellRange2.end_row, jCCellRange2.end_column));
                    }
                }
            }
            catch (Exception exception) {}
            this.splitSpans(jCCellRange);
        }
        if ((n4 = this.getFrozenColumns()) > 0) {
            int n5 = 0;
            while (n5 < n4) {
                this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, -1, n5);
                ++n5;
            }
        }
        int n6 = jCCellRange.start_column;
        while (n6 <= jCCellRange.end_column) {
            this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, -1, n6);
            ++n6;
        }
        int n7 = this.getFrozenRows();
        if (n7 > 0) {
            n3 = 0;
            while (n3 < n7) {
                this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n3, -1);
                ++n3;
            }
        }
        n3 = jCCellRange.start_row;
        while (n3 <= jCCellRange.end_row) {
            this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n3, -1);
            ++n3;
        }
        if (n4 > 0 && n7 > 0) {
            n2 = 0;
            while (n2 < n7) {
                n = 0;
                while (n < n4) {
                    this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n2, n);
                    ++n;
                }
                ++n2;
            }
        }
        if (n4 > 0) {
            n2 = jCCellRange.start_row;
            while (n2 <= jCCellRange.end_row) {
                n = 0;
                while (n < n4) {
                    this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n2, n);
                    ++n;
                }
                ++n2;
            }
        }
        if (n7 > 0) {
            n2 = 0;
            while (n2 < n7) {
                n = jCCellRange.start_column;
                while (n <= jCCellRange.end_column) {
                    this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n2, n);
                    ++n;
                }
                ++n2;
            }
        }
        n2 = jCCellRange.start_row;
        while (n2 <= jCCellRange.end_row) {
            n = jCCellRange.start_column;
            while (n <= jCCellRange.end_column) {
                this.cellAreaHandler.cellAreaRenderer.paintCell(graphics, n2, n);
                ++n;
            }
            ++n2;
        }
        if (this.getFrameBorderWidth() > 0) {
            Rectangle rectangle;
            Rectangle rectangle2;
            Rectangle rectangle3 = new Rectangle(this.cellAreaHandler.getBounds((int)jCCellRange.start_row, (int)-1).x, this.cellAreaHandler.getBounds((int)jCCellRange.start_row, (int)-1).y, this.cellAreaHandler.getBounds((int)jCCellRange.start_row, (int)-1).width, this.cellAreaHandler.getBounds((int)jCCellRange.end_row, (int)-1).y + this.cellAreaHandler.getBounds((int)jCCellRange.end_row, (int)-1).height - this.cellAreaHandler.getBounds((int)jCCellRange.start_row, (int)-1).y);
            if (n7 > 0) {
                rectangle2 = new Rectangle(this.cellAreaHandler.getBounds((int)0, (int)-1).x, this.cellAreaHandler.getBounds((int)0, (int)-1).y, this.cellAreaHandler.getBounds((int)0, (int)-1).width, this.cellAreaHandler.getBounds((int)(n7 - 1), (int)-1).y + this.cellAreaHandler.getBounds((int)(n7 - 1), (int)-1).height - this.cellAreaHandler.getBounds((int)0, (int)-1).y);
                rectangle3 = new Rectangle(Math.min(rectangle3.x, rectangle2.x), Math.min(rectangle3.y, rectangle2.y), Math.max(rectangle3.width, rectangle2.width), rectangle3.height + rectangle2.height);
            }
            rectangle2 = new Rectangle(this.cellAreaHandler.getBounds((int)-1, (int)jCCellRange.start_column).x, this.cellAreaHandler.getBounds((int)-1, (int)jCCellRange.start_column).y, this.cellAreaHandler.getBounds((int)-1, (int)jCCellRange.end_column).x + this.cellAreaHandler.getBounds((int)-1, (int)jCCellRange.end_column).width - this.cellAreaHandler.getBounds((int)-1, (int)jCCellRange.start_column).x, this.cellAreaHandler.getBounds((int)-1, (int)jCCellRange.start_column).height);
            if (n4 > 0) {
                rectangle = new Rectangle(this.cellAreaHandler.getBounds((int)-1, (int)0).x, this.cellAreaHandler.getBounds((int)-1, (int)0).y, this.cellAreaHandler.getBounds((int)-1, (int)(n4 - 1)).x + this.cellAreaHandler.getBounds((int)-1, (int)(n4 - 1)).width - this.cellAreaHandler.getBounds((int)-1, (int)0).x, this.cellAreaHandler.getBounds((int)-1, (int)0).height);
                rectangle2 = new Rectangle(Math.min(rectangle2.x, rectangle.x), Math.min(rectangle2.y, rectangle.y), rectangle2.width + rectangle.width, Math.max(rectangle2.height, rectangle.height));
            }
            rectangle = new Rectangle(rectangle2.x, rectangle3.y, rectangle2.width, rectangle3.height);
            CellBorderModel cellBorderModel = this.table.getFrameBorder();
            Color color = this.table.getBackground();
            cellBorderModel.drawBackground(graphics, this.frame_border_width, 15, rectangle3.x - this.frame_border_width, rectangle3.y - this.frame_border_width, rectangle3.width + 2 * this.frame_border_width, rectangle3.height + 2 * this.frame_border_width, color.brighter(), color.darker(), color);
            cellBorderModel.drawBackground(graphics, this.frame_border_width, 15, rectangle2.x - this.frame_border_width, rectangle2.y - this.frame_border_width, rectangle2.width + 2 * this.frame_border_width, rectangle2.height + 2 * this.frame_border_width, color.brighter(), color.darker(), color);
            cellBorderModel.drawBackground(graphics, this.frame_border_width, 15, rectangle.x - this.frame_border_width, rectangle.y - this.frame_border_width, rectangle.width + 2 * this.frame_border_width, rectangle.height + 2 * this.frame_border_width, color.brighter(), color.darker(), color);
        }
        this.doPrintPageHeader(graphics, this.current_page);
        this.doPrintBody(graphics, this.current_page);
        this.doPrintPageFooter(graphics, this.current_page);
        ((PrintCellAreaHandler)this.cellAreaHandler).page_range = null;
    }

    private void printPageFooter(Graphics graphics, int n) {
        Graphics graphics2 = graphics.create();
        int n2 = this.margin_unit == 0 ? this.page_resolution : 1;
        graphics2.setClip(n2 * this.margin.left, this.page_height - n2 * this.margin.bottom, this.table_width, n2 * this.margin.bottom);
        graphics2.translate(n2 * this.margin.left, this.page_height - n2 * this.margin.bottom);
        Rectangle rectangle = graphics2.getClipBounds();
        graphics2.setColor(Color.black);
        graphics2.setFont(this.getFont());
        String string = String.valueOf(LocaleBundle.string("Page ")) + n + LocaleBundle.string(" of ") + this.getNumPages();
        graphics2.drawString(string, 0, rectangle.height / 2);
    }

    public void removePrintListener(JCPrintListener jCPrintListener) {
        this.printListeners = JCListenerList.remove(this.printListeners, jCPrintListener);
    }

    private void setInternalDimensions() {
        if (this.page_width == 0 || this.page_height == 0) {
            return;
        }
        int n = this.margin_unit == 0 ? this.page_resolution : 1;
        this.table_width = this.page_width - n * (this.margin.left + this.margin.right);
        this.table_height = this.page_height - n * (this.margin.top + this.margin.bottom);
        CellLayoutModel cellLayoutModel = this.getCellLayout();
        int n2 = this.table_width - this.getRowLabelWidth() - this.getRowLabelOffset() - this.getFrozenColumnWidth() - 4 * this.getFrameBorderWidth();
        int n3 = this.getFrozenColumns();
        while (n3 < this.getNumColumns()) {
            if (cellLayoutModel.getWidth(n3) > n2) {
                cellLayoutModel.setWidth(n3, n2);
            }
            ++n3;
        }
        int n4 = this.table_height - this.getColumnLabelHeight() - this.getColumnLabelOffset() - this.getFrozenRowHeight() - 4 * this.getFrameBorderWidth();
        int n5 = this.getFrozenRows();
        while (n5 < this.getNumRows()) {
            if (cellLayoutModel.getHeight(n5) > n4) {
                cellLayoutModel.setHeight(n5, n4);
            }
            ++n5;
        }
    }

    public void setMarginUnits(int n) {
        this.margin_unit = n == 0 ? 0 : 1;
    }

    public void setPageDimensions(int n, int n2) {
        if (n == 0 || n2 == 0) {
            n = 612;
            n2 = 792;
            this.page_resolution = 72;
        }
        this.page_width = n;
        this.page_height = n2;
        this.setInternalDimensions();
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.page_format = pageFormat;
    }

    public void setPageHeight(int n) {
        this.page_height = n;
        this.setInternalDimensions();
    }

    public void setPageMargins(Insets insets) {
        if (insets == null) {
            insets = this.getDefaultPageMargins();
        } else {
            this.margin = insets;
        }
        this.setInternalDimensions();
    }

    public void setPageResolution(int n) {
        this.page_resolution = n;
        this.setInternalDimensions();
    }

    public void setPageWidth(int n) {
        this.page_width = n;
        this.setInternalDimensions();
    }

    public void setPrintPage(int n) {
        this.print_page = n;
    }

    public void showPrintPreview(String string) {
        JCPrintPreview jCPrintPreview = new JCPrintPreview(string, this);
        jCPrintPreview.showPage(0);
    }

    private void splitSpans(JCCellRange jCCellRange) {
        block8: {
            if (this.spanHandler == null) break block8;
            Vector<JCCellRange> vector = new Vector<JCCellRange>();
            Collection collection = this.spanHandler.getSpannedRanges();
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    JCCellRange jCCellRange2 = (JCCellRange)iterator.next();
                    JCCellRange jCCellRange3 = new JCCellRange(jCCellRange2.start_row, jCCellRange2.start_column, jCCellRange2.end_row, jCCellRange2.end_column);
                    if (jCCellRange2.start_row < jCCellRange.start_row && jCCellRange2.end_row >= jCCellRange.end_row) {
                        jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange.start_row - 1, jCCellRange3.end_column);
                    }
                    if (jCCellRange2.start_row <= jCCellRange.end_row && jCCellRange2.end_row > jCCellRange.end_row) {
                        jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange.end_row, jCCellRange3.end_column);
                    }
                    if (jCCellRange2.start_column < jCCellRange.start_column && jCCellRange2.end_column >= jCCellRange.start_column) {
                        jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange.start_column, jCCellRange3.end_row, jCCellRange3.end_column);
                    }
                    if (jCCellRange2.start_column <= jCCellRange.end_column && jCCellRange2.end_column > jCCellRange.end_column) {
                        jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange3.end_row, jCCellRange.end_column);
                    }
                    vector.addElement(jCCellRange3);
                }
            }
            try {
                this.spanHandler.setSpannedRanges(vector);
            }
            catch (Exception exception) {}
        }
    }

    class IllegalSizeException
    extends IllegalStateException {
        protected IllegalSizeException(String string) {
            super(string);
        }
    }
}

