/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.BaseDataView;
import com.klg.jclass.table.DataViewSupport;
import com.klg.jclass.table.EditableTableDataModel;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.SortableDataViewModel;
import com.klg.jclass.table.TableDataModel;
import java.io.Serializable;

public class TableDataView
extends BaseDataView
implements SortableDataViewModel,
Serializable {
    protected TableDataModel dataSource;
    protected boolean isEditable = false;
    private int[] column_map;
    private int[] row_map;
    private boolean needs_column_map = false;
    private boolean needs_row_map = false;

    public TableDataView() {
    }

    public TableDataView(JCTable jCTable) {
        super(jCTable);
    }

    public void addTableDataListener(JCTableDataListener jCTableDataListener) {
        if (this.dataSource == null) {
            return;
        }
        this.dataSource.addTableDataListener(jCTableDataListener);
    }

    public void dataChanged(JCTableDataEvent jCTableDataEvent) {
        int n;
        int n2 = 0;
        int n3 = jCTableDataEvent.getRow();
        if (n3 >= 0) {
            n3 = this.getViewRow(n3);
        }
        if ((n = jCTableDataEvent.getColumn()) >= 0) {
            n = this.getViewColumn(n);
        }
        switch (jCTableDataEvent.getCommand()) {
            case 1: {
                int n4;
                n2 = 0;
                int n5 = this.table.getPixelWidth(n);
                if (n5 == 33001 || n5 == 33002) {
                    n2 |= 0x80;
                }
                if ((n4 = this.table.getPixelHeight(n3)) == 33001 || n4 == 33002) {
                    n2 |= 0x40;
                }
                if (n2 != 0) {
                    this.table.requestChange(n2, n3, n);
                }
                this.repaintRange(n3, n, n3, n);
                break;
            }
            case 2: {
                if (this.table.editTraverseHandler.getCellEditor() != null && n3 == this.table.current_row) {
                    this.table.cancelEdit(true);
                }
                this.repaintRange(n3, -1, n3, this.getNumColumns());
                break;
            }
            case 3: {
                if (this.table.editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                DataViewSupport.addRow(this.table, n3, 1, this.getNumRows(), this.getNumColumns());
                this.repaintRange(jCTableDataEvent.getRow(), -1, this.getNumRows(), this.getNumColumns());
                break;
            }
            case 4: {
                if (this.table.editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                if (this.needs_row_map) {
                    int n6 = 0;
                    while (n6 < jCTableDataEvent.getNumAffected()) {
                        int n7 = this.getViewRow(jCTableDataEvent.getRow() + n6);
                        this.row_map = this.removeMapElement(this.row_map, n7);
                        DataViewSupport.deleteRow(this.table, n7, 1, this.getNumRows(), this.getNumColumns());
                        ++n6;
                    }
                } else {
                    DataViewSupport.deleteRow(this.table, jCTableDataEvent.getRow(), jCTableDataEvent.getNumAffected(), this.getNumRows(), this.getNumColumns());
                }
                this.table.doLayout();
                break;
            }
            case 5: {
                if (this.table.editTraverseHandler.getCellEditor() != null && n == this.table.current_column) {
                    this.table.cancelEdit(true);
                }
                this.repaintRange(-1, n, this.getNumRows(), jCTableDataEvent.getColumn());
                break;
            }
            case 6: {
                if (this.table.editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                DataViewSupport.addColumn(this.table, n, 1, this.getNumRows(), this.getNumColumns());
                this.repaintRange(-1, n, this.getNumRows(), this.getNumColumns());
                break;
            }
            case 7: {
                if (this.table.editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                if (this.needs_column_map) {
                    int n8 = 0;
                    while (n8 < jCTableDataEvent.getNumAffected()) {
                        int n9 = this.getViewColumn(jCTableDataEvent.getColumn() + n8);
                        this.column_map = this.removeMapElement(this.column_map, n9);
                        DataViewSupport.deleteColumn(this.table, n9, 1, this.getNumRows(), this.getNumColumns());
                        ++n8;
                    }
                } else {
                    DataViewSupport.deleteColumn(this.table, jCTableDataEvent.getColumn(), jCTableDataEvent.getNumAffected(), this.getNumRows(), this.getNumColumns());
                }
                this.table.doLayout();
                break;
            }
            case 8: {
                int n10;
                n2 = 0;
                int n11 = this.table.getPixelWidth(-1);
                if (n11 == 33001 || n11 == 33002) {
                    n2 |= 0x80;
                }
                if ((n10 = this.table.getPixelHeight(n3)) == 33001 || n10 == 33002) {
                    n2 |= 0x40;
                }
                if (n2 != 0) {
                    this.table.requestChange(n2, n3, -1);
                }
                this.repaintRange(n3, -1, n3, -1);
                break;
            }
            case 9: {
                int n12;
                n2 = 0;
                int n13 = this.table.getPixelWidth(n);
                if (n13 == 33001 || n13 == 33002) {
                    n2 |= 0x80;
                }
                if ((n12 = this.table.getPixelHeight(-1)) == 33001 || n12 == 33002) {
                    n2 |= 0x40;
                }
                if (n2 != 0) {
                    this.table.requestChange(n2, -1, n);
                }
                this.repaintRange(-1, n, -1, n);
                break;
            }
            case 10: {
                if (this.table.editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                this.resetRowMap();
                DataViewSupport.moveRows(this.table, jCTableDataEvent.getRow(), jCTableDataEvent.getNumAffected(), jCTableDataEvent.getDestination());
                this.table.doLayout();
                this.table.repaint();
                break;
            }
            case 11: {
                if (this.table.editTraverseHandler.getCellEditor() != null) {
                    this.table.cancelEdit(true);
                }
                this.resetColumnMap();
                DataViewSupport.moveColumns(this.table, jCTableDataEvent.getColumn(), jCTableDataEvent.getNumAffected(), jCTableDataEvent.getDestination());
                this.table.doLayout();
                this.table.repaint();
                break;
            }
            case 12: {
                int n14 = this.dataSource.getNumRows();
                if (this.table.editTraverseHandler.getCellEditor() != null && n14 <= this.table.current_row) {
                    this.table.cancelEdit(true);
                }
                if (this.table.current_row >= n14) {
                    this.table.setCurrentCell(n14 - 1, this.table.current_column, 2);
                }
                this.resetRowMap();
                this.table.requestChange(2);
                break;
            }
            case 13: {
                int n15 = this.dataSource.getNumColumns();
                if (this.table.editTraverseHandler.getCellEditor() != null && n15 <= this.table.current_column) {
                    this.table.cancelEdit(true);
                }
                if (this.table.current_column >= n15) {
                    this.table.setCurrentCell(this.table.current_row, n15 - 1, 3);
                }
                this.resetColumnMap();
                this.table.requestChange(2);
                break;
            }
            case 14: {
                this.table.requestChange(2);
                break;
            }
        }
    }

    public void dispose() {
        if (this.dataSource != null) {
            this.dataSource.removeTableDataListener(this);
        }
    }

    public boolean dragColumn(int n, int n2) {
        int n3 = this.dataSource.getNumColumns();
        int n4 = this.table.getFrozenColumns();
        if (n < 0 || n > n3) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n < n4 || n2 < n4) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        this.needs_column_map = true;
        if (this.column_map == null || this.column_map.length < n3) {
            this.resizeColumnMap();
        }
        this.column_map = this.shiftMappedArray(this.column_map, n, n2);
        boolean bl = DataViewSupport.dragColumn(this.table, n, n2);
        this.table.doLayout();
        this.table.repaint();
        return bl;
    }

    public boolean dragRow(int n, int n2) {
        int n3 = this.dataSource.getNumRows();
        int n4 = this.table.getFrozenRows();
        if (n < 0 || n > n3) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n < n4 || n2 < n4) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        this.needs_row_map = true;
        if (this.row_map == null || this.row_map.length < n3) {
            this.resizeRowMap();
        }
        this.row_map = this.shiftMappedArray(this.row_map, n, n2);
        boolean bl = DataViewSupport.dragRow(this.table, n, n2);
        this.table.doLayout();
        this.table.repaint();
        return bl;
    }

    public int[] getColumnMap() {
        int n = this.dataSource.getNumColumns();
        if (this.column_map == null || this.column_map.length < n) {
            this.resizeColumnMap();
        }
        return this.column_map;
    }

    public int getDataColumn(int n) {
        if (this.column_map == null) {
            return n;
        }
        int n2 = this.dataSource.getNumColumns();
        if (this.column_map.length < n2) {
            this.resizeColumnMap();
        }
        if (n >= 0 && n < n2) {
            return this.column_map[n];
        }
        return -999;
    }

    public int getDataRow(int n) {
        if (this.row_map == null) {
            return n;
        }
        int n2 = this.dataSource.getNumRows();
        if (this.row_map.length < n2) {
            this.resizeRowMap();
        }
        if (n >= 0 && n < n2) {
            return this.row_map[n];
        }
        return -999;
    }

    public TableDataModel getDataSource() {
        return this.dataSource;
    }

    public int getNumColumns() {
        if (this.dataSource == null) {
            return 0;
        }
        return this.dataSource.getNumColumns();
    }

    public int getNumRows() {
        if (this.dataSource == null) {
            return 0;
        }
        return this.dataSource.getNumRows();
    }

    public Object getObject(int n, int n2) {
        if (this.dataSource == null) {
            return null;
        }
        if (n >= 0 && n2 >= 0) {
            return this.dataSource.getTableDataItem(this.getDataRow(n), this.getDataColumn(n2));
        }
        if (n == -1) {
            return this.dataSource.getTableColumnLabel(this.getDataColumn(n2));
        }
        return this.dataSource.getTableRowLabel(this.getDataRow(n));
    }

    public int[] getRowMap() {
        int n = this.dataSource.getNumRows();
        if (this.row_map == null || this.row_map.length < n) {
            this.resizeRowMap();
        }
        return this.row_map;
    }

    public Object getTableColumnLabel(int n) {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getTableColumnLabel(this.getDataColumn(n));
    }

    public Object getTableDataItem(int n, int n2) {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getTableDataItem(this.getDataRow(n), this.getDataColumn(n2));
    }

    public Object getTableRowLabel(int n) {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getTableRowLabel(this.getDataRow(n));
    }

    public int getViewColumn(int n) {
        if (this.column_map == null) {
            return n;
        }
        int n2 = this.dataSource.getNumColumns();
        if (this.column_map == null || this.column_map.length < n2) {
            this.resizeColumnMap();
        }
        if (n < n2) {
            if (this.column_map[n] == n) {
                return n;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (this.column_map[n3] == n) {
                    return n3;
                }
                ++n3;
            }
        }
        return -999;
    }

    public int getViewRow(int n) {
        if (this.row_map == null) {
            return n;
        }
        int n2 = this.dataSource.getNumRows();
        if (this.row_map == null || this.row_map.length < n2) {
            this.resizeRowMap();
        }
        if (n < n2) {
            if (this.row_map[n] == n) {
                return n;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (this.row_map[n3] == n) {
                    return n3;
                }
                ++n3;
            }
        }
        return -999;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    protected int[] removeMapElement(int[] nArray, int n) {
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 - 1];
        int n3 = 0;
        while (n3 < n2) {
            if (n3 < n) {
                nArray2[n3] = nArray[n3];
            } else if (n3 > n) {
                nArray2[n3 - 1] = nArray[n3];
            }
            ++n3;
        }
        return nArray2;
    }

    public void removeTableDataListener(JCTableDataListener jCTableDataListener) {
        if (this.dataSource == null) {
            return;
        }
        this.dataSource.removeTableDataListener(jCTableDataListener);
    }

    protected void repaintRange(int n, int n2, int n3, int n4) {
        this.table.getCellAreaHandler().getCellAreaRenderer().repaintRange(n, n2, n3, n4);
    }

    public void resetColumnMap() {
        this.needs_column_map = false;
        if (this.column_map != null) {
            int n = this.column_map.length;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = n2;
                ++n2;
            }
            this.setColumnMap(nArray);
        }
        this.column_map = null;
        this.table.sort_column = -999;
        this.table.sort_direction = -999;
    }

    public void resetRowMap() {
        this.needs_row_map = false;
        if (this.row_map != null) {
            int n = this.row_map.length;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = n2;
                ++n2;
            }
            this.setRowMap(nArray);
        }
        this.row_map = null;
        this.table.sort_column = -999;
        this.table.sort_direction = -999;
    }

    protected void resizeColumnMap() {
        if (!this.needs_column_map) {
            return;
        }
        int n = this.dataSource.getNumColumns();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.column_map == null || n2 >= this.column_map.length ? n2 : this.column_map[n2];
            ++n2;
        }
        this.column_map = nArray;
    }

    protected void resizeRowMap() {
        if (!this.needs_row_map) {
            return;
        }
        int n = this.dataSource.getNumRows();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.row_map == null || n2 >= this.row_map.length ? n2 : this.row_map[n2];
            ++n2;
        }
        this.row_map = nArray;
    }

    public boolean setColumnMap(int[] nArray) {
        int n = this.dataSource.getNumColumns();
        if (nArray.length != n) {
            return false;
        }
        this.table.cancelEdit(true);
        this.needs_column_map = true;
        if (this.column_map == null || this.column_map.length < n) {
            this.resizeColumnMap();
        }
        if (this.table.isSeriesDataSorted()) {
            if (DataViewSupport.swapColumnArrays(this.table, this.column_map, nArray)) {
                this.column_map = nArray;
            }
        } else {
            this.column_map = nArray;
        }
        this.table.repaint();
        return true;
    }

    public void setDataSource(TableDataModel tableDataModel) {
        boolean bl = false;
        if (tableDataModel == null) {
            return;
        }
        this.table.setRepaintEnabled(false);
        if (this.dataSource != null) {
            bl = true;
            this.dataSource.removeTableDataListener(this);
        }
        if (this.table.editTraverseHandler != null) {
            this.table.editTraverseHandler.cancel();
        }
        this.dataSource = tableDataModel;
        this.dataSource.addTableDataListener(this);
        this.isEditable = this.dataSource instanceof EditableTableDataModel;
        if (bl && this.table.editTraverseHandler != null) {
            this.table.editTraverseHandler.traverseInitial();
        }
        this.resetColumnMap();
        this.resetRowMap();
        this.table.setRecalcRequired(true);
        this.table.setRepaintEnabled(true);
    }

    public boolean setRowMap(int[] nArray) {
        int n = this.dataSource.getNumRows();
        if (nArray.length != n) {
            return false;
        }
        this.table.cancelEdit(true);
        this.needs_row_map = true;
        if (this.row_map == null || this.row_map.length < n) {
            this.resizeRowMap();
        }
        if (this.table.isSeriesDataSorted()) {
            if (DataViewSupport.swapRowArrays(this.table, this.row_map, nArray)) {
                this.row_map = nArray;
            }
        } else {
            this.row_map = nArray;
        }
        this.table.repaint();
        return true;
    }

    public boolean setTableDataItem(Object object, int n, int n2) {
        if (this.dataSource == null) {
            return false;
        }
        if (this.isEditable) {
            return ((EditableTableDataModel)this.dataSource).setTableDataItem(object, this.getDataRow(n), this.getDataColumn(n2));
        }
        return true;
    }

    protected int[] shiftMappedArray(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        if (n2 == Integer.MAX_VALUE) {
            int n4 = 0;
            while (n4 < n) {
                nArray2[n4] = nArray[n4];
                ++n4;
            }
            int n5 = n + 1;
            while (n5 < n3) {
                nArray2[n5 - 1] = nArray[n5];
                ++n5;
            }
            nArray2[n3 - 1] = nArray[n];
        } else if (n < n2) {
            int n6 = 0;
            while (n6 < n3) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            int n7 = n + 1;
            while (n7 < n2) {
                nArray2[n7 - 1] = nArray[n7];
                ++n7;
            }
            nArray2[n2 - 1] = nArray[n];
        } else if (n > n2) {
            int n8 = 0;
            while (n8 < n3) {
                nArray2[n8] = nArray[n8];
                ++n8;
            }
            int n9 = n2;
            while (n9 < n) {
                nArray2[n9 + 1] = nArray[n9];
                ++n9;
            }
            nArray2[n2] = nArray[n];
        }
        return nArray2;
    }

    public boolean swapColumns(int n, int n2) {
        int n3 = this.dataSource.getNumColumns();
        if (n < 0 || n > n3) {
            return false;
        }
        if (n2 < 0 || n2 > n3) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        this.table.cancelEdit(true);
        this.needs_column_map = true;
        if (this.column_map == null || this.column_map.length < n3) {
            this.resizeColumnMap();
        }
        int n4 = this.column_map[n];
        this.column_map[n] = this.column_map[n2];
        this.column_map[n2] = n4;
        DataViewSupport.swapColumns(this.table, n, n2);
        this.table.doLayout();
        this.table.repaint();
        return true;
    }

    public boolean swapRows(int n, int n2) {
        int n3 = this.dataSource.getNumRows();
        if (n < 0 || n > n3) {
            return false;
        }
        if (n2 < 0 || n2 > n3) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        this.table.cancelEdit(true);
        this.needs_row_map = true;
        if (this.row_map == null || this.row_map.length < n3) {
            this.resizeRowMap();
        }
        int n4 = this.row_map[n];
        this.row_map[n] = this.row_map[n2];
        this.row_map[n2] = n4;
        DataViewSupport.swapRows(this.table, n, n2);
        this.table.doLayout();
        this.table.repaint();
        return true;
    }
}

