/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.build;

import com.borland.jbuilder.build.JavaBuildPropertyGroup;
import com.borland.jbuilder.node.JBProject;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.NodePropertyDescriptor;
import com.borland.primetime.node.Project;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class BuildUtil {
    public static final String GEN_DIR_NAME = "Generated Source";
    public static final String TEMP_DIR_NAME = "Temporary_Files";

    static {
        TEMP_DIR_NAME = TEMP_DIR_NAME;
        GEN_DIR_NAME = GEN_DIR_NAME;
    }

    private BuildUtil() {
    }

    private static void a(File file, File file2) {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String string = fileArray[i2].getName();
            File file3 = new File(file2, string);
            if (!fileArray[i2].isDirectory()) {
                try {
                    VFS.copy(new Url(fileArray[i2]), new Url(file3));
                }
                catch (IOException iOException) {}
                continue;
            }
            BuildUtil.a(fileArray[i2], file3);
        }
    }

    private static void b(File file, File file2) {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (!fileArray[i2].isDirectory()) continue;
            String string = fileArray[i2].getName();
            File file3 = new File(file2, string);
            if (!file3.exists()) {
                file3.mkdir();
            }
            BuildUtil.b(fileArray[i2], file3);
        }
    }

    public static Node[] extractGeneratedChildNodes(Node node) {
        LinkedList<FileNode> linkedList = null;
        SortedMap sortedMap = node.getProperties();
        if (!sortedMap.isEmpty()) {
            Set set = sortedMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                NodePropertyDescriptor nodePropertyDescriptor = (NodePropertyDescriptor)entry.getKey();
                String string = nodePropertyDescriptor.getCategory();
                if (string == null || !string.equals("generated")) continue;
                String string2 = (String)entry.getValue();
                try {
                    if (linkedList == null) {
                        linkedList = new LinkedList<FileNode>();
                    }
                    Url url = BuildUtil.getGeneratedDir((JBProject)node.getProject()).getRelativeUrl(string2);
                    linkedList.add(node.getProject().getNode(url));
                }
                catch (Exception exception) {}
            }
        }
        if (linkedList == null) {
            return Node.EMPTY_ARRAY;
        }
        return linkedList.toArray(Node.EMPTY_ARRAY);
    }

    protected static String[] getSubFiles(File file, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2].isDirectory()) {
                String[] stringArray = BuildUtil.getSubFiles(fileArray[i2], string);
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    arrayList.add(stringArray[i3]);
                }
                continue;
            }
            if (!fileArray[i2].getPath().endsWith(".".concat(String.valueOf(String.valueOf(string))))) continue;
            arrayList.add(fileArray[i2].getPath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void copyDirectoryTree(File file, File file2) throws IOException {
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file.isDirectory() || !file2.isDirectory()) {
            throw new IOException("Not a directory");
        }
        BuildUtil.b(file, file2);
        BuildUtil.a(file, file2);
    }

    public static void clearDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isDirectory()) {
                    BuildUtil.clearDirectory(fileArray[i2]);
                }
                fileArray[i2].delete();
            }
        }
    }

    public static Url getGeneratedDir(JBProject jBProject) {
        Url url = null;
        url = "1".equals(JavaBuildPropertyGroup.SOURCE_TO_OUTPUT.getValue(jBProject)) ? jBProject.getPaths().getOutPath().getRelativeUrl(GEN_DIR_NAME) : jBProject.getPaths().getDefaultSourcePath();
        return url;
    }

    public static Url getTempDirUrl(JBProject jBProject) {
        Url url = jBProject.getPaths().getOutPath().getRelativeUrl(TEMP_DIR_NAME);
        return url;
    }

    public static String getTempDir(JBProject jBProject) {
        Url url = jBProject.getPaths().getOutPath().getRelativeUrl(TEMP_DIR_NAME);
        return url.getFileObject().getPath();
    }

    public static void prepareTempAndGeneratedDir(Project project) {
        JBProject jBProject = (JBProject)project;
        Url url = jBProject.getPaths().getOutPath().getRelativeUrl(TEMP_DIR_NAME);
        if (url.getFileObject().exists()) {
            BuildUtil.clearDirectory(url.getFileObject());
        } else {
            url.getFileObject().mkdirs();
        }
        Url url2 = BuildUtil.getGeneratedDir((JBProject)project);
        if (!url2.getFileObject().exists()) {
            url2.getFileObject().mkdirs();
        }
    }
}

