/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.build;

import com.borland.jbuilder.build.BuildMessage;
import com.borland.jbuilder.build.BuildReport;
import com.borland.jbuilder.build.BuildUtil;
import com.borland.jbuilder.build.CommandMaker;
import com.borland.jbuilder.build.ExternalMaker;
import com.borland.jbuilder.build.JavaBuildTask;
import com.borland.jbuilder.build.ParseError;
import com.borland.jbuilder.build.e;
import com.borland.jbuilder.build.kc;
import com.borland.jbuilder.build.lc;
import com.borland.jbuilder.jot.JotParseException;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.primetime.build.BuildProcess;
import com.borland.primetime.build.BuildTask;
import com.borland.primetime.build.BuildWarning;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.NodePropertyDescriptor;
import com.borland.primetime.node.Project;
import com.borland.primetime.node.UrlNode;
import com.borland.primetime.util.Platform;
import com.borland.primetime.util.Strings;
import com.borland.primetime.vfs.InvalidUrlException;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.SwingUtilities;

public abstract class ExternalBuildTask
implements BuildTask {
    private boolean a = false;
    private ArrayList i;
    protected Project currProj;
    protected ParseError parseError;
    protected ExternalMaker maker;
    protected String generatedPropertyKey;
    protected String compilingStatusMessage;
    protected String invocationErrorMessage = INVOCATION_MESSAGE;
    protected String extension = "java";
    public static final String INVOCATION_MESSAGE_CORBA;
    public static final String INVOCATION_MESSAGE;
    public static final String PROPKEY_GENERATED = "generated";

    static {
        PROPKEY_GENERATED = PROPKEY_GENERATED;
        INVOCATION_MESSAGE = e.a(111);
        INVOCATION_MESSAGE_CORBA = e.a(112);
    }

    public static String getPathEnvVariable() {
        if (Platform.WIN32) {
            return "Path";
        }
        return "PATH";
    }

    public static String getJdkPath(JBProject jBProject) {
        Url url = jBProject.getPaths().getJDKPathSet().getHomePath();
        Url url2 = url.getRelativeUrl("bin");
        Url url3 = url.getRelativeUrl("bin/java");
        String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(url2.getFileObject().getPath()))).append(File.pathSeparator).append(url3.getFileObject().getPath())));
        return string;
    }

    public static void informChildrenChanged(Node[] nodeArray) {
        SwingUtilities.invokeLater(new kc(nodeArray));
    }

    public static void informChildrenChanged(Node node) {
        SwingUtilities.invokeLater(new lc(node));
    }

    public static Url[] deleteAllGeneratedFiles(UrlNode[] urlNodeArray) {
        ArrayList<Url> arrayList = new ArrayList<Url>();
        for (int i2 = 0; i2 < urlNodeArray.length; ++i2) {
            Url[] urlArray = ExternalBuildTask.deleteAllGeneratedFiles(urlNodeArray[i2]);
            for (int i3 = 0; i3 < urlArray.length; ++i3) {
                arrayList.add(urlArray[i3]);
            }
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    public static Url[] deleteAllGeneratedFiles(UrlNode urlNode) {
        ArrayList<Url> arrayList = new ArrayList<Url>();
        String[] stringArray = ExternalBuildTask.a(urlNode);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Url[] urlArray = ExternalBuildTask.deleteGeneratedFiles(stringArray[i2], urlNode);
            for (int i3 = 0; i3 < urlArray.length; ++i3) {
                arrayList.add(urlArray[i3]);
            }
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    public static Url[] deleteGeneratedFiles(String string, UrlNode urlNode) {
        return ExternalBuildTask.deleteGeneratedFiles(string, new UrlNode[]{urlNode});
    }

    private static String[] a(UrlNode urlNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SortedMap sortedMap = urlNode.getProperties();
        if (!sortedMap.isEmpty()) {
            Set set = sortedMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                Map.Entry entry = iterator.next();
                NodePropertyDescriptor nodePropertyDescriptor = (NodePropertyDescriptor)entry.getKey();
                String string2 = nodePropertyDescriptor.getCategory();
                if (string2 == null || !string2.equals(PROPKEY_GENERATED) || !(string = nodePropertyDescriptor.getProperty()).endsWith(".0")) continue;
                arrayList.add(string.substring(0, string.lastIndexOf(".0")));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Url[] getAllGeneratedFiles(UrlNode[] urlNodeArray) {
        ArrayList<Url> arrayList = new ArrayList<Url>();
        for (int i2 = 0; i2 < urlNodeArray.length; ++i2) {
            Url[] urlArray = ExternalBuildTask.getAllGeneratedFiles(urlNodeArray[i2]);
            for (int i3 = 0; i3 < urlArray.length; ++i3) {
                arrayList.add(urlArray[i3]);
            }
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    public static Url[] getAllGeneratedFiles(UrlNode urlNode) {
        ArrayList<Url> arrayList = new ArrayList<Url>();
        String[] stringArray = ExternalBuildTask.a(urlNode);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Url[] urlArray = ExternalBuildTask.getGeneratedFiles(stringArray[i2], urlNode, false);
            for (int i3 = 0; i3 < urlArray.length; ++i3) {
                arrayList.add(urlArray[i3]);
            }
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    public static Url[] deleteGeneratedFiles(String string, UrlNode[] urlNodeArray) {
        Browser browser = Browser.getActiveBrowser();
        ArrayList<Url> arrayList = new ArrayList<Url>();
        for (int i2 = 0; i2 < urlNodeArray.length; ++i2) {
            int n2;
            UrlNode urlNode = urlNodeArray[i2];
            Project project = urlNode.getProject();
            Url[] urlArray = ExternalBuildTask.getGeneratedFiles(string, urlNode, true);
            Node[] nodeArray = new UrlNode[urlArray.length];
            for (n2 = 0; n2 < urlArray.length; ++n2) {
                nodeArray[n2] = project.getNode(urlArray[n2]);
            }
            if (browser != null) {
                try {
                    browser.closeNodes(nodeArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (n2 = 0; n2 < nodeArray.length; ++n2) {
                Node node = nodeArray[n2];
                try {
                    ((UrlNode)node).getUrl().getFileObject().delete();
                    arrayList.add(((UrlNode)node).getUrl());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                node.setParent(null);
            }
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    public static Url[] getGeneratedFiles(String string, UrlNode urlNode, boolean bl) {
        return ExternalBuildTask.getGeneratedFiles(string, new UrlNode[]{urlNode}, bl);
    }

    public static Url[] getGeneratedFiles(String string, UrlNode[] urlNodeArray, boolean bl) {
        ArrayList<Url> arrayList = new ArrayList<Url>();
        for (int i2 = 0; i2 < urlNodeArray.length; ++i2) {
            Url url;
            int n2 = 0;
            while ((url = ExternalBuildTask.a(string, urlNodeArray[i2], n2, bl)) != null) {
                arrayList.add(url);
                ++n2;
            }
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    private static Url a(String string, UrlNode urlNode, int n2, boolean bl) {
        Url url = null;
        String string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".").append(Integer.toString(n2))));
        String string3 = urlNode.getProperty(PROPKEY_GENERATED, string2, null);
        if (string3 != null) {
            if (bl) {
                urlNode.setProperty(PROPKEY_GENERATED, string2, null);
            }
            try {
                url = new Url(string3);
            }
            catch (InvalidUrlException invalidUrlException) {
                JBProject jBProject = urlNode instanceof JBProject ? (JBProject)urlNode : (JBProject)urlNode.getProject();
                url = BuildUtil.getGeneratedDir(jBProject).getRelativeUrl(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public static void recordGeneratedFiles(String string, UrlNode urlNode, UrlNode[] urlNodeArray) {
        Arrays.sort(urlNodeArray);
        for (int i2 = 0; i2 < urlNodeArray.length; ++i2) {
            ExternalBuildTask.recordGeneratedFile(string, urlNode, urlNodeArray[i2].getUrl(), i2);
        }
        ExternalBuildTask.recordGeneratedFile(string, urlNode, null, urlNodeArray.length);
        urlNode.makePersistent();
    }

    public static void recordGeneratedFiles(String string, UrlNode urlNode, Url[] urlArray) {
        int n2;
        Object[] objectArray = new UrlNode[urlArray.length];
        for (n2 = 0; n2 < urlArray.length; ++n2) {
            objectArray[n2] = urlNode.getProject().getNode(urlArray[n2]);
        }
        Arrays.sort(objectArray);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            ExternalBuildTask.recordGeneratedFile(string, urlNode, ((UrlNode)objectArray[n2]).getUrl(), n2);
        }
        ExternalBuildTask.recordGeneratedFile(string, urlNode, null, objectArray.length);
        urlNode.makePersistent();
    }

    public static void recordGeneratedFile(String string, UrlNode urlNode, Url url, int n2) {
        JBProject jBProject = urlNode instanceof JBProject ? (JBProject)urlNode : (JBProject)urlNode.getProject();
        Url url2 = BuildUtil.getGeneratedDir(jBProject);
        String string2 = url != null ? url2.getRelativePath(url) : null;
        String string3 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".").append(Integer.toString(n2))));
        urlNode.setProperty(PROPKEY_GENERATED, string3, string2);
    }

    static void a(Project project) {
        File file = BuildUtil.getTempDirUrl((JBProject)project).getFileObject();
        BuildUtil.clearDirectory(file);
        file.delete();
    }

    public static String findJavaTool(JBProject jBProject) {
        Url url = jBProject.getPaths().getJDKPathSet().getHomePath();
        File file = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(url.getFileObject().getPath()))).append(File.separatorChar).append("bin"))));
        String string = file.getAbsolutePath();
        if (string == null || string.length() == 0) {
            String string2 = System.getProperty("java.home");
            file = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(File.separatorChar).append("bin"))));
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static boolean needsRebuild(FileNode fileNode, String string) {
        boolean bl = true;
        long l2 = ExternalBuildTask.getGenerationTime(fileNode, string);
        if (l2 > (long)0) {
            bl = fileNode.getUrl().getFileObject().lastModified() > l2;
        }
        return bl;
    }

    protected boolean needsRebuild(FileNode fileNode) {
        return ExternalBuildTask.needsRebuild(fileNode, this.generatedPropertyKey);
    }

    protected static long getGenerationTime(FileNode fileNode, String string) {
        long l2 = 0L;
        String string2 = String.valueOf(String.valueOf(string)).concat(".0");
        String string3 = fileNode.getProperty(PROPKEY_GENERATED, string2, null);
        if (string3 != null) {
            Url url = null;
            try {
                url = new Url(string3);
            }
            catch (InvalidUrlException invalidUrlException) {
                url = BuildUtil.getGeneratedDir((JBProject)fileNode.getProject()).getRelativeUrl(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (url != null) {
                l2 = url.getFileObject().lastModified();
            }
        }
        return l2;
    }

    static String a(JBProject jBProject) {
        String string = "";
        Url[] urlArray = jBProject.getPaths().getFullClassPath();
        if (urlArray != null && urlArray.length > 0) {
            int n2 = urlArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(urlArray[i2].getFileObject().getPath());
                if (i2 >= n2 - 1) continue;
                stringBuffer.append(File.pathSeparator);
            }
            string = ExternalBuildTask.a(stringBuffer.toString());
        }
        return string;
    }

    static String a(String string) {
        String string2 = " \"";
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string)));
        string2 = String.valueOf(String.valueOf(string2)).concat("\"");
        return string2;
    }

    protected abstract String[] generateArgs(Url var1);

    protected void buildGeneratedFiles(BuildProcess buildProcess, Node node) {
        JavaBuildTask javaBuildTask = null;
        Node[] nodeArray = node.getDisplayChildren();
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            Url url;
            Node node2 = nodeArray[i2];
            if (!(node2 instanceof JavaFileNode)) continue;
            if (javaBuildTask == null) {
                if (buildProcess.containsTaskKey(JavaBuildTask.SHARED_JAVA_BUILD_TASK)) {
                    javaBuildTask = (JavaBuildTask)buildProcess.getTask(JavaBuildTask.SHARED_JAVA_BUILD_TASK);
                } else {
                    javaBuildTask = new JavaBuildTask();
                    buildProcess.putTask(JavaBuildTask.SHARED_JAVA_BUILD_TASK, javaBuildTask);
                    buildProcess.getBuildTaskList().add(javaBuildTask);
                }
            }
            if (!VFS.exists(url = ((JavaFileNode)node2).getUrl())) continue;
            javaBuildTask.addBuildSource(url);
        }
    }

    protected void collectGeneratedFiles(BuildProcess buildProcess, Project project, Url url, String string) {
        if (!(project instanceof JBProject)) {
            return;
        }
        JBProject jBProject = (JBProject)project;
        Url url2 = BuildUtil.getGeneratedDir(jBProject);
        File file = BuildUtil.getTempDirUrl(jBProject).getFileObject();
        try {
            Comparable comparable;
            Object object;
            int n2;
            FileNode fileNode = project.findNode(url);
            Url[] urlArray = ExternalBuildTask.deleteGeneratedFiles(string, fileNode);
            if (buildProcess.containsTaskKey(JavaBuildTask.SHARED_JAVA_BUILD_TASK)) {
                JavaBuildTask javaBuildTask = (JavaBuildTask)buildProcess.getTask(JavaBuildTask.SHARED_JAVA_BUILD_TASK);
                for (int i2 = 0; i2 < urlArray.length; ++i2) {
                    javaBuildTask.removeBuildSource(urlArray[i2]);
                }
            }
            BuildUtil.copyDirectoryTree(file, url2.getFileObject());
            int n3 = file.getPath().length();
            String string2 = url2.getFileObject().getPath();
            String[] stringArray = BuildUtil.getSubFiles(file, this.extension);
            ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(stringArray[n2].substring(n3))));
                try {
                    comparable = new File((String)object);
                    ((File)comparable).setReadOnly();
                    arrayList.add(project.getNode(new Url((File)comparable)));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Collections.sort(arrayList);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = (FileNode)arrayList.get(n2);
                comparable = ((FileNode)object).getUrl();
                String string3 = url2.getRelativePath((Url)comparable);
                String string4 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".").append(Integer.toString(n2))));
                fileNode.setProperty(PROPKEY_GENERATED, string4, string3);
            }
            ExternalBuildTask.informChildrenChanged(fileNode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean build(BuildProcess buildProcess, Project project, boolean bl) {
        Object object;
        Object object2;
        if (!(project instanceof JBProject)) {
            return true;
        }
        this.currProj = project;
        if (this.maker == null) {
            this.maker = new CommandMaker(this.invocationErrorMessage, this.parseError);
            String string = ExternalBuildTask.getPathEnvVariable();
            object2 = ExternalBuildTask.getJdkPath((JBProject)project);
            object = ((CommandMaker)this.maker).getEnvironmentVariable(string);
            if (object != null) {
                object2 = String.valueOf(String.valueOf(object2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(File.pathSeparator)).concat(String.valueOf(String.valueOf(object))))));
            }
            ((CommandMaker)this.maker).setEnvironmentVariable(string, (String)object2);
        }
        for (int i2 = 0; i2 < this.i.size() && !buildProcess.isCancelled(); ++i2) {
            boolean bl2;
            object2 = (Url)this.i.get(i2);
            if (object2 == null) continue;
            buildProcess.fireBuildStatus(Strings.format(this.compilingStatusMessage, ((Url)object2).getName()), true);
            object = project.findNode((Url)object2);
            boolean bl3 = true;
            try {
                bl2 = bl || this.needsRebuild((FileNode)object);
            }
            catch (BuildWarning buildWarning) {
                buildProcess.fireBuildProblem(buildWarning.getUrl(), false, buildWarning.getMessage(), buildWarning.getLine(), buildWarning.getColumn(), null);
                continue;
            }
            if (bl2) {
                String[] stringArray = null;
                try {
                    stringArray = this.generateArgs((Url)object2);
                }
                catch (JotParseException jotParseException) {
                    buildProcess.fireBuildProblem((Url)object2, true, jotParseException.getMessage(), jotParseException.getLine(), jotParseException.getColumn(), null);
                    boolean bl4 = false;
                    return bl4;
                }
                catch (BuildWarning buildWarning) {
                    buildProcess.fireBuildProblem(buildWarning.getUrl(), false, buildWarning.getMessage(), buildWarning.getLine(), buildWarning.getColumn(), null);
                    continue;
                }
                if (stringArray != null) {
                    Object object3;
                    BuildUtil.prepareTempAndGeneratedDir(project);
                    BuildReport buildReport = this.maker.invoke(stringArray);
                    if (this.a) {
                        object3 = this.getClass().getName();
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(object3))).append(" BuildSuccessful ").append(buildReport.isBuildSuccessful()))));
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(object3))).append(" Total Msg Count ").append(buildReport.getTotalMessageCount()))));
                    }
                    if ((object3 = buildReport.getAllMessages()) != null) {
                        for (int i3 = 0; i3 < ((BuildMessage[])object3).length; ++i3) {
                            if (object3[i3].isError() || object3[i3].isWarning()) {
                                buildProcess.fireBuildProblem((Url)object2, object3[i3].isError(), object3[i3].getMessage(), object3[i3].getLineNumber(), object3[i3].getColumnNumber(), null);
                                continue;
                            }
                            buildProcess.fireBuildMessage(((Url)object2).getFileObject().getPath(), object3[i3].getMessage());
                        }
                    }
                    if (buildReport.isBuildSuccessful()) {
                        this.collectGeneratedFiles(buildProcess, project, (Url)object2, this.generatedPropertyKey);
                        bl3 = true;
                    }
                    ExternalBuildTask.a(project);
                }
            }
            if (!bl3) continue;
            this.buildGeneratedFiles(buildProcess, (Node)object);
        }
        return false;
    }

    public void addBuildSource(Url url) {
        this.i.add(url);
    }

    public ExternalBuildTask(String string) {
        this.compilingStatusMessage = e.a(32);
        this.i = new ArrayList();
        this.generatedPropertyKey = string;
    }

    public ExternalBuildTask() {
        this.compilingStatusMessage = e.a(32);
        this.i = new ArrayList();
    }
}

