/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.debugger;

import com.borland.jbuilder.debugger.DebugJavaProcess;
import com.borland.jbuilder.debugger.DebugJavaProcessTracker;
import com.borland.jbuilder.debugger.DebugTree;
import com.borland.jbuilder.debugger.DebugTreeNode;
import com.borland.jbuilder.debugger.FieldVariable;
import com.borland.jbuilder.debugger.Variable;
import com.borland.jbuilder.debugger.WatchDescriptor;
import com.borland.jbuilder.debugger.ac;
import com.borland.jbuilder.debugger.bc;
import com.borland.jbuilder.debugger.c;
import com.borland.jbuilder.debugger.cc;
import com.borland.jbuilder.debugger.dc;
import com.borland.primetime.actions.ActionGroup;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserIcons;
import com.borland.primetime.ui.LazyTreeNode;
import com.borland.primetime.util.Hex;
import com.borland.primetime.util.Strings;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class PrimitiveTreeNode
extends DebugTreeNode {
    private WatchDescriptor d;
    private PrimitiveValue b;
    private Variable a;
    private boolean c;

    static boolean d(PrimitiveTreeNode primitiveTreeNode) {
        return primitiveTreeNode.c;
    }

    static Variable b(PrimitiveTreeNode primitiveTreeNode) {
        return primitiveTreeNode.a;
    }

    static PrimitiveValue c(PrimitiveTreeNode primitiveTreeNode) {
        return primitiveTreeNode.b;
    }

    static WatchDescriptor a(PrimitiveTreeNode primitiveTreeNode) {
        return primitiveTreeNode.d;
    }

    static PrimitiveValue a(PrimitiveTreeNode primitiveTreeNode, DebugJavaProcessTracker debugJavaProcessTracker, Type type) {
        return primitiveTreeNode.a(debugJavaProcessTracker, type);
    }

    static void a(PrimitiveTreeNode primitiveTreeNode, DebugJavaProcessTracker debugJavaProcessTracker, DebugTree debugTree, boolean bl) {
        primitiveTreeNode.a(debugJavaProcessTracker, debugTree, bl);
    }

    static void a(PrimitiveTreeNode primitiveTreeNode, DebugJavaProcessTracker debugJavaProcessTracker, DebugTree debugTree, PrimitiveValue primitiveValue) {
        primitiveTreeNode.a(debugJavaProcessTracker, debugTree, primitiveValue);
    }

    public static char parseChar(String string) throws Exception {
        String string2 = com.borland.jbuilder.debugger.c.a(412);
        char c2 = '\u0000';
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        if (n2 > 1 && cArray[0] == '\'' && cArray[n2 - 1] == '\'') {
            if (n2 == 2) {
                string2 = com.borland.jbuilder.debugger.c.a(182);
            } else if (n2 == 3) {
                c2 = cArray[1];
                bl = true;
            } else if (cArray[1] == '\\') {
                if (n2 == 8) {
                    if (cArray[2] == 'u') {
                        try {
                            c2 = (char)Short.valueOf(new String(cArray, 3, 4), 16).shortValue();
                            bl = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            string2 = com.borland.jbuilder.debugger.c.a(235);
                        }
                    }
                } else if (n2 == 4) {
                    bl = true;
                    switch (cArray[2]) {
                        case '\'': 
                        case '\\': {
                            c2 = cArray[2];
                            break;
                        }
                        case 'n': {
                            c2 = (char)10;
                            break;
                        }
                        case 'b': {
                            c2 = (char)8;
                            break;
                        }
                        case 't': {
                            c2 = (char)9;
                            break;
                        }
                        case 'f': {
                            c2 = (char)12;
                            break;
                        }
                        case 'r': {
                            c2 = (char)13;
                            break;
                        }
                        default: {
                            string2 = com.borland.jbuilder.debugger.c.a(235);
                            bl = false;
                            break;
                        }
                    }
                }
            }
        } else {
            int n3;
            if (string.startsWith("0x") || string.startsWith("0X")) {
                n3 = Integer.parseInt(string.substring(2), 16);
            } else {
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    throw new Exception(string2);
                }
            }
            if (n3 <= 65535) {
                c2 = (char)n3;
                bl = true;
            }
        }
        if (!bl) {
            throw new Exception(string2);
        }
        return c2;
    }

    public static PrimitiveValue toPrimitiveValue(Type type, String string) {
        VirtualMachine virtualMachine = type.virtualMachine();
        try {
            if (type instanceof IntegerType) {
                if (string.startsWith("0x") || string.startsWith("0X")) {
                    IntegerValue integerValue = virtualMachine.mirrorOf((int)Long.parseLong(string.substring(2), 16));
                    return integerValue;
                }
                IntegerValue integerValue = virtualMachine.mirrorOf(Integer.parseInt(string));
                return integerValue;
            }
            if (type instanceof ShortType) {
                if (string.startsWith("0x") || string.startsWith("0X")) {
                    ShortValue shortValue = virtualMachine.mirrorOf((short)Integer.parseInt(string.substring(2), 16));
                    return shortValue;
                }
                ShortValue shortValue = virtualMachine.mirrorOf(Short.parseShort(string));
                return shortValue;
            }
            if (type instanceof LongType) {
                if (string.startsWith("0x") || string.startsWith("0X")) {
                    LongValue longValue = virtualMachine.mirrorOf(Long.parseLong(string.substring(2), 16));
                    return longValue;
                }
                LongValue longValue = virtualMachine.mirrorOf(Long.parseLong(string));
                return longValue;
            }
            if (type instanceof ByteType) {
                if (string.startsWith("0x") || string.startsWith("0X")) {
                    ByteValue byteValue = virtualMachine.mirrorOf((byte)Short.parseShort(string.substring(2), 16));
                    return byteValue;
                }
                ByteValue byteValue = virtualMachine.mirrorOf(Byte.parseByte(string));
                return byteValue;
            }
            if (type instanceof FloatType) {
                FloatValue floatValue = virtualMachine.mirrorOf(Float.parseFloat(string));
                return floatValue;
            }
            if (type instanceof DoubleType) {
                DoubleValue doubleValue = virtualMachine.mirrorOf(Double.parseDouble(string));
                return doubleValue;
            }
            if (type instanceof BooleanType) {
                BooleanValue booleanValue = virtualMachine.mirrorOf(Boolean.valueOf(string));
                return booleanValue;
            }
            if (type instanceof CharType) {
                CharValue charValue = virtualMachine.mirrorOf(PrimitiveTreeNode.parseChar(string));
                return charValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String toString(Value value, boolean bl) {
        String string;
        block12: {
            Type type;
            block11: {
                string = value.toString();
                type = value.type();
                if (!(type instanceof CharType)) break block11;
                char c2 = string.charAt(0);
                string = bl ? PrimitiveTreeNode.a(c2) : PrimitiveTreeNode.toString(c2);
                break block12;
            }
            if (!bl) break block12;
            try {
                String string2 = "0x";
                if (type instanceof IntegerType) {
                    string = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(Integer.toHexString(Integer.valueOf(string)))));
                } else if (type instanceof ShortType) {
                    String string3 = Integer.toHexString(Short.valueOf(string).intValue());
                    int n2 = string3.length();
                    if (n2 > 4) {
                        string3 = string3.substring(n2 - 4);
                    }
                    string = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string3)));
                } else if (type instanceof ByteType) {
                    String string4 = Integer.toHexString(Byte.valueOf(string).intValue());
                    int n3 = string4.length();
                    if (n3 > 2) {
                        string4 = string4.substring(n3 - 2);
                    }
                    string = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string4)));
                } else if (type instanceof LongType) {
                    string = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(Long.toHexString(Long.valueOf(string)))));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return string;
    }

    public static String toString(char c2) {
        String string;
        switch (c2) {
            case '\'': {
                string = "'\\''";
                break;
            }
            case '\\': {
                string = "'\\\\'";
                break;
            }
            case '\n': {
                string = "'\\n'";
                break;
            }
            case '\b': {
                string = "'\\b'";
                break;
            }
            case '\t': {
                string = "'\\t'";
                break;
            }
            case '\f': {
                string = "'\\f'";
                break;
            }
            case '\r': {
                string = "'\\r'";
                break;
            }
            default: {
                if (c2 >= '\u0000' && c2 <= '\u001f') {
                    string = PrimitiveTreeNode.a(c2);
                    break;
                }
                char[] cArray = new char[]{'\'', c2, '\''};
                string = new String(cArray, 0, 3);
            }
        }
        return string;
    }

    private static String a(char c2) {
        char[] cArray = new char[]{'\'', '\\', 'u', Hex.chars[c2 >> 12 & 0xF], Hex.chars[c2 >> 8 & 0xF], Hex.chars[c2 >> 4 & 0xF], Hex.chars[c2 & 0xF], '\''};
        return new String(cArray, 0, 8);
    }

    public static boolean canDisplayInHex(Type type) {
        return type instanceof CharType || type instanceof IntegerType || type instanceof ShortType || type instanceof ByteType || type instanceof LongType;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.a.getDescription()))).append(" = ").append(PrimitiveTreeNode.toString(this.b, this.c))));
    }

    public void setDisplayInHex(boolean bl) {
        this.c = bl;
        this.d.setDisplayInHex(bl);
    }

    public ActionGroup getPopupActionGroup(DebugJavaProcessTracker debugJavaProcessTracker, DebugTree debugTree) {
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add(new dc(this, debugJavaProcessTracker, 1, Strings.format(com.borland.jbuilder.debugger.c.a(127), this.a.getKind()), '\u0000', com.borland.jbuilder.debugger.c.a(126), BrowserIcons.ICON_ADDWATCH));
        if (this.a instanceof FieldVariable) {
            actionGroup.add(new cc(this, debugJavaProcessTracker, 1, Strings.format(com.borland.jbuilder.debugger.c.a(129), this.a.getKind()), '\u0000', com.borland.jbuilder.debugger.c.a(128), BrowserIcons.ICON_ADDBREAKPOINT));
        }
        actionGroup.add(new bc(this, debugJavaProcessTracker, debugTree, 1, com.borland.jbuilder.debugger.c.a(100), '\u0000', com.borland.jbuilder.debugger.c.a(99)));
        if (PrimitiveTreeNode.canDisplayInHex(this.b.type())) {
            actionGroup.add(new ac(this, debugJavaProcessTracker, debugTree));
        }
        return actionGroup;
    }

    public Icon getIcon() {
        return BrowserIcons.ICON_PRIMITIVE;
    }

    private void a(DebugJavaProcessTracker debugJavaProcessTracker, DebugTree debugTree, PrimitiveValue primitiveValue) {
        String string = this.a.setValue(primitiveValue);
        if (string == null) {
            this.b = primitiveValue;
            debugJavaProcessTracker.updateTreeNode(this, debugTree);
            debugJavaProcessTracker.forceUpdateViews();
            debugJavaProcessTracker.getDebugJavaProcess().getJavaEvaluator().clearTooltipCache();
            debugJavaProcessTracker.setStatus("");
        } else {
            debugJavaProcessTracker.setStatus(string);
        }
    }

    private void a(DebugJavaProcessTracker debugJavaProcessTracker, DebugTree debugTree, boolean bl) {
        this.setDisplayInHex(bl);
        debugJavaProcessTracker.updateTreeNode(this, debugTree);
    }

    private PrimitiveValue a(DebugJavaProcessTracker debugJavaProcessTracker, Type type) {
        String string = JOptionPane.showInputDialog(Browser.getActiveBrowser(), Strings.format(com.borland.jbuilder.debugger.c.a(189), type.name()), com.borland.jbuilder.debugger.c.a(103), 3);
        if (string != null) {
            try {
                DebugJavaProcess debugJavaProcess = debugJavaProcessTracker.getDebugJavaProcess();
                PrimitiveValue primitiveValue = (PrimitiveValue)debugJavaProcess.getJavaEvaluator().evaluate(string, debugJavaProcess.getSuspendedThread(), type);
                return primitiveValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public PrimitiveTreeNode(Variable variable, PrimitiveValue primitiveValue, WatchDescriptor watchDescriptor) {
        this.a = variable;
        this.b = primitiveValue;
        this.d = watchDescriptor;
        this.c = false;
        this.setNodes(LazyTreeNode.EMPTY_NODES);
    }
}

