/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.editor;

import com.borland.primetime.editor.AbstractScanner;

public class XMLScanner
extends AbstractScanner {
    protected static final int IN_TAG = 512;
    protected static final int BEGIN_TAG = 256;
    protected static final int IN_DQ_STRING = 4;
    protected static final int IN_SQ_STRING = 2;
    protected static final int IN_COMMENT = 1;
    protected static final int NORMAL = 0;

    static {
        NORMAL = 0;
        IN_COMMENT = 1;
        IN_SQ_STRING = 2;
        IN_DQ_STRING = 4;
        BEGIN_TAG = 256;
        IN_TAG = 512;
    }

    protected int checkString(int n2) {
        if ((n2 & 4) != 0) {
            while (this.ch != '\"' && this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            }
            if (this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
                this.stateFlags &= 0xFFFFFFFB;
            }
            return 9;
        }
        if ((n2 & 2) != 0) {
            while (this.ch != '\'' && this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            }
            if (this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
                this.stateFlags &= 0xFFFFFFFD;
            }
            return 9;
        }
        if (this.ch == '\"') {
            this.ch = this.buf[++this.bp];
            while (this.ch != '\"' && this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            }
            if (this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            } else {
                this.stateFlags |= 4;
            }
            return 9;
        }
        if (this.ch == '\'') {
            this.ch = this.buf[++this.bp];
            while (this.ch != '\'' && this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            }
            if (this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            } else {
                this.stateFlags |= 2;
            }
            return 9;
        }
        return -1;
    }

    protected int checkIdentifier(int n2) {
        if ((n2 & 0x100) != 0) {
            this.stateFlags &= 0xFFFFFEFF;
            this.stateFlags |= 0x200;
        }
        if (this.isValidIdentifierStart(this.ch) && this.ch != '\u0000') {
            int n3 = this.bp++;
            this.ch = this.buf[this.bp];
            while (this.isValidIdentifierPart(this.ch) && this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            }
            if ((n2 & 0x100) != 0) {
                return 17;
            }
            if ((n2 & 0x200) != 0 && this.ch == '=') {
                return 18;
            }
            return 3;
        }
        return -1;
    }

    protected int checkComment(int n2) {
        if ((n2 & 1) != 0) {
            while (true) {
                if (this.ch != '-' && this.ch != '\u0000') {
                    this.ch = this.buf[++this.bp];
                    continue;
                }
                if (this.ch == '-') {
                    this.ch = this.buf[++this.bp];
                }
                if (this.ch != '-' && this.ch != '\u0000') continue;
                while (this.ch == '-') {
                    this.ch = this.buf[++this.bp];
                }
                if (this.ch == '>' || this.ch == '\u0000') break;
            }
            if (this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
                this.stateFlags &= 0xFFFFFFFE;
            }
            return 5;
        }
        int n3 = this.bp++;
        if (this.ch == '<') {
            this.ch = this.buf[this.bp];
            if (this.ch == '!') {
                this.ch = this.buf[++this.bp];
                if (this.ch == '-') {
                    this.ch = this.buf[++this.bp];
                    if (this.ch == '-') {
                        while (true) {
                            this.ch = this.buf[++this.bp];
                            if (this.ch != '-' && this.ch != '\u0000') continue;
                            if (this.ch == '-') {
                                this.ch = this.buf[++this.bp];
                            }
                            if (this.ch != '-' && this.ch != '\u0000') continue;
                            while (this.ch == '-') {
                                this.ch = this.buf[++this.bp];
                            }
                            if (this.ch == '>' || this.ch == '\u0000') break;
                        }
                        if (this.ch != '\u0000') {
                            this.ch = this.buf[++this.bp];
                        } else {
                            this.stateFlags |= 1;
                        }
                        return 5;
                    }
                }
            }
            this.bp = n3;
            this.ch = this.buf[this.bp];
        }
        return -1;
    }

    protected int checkPlainText(int n2) {
        if (this.ch != '<' && this.ch != '\u0000') {
            this.ch = this.buf[++this.bp];
            while (this.ch != '<' && this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            }
            return 3;
        }
        return -1;
    }

    protected boolean isSymbol(char c2) {
        switch (c2) {
            case '!': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '[': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidIdentifierPart(char c2) {
        switch (c2) {
            case '$': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return true;
            }
            case ' ': 
            case '(': 
            case '.': {
                return false;
            }
        }
        return Character.isJavaIdentifierPart(c2);
    }

    protected boolean isValidIdentifierStart(char c2) {
        switch (c2) {
            case '!': 
            case '#': 
            case '/': 
            case '?': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return true;
            }
            case ' ': {
                return false;
            }
        }
        return Character.isJavaIdentifierStart(c2);
    }

    protected boolean isExtendedKeyword(String string) {
        return false;
    }

    protected boolean isKeyword(String string) {
        return false;
    }

    protected int nextToken(int n2) {
        int n3 = -1;
        if (n2 == 0) {
            n3 = this.checkComment(n2);
            if (n3 != -1) {
                return n3;
            }
            if (this.ch == '<') {
                this.stateFlags = 256;
                this.ch = this.buf[++this.bp];
                return 3;
            }
            n3 = this.checkPlainText(n2);
            if (n3 != -1) {
                return n3;
            }
        } else {
            if ((n2 & 1) != 0) {
                return this.checkComment(n2);
            }
            if ((n2 & 4) != 0 || (n2 & 2) != 0) {
                return this.checkString(n2);
            }
            if (this.ch == '<') {
                this.stateFlags |= 0x100;
                this.ch = this.buf[++this.bp];
                return 3;
            }
            if (this.ch == '>') {
                this.stateFlags = 0;
                this.ch = this.buf[++this.bp];
                return 3;
            }
            n3 = this.checkIdentifier(this.stateFlags);
            if (n3 != -1) {
                return n3;
            }
            n3 = this.checkWhitespace(this.stateFlags);
            if (n3 != -1) {
                return n3;
            }
            n3 = this.checkNumber(this.stateFlags);
            if (n3 != -1) {
                return n3;
            }
            n3 = this.checkString(this.stateFlags);
            if (n3 != -1) {
                return n3;
            }
            n3 = this.checkSymbol(this.stateFlags);
            if (n3 != -1) {
                return n3;
            }
        }
        if (this.ch == '\u0000') {
            return -1;
        }
        this.ch = this.buf[++this.bp];
        return 12;
    }
}

