/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.insight.java;

import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.node.JspFileNode;
import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.insight.Insight;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.viewer.AbstractTextNodeViewer;
import com.borland.primetime.viewer.NodeViewMap;
import java.awt.event.ActionEvent;
import javax.swing.Action;

public class JavaInsightActions {
    public static final Action[] customActions;
    public static EditorAction ACTION_InsightInvokeSymbol;
    public static EditorAction ACTION_InsightInvokeClass;
    public static EditorAction ACTION_InsightInvokeParameters;
    public static EditorAction ACTION_InsightInvokeMembers;
    public static final String insightSymbolAction = "javainsight-invoke-symbol";
    public static final String insightClassesAction = "javainsight-invoke-classes";
    public static final String insightParametersAction = "javainsight-invoke-parameters";
    public static final String insightMembersAction = "javainsight-invoke-members";

    static {
        insightMembersAction = insightMembersAction;
        insightParametersAction = insightParametersAction;
        insightClassesAction = insightClassesAction;
        insightSymbolAction = insightSymbolAction;
        ACTION_InsightInvokeMembers = new InsightMembersAction(insightMembersAction);
        ACTION_InsightInvokeParameters = new InsightParametersAction(insightParametersAction);
        ACTION_InsightInvokeClass = new InsightClassesAction(insightClassesAction);
        ACTION_InsightInvokeSymbol = new InsightSymbolAction(insightSymbolAction);
        customActions = new Action[]{ACTION_InsightInvokeMembers, ACTION_InsightInvokeParameters, ACTION_InsightInvokeClass, ACTION_InsightInvokeSymbol};
    }

    public static boolean isInsightAction(Action action) {
        return action != null && ((String)action.getValue("Name")).startsWith("javainsight");
    }

    public Action[] getActions() {
        return customActions;
    }

    public static class InsightSymbolAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane.isPopupEnabled()) {
                FileNode fileNode = NodeViewMap.getNode(editorPane);
                if (fileNode instanceof JspFileNode && !JBuilderInfo.isEnterpriseEnabled()) {
                    return;
                }
                Insight insight = NodeViewMap.getNodeViewer(editorPane).getInsight(fileNode);
                insight.invoke(editorPane, 8, 0, null);
            }
        }

        public InsightSymbolAction(String string) {
            super(string);
        }
    }

    public static class InsightClassesAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane.isPopupEnabled()) {
                AbstractTextNodeViewer abstractTextNodeViewer = NodeViewMap.getNodeViewer(editorPane);
                FileNode fileNode = NodeViewMap.getNode(editorPane);
                if (fileNode instanceof JspFileNode && !JBuilderInfo.isEnterpriseEnabled()) {
                    return;
                }
                Insight insight = abstractTextNodeViewer.getInsight(fileNode);
                insight.invoke(editorPane, 4, 0, null);
            }
        }

        public InsightClassesAction(String string) {
            super(string);
        }
    }

    public static class InsightParametersAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane.isPopupEnabled()) {
                AbstractTextNodeViewer abstractTextNodeViewer = NodeViewMap.getNodeViewer(editorPane);
                FileNode fileNode = NodeViewMap.getNode(editorPane);
                if (fileNode instanceof JspFileNode && !JBuilderInfo.isEnterpriseEnabled()) {
                    return;
                }
                Insight insight = abstractTextNodeViewer.getInsight(fileNode);
                insight.invoke(editorPane, 1, 0, null);
            }
        }

        public InsightParametersAction(String string) {
            super(string);
        }
    }

    public static class InsightMembersAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane.isPopupEnabled()) {
                AbstractTextNodeViewer abstractTextNodeViewer = NodeViewMap.getNodeViewer(editorPane);
                FileNode fileNode = NodeViewMap.getNode(editorPane);
                if (fileNode instanceof JspFileNode && !JBuilderInfo.isEnterpriseEnabled()) {
                    return;
                }
                Insight insight = abstractTextNodeViewer.getInsight(fileNode);
                insight.invoke(editorPane, 2, 0, null);
            }
        }

        public InsightMembersAction(String string) {
            super(string);
        }
    }
}

