/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.refactor.imports;

import com.borland.compiler.frontend.AST;
import com.borland.compiler.frontend.IdRef;
import com.borland.compiler.frontend.Import;
import com.borland.compiler.frontend.Select;
import com.borland.compiler.symtab.Basic;
import com.borland.compiler.symtab.ClassObj;
import com.borland.compiler.symtab.Name;
import com.borland.compiler.symtab.Obj;
import com.borland.compiler.symtab.Typ;
import com.borland.jbuilder.java.JavaNames;
import com.borland.jbuilder.java.SourceInfo;
import com.borland.jbuilder.java.filter.ObjKindFilter;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.repository.ClassEntry;
import com.borland.jbuilder.repository.PackageEntry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ImportUtil {
    private static Name c;
    private static Name d;
    private static Name b;
    static Name e;
    static Name a;

    static {
        a = Name.fromString("*");
        e = Name.fromString("Array");
        b = Name.fromString("true");
        d = Name.fromString("false");
        c = Name.fromString("null");
    }

    public static boolean doesPackageContainClass(PackageEntry packageEntry, String string) {
        Iterator iterator = packageEntry.getClassEntries().iterator();
        while (iterator.hasNext()) {
            ClassEntry classEntry = (ClassEntry)iterator.next();
            if (!classEntry.getShortName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNameAlreadyImported(JBProject jBProject, String[] stringArray, String string, String string2) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3;
            String string4 = stringArray[i2];
            String string5 = JavaNames.getPackage(string4);
            if (string5.equals(string) || string4.indexOf(42) != -1 || !(string3 = JavaNames.getShortClassName(string4)).equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean doPackagesContainClassName(JBProject jBProject, String[] stringArray, String string, String string2) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            PackageEntry packageEntry;
            String string3 = stringArray[i2];
            String string4 = JavaNames.getPackage(string3);
            if (string4.equals(string) || string3.indexOf(42) == -1 || !ImportUtil.doesPackageContainClass(packageEntry = jBProject.getRepository().getPackageEntry(string4), string2)) continue;
            return true;
        }
        return false;
    }

    public static Set getClassObjs(SourceInfo sourceInfo, int n2) {
        ObjKindFilter objKindFilter = new ObjKindFilter(2);
        AST[] aSTArray = sourceInfo.applyFilter(objKindFilter);
        HashSet<ClassObj> hashSet = new HashSet<ClassObj>();
        for (int i2 = 0; i2 < aSTArray.length; ++i2) {
            IdRef idRef = (IdRef)aSTArray[i2];
            if (idRef.pos < n2 || idRef.name == b || idRef.name == d || idRef.name == c) continue;
            Obj obj = null;
            if (idRef.obj.kind == 2 && !(idRef instanceof Select)) {
                obj = idRef.obj;
            } else if (idRef.obj.name == Basic.initS && idRef.obj.owner.kind == 2 && !(idRef instanceof Select)) {
                obj = idRef.obj.owner;
            }
            if (obj == null || Typ.isError(obj.typ) || obj.typ.tag != 11 || obj.name == e) continue;
            hashSet.add(obj.typ.baseTyp().obj);
        }
        return hashSet;
    }

    public static Set getClassEntrys(JBProject jBProject, SourceInfo sourceInfo, int n2) {
        Set set = ImportUtil.getClassObjs(sourceInfo, n2);
        HashSet<ClassEntry> hashSet = new HashSet<ClassEntry>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ClassObj classObj = (ClassObj)iterator.next();
            if (classObj == null || classObj.flatname == null) continue;
            String string = classObj.flatName().toString();
            ClassEntry classEntry = null;
            if (string == null || (classEntry = jBProject.getRepository().getClassEntry(string)) == null) continue;
            hashSet.add(classEntry);
        }
        return hashSet;
    }

    public static String getLongName(Obj obj) {
        if (obj != null && obj.flatName() != null) {
            return obj.flatName().toString();
        }
        return "";
    }

    public static String getShortName(Obj obj) {
        if (obj != null && obj.name != null) {
            return obj.name.toString();
        }
        return "";
    }

    public static int findStrucPosition(Select select) {
        if (select.struc instanceof Select) {
            return ImportUtil.findStrucPosition((Select)select.struc);
        }
        return select.struc.pos;
    }

    public static int getImportEndPos(SourceInfo sourceInfo) {
        AST[] aSTArray = sourceInfo.findAll(26);
        int n2 = 0;
        if (aSTArray.length > 0) {
            n2 = aSTArray[aSTArray.length - 1].endpos;
        } else {
            AST[] aSTArray2 = sourceInfo.findAll(25);
            if (aSTArray2.length > 0) {
                n2 = aSTArray2[0].endpos;
            }
        }
        return n2;
    }

    public static AST findImportAST(SourceInfo sourceInfo, int n2) {
        AST[] aSTArray = sourceInfo.findAll(26);
        for (int i2 = 0; i2 < aSTArray.length; ++i2) {
            if (n2 < aSTArray[i2].pos || n2 > aSTArray[i2].endpos) continue;
            return aSTArray[i2];
        }
        return null;
    }

    public static boolean hasStarImport(SourceInfo sourceInfo, String string) {
        Name name = Name.fromString(String.valueOf(String.valueOf(string)).concat(".*"));
        AST[] aSTArray = sourceInfo.findAll(26);
        for (int i2 = 0; i2 < aSTArray.length; ++i2) {
            if (((Import)aSTArray[i2]).pid.fullName() != name) continue;
            return true;
        }
        return false;
    }

    private ImportUtil() {
    }
}

