/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.unittest;

import com.borland.jbuilder.unittest.Res;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public class JdbcFixture {
    private static String fixturePath = ".";
    private String url = null;
    private String driver = null;
    private String username = null;
    private String password = null;
    private boolean promptForPassword = true;
    private String catalog = null;
    private String schema = null;
    private boolean verbose = false;
    private transient boolean initialized = false;
    private transient Statement statement = null;
    private transient Connection connection = null;
    private transient boolean holdIt = false;

    public void setUrl(String s2) {
        this.url = s2;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDriver(String s2) {
        this.driver = s2;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setPassword(String s2) {
        this.password = s2;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPromptForPassword(boolean b2) {
        this.promptForPassword = b2;
    }

    public boolean getPromptForPassword() {
        return this.promptForPassword;
    }

    public void setUsername(String s2) {
        this.username = s2;
    }

    public String getUsername() {
        return this.username;
    }

    public void setSqlSchema(String s2) {
        this.schema = s2;
    }

    public String getSqlSchema() {
        return this.schema;
    }

    public void setCatalog(String s2) {
        this.catalog = s2;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setVerbose(boolean b2) {
        this.verbose = b2;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    private void abortTest() {
        this.holdIt = true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setUp() {
        try {
            if (!this.initialize()) {
                this.abortTest();
            }
        }
        catch (ClassNotFoundException e2) {
            System.err.println(e2);
            System.err.println(Res.getString(0));
            this.abortTest();
        }
        catch (SQLException e3) {
            System.err.println("JdbcFixture.setup():");
            System.err.println("  ".concat(String.valueOf(String.valueOf(e3))));
            this.abortTest();
        }
    }

    private boolean initialize() throws SQLException, ClassNotFoundException {
        if (this.holdIt) {
            return false;
        }
        if (this.initialized) {
            return true;
        }
        Class.forName(this.driver);
        this.connection = DriverManager.getConnection(this.url, this.username, this.password);
        if (this.connection != null) {
            this.statement = this.connection.createStatement();
            this.initialized = this.statement != null;
            return this.initialized;
        }
        this.initialized = false;
        return false;
    }

    public void tearDown() {
        if (this.holdIt) {
            return;
        }
        try {
            if (this.initialized && this.connection != null) {
                this.connection.close();
                this.initialized = false;
            }
        }
        catch (Exception e2) {
            System.err.println(e2);
            this.abortTest();
        }
    }

    public void runSqlFile(String s2, boolean abortOnFailure) {
        block8: {
            if (this.holdIt) {
                return;
            }
            try {
                if (!this.initialize()) {
                    return;
                }
            }
            catch (Exception e2) {
                System.err.println(e2);
                System.err.println(Res.getString(5));
                if (abortOnFailure) {
                    this.abortTest();
                }
                return;
            }
            try {
                File file = new File(s2);
                if (!file.exists()) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Res.getString(4)))).append(s2).append("\""))));
                    this.abortTest();
                    return;
                }
                BufferedReader rdr = new BufferedReader(new FileReader(file));
                StringBuffer buf = this.readFileIntoBuffer(rdr);
                this.runSqlBuffer(buf, abortOnFailure);
            }
            catch (Exception e3) {
                System.err.println(e3);
                if (!abortOnFailure) break block8;
                this.abortTest();
            }
        }
    }

    public void runSqlBuffer(StringBuffer buf, boolean abortOnFailure) {
        block4: {
            try {
                StringTokenizer queries = new StringTokenizer(buf.toString(), ";");
                while (queries.hasMoreTokens()) {
                    if (this.holdIt) {
                        return;
                    }
                    String q2 = queries.nextToken().trim();
                    if (q2.length() <= 0) continue;
                    int k2 = this.statement.executeUpdate(q2);
                    if (!this.verbose) continue;
                    System.err.println("update query=".concat(String.valueOf(String.valueOf(q2))));
                }
            }
            catch (Exception e2) {
                System.err.println(e2);
                if (!abortOnFailure) break block4;
                this.abortTest();
            }
        }
    }

    private StringBuffer readFileIntoBuffer(Reader rdr) {
        StringBuffer buf = new StringBuffer();
        if (this.holdIt) {
            return buf;
        }
        try {
            int c2;
            while ((c2 = rdr.read()) != -1) {
                if (this.holdIt) {
                    StringBuffer stringBuffer = buf;
                    return stringBuffer;
                }
                buf.append((char)c2);
            }
            StringBuffer stringBuffer = buf;
            return stringBuffer;
        }
        catch (Exception e2) {
            System.err.println(e2);
            StringBuffer stringBuffer = null;
            return stringBuffer;
        }
    }

    public static void dumpResultSet(ResultSet rs, Writer writer) {
        try {
            BufferedWriter bw = new BufferedWriter(writer);
            JdbcFixture.outputCommas(rs, true, true, true, true, bw);
            bw.flush();
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
    }

    public static void outputCommas(ResultSet rs, boolean doheader, boolean docommas, boolean doquotes, boolean suppressNulls, BufferedWriter writer) {
        int maxCount = Short.MAX_VALUE;
        int thisCount = 0;
        try {
            int i2;
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            if (doheader) {
                for (i2 = 1; i2 <= numberOfColumns; ++i2) {
                    if (doquotes) {
                        writer.write("\"");
                    }
                    writer.write(rsmd.getColumnName(i2));
                    if (doquotes) {
                        writer.write("\"");
                    }
                    if (i2 >= numberOfColumns || !docommas) continue;
                    writer.write(", ");
                }
                writer.newLine();
            }
            while (rs.next() && thisCount++ <= maxCount) {
                for (i2 = 1; i2 <= numberOfColumns; ++i2) {
                    String val = rs.getString(i2);
                    if (val != null) {
                        if (doquotes) {
                            writer.write("\"");
                        }
                        writer.write(val);
                        if (doquotes) {
                            writer.write("\"");
                        }
                    } else if (suppressNulls) {
                        writer.write("");
                    } else {
                        writer.write("null");
                    }
                    if (i2 >= numberOfColumns || !docommas) continue;
                    writer.write(", ");
                }
                writer.newLine();
            }
        }
        catch (Exception e2) {
            try {
                writer.write(e2.toString());
                writer.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

