/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.wizard.common;

import com.borland.jbuilder.enterprise.ejb.AppServer;
import com.borland.jbuilder.enterprise.ejb.AppServerManager;
import com.borland.jbuilder.jot.JotClass;
import com.borland.jbuilder.jot.JotMarker;
import com.borland.jbuilder.jot.JotSourceFile;
import com.borland.jbuilder.node.AutomaticPackages;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.node.PackageNode;
import com.borland.jbuilder.paths.PathSet;
import com.borland.jbuilder.template.engine.TemplateEngine;
import com.borland.jbuilder.wizard.common.ClassNameUtil;
import com.borland.jbuilder.wizard.newproject.ProjectWizard;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.properties.GlobalArrayProperty;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.wizard.WizardDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class ProjectUtil {
    private static final String c = "DefaultPackage";
    private static final GlobalArrayProperty b;
    private static final int a = 16;

    static {
        a = 16;
        b = new GlobalArrayProperty("wizards.classpath", "classpath_history");
        c = c;
    }

    public static JBProject activateProject(Browser browser) {
        Project project = browser.getProjectView().getActiveUserProject();
        if (!(project instanceof JBProject)) {
            WizardDialog wizardDialog = new WizardDialog(browser, new ProjectWizard());
            wizardDialog.show();
            project = browser.getProjectView().getActiveUserProject();
            if (!(project instanceof JBProject)) {
                project = null;
            }
        }
        return (JBProject)project;
    }

    public static void updateClasspathForEjb(JBProject jBProject) {
        AppServer appServer = AppServerManager.getAppServer(jBProject);
        if (appServer != null) {
            String string = appServer.getClassName();
            jBProject.getPaths().putClassOnFullPath(string);
        }
    }

    public static Node getSuggestedParent(Project project, String string) {
        Project project2 = project;
        if (string != null && string.indexOf(46) > -1) {
            if (AutomaticPackages.isAutoPackagesEnabled(project)) {
                project2 = null;
            } else if (ProjectUtil.a(project, string)) {
                project2 = null;
            }
        }
        return project2;
    }

    private static boolean a(Project project, String string) {
        if (string != null && string.length() > 0) {
            Node[] nodeArray = project.getChildren();
            for (int i2 = 0; i2 < nodeArray.length; ++i2) {
                String string2;
                if (!(nodeArray[i2] instanceof PackageNode) || !(string2 = nodeArray[i2].getDisplayName()).equals(string) && !string.startsWith(String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf('.'))))) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateHistoryList(GlobalArrayProperty globalArrayProperty, String string) {
        List<String> list = Arrays.asList(globalArrayProperty.getValues());
        ArrayList<String> arrayList = new ArrayList<String>(list);
        int n2 = arrayList.indexOf(string);
        if (n2 != -1) {
            arrayList.remove(n2);
            arrayList.add(0, string);
        } else {
            arrayList.add(0, string);
            if (arrayList.size() > 16) {
                arrayList.remove(16);
            }
        }
        globalArrayProperty.setValues(arrayList.toArray(new String[arrayList.size()]));
    }

    public static void addClassPathText(String string) {
        ProjectUtil.updateHistoryList(b, string);
    }

    public static ComboBoxModel getClassPathHistory() {
        return new DefaultComboBoxModel<String>(b.getValues());
    }

    public static void generateHeaderComments(Project project, JotSourceFile jotSourceFile) {
        JotClass[] jotClassArray = jotSourceFile.getClasses();
        JotMarker jotMarker = null;
        if (jotClassArray.length > 0) {
            jotMarker = (JotMarker)((Object)jotClassArray[0]);
        }
        jotSourceFile.addComment(jotMarker, true, 2, ProjectUtil.getHeaderComments(project));
    }

    public static String getHeaderComments(Project project) {
        String[] stringArray = TemplateEngine.getClassJavadoc(project);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(String.valueOf(String.valueOf(stringArray[i2])).concat("\n"));
        }
        return stringBuffer.toString();
    }

    public static void addLibraryToProject(JBProject jBProject, String string) {
        PathSet pathSet = jBProject.getPaths().getLibrary(string);
        PathSet[] pathSetArray = jBProject.getPaths().getRequired();
        boolean bl = false;
        for (int i2 = 0; i2 != pathSetArray.length && !bl; ++i2) {
            bl = pathSet == pathSetArray[i2];
        }
        if (!bl) {
            PathSet[] pathSetArray2 = new PathSet[pathSetArray.length + 1];
            System.arraycopy(pathSetArray, 0, pathSetArray2, 0, pathSetArray.length);
            pathSetArray2[pathSetArray.length] = pathSet;
            jBProject.getPaths().setRequired(pathSetArray2);
            jBProject.check();
        }
    }

    public static String partOfPath(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        int n2 = string2.length();
        int n3 = 0;
        String string3 = null;
        while (n3 < n2) {
            int n4 = string2.indexOf(59, n3);
            if (n4 < 0) {
                n4 = n2;
            }
            string3 = string2.substring(n3, n4).toLowerCase();
            if (string.length() >= string3.length()) {
                if (string3.equalsIgnoreCase(string.substring(0, string3.length()))) {
                    n3 = n2;
                    continue;
                }
                n3 = n4 + 1;
                string3 = null;
                continue;
            }
            n3 = n4 + 1;
            string3 = null;
        }
        return string3;
    }

    public static String getDefaultPackageName(Project project) {
        String string = project.getProperty(c);
        if (string == null) {
            string = project.getAutoProperty("sys", c);
        }
        return string;
    }

    public static void setDefaultPackageName(Project project, String string) {
        project.setAutoProperty("sys", c, string);
        if (project.getProperty(c) != null) {
            project.setProperty(c, null);
        }
    }

    public static String getPackageName(Project project) {
        JBProject jBProject = null;
        if (project instanceof JBProject) {
            jBProject = (JBProject)project;
        }
        String string = null;
        if (project != null && ((string = ProjectUtil.getDefaultPackageName(project)) == null || string.length() == 0)) {
            Object object;
            Object object2;
            Node[] nodeArray = project.getChildren();
            int n2 = nodeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!(nodeArray[i2] instanceof JavaFileNode) || jBProject == null) continue;
                object2 = null;
                object = (JavaFileNode)nodeArray[i2];
                object2 = jBProject.getJotPackages().getSourceFile(((FileNode)object).getUrl());
                if (object2 == null || (string = object2.getPackage()) == null) continue;
                i2 = n2;
            }
            if (string == null || string.length() == 0) {
                object2 = project.getProjectPath().getFileObject().getPath();
                object = ProjectUtil.partOfPath((String)object2, project.getProperty("CompilerSourcePath"));
                if (object != null && !((String)object).equals(((String)object2).substring(0, ((String)object2).lastIndexOf(File.separatorChar)))) {
                    string = ((String)object2).substring(((String)object).length()).toLowerCase();
                    if (string.lastIndexOf(File.separatorChar) > 0) {
                        string = string.substring(0, string.lastIndexOf(File.separatorChar));
                        string = string.replace(File.separatorChar, '.');
                    } else {
                        string = project.getDisplayName().toLowerCase();
                        int n3 = string.indexOf(46);
                        if (n3 > -1) {
                            string = string.substring(0, n3);
                        }
                    }
                } else {
                    int n4;
                    Object object3;
                    File file = new File(project.getLongDisplayName());
                    String string2 = file.getParent();
                    String string3 = "";
                    if (jBProject != null) {
                        object3 = jBProject.getPaths().getSourcePath();
                        for (n4 = 0; n4 < ((Url[])object3).length; ++n4) {
                            string3 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string3))).append(((Url)object3[n4]).getFileObject().getPath()).append(File.pathSeparator)));
                        }
                    }
                    if ((object3 = ProjectUtil.partOfPath(string2, string3)) == null || ((String)object3).equals(string2)) {
                        string = project.getDisplayName().toLowerCase();
                        n4 = string.indexOf(46);
                        if (n4 > -1) {
                            string = string.substring(0, n4);
                        }
                    } else if ((string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1).toLowerCase()) != null && string2.length() > 0 && ClassNameUtil.validClass(string2)) {
                        string = string2;
                    }
                }
            }
        }
        if (string != null && string.startsWith(".")) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    private static String a(Url url, Url[] urlArray) {
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            if (!urlArray[i2].isChild(url)) continue;
            String string = urlArray[i2].getRelativePath(url);
            int n2 = (string = Url.URL_ENCODING.decode(string)).lastIndexOf(47);
            if (n2 > 0) {
                return string.substring(0, n2).replace('/', '.');
            }
            return "";
        }
        return null;
    }

    private static String b(Browser browser, JBProject jBProject) {
        Node node = browser.getProjectView().getSelectedNode();
        String string = null;
        if (node instanceof JavaFileNode) {
            string = ProjectUtil.a(((JavaFileNode)node).getUrl(), jBProject.getPaths().getSourcePath());
            if ("".equals(string)) {
                string = null;
            }
        } else if (node instanceof PackageNode && ("".equals(string = ((PackageNode)node).getName()) || jBProject.getPackageContent(jBProject.getPaths().getSourcePath(), string, 3).size() == 0)) {
            string = null;
        }
        return string;
    }

    private static String a(Browser browser, JBProject jBProject) {
        String string;
        Node node = browser.getActiveNode();
        if (node instanceof JavaFileNode && (string = ProjectUtil.a(((JavaFileNode)node).getUrl(), jBProject.getPaths().getSourcePath())) != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    public static String getCurrentPackageGuess(Browser browser, JBProject jBProject) {
        String string = ProjectUtil.a(browser, jBProject);
        if (string == null) {
            return ProjectUtil.b(browser, jBProject);
        }
        return string;
    }

    public static ComboBoxModel getLikelyPackageNames(Browser browser) {
        Project project = browser.getActiveUserProject();
        ProjectUtil.addClassPathText(ProjectUtil.getPackageName(project));
        if (project instanceof JBProject) {
            String string;
            Vector<String> vector = new Vector<String>();
            LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(b.getValues()));
            String string2 = ProjectUtil.a(browser, (JBProject)project);
            if (string2 != null) {
                linkedList.remove(string2);
                vector.add(string2);
            }
            if ((string = ProjectUtil.b(browser, (JBProject)project)) != null && !string.equals(string2)) {
                linkedList.remove(string);
                vector.add(string);
            }
            vector.addAll(linkedList);
            return new DefaultComboBoxModel(vector);
        }
        return ProjectUtil.getClassPathHistory();
    }

    public static boolean packageMatch(String string, Url url) {
        String string2 = url.toString();
        return string2.length() >= string.length() && string.toLowerCase() == string2.substring(string2.length() - string.length()).toLowerCase();
    }

    public static String getFirstValidSourcePath(Project project) {
        int n2;
        Object var1_1 = null;
        String string = null;
        String string2 = "";
        JBProject jBProject = null;
        if (project instanceof JBProject) {
            jBProject = (JBProject)project;
        }
        if (jBProject != null) {
            Url[] urlArray = jBProject.getPaths().getSourcePath();
            for (n2 = 0; n2 < urlArray.length; ++n2) {
                string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(urlArray[n2].getFileObject().getPath()).append(File.pathSeparator)));
            }
        }
        int n3 = 0;
        n2 = string2.length();
        while (n3 < n2) {
            int n4 = string2.indexOf(File.pathSeparatorChar, n3);
            if (n4 < 0) {
                n4 = n2;
            }
            if ((string = string2.substring(n3, n4)).endsWith(".zip")) {
                n3 = n4 + 1;
                continue;
            }
            return string;
        }
        return null;
    }

    private static Url[] a(Project project) {
        ArrayList<Url> arrayList = new ArrayList<Url>();
        Node[] nodeArray = project.getChildren();
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            if (!(nodeArray[i2] instanceof FileNode)) continue;
            FileNode fileNode = (FileNode)nodeArray[i2];
            arrayList.add(fileNode.getUrl());
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    public static String getBasePath(Project project, String string) {
        String string2 = null;
        String string3 = "";
        JBProject jBProject = null;
        if (project instanceof JBProject) {
            jBProject = (JBProject)project;
        }
        if (jBProject != null) {
            Url url = jBProject.getPaths().getDefaultSourcePath();
            return url.getFileObject().getPath();
        }
        String string4 = "";
        int n2 = 0;
        int n3 = string3.length();
        if (string == null) {
            string = ProjectUtil.getPackageName(project);
        }
        Url[] urlArray = ProjectUtil.a(project);
        if (urlArray.length > 0) {
            int n4;
            for (n4 = 0; n4 < urlArray.length && !ProjectUtil.packageMatch(string, urlArray[n4]); ++n4) {
            }
            if (n4 >= urlArray.length) {
                while (n2 < n3) {
                    File file;
                    int n5 = string3.indexOf(59, n2);
                    if (n5 < 0) {
                        n5 = n3;
                    }
                    if ((file = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2 = string3.substring(n2, n5)))).append(File.separator).append(string))))).isDirectory()) {
                        n2 = n3;
                        continue;
                    }
                    n2 = n5 + 1;
                    string2 = null;
                }
                if (string2 == null) {
                    string2 = ProjectUtil.getFirstValidSourcePath(project);
                }
                if (string2 == null) {
                    string2 = project.getLongDisplayName();
                    if ((string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar))).endsWith(string)) {
                        string2 = string2.substring(0, string2.length() - string.length() - 1);
                    }
                }
            } else {
                string2 = urlArray[n4].toString();
                string4 = ProjectUtil.partOfPath(string2 = string2.substring(0, string.length() - 1), string3);
                if (string4 == "" && (string2 = ProjectUtil.getFirstValidSourcePath(project)) == null) {
                    string2 = project.getLongDisplayName();
                    if ((string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar))).endsWith(string)) {
                        string2 = string2.substring(0, string2.length() - string.length() - 1);
                    }
                }
            }
        } else {
            string2 = ProjectUtil.getFirstValidSourcePath(project);
            if (string2 == null) {
                string2 = project.getLongDisplayName();
                if ((string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar))).endsWith(string)) {
                    string2 = string2.substring(0, string2.length() - string.length() - 1);
                }
            }
        }
        if (string2.endsWith(File.pathSeparator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String getProjectDirName(Project project) {
        String string = project.getProjectPath().getFileObject().getPath();
        return string != null ? string : ".";
    }

    public static int getUniqueFileNameID(Project project, String string, String string2, String string3) {
        for (int i2 = 1; i2 < 1000; ++i2) {
            File file = new File(string, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(i2).append(string3))));
            if (project.findNode(new Url(file)) != null || file.exists() || (file = new File(string, String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(i2))))).isDirectory()) continue;
            return i2;
        }
        return -1;
    }

    public static int getUniqueFileNameID(Project project, String string, String string2) {
        return ProjectUtil.getUniqueFileNameID(project, project.getProjectPath().getFile(), string, string2);
    }
}

