/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.wizard.jms;

import com.borland.jbuilder.jot.JotClassSource;
import com.borland.jbuilder.jot.JotCodeBlock;
import com.borland.jbuilder.jot.JotFieldDeclaration;
import com.borland.jbuilder.jot.JotIf;
import com.borland.jbuilder.jot.JotMarker;
import com.borland.jbuilder.jot.JotMethodSource;
import com.borland.jbuilder.jot.JotNames;
import com.borland.jbuilder.jot.JotPackages;
import com.borland.jbuilder.jot.JotSourceFile;
import com.borland.jbuilder.jot.JotStatement;
import com.borland.jbuilder.jot.JotTry;
import com.borland.jbuilder.wizard.common.ProjectUtil;
import com.borland.jbuilder.wizard.jbx.BasicClassWizard;
import com.borland.jbuilder.wizard.jms.JmsWizardState;
import com.borland.jbuilder.wizard.jms.a;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.util.Strings;
import com.borland.primetime.util.VetoException;
import com.borland.primetime.vfs.Buffer;
import javax.swing.JOptionPane;

public class JmsGenerator {
    private JmsWizardState a;

    protected void generatePubSub(JotSourceFile jotSourceFile, JotClassSource jotClassSource) {
        JotMarker jotMarker = this.generateGetTopicConnectionFactory(jotClassSource, null);
        jotMarker = this.generateGetTopicConnection(jotClassSource, jotMarker);
        jotMarker = this.generateGetTopicSession(jotClassSource, jotMarker);
        jotMarker = this.generateGetTopic(jotClassSource, jotMarker);
        jotMarker = this.generateGetTopicPublisher(jotClassSource, jotMarker);
        jotMarker = this.generateGetTopicSubscriber(jotClassSource, jotMarker);
        jotMarker = this.generatePublishText(jotClassSource, jotMarker);
        jotMarker = this.generateOnMessage(jotClassSource, jotMarker, true);
        jotMarker = this.generateClose(jotClassSource, jotMarker);
    }

    protected void generateP2p(JotSourceFile jotSourceFile, JotClassSource jotClassSource) {
        JotMarker jotMarker = this.generateGetQueueConnectionFactory(jotClassSource, null);
        jotMarker = this.generateGetQueueConnection(jotClassSource, jotMarker);
        jotMarker = this.generateGetQueueSession(jotClassSource, jotMarker);
        jotMarker = this.generateGetQueue(jotClassSource, jotMarker);
        jotMarker = this.generateGetQueueSender(jotClassSource, jotMarker);
        jotMarker = this.generateGetQueueReceiver(jotClassSource, jotMarker);
        jotMarker = this.generateSendText(jotClassSource, jotMarker);
        jotMarker = this.generateOnMessage(jotClassSource, jotMarker, false);
        jotMarker = this.generateClose(jotClassSource, jotMarker);
    }

    protected JotMarker generateClose(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "void", "close");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotCodeBlock jotCodeBlock = jotMethodSource.getCodeBlock();
        if (this.a.isP2p()) {
            JotIf jotIf = jotCodeBlock.addIfStatement(null, false, "queueSender != null");
            jotIf.getCodeBlock().addStatement(null, false, "queueSender.close()");
            jotIf = jotCodeBlock.addIfStatement(jotIf, false, "queueReceiver != null");
            jotIf.getCodeBlock().addStatement(null, false, "queueReceiver.close()");
            jotIf = jotCodeBlock.addIfStatement(jotIf, false, "queueSession != null");
            jotIf.getCodeBlock().addStatement(null, false, "queueSession.close()");
            jotIf = jotCodeBlock.addIfStatement(jotIf, false, "queueConnection != null");
            jotIf.getCodeBlock().addStatement(null, false, "queueConnection.close()");
        } else {
            JotIf jotIf = jotCodeBlock.addIfStatement(null, false, "topicPublisher != null");
            jotIf.getCodeBlock().addStatement(null, false, "topicPublisher.close()");
            jotIf = jotCodeBlock.addIfStatement(jotIf, false, "topicSubscriber != null");
            jotIf.getCodeBlock().addStatement(null, false, "topicSubscriber.close()");
            jotIf = jotCodeBlock.addIfStatement(jotIf, false, "topicSession != null");
            jotIf.getCodeBlock().addStatement(null, false, "topicSession.close()");
            jotIf = jotCodeBlock.addIfStatement(jotIf, false, "topicConnection != null");
            jotIf.getCodeBlock().addStatement(null, false, "topicConnection.close()");
        }
        return jotMethodSource;
    }

    protected JotMarker generateOnMessage(JotClassSource jotClassSource, JotMarker jotMarker, boolean bl) {
        JotIf jotIf;
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "void", "onMessage");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addParameter(null, false, "Message", "message");
        JotCodeBlock jotCodeBlock = jotMethodSource.getCodeBlock();
        JotIf jotIf2 = jotIf = jotCodeBlock.addIfStatement(null, false, "message instanceof BytesMessage", true);
        JotStatement jotStatement = jotIf.getCodeBlock().addStatement(null, false, "BytesMessage bytesMessage = (BytesMessage) message");
        jotIf.getCodeBlock().addComment(jotStatement, false, 1, com.borland.jbuilder.wizard.jms.a.a(49));
        jotIf = jotIf.getElse().getCodeBlock().addIfStatement(jotIf, false, "message instanceof MapMessage", true);
        jotStatement = jotIf.getCodeBlock().addStatement(null, false, "MapMessage mapMessage = (MapMessage) message");
        jotIf.getCodeBlock().addComment(jotStatement, false, 1, com.borland.jbuilder.wizard.jms.a.a(50));
        jotIf = jotIf.getElse().getCodeBlock().addIfStatement(jotIf, false, "message instanceof ObjectMessage", true);
        jotStatement = jotIf.getCodeBlock().addStatement(null, false, "ObjectMessage objectMessage = (ObjectMessage) message");
        jotIf.getCodeBlock().addComment(jotStatement, false, 1, com.borland.jbuilder.wizard.jms.a.a(51));
        jotIf = jotIf.getElse().getCodeBlock().addIfStatement(jotIf, false, "message instanceof StreamMessage", true);
        jotStatement = jotIf.getCodeBlock().addStatement(null, false, "StreamMessage streamMessage = (StreamMessage) message");
        jotIf.getCodeBlock().addComment(jotStatement, false, 1, com.borland.jbuilder.wizard.jms.a.a(52));
        jotIf = jotIf.getElse().getCodeBlock().addIfStatement(jotIf, false, "message instanceof TextMessage");
        jotStatement = jotIf.getCodeBlock().addStatement(null, false, "TextMessage textMessage = (TextMessage) message");
        jotIf.getCodeBlock().addComment(jotStatement, false, 1, com.borland.jbuilder.wizard.jms.a.a(53));
        String string = null;
        string = bl ? "getTopicSession(false).commit()" : "getQueueSession().commit()";
        JotTry jotTry = jotCodeBlock.addTryStatement((JotMarker)jotIf2, false, "Exception", "ex");
        jotIf = jotTry.getCodeBlock().addIfStatement(jotIf2, false, "isTransacted()");
        jotIf.getCodeBlock().addStatement(null, false, string);
        jotTry.getCatches()[0].getCodeBlock().addStatement(null, false, "ex.printStackTrace()");
        return jotMethodSource;
    }

    protected JotMarker generateSendText(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "void", "sendText");
        jotMethodSource.addParameter(null, false, "String", "message");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotCodeBlock jotCodeBlock = jotMethodSource.getCodeBlock();
        jotMarker = jotCodeBlock.addStatement(null, false, "TextMessage textMessage = getQueueSession().createTextMessage()");
        jotMarker = jotCodeBlock.addStatement(jotMarker, false, "textMessage.clearBody()");
        jotMarker = jotCodeBlock.addStatement(jotMarker, false, "textMessage.setText(message)");
        jotMarker = jotCodeBlock.addStatement(jotMarker, false, "getQueueSender().send(textMessage)");
        JotIf jotIf = jotCodeBlock.addIfStatement(jotMarker, false, "isTransacted()");
        jotIf.getCodeBlock().addStatement(null, false, "getQueueSession().commit()");
        return jotMethodSource;
    }

    protected JotMarker generatePublishText(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "void", "publishText");
        jotMethodSource.addParameter(null, false, "String", "message");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotCodeBlock jotCodeBlock = jotMethodSource.getCodeBlock();
        jotMarker = jotCodeBlock.addStatement(null, false, "TextMessage textMessage = getTopicSession(false).createTextMessage()");
        jotMarker = jotCodeBlock.addStatement(jotMarker, false, "textMessage.clearBody()");
        jotMarker = jotCodeBlock.addStatement(jotMarker, false, "textMessage.setText(message)");
        jotMarker = jotCodeBlock.addStatement(jotMarker, false, "getTopicPublisher().publish(textMessage)");
        JotIf jotIf = jotCodeBlock.addIfStatement(jotMarker, false, "isTransacted()");
        jotIf.getCodeBlock().addStatement(null, false, "getTopicSession(false).commit()");
        return jotMethodSource;
    }

    protected JotMarker generateGetQueueReceiver(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "QueueReceiver", "getQueueReceiver");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "queueReceiver == null");
        JotStatement jotStatement = jotIf.getCodeBlock().addStatement(null, false, "queueReceiver = getQueueSession().createReceiver(getQueue())");
        jotStatement = jotIf.getCodeBlock().addStatement(jotStatement, false, "queueReceiver.setMessageListener(this)");
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return queueReceiver");
        return jotMethodSource;
    }

    protected JotMarker generateGetTopicSubscriber(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "TopicSubscriber", "getTopicSubscriber");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "topicSubscriber == null");
        JotIf jotIf2 = jotIf.getCodeBlock().addIfStatement(null, false, "isDurable()", true);
        jotIf2.getCodeBlock().addStatement(null, false, "topicSubscriber = getTopicSession(true).createDurableSubscriber(getTopic(), getDurableName())");
        jotIf2.getElse().getCodeBlock().addStatement(null, false, "topicSubscriber = getTopicSession(true).createSubscriber(getTopic())");
        JotStatement jotStatement = jotIf.getCodeBlock().addStatement(jotIf2, false, "topicSubscriber.setMessageListener(this)");
        jotIf.getCodeBlock().addStatement(jotStatement, false, "getTopicConnection(true).start()");
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return topicSubscriber");
        return jotMethodSource;
    }

    protected JotMarker generateGetQueueSender(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "QueueSender", "getQueueSender");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "queueSender == null");
        jotIf.getCodeBlock().addStatement(null, false, "queueSender = getQueueSession().createSender(getQueue())");
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return queueSender");
        return jotMethodSource;
    }

    protected JotMarker generateGetTopicPublisher(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "TopicPublisher", "getTopicPublisher");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "topicPublisher == null");
        jotIf.getCodeBlock().addStatement(null, false, "topicPublisher = getTopicSession(false).createPublisher(getTopic())");
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return topicPublisher");
        return jotMethodSource;
    }

    protected JotMarker generateGetQueue(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "Queue", "getQueue");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "queue == null");
        jotMarker = jotIf.getCodeBlock().addStatement(null, false, "Object obj = getContext().lookup(queueName)");
        jotIf.getCodeBlock().addStatement(jotMarker, false, "queue = (Queue) obj");
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return queue");
        return jotMethodSource;
    }

    protected JotMarker generateGetTopic(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "Topic", "getTopic");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "topic == null");
        jotMarker = jotIf.getCodeBlock().addStatement(null, false, "Object obj = getContext().lookup(topicName)");
        jotIf.getCodeBlock().addStatement(jotMarker, false, "topic = (Topic) obj");
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return topic");
        return jotMethodSource;
    }

    protected JotMarker generateGetQueueSession(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "QueueSession", "getQueueSession");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "queueSession == null");
        String string = "queueSession = getQueueConnection().createQueueSession(transacted, acknowledgementMode)";
        jotIf.getCodeBlock().addStatement(null, false, string);
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return queueSession");
        return jotMethodSource;
    }

    protected JotMarker generateGetTopicSession(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "TopicSession", "getTopicSession");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        jotMethodSource.addParameter(null, false, "boolean", "consumer");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "topicSession == null");
        String string = "topicSession = getTopicConnection(consumer).createTopicSession(isTransacted(), getAcknowledgementMode())";
        jotIf.getCodeBlock().addStatement(null, false, string);
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return topicSession");
        return jotMethodSource;
    }

    protected JotMarker generateGetQueueConnection(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "QueueConnection", "getQueueConnection");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "queueConnection == null");
        jotIf.getCodeBlock().addStatement(null, false, "queueConnection = getQueueConnectionFactory().createQueueConnection()");
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return queueConnection");
        return jotMethodSource;
    }

    protected JotMarker generateGetTopicConnection(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "TopicConnection", "getTopicConnection");
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        jotMethodSource.addParameter(null, false, "boolean", "consumer");
        JotIf jotIf = jotMethodSource.getCodeBlock().addIfStatement(null, false, "topicConnection == null");
        JotStatement jotStatement = jotIf.getCodeBlock().addStatement(null, false, "topicConnection = getTopicConnectionFactory().createTopicConnection()");
        JotIf jotIf2 = jotIf.getCodeBlock().addIfStatement(jotStatement, false, "isDurable() && consumer");
        jotIf2.getCodeBlock().addStatement(null, false, "topicConnection.setClientID(clientId)");
        jotMethodSource.getCodeBlock().addStatement(jotIf, false, "return topicConnection");
        return jotMethodSource;
    }

    protected JotMarker generateGetConnectionFactory(JotClassSource jotClassSource, JotMarker jotMarker, String string, String string2) {
        String string3 = String.valueOf(String.valueOf(string.substring(0, 1).toLowerCase())).concat(String.valueOf(String.valueOf(string.substring(1))));
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, string, "get".concat(String.valueOf(String.valueOf(string))));
        jotMethodSource.setModifiers(1);
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotCodeBlock jotCodeBlock = jotMethodSource.getCodeBlock();
        JotIf jotIf = jotCodeBlock.addIfStatement(null, false, String.valueOf(String.valueOf(string3)).concat(" == null"));
        String string4 = String.valueOf(String.valueOf(new StringBuffer("Object obj = getContext().lookup(").append(string2).append(")")));
        jotMarker = jotIf.getCodeBlock().addStatement(null, false, string4);
        jotIf.getCodeBlock().addStatement(jotMarker, false, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string3))).append(" = (").append(string).append(") obj"))));
        jotCodeBlock.addStatement(jotIf, false, "return ".concat(String.valueOf(String.valueOf(string3))));
        return jotMethodSource;
    }

    protected JotMarker generateGetQueueConnectionFactory(JotClassSource jotClassSource, JotMarker jotMarker) {
        return this.generateGetConnectionFactory(jotClassSource, jotMarker, "QueueConnectionFactory", "queueConnectionFactoryName");
    }

    protected JotMarker generateGetTopicConnectionFactory(JotClassSource jotClassSource, JotMarker jotMarker) {
        return this.generateGetConnectionFactory(jotClassSource, jotMarker, "TopicConnectionFactory", "topicConnectionFactoryName");
    }

    protected JotMarker generateGetContext(JotClassSource jotClassSource, JotMarker jotMarker) {
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, "Context", "getContext");
        jotMethodSource.addThrowSpecifier(null, false, "Exception");
        JotCodeBlock jotCodeBlock = jotMethodSource.getCodeBlock();
        JotIf jotIf = jotCodeBlock.addIfStatement(null, false, "context == null");
        jotCodeBlock.addStatement(jotIf, false, "return context");
        JotTry jotTry = jotIf.getCodeBlock().addTryStatement(null, false, "Exception", "ex");
        jotTry.getCodeBlock().addStatement(null, false, "context = new InitialContext(environment)");
        jotMarker = jotTry.getCatches()[0].getCodeBlock().addStatement(null, false, "ex.printStackTrace()");
        jotTry.getCatches()[0].getCodeBlock().addStatement(jotMarker, false, "throw ex");
        return jotMethodSource;
    }

    protected void generateComments(JotSourceFile jotSourceFile, JotClassSource jotClassSource) {
        String string = JotNames.getShortClassName(this.a.getClassName());
        String string2 = String.valueOf(String.valueOf(string.substring(0, 1).toLowerCase())).concat(String.valueOf(String.valueOf(string.length() > 1 ? string.substring(1) : "")));
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.isP2p()) {
            stringBuffer.append(com.borland.jbuilder.wizard.jms.a.a(28));
        } else {
            stringBuffer.append(com.borland.jbuilder.wizard.jms.a.a(29));
        }
        stringBuffer.append(com.borland.jbuilder.wizard.jms.a.a(30));
        stringBuffer.append("<code>\n");
        String string3 = "{0} {1} = new {0}();\n";
        stringBuffer.append(Strings.format(string3, string, string2));
        string3 = "{0}.setEnvironment(hashtable);  ";
        stringBuffer.append(Strings.format(string3, string2));
        stringBuffer.append(com.borland.jbuilder.wizard.jms.a.a(60));
        string3 = this.a.isP2p() ? "{0}.sendText(\"{1}\");\n" : "{0}.publishText(\"{1}\");\n";
        stringBuffer.append(Strings.format(string3, string2, com.borland.jbuilder.wizard.jms.a.a(31)));
        string3 = "{0}.close(); //{1}\n";
        stringBuffer.append(Strings.format(string3, string2, com.borland.jbuilder.wizard.jms.a.a(32)));
        stringBuffer.append("</code>\n \n");
        stringBuffer.append("<code>\nTo receive a message:\n");
        string3 = "{0} {1} = new {0}();\n";
        stringBuffer.append(Strings.format(string3, string, string2));
        string3 = this.a.isP2p() ? "{0}.getQueueReceiver();\n" : "{0}.getTopicSubscriber();\n";
        stringBuffer.append(Strings.format(string3, string2));
        stringBuffer.append("</code>\n");
        if (this.a.isGenerateHeaders()) {
            stringBuffer.insert(0, String.valueOf(String.valueOf(ProjectUtil.getHeaderComments(this.a.getProject()))).concat("\n \n"));
        }
        jotSourceFile.addComment(jotClassSource, true, 2, stringBuffer.toString());
    }

    protected JotMarker addGetterAndSetter(JotClassSource jotClassSource, String string, String string2, JotMarker jotMarker) {
        String string3 = String.valueOf(String.valueOf(string2.substring(0, 1).toUpperCase())).concat(String.valueOf(String.valueOf(string2.substring(1))));
        String string4 = string.equals("boolean") ? "is" : "get";
        JotMethodSource jotMethodSource = jotClassSource.addMethod(jotMarker, false, string, String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(string3))));
        jotMethodSource.setModifiers(1);
        jotMethodSource.getCodeBlock().addStatement(null, false, "return ".concat(String.valueOf(String.valueOf(string2))));
        jotMethodSource = jotClassSource.addMethod(jotMethodSource, false, "void", "set".concat(String.valueOf(String.valueOf(string3))));
        jotMethodSource.setModifiers(1);
        jotMethodSource.addParameter(null, false, string, string2);
        jotMethodSource.getCodeBlock().addStatement(null, false, String.valueOf(String.valueOf(new StringBuffer("this.").append(string2).append(" = ").append(string2))));
        return jotMethodSource;
    }

    protected void generateFields(JotClassSource jotClassSource) {
        JotFieldDeclaration jotFieldDeclaration = jotClassSource.addField(null, false, "Context", "context");
        jotFieldDeclaration.setModifiers(10);
        jotFieldDeclaration.setInitializer("null");
        jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "boolean", "transacted");
        jotFieldDeclaration.setModifiers(2);
        jotFieldDeclaration.setInitializer(new Boolean(this.a.isTransacted()).toString());
        jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "int", "acknowledgementMode");
        jotFieldDeclaration.setModifiers(2);
        jotFieldDeclaration.setInitializer(this.a.getAcknowledgeModeAsString());
        jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "Hashtable", "environment");
        jotFieldDeclaration.setModifiers(2);
        jotFieldDeclaration.setInitializer("null");
        JotMarker jotMarker = this.addGetterAndSetter(jotClassSource, "boolean", "transacted", null);
        jotMarker = this.addGetterAndSetter(jotClassSource, "int", "acknowledgementMode", jotMarker);
        jotMarker = this.addGetterAndSetter(jotClassSource, "Hashtable", "environment", jotMarker);
        if (this.a.isP2p()) {
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "QueueConnectionFactory", "queueConnectionFactory");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "QueueConnection", "queueConnection");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "QueueSession", "queueSession");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "QueueSender", "queueSender");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "QueueReceiver", "queueReceiver");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "Queue", "queue");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "String", "queueConnectionFactoryName");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer(String.valueOf(String.valueOf(new StringBuffer("\"").append(this.a.getJndiName()).append("\""))));
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "String", "queueName");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer(String.valueOf(String.valueOf(new StringBuffer("\"").append(this.a.getTopicOrQueueName()).append("\""))));
            jotMarker = this.addGetterAndSetter(jotClassSource, "String", "queueConnectionFactoryName", jotMarker);
            jotMarker = this.addGetterAndSetter(jotClassSource, "String", "queueName", jotMarker);
        } else {
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "TopicConnectionFactory", "topicConnectionFactory");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "TopicConnection", "topicConnection");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "TopicSession", "topicSession");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "TopicPublisher", "topicPublisher");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "TopicSubscriber", "topicSubscriber");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "Topic", "topic");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer("null");
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "String", "topicConnectionFactoryName");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer(String.valueOf(String.valueOf(new StringBuffer("\"").append(this.a.getJndiName()).append("\""))));
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "String", "topicName");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer(String.valueOf(String.valueOf(new StringBuffer("\"").append(this.a.getTopicOrQueueName()).append("\""))));
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "String", "clientId");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer(String.valueOf(String.valueOf(new StringBuffer("\"").append(this.a.getClientId()).append("\""))));
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "String", "durableName");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer(String.valueOf(String.valueOf(new StringBuffer("\"").append(this.a.getDurableName()).append("\""))));
            jotFieldDeclaration = jotClassSource.addField(jotFieldDeclaration, false, "boolean", "durable");
            jotFieldDeclaration.setModifiers(2);
            jotFieldDeclaration.setInitializer(this.a.isDurable() ? "true" : "false");
            jotMarker = this.addGetterAndSetter(jotClassSource, "String", "topicConnectionFactoryName", jotMarker);
            jotMarker = this.addGetterAndSetter(jotClassSource, "String", "topicName", jotMarker);
            jotMarker = this.addGetterAndSetter(jotClassSource, "String", "clientId", jotMarker);
            jotMarker = this.addGetterAndSetter(jotClassSource, "String", "durableName", jotMarker);
            jotMarker = this.addGetterAndSetter(jotClassSource, "boolean", "durable", jotMarker);
        }
    }

    public FileNode generate() throws VetoException {
        try {
            String string = this.a.getPackageName();
            String string2 = this.a.getClassName();
            FileNode fileNode = BasicClassWizard.createNode(this.a.getProject(), string, String.valueOf(String.valueOf(string2)).concat(".java"));
            Buffer buffer = fileNode.getBuffer();
            JotPackages jotPackages = this.a.getProject().getJotPackages();
            JotSourceFile jotSourceFile = jotPackages.getSourceFile(fileNode.getUrl());
            if (string.length() > 0) {
                jotSourceFile.setPackage(string);
            }
            jotSourceFile.addImport("javax.jms.*");
            jotSourceFile.addImport("javax.naming.*");
            jotSourceFile.addImport("java.util.Hashtable");
            JotClassSource jotClassSource = jotSourceFile.addClass(null, false, string2, false);
            if (!this.a.getSuperClass().equals("java.lang.Object")) {
                jotClassSource.setSuperclass(this.a.getSuperClass());
            }
            jotClassSource.setModifiers(1);
            jotClassSource.addInterface(null, false, "MessageListener");
            this.generateFields(jotClassSource);
            this.generateGetContext(jotClassSource, null);
            if (this.a.isP2p()) {
                this.generateP2p(jotSourceFile, jotClassSource);
            } else {
                this.generatePubSub(jotSourceFile, jotClassSource);
            }
            this.generateComments(jotSourceFile, jotClassSource);
            jotPackages.commit(jotSourceFile);
            jotPackages.release(jotSourceFile);
            this.a.getProject().getPaths().putClassOnFullPath("javax.naming.InitialContext");
            this.a.getProject().getPaths().putClassOnFullPath("javax.jms.Connection");
            FileNode fileNode2 = fileNode;
            return fileNode2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.a.getComponent(), exception, com.borland.jbuilder.wizard.jms.a.a(1), 1);
            throw new VetoException();
        }
    }

    public void setJmsWizardState(JmsWizardState jmsWizardState) {
        this.a = jmsWizardState;
    }

    public JmsWizardState getJmsWizardState() {
        return this.a;
    }
}

