/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.BriefAction;
import com.borland.primetime.editor.BriefActionNames;
import com.borland.primetime.editor.BriefKeymap;
import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorActions;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.a;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserFile;
import com.borland.primetime.ide.BrowserWindow;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class BriefActions
extends EditorActions
implements BriefActionNames {
    public static final Action[] customActions;
    public static EditorAction ACTION_BriefEscape;
    public static EditorAction ACTION_BriefPreviousWord;
    public static EditorAction ACTION_BriefNextWord;
    public static EditorAction ACTION_BriefExitIDE;
    public static EditorAction ACTION_BriefInsertLine;
    public static EditorAction ACTION_BriefUndo;
    public static EditorAction ACTION_BriefPaste;
    public static EditorAction ACTION_BriefDelete;
    public static EditorAction ACTION_BriefSelectionEnd;
    public static EditorAction ACTION_BriefEnd;
    public static EditorAction ACTION_BriefSelectionHome;
    public static EditorAction ACTION_BriefHome;
    public static EditorAction ACTION_BriefSelectChar;
    public static EditorAction ACTION_BriefCut;
    public static EditorAction ACTION_BriefCopy;
    public static EditorAction ACTION_BriefCheckIgnore;

    static {
        ACTION_BriefCheckIgnore = new BriefCheckIgnoreAction("brief-check-ignore");
        ACTION_BriefCopy = new BriefCopyAction("brief-copy");
        ACTION_BriefCut = new BriefCutAction("brief-cut");
        ACTION_BriefSelectChar = new BriefSelectCharAction("brief-select-char");
        ACTION_BriefHome = new BriefHomeAction("brief-home", false);
        ACTION_BriefSelectionHome = new BriefHomeAction("brief-selection-home", true);
        ACTION_BriefEnd = new BriefEndAction("brief-end", false);
        ACTION_BriefSelectionEnd = new BriefEndAction("brief-selection-end", true);
        ACTION_BriefDelete = new BriefDeleteAction("brief-delete");
        ACTION_BriefPaste = new BriefPasteAction("brief-paste");
        ACTION_BriefUndo = new BriefUndoAction("brief-undo");
        ACTION_BriefInsertLine = new BriefInsertLineAction("brief-insert-line");
        ACTION_BriefExitIDE = new BriefExitIDEAction("brief-exit-ide");
        ACTION_BriefNextWord = new BriefNextWordAction("brief-next-word");
        ACTION_BriefPreviousWord = new BriefPreviousWordAction("brief-previous-word");
        ACTION_BriefEscape = new BriefEscapeAction("brief-escape");
        customActions = new Action[]{ACTION_BriefCheckIgnore, ACTION_BriefCopy, ACTION_BriefCut, ACTION_BriefSelectChar, ACTION_BriefHome, ACTION_BriefSelectionHome, ACTION_BriefEnd, ACTION_BriefSelectionEnd, ACTION_BriefDelete, ACTION_BriefPaste, ACTION_BriefUndo, ACTION_BriefInsertLine, ACTION_BriefExitIDE, ACTION_BriefNextWord, ACTION_BriefPreviousWord, ACTION_BriefEscape};
    }

    public static Action[] getActions() {
        return TextAction.augmentList(EditorActions.getActions(), customActions);
    }

    public static class BriefEscapeAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                this.getStateInfo(editorPane).setMode(0);
                int n2 = editorPane.getCaretPosition();
                if (n2 >= 0) {
                    editorPane.setCaretPosition(n2);
                }
            }
        }

        public BriefEscapeAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(41));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefPreviousWordAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                int n2 = this.getStateInfo(editorPane).getMode();
                if (n2 == 1) {
                    this.getStateInfo(editorPane).setMode(0);
                }
                Caret caret = editorPane.getCaret();
                int n3 = caret.getMark();
                int n4 = caret.getDot();
                if (this.getStateInfo(editorPane).getMode() == 0) {
                    EditorActions.ACTION_PreviousWord.actionPerformed(actionEvent);
                } else {
                    EditorActions.ACTION_SelectionPreviousWord.actionPerformed(actionEvent);
                }
                if (n2 == 2 || n2 == 8) {
                    caret = editorPane.getCaret();
                    int n5 = caret.getDot();
                    if (n3 < n4 && n5 <= n3) {
                        editorPane.setCaretPosition(n3 + 1);
                        editorPane.moveCaretPosition(n5);
                    }
                }
            }
        }

        public BriefPreviousWordAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(47));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefNextWordAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                int n2 = this.getStateInfo(editorPane).getMode();
                if (n2 == 1) {
                    this.getStateInfo(editorPane).setMode(0);
                }
                Caret caret = editorPane.getCaret();
                int n3 = caret.getMark();
                int n4 = caret.getDot();
                if (this.getStateInfo(editorPane).getMode() == 0) {
                    EditorActions.ACTION_NextWord.actionPerformed(actionEvent);
                } else {
                    EditorActions.ACTION_SelectionNextWord.actionPerformed(actionEvent);
                }
                if (n2 == 2 || n2 == 8) {
                    caret = editorPane.getCaret();
                    int n5 = caret.getDot();
                    if (n3 > n4 && n5 >= n3) {
                        editorPane.setCaretPosition(n3 - 1);
                        editorPane.moveCaretPosition(n5);
                    }
                }
            }
        }

        public BriefNextWordAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(45));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefExitIDEAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Browser browser = Browser.getActiveBrowser();
            BrowserFile.ACTION_NodeSaveAll.actionPerformed(browser);
            BrowserWindow.ACTION_BrowserExit.actionPerformed(browser);
        }

        public BriefExitIDEAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(42));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefInsertLineAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane != null) {
                    if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                        return;
                    }
                    editorPane.startUndoGroup();
                    int n2 = editorPane.getCaretPosition();
                    editorPane.setCaretPosition(Utilities.getRowEnd(editorPane, n2));
                    EditorActions.ACTION_SmartIndent.actionPerformed(actionEvent);
                    editorPane.endUndoGroup();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public BriefInsertLineAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(44));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefUndoAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                this.getStateInfo(editorPane).setIgnoringKey(true);
                EditorActions.ACTION_Undo.actionPerformed(actionEvent);
            }
        }

        public BriefUndoAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(52));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefPasteAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane != null) {
                    if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                        return;
                    }
                    int n2 = editorPane.getCaretPosition();
                    editorPane.startUndoGroup();
                    BriefKeymap briefKeymap = (BriefKeymap)EditorManager.getKeymap();
                    if (briefKeymap.getCopyMode() == 1) {
                        Document document = editorPane.getDocument();
                        Element element = document.getDefaultRootElement();
                        int n3 = element.getElementCount();
                        editorPane.setCaretPosition(Utilities.getRowStart(editorPane, n2));
                        EditorActions.ACTION_OpenLine.actionPerformed(actionEvent);
                        EditorActions.ACTION_Paste.actionPerformed(actionEvent);
                        editorPane.setCaretPosition(n2);
                        for (n3 = element.getElementCount() - n3; n3 > 0; --n3) {
                            EditorActions.ACTION_Down.actionPerformed(actionEvent);
                        }
                    } else {
                        EditorActions.ACTION_Paste.actionPerformed(actionEvent);
                        if (briefKeymap.getCopyMode() == 2) {
                            editorPane.setCaretPosition(n2);
                            EditorActions.ACTION_Down.actionPerformed(actionEvent);
                        }
                    }
                    editorPane.endUndoGroup();
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        public BriefPasteAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(46));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefDeleteAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                EditorActions.ACTION_DeleteNextChar.actionPerformed(actionEvent);
                int n2 = this.getStateInfo(editorPane).getMode();
                if (n2 == 1) {
                    EditorActions.ACTION_DeleteNextChar.actionPerformed(actionEvent);
                }
                this.getStateInfo(editorPane).setMode(0);
            }
        }

        public BriefDeleteAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(39));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefEndAction
    extends BriefAction {
        boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane != null) {
                    Object object;
                    boolean bl = false;
                    Action action = editorPane.getLastAction();
                    if (action != null && (object = action.getValue("Name")) != null && (object.equals(ACTION_BriefEnd.getValue("Name")) || object.equals(ACTION_BriefSelectionEnd.getValue("Name")) || object.equals(EditorActions.ACTION_EndLine.getValue("Name")) || object.equals(EditorActions.ACTION_SelectionEndLine.getValue("Name")))) {
                        bl = true;
                    }
                    int n2 = editorPane.getCaretPosition();
                    if (!bl || Utilities.getRowEnd(editorPane, n2) != n2) {
                        if (this.a) {
                            EditorActions.ACTION_SelectionEndLine.actionPerformed(actionEvent);
                        } else {
                            EditorActions.ACTION_EndLine.actionPerformed(actionEvent);
                        }
                        return;
                    }
                    if (this.a) {
                        EditorActions.ACTION_SelectionBottomOfScreen.actionPerformed(actionEvent);
                    } else {
                        EditorActions.ACTION_BottomOfScreen.actionPerformed(actionEvent);
                    }
                    if (n2 == editorPane.getCaretPosition()) {
                        if (this.a) {
                            EditorActions.ACTION_SelectionEnd.actionPerformed(actionEvent);
                        } else {
                            EditorActions.ACTION_End.actionPerformed(actionEvent);
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public BriefEndAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(49));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(40));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(51));
        }
    }

    public static class BriefHomeAction
    extends BriefAction {
        boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane != null) {
                    Object object;
                    boolean bl = false;
                    Action action = editorPane.getLastAction();
                    if (action != null && (object = action.getValue("Name")) != null && (object.equals(ACTION_BriefHome.getValue("Name")) || object.equals(ACTION_BriefSelectionHome.getValue("Name")) || object.equals(EditorActions.ACTION_BeginLine.getValue("Name")) || object.equals(EditorActions.ACTION_SelectionBeginLine.getValue("Name")))) {
                        bl = true;
                    }
                    int n2 = editorPane.getCaretPosition();
                    if (!bl || Utilities.getRowStart(editorPane, n2) != n2) {
                        if (this.a) {
                            EditorActions.ACTION_SelectionBeginLine.actionPerformed(actionEvent);
                        } else {
                            EditorActions.ACTION_BeginLine.actionPerformed(actionEvent);
                        }
                        return;
                    }
                    Rectangle rectangle = new Rectangle();
                    editorPane.computeVisibleRect(rectangle);
                    if (editorPane.viewToModel(new Point(rectangle.x, rectangle.y)) != n2) {
                        if (this.a) {
                            EditorActions.ACTION_SelectionTopOfScreen.actionPerformed(actionEvent);
                        } else {
                            EditorActions.ACTION_TopOfScreen.actionPerformed(actionEvent);
                        }
                        return;
                    }
                    if (this.a) {
                        EditorActions.ACTION_SelectionBegin.actionPerformed(actionEvent);
                    } else {
                        EditorActions.ACTION_Begin.actionPerformed(actionEvent);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public BriefHomeAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(50));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(43));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(51));
        }
    }

    public static class BriefSelectCharAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            block7: {
                EditorPane editorPane;
                block8: {
                    editorPane = this.getEditorTarget(actionEvent);
                    if (editorPane == null) break block7;
                    int n2 = this.getStateInfo(editorPane).getMode();
                    if (n2 == 1) {
                        this.getStateInfo(editorPane).setMode(0);
                    }
                    if (n2 != 0) break block8;
                    String string = actionEvent.getActionCommand();
                    if (string == null) break block7;
                    char c2 = string.charAt(0);
                    if (c2 == 'm' || c2 == 'c') {
                        EditorActions.ACTION_SelectionForward.actionPerformed(actionEvent);
                    }
                    switch (c2) {
                        case 'c': {
                            this.getStateInfo(editorPane).setMode(2);
                            break;
                        }
                        case 'm': {
                            this.getStateInfo(editorPane).setMode(8);
                            break;
                        }
                        case 'a': {
                            this.getStateInfo(editorPane).setMode(4);
                            break;
                        }
                        default: {
                            this.getStateInfo(editorPane).setMode(0);
                            break;
                        }
                    }
                    break block7;
                }
                this.getStateInfo(editorPane).setMode(0);
                editorPane.setCaretPosition(editorPane.getCaretPosition());
            }
        }

        public BriefSelectCharAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(48));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefCutAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane != null) {
                    Object object;
                    if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                        return;
                    }
                    String string = actionEvent.getActionCommand();
                    if (string != null && string.charAt(0) == '-') {
                        this.getStateInfo(editorPane).setIgnoringKey(true);
                    }
                    Action action = editorPane.getLastAction();
                    boolean bl = false;
                    if (action != null && (object = action.getValue("Name")) != null && (object.equals(EditorActions.ACTION_SearchDialog.getValue("Name")) || object.equals(EditorActions.ACTION_SearchAgain.getValue("Name")))) {
                        bl = true;
                    }
                    editorPane.startUndoGroup();
                    object = editorPane.getCaret();
                    int n2 = object.getDot();
                    int n3 = object.getMark();
                    BriefKeymap briefKeymap = (BriefKeymap)EditorManager.getKeymap();
                    if (n2 != n3 && !bl) {
                        editorPane.cut();
                        int n4 = this.getStateInfo(editorPane).getMode();
                        briefKeymap.setCopyMode(n4);
                        if (n4 == 1) {
                            EditorActions.ACTION_DeleteNextChar.actionPerformed(actionEvent);
                        }
                    } else {
                        int n5 = editorPane.getCaretPosition();
                        int n6 = Utilities.getRowStart(editorPane, n5);
                        int n7 = Utilities.getRowEnd(editorPane, n5);
                        editorPane.setCaretPosition(n6);
                        editorPane.moveCaretPosition(n7);
                        editorPane.cut();
                        EditorActions.ACTION_DeleteNextChar.actionPerformed(actionEvent);
                        briefKeymap.setCopyMode(1);
                    }
                    this.getStateInfo(editorPane).setMode(0);
                    editorPane.endUndoGroup();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public BriefCutAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(38));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefCopyAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane != null) {
                    Object object;
                    String string = actionEvent.getActionCommand();
                    if (string != null && string.charAt(0) == '+') {
                        this.getStateInfo(editorPane).setIgnoringKey(true);
                    }
                    Action action = editorPane.getLastAction();
                    boolean bl = false;
                    if (action != null && (object = action.getValue("Name")) != null && (object.equals(EditorActions.ACTION_SearchDialog.getValue("Name")) || object.equals(EditorActions.ACTION_SearchAgain.getValue("Name")))) {
                        bl = true;
                    }
                    editorPane.startUndoGroup();
                    object = editorPane.getCaret();
                    int n2 = object.getDot();
                    int n3 = object.getMark();
                    BriefKeymap briefKeymap = (BriefKeymap)EditorManager.getKeymap();
                    if (n2 != n3 && !bl) {
                        editorPane.copy();
                        int n4 = editorPane.getCaretPosition();
                        editorPane.setCaretPosition(n4);
                        briefKeymap.setCopyMode(this.getStateInfo(editorPane).getMode());
                    } else {
                        int n5 = editorPane.getCaretPosition();
                        int n6 = Utilities.getRowStart(editorPane, n5);
                        int n7 = Utilities.getRowEnd(editorPane, n5);
                        editorPane.setCaretPosition(n6);
                        editorPane.moveCaretPosition(n7);
                        editorPane.copy();
                        editorPane.setCaretPosition(n5);
                        briefKeymap.setCopyMode(1);
                    }
                    this.getStateInfo(editorPane).setMode(0);
                    editorPane.endUndoGroup();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public BriefCopyAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(37));
            this.putValue("ActionGroup", a.a(51));
        }
    }

    public static class BriefCheckIgnoreAction
    extends BriefAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                if (!this.getStateInfo(editorPane).ignoringKey()) {
                    Keymap keymap = EditorManager.getKeymap();
                    keymap.getDefaultAction().actionPerformed(actionEvent);
                } else {
                    this.getStateInfo(editorPane).setIgnoringKey(false);
                }
            }
        }

        public BriefCheckIgnoreAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(36));
            this.putValue("ActionGroup", a.a(51));
        }
    }
}

