/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.java.SourceInfo;
import com.borland.jbuilder.template.engine.TemplateEngine;
import com.borland.primetime.editor.BookmarkManager;
import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorActionNames;
import com.borland.primetime.editor.EditorDocument;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.GotoBookmarkDialog;
import com.borland.primetime.editor.GotoLineDialog;
import com.borland.primetime.editor.ModalKeymap;
import com.borland.primetime.editor.SearchDialog;
import com.borland.primetime.editor.SearchManager;
import com.borland.primetime.editor.SearchOptions;
import com.borland.primetime.editor.TextUtilities;
import com.borland.primetime.editor.a;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.Project;
import com.borland.primetime.util.Platform;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;

public class EditorActions
implements EditorActionNames {
    static ArrayList b;
    static ArrayList c;
    public static final Action[] customActions;
    public static EditorAction ACTION_ClosingCurlyBrace;
    public static EditorAction ACTION_TransposeChars;
    public static EditorAction ACTION_TransposeWords;
    public static EditorAction ACTION_TransposeLines;
    public static EditorAction ACTION_DefaultKeyTyped;
    public static EditorAction ACTION_PreviousTabStop;
    public static EditorAction ACTION_PreviousIndent;
    public static EditorAction ACTION_CommentLine;
    public static EditorAction ACTION_StripTrailingSpace;
    public static EditorAction ACTION_UnTabKey;
    public static EditorAction ACTION_TabKey;
    public static EditorAction ACTION_InsertTab;
    public static EditorAction ACTION_Recenter;
    public static EditorAction ACTION_ReverseIncrementalSearch;
    public static EditorAction ACTION_IncrementalSearch;
    public static EditorAction ACTION_ReplaceDialog;
    public static EditorAction ACTION_SearchSelectedBackward;
    public static EditorAction ACTION_SearchSelectedForward;
    public static EditorAction ACTION_SearchAgainBackward;
    public static EditorAction ACTION_SearchAgainForward;
    public static EditorAction ACTION_SearchAgainInReverse;
    public static EditorAction ACTION_SearchAgain;
    public static EditorAction ACTION_SearchDialog;
    public static EditorAction ACTION_Paste;
    public static EditorAction ACTION_Copy;
    public static EditorAction ACTION_Cut;
    public static EditorAction ACTION_OpenLine;
    public static EditorAction ACTION_LowerCaseWord;
    public static EditorAction ACTION_UpperCaseWord;
    public static EditorAction ACTION_ToggleCase;
    public static EditorAction ACTION_LowerCase;
    public static EditorAction ACTION_UpperCase;
    public static EditorAction ACTION_Redo;
    public static EditorAction ACTION_Undo;
    public static EditorAction ACTION_SmartBackspace;
    public static EditorAction ACTION_SmartIndent;
    public static EditorAction ACTION_OutdentBlock;
    public static EditorAction ACTION_IndentBlock;
    public static EditorAction ACTION_DeleteBeginWord;
    public static EditorAction ACTION_DeleteWord;
    public static EditorAction ACTION_DeleteEndLine;
    public static EditorAction ACTION_DeleteBeginLine;
    public static EditorAction ACTION_DeleteLine;
    public static EditorAction ACTION_DeleteSelection;
    public static EditorAction ACTION_DeleteNextChar;
    public static EditorAction ACTION_DeletePrevChar;
    public static EditorAction ACTION_ToggleInsertMode;
    public static EditorAction ACTION_SelectAll;
    public static EditorAction ACTION_SelectMultiLine;
    public static EditorAction ACTION_SelectLine;
    public static EditorAction ACTION_SelectWord;
    public static EditorAction ACTION_SelectionMatchBrace;
    public static EditorAction ACTION_SelectionEnd;
    public static EditorAction ACTION_SelectionBegin;
    public static EditorAction ACTION_SelectionPageDown;
    public static EditorAction ACTION_SelectionPageUp;
    public static EditorAction ACTION_SelectionBottomOfScreen;
    public static EditorAction ACTION_SelectionTopOfScreen;
    public static EditorAction ACTION_SelectionEndLine;
    public static EditorAction ACTION_SelectionBeginLine;
    public static EditorAction ACTION_SelectionNextWord;
    public static EditorAction ACTION_SelectionPreviousWord;
    public static EditorAction ACTION_SelectionEndWord;
    public static EditorAction ACTION_SelectionBeginWord;
    public static EditorAction ACTION_SelectionDown;
    public static EditorAction ACTION_SelectionUp;
    public static EditorAction ACTION_SelectionBackward;
    public static EditorAction ACTION_SelectionForward;
    public static EditorAction ACTION_GotoBookmarkDialog;
    public static EditorAction ACTION_ClearBookmarks;
    public static EditorAction ACTION_PreviousBookmark;
    public static EditorAction ACTION_NextBookmark;
    public static EditorAction ACTION_GotoBookmark9;
    public static EditorAction ACTION_GotoBookmark8;
    public static EditorAction ACTION_GotoBookmark7;
    public static EditorAction ACTION_GotoBookmark6;
    public static EditorAction ACTION_GotoBookmark5;
    public static EditorAction ACTION_GotoBookmark4;
    public static EditorAction ACTION_GotoBookmark3;
    public static EditorAction ACTION_GotoBookmark2;
    public static EditorAction ACTION_GotoBookmark1;
    public static EditorAction ACTION_GotoBookmark0;
    public static EditorAction ACTION_SetBookmark9;
    public static EditorAction ACTION_SetBookmark8;
    public static EditorAction ACTION_SetBookmark7;
    public static EditorAction ACTION_SetBookmark6;
    public static EditorAction ACTION_SetBookmark5;
    public static EditorAction ACTION_SetBookmark4;
    public static EditorAction ACTION_SetBookmark3;
    public static EditorAction ACTION_SetBookmark2;
    public static EditorAction ACTION_SetBookmark1;
    public static EditorAction ACTION_SetBookmark0;
    public static EditorAction ACTION_ToggleBookmark;
    public static EditorAction ACTION_MatchBrace;
    public static EditorAction ACTION_GotoLineDialog;
    public static EditorAction ACTION_ScrollDown;
    public static EditorAction ACTION_ScrollUp;
    public static EditorAction ACTION_End;
    public static EditorAction ACTION_Begin;
    public static EditorAction ACTION_PageRight;
    public static EditorAction ACTION_PageLeft;
    public static EditorAction ACTION_PageDown;
    public static EditorAction ACTION_PageUp;
    public static EditorAction ACTION_BottomOfScreen;
    public static EditorAction ACTION_TopOfScreen;
    public static EditorAction ACTION_EndLine;
    public static EditorAction ACTION_BeginLine;
    public static EditorAction ACTION_PreviousWord;
    public static EditorAction ACTION_NextWord;
    public static EditorAction ACTION_EndWord;
    public static EditorAction ACTION_BeginWord;
    public static EditorAction ACTION_Down;
    public static EditorAction ACTION_Up;
    public static EditorAction ACTION_Backward;
    public static EditorAction ACTION_Forward;

    static {
        ACTION_Forward = new ForwardAction("caret-forward", false);
        ACTION_Backward = new BackwardAction("caret-backward", false);
        ACTION_Up = new UpAction("caret-up", false);
        ACTION_Down = new DownAction("caret-down", false);
        ACTION_BeginWord = new BeginWordAction("begin-word", false);
        ACTION_EndWord = new EndWordAction("end-word", false);
        ACTION_NextWord = new NextWordAction("next-word", false);
        ACTION_PreviousWord = new PreviousWordAction("previous-word", false);
        ACTION_BeginLine = new BeginLineAction("begin-line", false);
        ACTION_EndLine = new EndLineAction("end-line", false);
        ACTION_TopOfScreen = new TopOfScreenAction("top-of-screen", false);
        ACTION_BottomOfScreen = new BottomOfScreenAction("bottom-of-screen", false);
        ACTION_PageUp = new PageUpAction("page-up", false);
        ACTION_PageDown = new PageDownAction("page-down", false);
        ACTION_PageLeft = new PageLeftAction("page-left");
        ACTION_PageRight = new PageRightAction("page-right");
        ACTION_Begin = new BeginAction("begin-file", false);
        ACTION_End = new EndAction("end-file", false);
        ACTION_ScrollUp = new ScrollUpAction("scroll-up");
        ACTION_ScrollDown = new ScrollDownAction("scroll-down");
        ACTION_GotoLineDialog = new GotoLineDialogAction();
        ACTION_MatchBrace = new MatchBraceAction("match-brace", false);
        ACTION_ToggleBookmark = new ToggleBookmarkAction("toggle-bookmark");
        ACTION_SetBookmark0 = new SetBookmarkAction("set-bookmark-0", 0);
        ACTION_SetBookmark1 = new SetBookmarkAction("set-bookmark-1", 1);
        ACTION_SetBookmark2 = new SetBookmarkAction("set-bookmark-2", 2);
        ACTION_SetBookmark3 = new SetBookmarkAction("set-bookmark-3", 3);
        ACTION_SetBookmark4 = new SetBookmarkAction("set-bookmark-4", 4);
        ACTION_SetBookmark5 = new SetBookmarkAction("set-bookmark-5", 5);
        ACTION_SetBookmark6 = new SetBookmarkAction("set-bookmark-6", 6);
        ACTION_SetBookmark7 = new SetBookmarkAction("set-bookmark-7", 7);
        ACTION_SetBookmark8 = new SetBookmarkAction("set-bookmark-8", 8);
        ACTION_SetBookmark9 = new SetBookmarkAction("set-bookmark-9", 9);
        ACTION_GotoBookmark0 = new GotoBookmarkAction("goto-bookmark-0", 0);
        ACTION_GotoBookmark1 = new GotoBookmarkAction("goto-bookmark-1", 1);
        ACTION_GotoBookmark2 = new GotoBookmarkAction("goto-bookmark-2", 2);
        ACTION_GotoBookmark3 = new GotoBookmarkAction("goto-bookmark-3", 3);
        ACTION_GotoBookmark4 = new GotoBookmarkAction("goto-bookmark-4", 4);
        ACTION_GotoBookmark5 = new GotoBookmarkAction("goto-bookmark-5", 5);
        ACTION_GotoBookmark6 = new GotoBookmarkAction("goto-bookmark-6", 6);
        ACTION_GotoBookmark7 = new GotoBookmarkAction("goto-bookmark-7", 7);
        ACTION_GotoBookmark8 = new GotoBookmarkAction("goto-bookmark-8", 8);
        ACTION_GotoBookmark9 = new GotoBookmarkAction("goto-bookmark-9", 9);
        ACTION_NextBookmark = new NextBookmarkAction("next-bookmark");
        ACTION_PreviousBookmark = new PreviousBookmarkAction("previous-bookmark");
        ACTION_ClearBookmarks = new ClearBookmarksAction("clear-bookmarks");
        ACTION_GotoBookmarkDialog = new GotoBookmarkDialogAction("goto-bookmark-dialog");
        ACTION_SelectionForward = new ForwardAction("selection-forward", true);
        ACTION_SelectionBackward = new BackwardAction("selection-backward", true);
        ACTION_SelectionUp = new UpAction("selection-up", true);
        ACTION_SelectionDown = new DownAction("selection-down", true);
        ACTION_SelectionBeginWord = new BeginWordAction("selection-begin-word", true);
        ACTION_SelectionEndWord = new EndWordAction("selection-end-word", true);
        ACTION_SelectionPreviousWord = new PreviousWordAction("selection-previous-word", true);
        ACTION_SelectionNextWord = new NextWordAction("selection-next-word", true);
        ACTION_SelectionBeginLine = new BeginLineAction("selection-begin-line", true);
        ACTION_SelectionEndLine = new EndLineAction("selection-end-line", true);
        ACTION_SelectionTopOfScreen = new TopOfScreenAction("selection-top-of-screen", true);
        ACTION_SelectionBottomOfScreen = new BottomOfScreenAction("selection-bottom-of-screen", true);
        ACTION_SelectionPageUp = new PageUpAction("selection-page-up", true);
        ACTION_SelectionPageDown = new PageDownAction("selection-page-down", true);
        ACTION_SelectionBegin = new BeginAction("selection-begin-file", true);
        ACTION_SelectionEnd = new EndAction("selection-end-file", true);
        ACTION_SelectionMatchBrace = new MatchBraceAction("selection-match-brace", true);
        ACTION_SelectWord = new SelectWordAction();
        ACTION_SelectLine = new SelectLineAction("select-line", false);
        ACTION_SelectMultiLine = new SelectLineAction("select-multi-line", true);
        ACTION_SelectAll = new SelectAllAction();
        ACTION_ToggleInsertMode = new ToggleInsertModeAction("toggle-insert-mode");
        ACTION_DeletePrevChar = new DeletePrevCharAction("delete-previous");
        ACTION_DeleteNextChar = new DeleteNextCharAction("delete-next");
        ACTION_DeleteSelection = new DeleteSelectionAction("delete-selection");
        ACTION_DeleteLine = new DeleteLineAction("delete-line");
        ACTION_DeleteBeginLine = new DeleteBeginLineAction("delete-begin-line");
        ACTION_DeleteEndLine = new DeleteEndLineAction("delete-end-line");
        ACTION_DeleteWord = new DeleteWordAction("delete-word");
        ACTION_DeleteBeginWord = new DeleteBeginWordAction("delete-begin-word");
        ACTION_IndentBlock = new IndentBlockAction("indent-block");
        ACTION_OutdentBlock = new OutdentBlockAction("outdent-block");
        ACTION_SmartIndent = new SmartIndentAction("smart-indent");
        ACTION_SmartBackspace = new SmartBackspaceAction("smart-backspace");
        ACTION_Undo = new UndoAction("undo");
        ACTION_Redo = new RedoAction("redo");
        ACTION_UpperCase = new UpperCaseAction("upper-case");
        ACTION_LowerCase = new LowerCaseAction("lower-case");
        ACTION_ToggleCase = new ToggleCaseAction("toggle-case");
        ACTION_UpperCaseWord = new ChangeWordCaseAction("upper-case-word", true);
        ACTION_LowerCaseWord = new ChangeWordCaseAction("lower-case-word", false);
        ACTION_OpenLine = new OpenLineAction("open-line");
        ACTION_Cut = new CutAction();
        ACTION_Copy = new CopyAction();
        ACTION_Paste = new PasteAction();
        ACTION_SearchDialog = new SearchDialogAction();
        ACTION_SearchAgain = new SearchAgainAction("search-again", 0);
        ACTION_SearchAgainInReverse = new SearchAgainAction("search-again-in-reverse", 1);
        ACTION_SearchAgainForward = new SearchAgainAction("search-again-forward", 2);
        ACTION_SearchAgainBackward = new SearchAgainAction("search-again-backward", 3);
        ACTION_SearchSelectedForward = new SearchSelectedAction("search-selected-forward", true);
        ACTION_SearchSelectedBackward = new SearchSelectedAction("search-selected-backward", false);
        ACTION_ReplaceDialog = new ReplaceDialogAction();
        ACTION_IncrementalSearch = new IncrementalSearchAction("incremental-search", true);
        ACTION_ReverseIncrementalSearch = new IncrementalSearchAction("reverse-incremental-search", false);
        ACTION_Recenter = new RecenterAction("recenter");
        ACTION_InsertTab = new InsertTabAction("insert-tab");
        ACTION_TabKey = new TabKeyAction("tab-key");
        ACTION_UnTabKey = new UnTabKeyAction("untab-key");
        ACTION_StripTrailingSpace = new StripTrailingSpaceAction("strip-trailing-spaces");
        ACTION_CommentLine = new CommentLineAction("comment-line");
        ACTION_PreviousIndent = new PreviousIndentAction("previous-indent", true);
        ACTION_PreviousTabStop = new PreviousIndentAction("previous-tab-stop", true);
        ACTION_DefaultKeyTyped = new DefaultKeyTypedAction();
        ACTION_TransposeLines = new TransposeLinesAction("transpose-lines");
        ACTION_TransposeWords = new TransposeWordsAction("transpose-words");
        ACTION_TransposeChars = new TransposeCharsAction("transpose-chars");
        ACTION_ClosingCurlyBrace = new ClosingCurlyBraceAction("closing-curly-brace");
        customActions = new Action[]{ACTION_Forward, ACTION_Backward, ACTION_Up, ACTION_Down, ACTION_BeginWord, ACTION_EndWord, ACTION_NextWord, ACTION_PreviousWord, ACTION_BeginLine, ACTION_EndLine, ACTION_TopOfScreen, ACTION_BottomOfScreen, ACTION_PageUp, ACTION_PageDown, ACTION_PageLeft, ACTION_PageRight, ACTION_Begin, ACTION_End, ACTION_ScrollUp, ACTION_ScrollDown, ACTION_GotoLineDialog, ACTION_MatchBrace, ACTION_ToggleBookmark, ACTION_SetBookmark0, ACTION_SetBookmark1, ACTION_SetBookmark2, ACTION_SetBookmark3, ACTION_SetBookmark4, ACTION_SetBookmark5, ACTION_SetBookmark6, ACTION_SetBookmark7, ACTION_SetBookmark8, ACTION_SetBookmark9, ACTION_GotoBookmark0, ACTION_GotoBookmark1, ACTION_GotoBookmark2, ACTION_GotoBookmark3, ACTION_GotoBookmark4, ACTION_GotoBookmark5, ACTION_GotoBookmark6, ACTION_GotoBookmark7, ACTION_GotoBookmark8, ACTION_GotoBookmark9, ACTION_NextBookmark, ACTION_PreviousBookmark, ACTION_ClearBookmarks, ACTION_GotoBookmarkDialog, ACTION_SelectionForward, ACTION_SelectionBackward, ACTION_SelectionUp, ACTION_SelectionDown, ACTION_SelectionBeginWord, ACTION_SelectionEndWord, ACTION_SelectionPreviousWord, ACTION_SelectionNextWord, ACTION_SelectionBeginLine, ACTION_SelectionEndLine, ACTION_SelectionTopOfScreen, ACTION_SelectionBottomOfScreen, ACTION_SelectionPageUp, ACTION_SelectionPageDown, ACTION_SelectionBegin, ACTION_SelectionEnd, ACTION_SelectionMatchBrace, ACTION_SelectWord, ACTION_SelectLine, ACTION_SelectMultiLine, ACTION_SelectAll, ACTION_ToggleInsertMode, ACTION_DeletePrevChar, ACTION_DeleteNextChar, ACTION_DeleteSelection, ACTION_DeleteLine, ACTION_DeleteBeginLine, ACTION_DeleteEndLine, ACTION_DeleteWord, ACTION_DeleteBeginWord, ACTION_IndentBlock, ACTION_OutdentBlock, ACTION_SmartIndent, ACTION_SmartBackspace, ACTION_Undo, ACTION_Redo, ACTION_UpperCase, ACTION_LowerCase, ACTION_ToggleCase, ACTION_UpperCaseWord, ACTION_LowerCaseWord, ACTION_OpenLine, ACTION_Cut, ACTION_Copy, ACTION_Paste, ACTION_SearchDialog, ACTION_SearchAgain, ACTION_SearchAgainInReverse, ACTION_SearchAgainForward, ACTION_SearchAgainBackward, ACTION_SearchSelectedForward, ACTION_SearchSelectedBackward, ACTION_ReplaceDialog, ACTION_IncrementalSearch, ACTION_ReverseIncrementalSearch, ACTION_Recenter, ACTION_InsertTab, ACTION_TabKey, ACTION_UnTabKey, ACTION_StripTrailingSpace, ACTION_CommentLine, ACTION_PreviousIndent, ACTION_PreviousTabStop, ACTION_DefaultKeyTyped, ACTION_TransposeLines, ACTION_TransposeWords, ACTION_TransposeChars, ACTION_ClosingCurlyBrace};
        c = new ArrayList();
        b = new ArrayList();
    }

    static int a(int n2, Document document) {
        return EditorActions.b(n2, document);
    }

    static int a(int n2, boolean bl, Document document, char c2, char c3) {
        return EditorActions.b(n2, bl, document, c2, c3);
    }

    private static int b(int n2, boolean bl, Document document, char c2, char c3) {
        int n3 = 0;
        Element element = document.getDefaultRootElement();
        int n4 = element.getElementCount();
        Segment segment = new Segment();
        boolean bl2 = false;
        try {
            int n5;
            if (bl) {
                for (n5 = element.getElementIndex(n2); n5 < n4; ++n5) {
                    int n6;
                    int n7;
                    Element element2 = element.getElement(n5);
                    int n8 = element2.getStartOffset();
                    int n9 = element2.getEndOffset();
                    document.getText(n8, n9 - n8, segment);
                    int n10 = 0;
                    if (n2 != 0) {
                        n2 = n2 - n8 + 1;
                        n7 = segment.offset;
                        while (n7 < segment.offset + n2) {
                            if (n10 == 47 && segment.array[n7] == '/') {
                                n6 = -1;
                                return n6;
                            }
                            n10 = segment.array[n7++];
                        }
                        n10 = 0;
                    }
                    n7 = 0;
                    n6 = 0;
                    boolean bl3 = false;
                    int n11 = segment.offset + n2;
                    while (n11 < segment.offset + segment.count) {
                        char c4 = segment.array[n11];
                        if (bl3 && (c4 == '\'' || c4 == '\"')) {
                            bl3 = false;
                        } else if (c4 == '\\') {
                            bl3 = !bl3;
                        } else {
                            bl3 = false;
                            if (c4 == '*' && n10 == 47) {
                                bl2 = true;
                            } else if (c4 == '/' && n10 == 42) {
                                bl2 = false;
                            } else if (!bl2) {
                                if (c4 == '/' && n10 == 47) break;
                                if (c4 == '\'' && n6 == 0) {
                                    n7 = n7 == 0 ? 1 : 0;
                                } else if (n7 == 0) {
                                    if (c4 == '\"') {
                                        n6 = n6 == 0 ? 1 : 0;
                                    } else if (n6 == 0) {
                                        if (c4 == c2) {
                                            ++n3;
                                        } else if (c4 == c3) {
                                            if (n3 == 0) {
                                                int n12 = n8 + n11 - segment.offset;
                                                return n12;
                                            }
                                            --n3;
                                        }
                                    }
                                }
                            }
                        }
                        n10 = segment.array[n11++];
                    }
                    n2 = 0;
                }
            } else {
                boolean bl4 = true;
                while (n5 >= 0) {
                    int n13;
                    Element element3 = element.getElement(n5);
                    int n14 = element3.getStartOffset();
                    int n15 = element3.getEndOffset();
                    document.getText(n14, n15 - n14, segment);
                    n2 = bl4 ? (n2 -= n14) : segment.count;
                    int n16 = 0;
                    int n17 = segment.offset;
                    while (n17 < segment.offset + n2) {
                        if (n16 == 47 && segment.array[n17] == '/') {
                            if (bl4) {
                                n13 = -1;
                                return n13;
                            }
                            --n17;
                            break;
                        }
                        n16 = segment.array[n17++];
                    }
                    n16 = 0;
                    n13 = 0;
                    boolean bl5 = false;
                    int n18 = n17 - 1;
                    while (n18 >= segment.offset) {
                        char c5 = segment.array[n18];
                        if (c5 != '\\' || n16 != 92 && (n18 <= segment.offset || segment.array[n18 - 1] != '\\')) {
                            if (c5 == '\\' && n16 == 39) {
                                n13 = n13 == 0 ? 1 : 0;
                            } else if (c5 == '\\' && n16 == 34) {
                                bl5 = !bl5;
                            } else if (c5 == '*' && n16 == 47) {
                                bl2 = true;
                            } else if (c5 == '/' && n16 == 42) {
                                bl2 = false;
                            } else if (!bl2) {
                                if (c5 == '\'' && !bl5) {
                                    n13 = n13 == 0 ? 1 : 0;
                                } else if (n13 == 0) {
                                    if (c5 == '\"') {
                                        bl5 = !bl5;
                                    } else if (!bl5) {
                                        if (c5 == c2) {
                                            ++n3;
                                        } else if (c5 == c3) {
                                            if (n3 == 0) {
                                                int n19 = n14 + n18 - segment.offset;
                                                return n19;
                                            }
                                            --n3;
                                        }
                                    }
                                }
                            }
                        }
                        n16 = segment.array[n18--];
                    }
                    bl4 = false;
                    --n5;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return -1;
    }

    private static int b(int n2, Document document) {
        try {
            Element element = document.getDefaultRootElement();
            Segment segment = new Segment();
            int n3 = EditorManager.getTabSize();
            while (n2 >= 0) {
                Element element2 = element.getElement(n2);
                int n4 = element2.getStartOffset();
                int n5 = element2.getEndOffset();
                document.getText(n4, n5 - n4, segment);
                int n6 = 0;
                for (int i2 = segment.offset; i2 < segment.offset + segment.count; ++i2) {
                    char c2 = segment.array[i2];
                    if (c2 == '*' || c2 == '/' && segment.array[i2 + 1] == '*' && segment.array[i2 + 2] == '*') {
                        if (c2 == '*') {
                            ++i2;
                            ++n6;
                        } else {
                            i2 += 3;
                            n6 += 3;
                        }
                        if (TextUtilities.isBlankLine(segment.array, i2, segment.offset + segment.count - i2)) {
                            if (c2 != '*') break;
                            int n7 = -1;
                            return n7;
                        }
                        while (i2 < segment.offset + segment.count) {
                            c2 = segment.array[i2];
                            if (c2 == '\t') {
                                n6 += n3 - n6 % n3;
                            } else if (c2 == ' ') {
                                ++n6;
                            } else {
                                int n8 = n6;
                                return n8;
                            }
                            ++i2;
                        }
                        continue;
                    }
                    if (c2 == '\t') {
                        n6 += n3 - n6 % n3;
                        continue;
                    }
                    if (c2 == ' ') {
                        ++n6;
                        continue;
                    }
                    if (TextUtilities.isBlankLine(segment.array, segment.offset, segment.count)) break;
                    int n9 = n6;
                    return n9;
                }
                --n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static boolean isBindableIdeAction(Action action) {
        for (int i2 = 0; i2 < b.size(); ++i2) {
            if (b.get(i2) != action) continue;
            return true;
        }
        return false;
    }

    public static Action[] getBindableIdeActions() {
        Action[] actionArray = new Action[b.size()];
        return b.toArray(actionArray);
    }

    public static void removeBindableIdeAction(Action action) {
        ((AbstractCollection)b).remove(action);
    }

    public static void addBindableIdeAction(Action action) {
        EditorActions.addBindableIdeAction(action, null);
    }

    public static void addBindableIdeAction(Action action, String string) {
        ArrayList<String> arrayList = (ArrayList<String>)action.getValue("KeymapName");
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(string);
        action.putValue("KeymapName", arrayList);
        b.add(action);
    }

    public static Action[] getBindableEditorActions() {
        Action[] actionArray = new Action[c.size()];
        return c.toArray(actionArray);
    }

    public static void removeBindableEditorAction(Action action) {
        ((AbstractCollection)c).remove(action);
    }

    public static void addBindableEditorAction(Action action) {
        EditorActions.addBindableEditorAction(action, null);
    }

    public static void addBindableEditorAction(Action action, String string) {
        ArrayList<String> arrayList = (ArrayList<String>)action.getValue("KeymapName");
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(string);
        action.putValue("KeymapName", arrayList);
        c.add(action);
    }

    public static Action[] getActions() {
        return customActions;
    }

    public static class ClosingCurlyBraceAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EditorPane editorPane;
                int n2 = actionEvent.getModifiers();
                if ((n2 & 8) != 0 && !Platform.MAC || (n2 & 2) != 0 || (n2 & 4) != 0) {
                    return;
                }
                if (EditorManager.isBooleanOptionValue("alignClosingCurlyBrace") && (editorPane = this.getEditorTarget(actionEvent)) != null && editorPane.isEditable()) {
                    int n3;
                    Document document = editorPane.getDocument();
                    int n4 = editorPane.getCaretPosition();
                    Element element = document.getDefaultRootElement();
                    int n5 = element.getElementIndex(n4);
                    Element element2 = element.getElement(n5);
                    int n6 = element2.getStartOffset();
                    int n7 = Math.min(n4, document.getLength());
                    Segment segment = new Segment();
                    document.getText(n6, n7 - n6, segment);
                    if (TextUtilities.isBlankLine(segment.array, segment.offset, segment.count) && (n3 = EditorActions.a(n4, false, document, '}', '{')) != -1) {
                        char c2;
                        int n8;
                        int n9;
                        n5 = element.getElementIndex(n3);
                        element2 = element.getElement(n5);
                        int n10 = element2.getStartOffset();
                        int n11 = Math.min(n3, element2.getEndOffset());
                        document.getText(n10, n11 - n10, segment);
                        for (n9 = segment.offset + segment.count - 1; n9 > segment.offset; --n9) {
                            --n11;
                            n8 = segment.array[n9];
                            if (n8 == 41) {
                                n3 = EditorActions.a(n11, false, document, ')', '(');
                                if (n3 == -1) break;
                                n5 = element.getElementIndex(n3);
                                element2 = element.getElement(n5);
                                n10 = element2.getStartOffset();
                                n11 = Math.min(n3, element2.getEndOffset());
                                document.getText(n10, n11 - n10, segment);
                                break;
                            }
                            if (!Character.isWhitespace((char)n8)) break;
                        }
                        n9 = 0;
                        for (n8 = segment.offset; n8 < segment.offset + segment.count && Character.isWhitespace(c2 = segment.array[n8]); ++n8) {
                            ++n9;
                        }
                        String string = new String(segment.array, segment.offset, n9);
                        string = String.valueOf(String.valueOf(string)).concat("}");
                        editorPane.startUndoGroup();
                        document.remove(n6, n4 - n6);
                        document.insertString(n6, string, null);
                        editorPane.endUndoGroup();
                        return;
                    }
                }
                ACTION_DefaultKeyTyped.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public ClosingCurlyBraceAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(69));
            this.putValue("ActionGroup", a.a(175));
        }
    }

    public static class GotoBookmarkDialogAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                GotoBookmarkDialog gotoBookmarkDialog = new GotoBookmarkDialog(editorPane);
                ((Component)gotoBookmarkDialog).setVisible(true);
            }
        }

        public GotoBookmarkDialogAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(141));
            this.putValue("ActionGroup", a.a(34));
        }
    }

    public static class TransposeCharsAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = Utilities.getRowStart(editorPane, n2);
                    int n4 = Utilities.getRowEnd(editorPane, n2);
                    Document document = editorPane.getDocument();
                    if (n2 != n4) {
                        if (n2 > 0) {
                            String string = document.getText(n2 - 1, 2);
                            char[] cArray = string.toCharArray();
                            char c2 = cArray[0];
                            cArray[0] = cArray[1];
                            cArray[1] = c2;
                            editorPane.startUndoGroup();
                            document.remove(n2 - 1, 2);
                            document.insertString(n2 - 1, new String(cArray), null);
                            editorPane.setCaretPosition(n2 + 1);
                            editorPane.endUndoGroup();
                        } else {
                            editorPane.getToolkit().beep();
                        }
                    } else {
                        String string = document.getText(n2 - 2, 2);
                        char[] cArray = string.toCharArray();
                        char c3 = cArray[0];
                        cArray[0] = cArray[1];
                        cArray[1] = c3;
                        editorPane.startUndoGroup();
                        document.remove(n2 - 2, 2);
                        document.insertString(n2 - 2, new String(cArray), null);
                        editorPane.setCaretPosition(n2);
                        editorPane.endUndoGroup();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public TransposeCharsAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(304));
            this.putValue("ActionGroup", a.a(303));
        }
    }

    public static class TransposeWordsAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    Document document = editorPane.getDocument();
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordStart(editorPane, n2);
                    int n4 = TextUtilities.getWordEnd(editorPane, n3);
                    int n5 = TextUtilities.getWordEnd(editorPane, n4);
                    int n6 = TextUtilities.getWordStart(editorPane, n5);
                    if (n6 == n3) {
                        editorPane.setCaretPosition(n3);
                        editorPane.getToolkit().beep();
                        return;
                    }
                    editorPane.startUndoGroup();
                    String string = document.getText(n3, n4 - n3);
                    String string2 = document.getText(n6, n5 - n6);
                    document.remove(n6, n5 - n6);
                    document.insertString(n6, string, null);
                    document.remove(n3, n4 - n3);
                    document.insertString(n3, string2, null);
                    editorPane.setCaretPosition(n5);
                    editorPane.endUndoGroup();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public TransposeWordsAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(306));
            this.putValue("ActionGroup", a.a(303));
        }
    }

    public static class TransposeLinesAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    Document document = editorPane.getDocument();
                    int n2 = editorPane.getCaretPosition();
                    Element element = document.getDefaultRootElement();
                    int n3 = element.getElementIndex(n2);
                    int n4 = element.getElementCount();
                    if (n4 <= 1) {
                        return;
                    }
                    editorPane.startUndoGroup();
                    Element element2 = element.getElement(n3 > 0 ? n3 : n3 + 1);
                    Element element3 = element.getElement(n3 > 0 ? n3 - 1 : n3);
                    int n5 = element2.getStartOffset();
                    int n6 = Math.min(element2.getEndOffset(), document.getLength());
                    int n7 = element3.getStartOffset();
                    String string = document.getText(n5, n6 - n5);
                    document.remove(n5, n6 - n5);
                    if (!string.endsWith("\n")) {
                        string = String.valueOf(String.valueOf(string)).concat("\n");
                        ++n6;
                    }
                    document.insertString(n7, string, null);
                    editorPane.setCaretPosition(n6);
                    editorPane.endUndoGroup();
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                    badLocationException.printStackTrace();
                }
            }
        }

        public TransposeLinesAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(305));
            this.putValue("ActionGroup", a.a(303));
        }
    }

    public static class PreviousIndentAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    Document document = editorPane.getDocument();
                    int n2 = this.a ? EditorManager.getBlockIndent() : EditorManager.getTabSize();
                    int n3 = EditorManager.getTabSize();
                    int n4 = editorPane.getCaretPosition();
                    Element element = TextUtilities.getLineElement(editorPane, n4);
                    int n5 = element.getStartOffset();
                    int n6 = element.getEndOffset();
                    Segment segment = new Segment();
                    document.getText(n5, n6 - n5, segment);
                    int n7 = TextUtilities.getTabbedTextPosition(segment, n3, n4 - n5);
                    int n8 = n7 % n2 == 0 ? n7 / n2 - 1 : n7 / n2;
                    n8 = Math.max(n8, 0);
                    editorPane.setCaretPosition(n5 + n8 * n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public PreviousIndentAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(197));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(198));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
        }
    }

    public static class CommentLineAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                    return;
                }
                editorPane.startUndoGroup();
                try {
                    Document document = editorPane.getDocument();
                    Element element = document.getDefaultRootElement();
                    Caret caret = editorPane.getCaret();
                    if (caret.getDot() != caret.getMark()) {
                        int n2;
                        int n3 = element.getElementIndex(editorPane.getSelectionStart());
                        int n4 = element.getElementIndex(editorPane.getSelectionEnd());
                        Element element2 = element.getElement(n4);
                        int n5 = element2.getStartOffset();
                        if (editorPane.getSelectionEnd() == n5) {
                            n4 = Math.max(n3, n4 - 1);
                        }
                        Segment segment = new Segment();
                        boolean bl = false;
                        for (n2 = n3; n2 <= n4; ++n2) {
                            Element element3 = element.getElement(n2);
                            int n6 = element3.getStartOffset();
                            int n7 = element3.getEndOffset();
                            int n8 = n7 - n6;
                            if (n8 >= 2) {
                                document.getText(n6, n8, segment);
                                if (segment.array[segment.offset] == '/' && segment.array[segment.offset + 1] == '/') {
                                    document.remove(n6, 2);
                                    continue;
                                }
                                document.insertString(n6, "//", null);
                                if (n2 != n3) continue;
                                bl = true;
                                continue;
                            }
                            document.insertString(n6, "//", null);
                            if (n2 != n3) continue;
                            bl = true;
                        }
                        if (bl) {
                            int n9;
                            n2 = caret.getMark();
                            if (n2 < (n9 = caret.getDot())) {
                                editorPane.setCaretPosition(n2 - 2);
                                editorPane.moveCaretPosition(n9);
                            } else {
                                editorPane.moveCaretPosition(n9 - 2);
                            }
                        }
                    } else {
                        int n10 = caret.getDot();
                        int n11 = element.getElementIndex(n10);
                        Element element4 = element.getElement(n11);
                        int n12 = element4.getStartOffset();
                        int n13 = element4.getEndOffset();
                        int n14 = n13 - n12;
                        ACTION_Down.actionPerformed(actionEvent);
                        if (n14 >= 2) {
                            Segment segment = new Segment();
                            document.getText(n12, n14, segment);
                            if (segment.array[segment.offset] == '/' && segment.array[segment.offset + 1] == '/') {
                                document.remove(n12, 2);
                            } else {
                                document.insertString(n12, "//", null);
                            }
                        } else {
                            document.insertString(n12, "//", null);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                editorPane.endUndoGroup();
            }
        }

        public CommentLineAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(75));
            this.putValue("ActionGroup", a.a(175));
        }
    }

    public static class OpenLineAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                    return;
                }
                int n2 = editorPane.getCaretPosition();
                editorPane.startUndoGroup();
                editorPane.replaceSelection("\n");
                editorPane.setCaretPosition(n2);
                editorPane.endUndoGroup();
            }
        }

        public OpenLineAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(182));
            this.putValue("ActionGroup", a.a(175));
        }
    }

    public static class StripTrailingSpaceAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                    return;
                }
                boolean bl = false;
                try {
                    Document document = editorPane.getDocument();
                    Element element = document.getDefaultRootElement();
                    int n2 = element.getElementCount();
                    Segment segment = new Segment();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        char c2;
                        Element element2 = element.getElement(i2);
                        int n3 = element2.getStartOffset();
                        int n4 = element2.getEndOffset();
                        int n5 = n4 - n3;
                        int n6 = 0;
                        document.getText(n3, n5, segment);
                        for (int i3 = segment.offset + n5 - 2; i3 >= segment.offset && ((c2 = segment.array[i3]) == ' ' || c2 == '\t'); --i3) {
                            ++n6;
                        }
                        if (n6 <= 0) continue;
                        if (!bl) {
                            editorPane.startUndoGroup();
                            bl = true;
                        }
                        document.remove(n4 - n6 - 1, n6);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                if (bl) {
                    editorPane.endUndoGroup();
                }
            }
        }

        public StripTrailingSpaceAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(287));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class MatchBraceAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    String string = editorPane.getText(n2, 1);
                    char c2 = string.charAt(0);
                    char c3 = '\u0000';
                    boolean bl = true;
                    switch (c2) {
                        case '[': {
                            c3 = ']';
                            break;
                        }
                        case '{': {
                            c3 = '}';
                            break;
                        }
                        case '(': {
                            c3 = ')';
                            break;
                        }
                        case ']': {
                            c3 = '[';
                            bl = false;
                            break;
                        }
                        case '}': {
                            c3 = '{';
                            bl = false;
                            break;
                        }
                        case ')': {
                            c3 = '(';
                            bl = false;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    Document document = editorPane.getDocument();
                    int n3 = EditorActions.a(n2, bl, document, c2, c3);
                    if (n3 == -1) {
                        return;
                    }
                    if (this.a) {
                        if (bl) {
                            editorPane.setCaretPosition(n2 + 1);
                            editorPane.moveCaretPosition(n3);
                        } else {
                            editorPane.moveCaretPosition(n3 + 1);
                        }
                    } else {
                        editorPane.gotoOffset(n3, false, 7);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public MatchBraceAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(261));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(172));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(226));
            }
        }
    }

    public static class InsertTabAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                editorPane.replaceSelection(new String("\t"));
            }
        }

        public InsertTabAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(152));
            this.putValue("ActionGroup", a.a(291));
        }
    }

    public static class UnTabKeyAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                Caret caret = editorPane.getCaret();
                if (caret.getDot() != caret.getMark()) {
                    boolean bl = false;
                    Document document = editorPane.getDocument();
                    Element element = document.getDefaultRootElement();
                    if (element.getElementIndex(caret.getDot()) != element.getElementIndex(caret.getMark())) {
                        bl = true;
                    } else {
                        ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
                        if (modeStateInfo != null && modeStateInfo.hasModalSelection && modeStateInfo.getMode() == 1) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        new OutdentBlockAction("outdent-block").actionPerformed(actionEvent);
                        return;
                    }
                } else {
                    new PreviousIndentAction("previous-tab-stop", true).actionPerformed(actionEvent);
                    return;
                }
            }
        }

        public UnTabKeyAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(308));
            this.putValue("ActionGroup", a.a(291));
        }
    }

    public static class TabKeyAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            block23: {
                EditorPane editorPane = this.getEditorTarget(actionEvent);
                if (editorPane == null) break block23;
                try {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    Element element;
                    Document document;
                    int n6;
                    Caret caret = editorPane.getCaret();
                    if (caret.getDot() != caret.getMark()) {
                        n6 = 0;
                        document = editorPane.getDocument();
                        element = document.getDefaultRootElement();
                        if (element.getElementIndex(caret.getDot()) != element.getElementIndex(caret.getMark())) {
                            n6 = 1;
                        } else {
                            ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
                            if (modeStateInfo != null && modeStateInfo.hasModalSelection && modeStateInfo.getMode() == 1) {
                                n6 = 1;
                            }
                        }
                        if (n6 != 0) {
                            new IndentBlockAction("indent-block").actionPerformed(actionEvent);
                            return;
                        }
                    }
                    n6 = editorPane.getSelectionStart();
                    document = editorPane.getDocument();
                    element = document.getDefaultRootElement();
                    int n7 = element.getElementIndex(n6);
                    Element element2 = element.getElement(n7);
                    int n8 = element2.getStartOffset();
                    int n9 = element2.getEndOffset();
                    int n10 = EditorManager.getTabSize();
                    int n11 = EditorManager.getBlockIndent();
                    Segment segment = new Segment();
                    document.getText(n8, n9 - n8, segment);
                    int n12 = TextUtilities.getTabbedTextPosition(segment, n10, n6 - n8);
                    boolean bl = true;
                    for (n5 = 0; n5 < n6 - n8; ++n5) {
                        n4 = segment.array[n5];
                        if (n4 == 32 || n4 == 9) continue;
                        bl = false;
                        break;
                    }
                    n5 = -1;
                    if (EditorManager.isBooleanOptionValue("smartTabs")) {
                        --n7;
                        block3: while (n7 >= 0) {
                            element2 = element.getElement(n7);
                            n4 = element2.getStartOffset();
                            n3 = element2.getEndOffset();
                            document.getText(n4, n3 - n4, segment);
                            if (TextUtilities.isBlankLine(segment.array, segment.offset, segment.count)) {
                                --n7;
                                continue;
                            }
                            n2 = 0;
                            boolean bl2 = false;
                            for (int i2 = segment.offset; i2 < segment.offset + segment.count; ++i2) {
                                char c2 = segment.array[i2];
                                if (n2 >= n12) {
                                    if (bl2) {
                                        if (!Character.isWhitespace(c2)) {
                                            n5 = n2 - n12;
                                            break block3;
                                        }
                                    } else if (Character.isWhitespace(c2)) {
                                        bl2 = true;
                                    }
                                }
                                if (c2 == '\t') {
                                    n2 += n10 - n2 % n10;
                                    continue;
                                }
                                ++n2;
                            }
                        }
                    }
                    if (n5 == -1) {
                        n5 = n11 - n12 % n11;
                    }
                    if (!editorPane.isEditable()) {
                        editorPane.setCaretPosition(editorPane.getCaretPosition() + n5);
                        return;
                    }
                    if (!bl || !EditorManager.isBooleanOptionValue("useTabChar")) {
                        char[] cArray = new char[n5];
                        for (n3 = 0; n3 < n5; ++n3) {
                            cArray[n3] = 32;
                        }
                        String string = new String(cArray, 0, n5);
                        editorPane.replaceSelection(string);
                        break block23;
                    }
                    n4 = (n5 += n12) / n10 + n5 % n10;
                    char[] cArray = new char[n4];
                    for (n2 = 0; n2 < n4; ++n2) {
                        cArray[n2] = n2 < n5 / n10 ? 9 : 32;
                    }
                    editorPane.startUndoGroup();
                    editorPane.replaceSelection(new String(cArray, 0, n4));
                    document.remove(n8, n6 - n8);
                    editorPane.endUndoGroup();
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("BadLocationException: p0: ").append(editorPane.getCaretPosition()).append(", length: ").append(editorPane.getText().length()))));
                }
            }
        }

        public TabKeyAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(292));
            this.putValue("ActionGroup", a.a(291));
        }
    }

    public static class RecenterAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                editorPane.gotoOffset(editorPane.getCaretPosition(), false, 1);
            }
        }

        public RecenterAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(200));
            this.putValue("ActionGroup", a.a(175));
        }
    }

    public static class IncrementalSearchAction
    extends EditorAction {
        protected boolean forward;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                SearchManager.incrementalSearch(editorPane, this.forward);
            }
        }

        public IncrementalSearchAction(String string, boolean bl) {
            super(string);
            this.forward = bl;
            if (bl) {
                this.putValue("LongDescription", a.a(134));
            } else {
                this.putValue("LongDescription", a.a(146));
            }
            this.putValue("ActionGroup", a.a(226));
        }
    }

    public static class SearchSelectedAction
    extends EditorAction {
        boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                int n2;
                int n3 = editorPane.getSelectionStart();
                if (n3 == (n2 = editorPane.getSelectionEnd())) {
                    return;
                }
                try {
                    Document document = editorPane.getDocument();
                    String string = document.getText(n3, n2 - n3);
                    if (this.a) {
                        editorPane.setCaretPosition(n3);
                        editorPane.moveCaretPosition(n2);
                    } else {
                        editorPane.setCaretPosition(n2);
                        editorPane.moveCaretPosition(n3);
                    }
                    SearchOptions searchOptions = SearchManager.getSavedOptions();
                    boolean bl = searchOptions.forwardSearch;
                    searchOptions.forwardSearch = this.a;
                    searchOptions.setSearchText(string);
                    SearchManager.setOptions(searchOptions);
                    SearchManager.repeatSearch(editorPane);
                    searchOptions.forwardSearch = bl;
                    SearchManager.setOptions(searchOptions);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public SearchSelectedAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(137));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(22));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(226));
        }
    }

    public static class SearchAgainAction
    extends EditorAction {
        int a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                SearchOptions searchOptions = SearchManager.getSavedOptions();
                boolean bl = searchOptions.forwardSearch;
                if (this.a == 2 || this.a == 3) {
                    searchOptions.forwardSearch = this.a == 2;
                    SearchManager.setOptions(searchOptions);
                } else if (this.a == 1) {
                    boolean bl2 = searchOptions.forwardSearch = !searchOptions.forwardSearch;
                }
                if (searchOptions.replaceText.length() > 0 && editorPane.isEditable()) {
                    SearchManager.repeatReplace(editorPane);
                } else if (searchOptions.searchText.length() > 0) {
                    SearchManager.repeatSearch(editorPane);
                } else {
                    SearchDialog searchDialog = new SearchDialog(editorPane, false);
                    ((Component)searchDialog).setVisible(true);
                }
                if (this.a > 0) {
                    searchOptions.forwardSearch = bl;
                    SearchManager.setOptions(searchOptions);
                }
            }
        }

        public SearchAgainAction(String string, int n2) {
            super(string);
            this.a = n2;
            switch (n2) {
                default: {
                    this.putValue("LongDescription", com.borland.primetime.editor.a.a(227));
                    break;
                }
                case 1: {
                    this.putValue("LongDescription", com.borland.primetime.editor.a.a(232));
                    break;
                }
                case 2: {
                    this.putValue("LongDescription", com.borland.primetime.editor.a.a(229));
                    break;
                }
                case 3: {
                    this.putValue("LongDescription", com.borland.primetime.editor.a.a(228));
                }
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(226));
        }
    }

    public static class ReplaceDialogAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable() && editorPane.isEnabled()) {
                SearchDialog searchDialog = new SearchDialog(editorPane, true);
                ((Component)searchDialog).setVisible(true);
            }
        }

        public ReplaceDialogAction() {
            super("replace-dialog");
            this.putValue("LongDescription", a.a(209));
            this.putValue("ActionGroup", a.a(226));
        }
    }

    public static class SearchDialogAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                SearchDialog searchDialog = new SearchDialog(editorPane, false);
                ((Component)searchDialog).setVisible(true);
            }
        }

        public SearchDialogAction() {
            super("search-dialog");
            this.putValue("LongDescription", a.a(233));
            this.putValue("ActionGroup", a.a(226));
        }
    }

    public static class PasteAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable() && editorPane.isEnabled()) {
                editorPane.paste();
            }
        }

        public PasteAction() {
            super("paste-from-clipboard");
            this.putValue("LongDescription", a.a(189));
            this.putValue("ActionGroup", a.a(68));
        }
    }

    public static class CopyAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                editorPane.copy();
            }
        }

        public CopyAction() {
            super("copy-to-clipboard");
            this.putValue("LongDescription", a.a(77));
            this.putValue("ActionGroup", a.a(68));
        }
    }

    public static class CutAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable() && editorPane.isEnabled()) {
                editorPane.cut();
            }
        }

        public CutAction() {
            super("cut-to-clipboard");
            this.putValue("LongDescription", a.a(79));
            this.putValue("ActionGroup", a.a(68));
        }
    }

    public static class ToggleCaseAction
    extends EditorAction {
        private LowerCaseAction b;
        private UpperCaseAction a = new UpperCaseAction("upper");

        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            int n3;
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable() && editorPane.isEnabled() && (n3 = editorPane.getSelectionStart()) < (n2 = editorPane.getSelectionEnd())) {
                try {
                    Document document = editorPane.getDocument();
                    String string = document.getText(n3, n2 - n3);
                    char[] cArray = string.toCharArray();
                    for (int i2 = 0; i2 < cArray.length; ++i2) {
                        if (!Character.isLetter(cArray[i2])) continue;
                        cArray[i2] = Character.isUpperCase(cArray[i2]) ? Character.toLowerCase(cArray[i2]) : Character.toUpperCase(cArray[i2]);
                    }
                    editorPane.startUndoGroup();
                    document.remove(n3, n2 - n3);
                    document.insertString(n3, new String(cArray), null);
                    editorPane.select(n3, n2);
                    editorPane.endUndoGroup();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public ToggleCaseAction(String string) {
            super(string);
            this.b = new LowerCaseAction("lower");
            this.putValue("LongDescription", com.borland.primetime.editor.a.a(300));
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(60));
        }
    }

    public static class LowerCaseAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            int n3;
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable() && editorPane.isEnabled() && (n3 = editorPane.getSelectionStart()) < (n2 = editorPane.getSelectionEnd())) {
                try {
                    Document document = editorPane.getDocument();
                    String string = document.getText(n3, n2 - n3);
                    editorPane.startUndoGroup();
                    document.remove(n3, n2 - n3);
                    document.insertString(n3, string.toLowerCase(), null);
                    editorPane.select(n3, n2);
                    editorPane.endUndoGroup();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public LowerCaseAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(167));
            this.putValue("ActionGroup", a.a(60));
        }
    }

    public static class UpperCaseAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            int n3;
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable() && editorPane.isEnabled() && (n3 = editorPane.getSelectionStart()) < (n2 = editorPane.getSelectionEnd())) {
                try {
                    Document document = editorPane.getDocument();
                    String string = document.getText(n3, n2 - n3);
                    editorPane.startUndoGroup();
                    document.remove(n3, n2 - n3);
                    document.insertString(n3, string.toUpperCase(), null);
                    editorPane.select(n3, n2);
                    editorPane.endUndoGroup();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public UpperCaseAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(313));
            this.putValue("ActionGroup", a.a(60));
        }
    }

    public static class RedoAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                editorPane.redo();
            }
        }

        public RedoAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(201));
            this.putValue("ActionGroup", a.a(175));
        }
    }

    public static class UndoAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                editorPane.undo();
            }
        }

        public UndoAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(309));
            this.putValue("ActionGroup", a.a(175));
        }
    }

    public static class SmartBackspaceAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            block19: {
                EditorPane editorPane = this.getEditorTarget(actionEvent);
                if (editorPane != null) {
                    if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                        return;
                    }
                    try {
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        boolean bl;
                        Caret caret = editorPane.getCaret();
                        boolean bl2 = bl = caret.getDot() != caret.getMark();
                        if (bl) {
                            editorPane.replaceSelection(null);
                            return;
                        }
                        EditorDocument editorDocument = (EditorDocument)editorPane.getDocument();
                        Element element = editorDocument.getDefaultRootElement();
                        int n6 = editorPane.getCaretPosition();
                        int n7 = element.getElementIndex(n6);
                        Element element2 = element.getElement(n7);
                        Segment segment = new Segment();
                        int n8 = element2.getStartOffset();
                        int n9 = element2.getEndOffset();
                        editorDocument.getText(n8, n9 - n8, segment);
                        if (n6 == n8) {
                            if (n6 > 0) {
                                editorPane.deletePrevChar();
                            }
                            return;
                        }
                        boolean bl3 = false;
                        for (n5 = segment.offset; n5 < segment.offset + n6 - n8; ++n5) {
                            n4 = segment.array[n5];
                            if (n4 != 32 && n4 != 9) {
                                editorPane.deletePrevChar();
                                return;
                            }
                            if (n4 != 9) continue;
                            bl3 = true;
                        }
                        n5 = EditorManager.getBlockIndent();
                        n4 = EditorManager.getTabSize();
                        int n10 = TextUtilities.getTabbedTextPosition(segment, n4, n6 - n8);
                        int n11 = n10 % n5;
                        int n12 = n11 != 0 ? n10 - n11 : (n10 == 0 ? n10 : n10 - n5);
                        int n13 = -1;
                        --n7;
                        while (n7 >= 0) {
                            element2 = element.getElement(n7);
                            int n14 = element2.getStartOffset();
                            n9 = element2.getEndOffset();
                            editorDocument.getText(n14, n9 - n14, segment);
                            for (n3 = segment.offset; n3 < segment.offset + segment.count; ++n3) {
                                n2 = segment.array[n3];
                                if (n2 == 32 || n2 == 9 || n2 == 10) continue;
                                n13 = n3 - segment.offset;
                                break;
                            }
                            if (n13 != -1) break;
                            --n7;
                        }
                        if (n13 > 0) {
                            n13 = TextUtilities.getTabbedTextPosition(segment, n4, n13);
                        }
                        int n15 = n13 = n13 != -1 ? Math.min(n12, n13) : n12;
                        if (bl3) {
                            char[] cArray = new char[n13];
                            if (EditorManager.isBooleanOptionValue("useTabChar")) {
                                n2 = n13 / n4;
                                for (n3 = 0; n3 < n2; ++n3) {
                                    cArray[n3] = 9;
                                }
                                n2 = n13 % n4;
                                for (int i2 = 0; i2 < n2; ++i2) {
                                    cArray[n3] = 32;
                                    ++n3;
                                }
                            } else {
                                while (n3 < n13) {
                                    cArray[n3] = 32;
                                    ++n3;
                                }
                            }
                            editorPane.startUndoSegment(2);
                            editorDocument.remove(n8, n6 - n8);
                            editorPane.endUndoSegment();
                            if (n3 > 0) {
                                editorPane.startUndoSegment(1);
                                ((AbstractDocument)editorDocument).insertString(n8, new String(cArray, 0, n3), null);
                                editorPane.endUndoSegment();
                            }
                            break block19;
                        }
                        editorPane.startUndoSegment(2);
                        editorDocument.remove(n8 + n13, n6 - n8 - n13);
                        editorPane.endUndoSegment();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        public SmartBackspaceAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(274));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class SmartIndentAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                    return;
                }
                try {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    EditorDocument editorDocument = (EditorDocument)editorPane.getDocument();
                    Element element = editorDocument.getDefaultRootElement();
                    Caret caret = editorPane.getCaret();
                    int n6 = EditorManager.getTabSize();
                    int n7 = EditorManager.getBlockIndent();
                    boolean bl = caret.getDot() != caret.getMark();
                    int n8 = editorPane.getCaretPosition();
                    int n9 = element.getElementIndex(n8);
                    Element element2 = element.getElement(n9);
                    if (!EditorManager.isInsertMode()) {
                        if (n9 < element.getElementCount() - 1) {
                            element2 = element.getElement(n9 + 1);
                            editorPane.setCaretPosition(element2.getStartOffset());
                        }
                        return;
                    }
                    if (!EditorManager.isBooleanOptionValue("smartIndent")) {
                        editorPane.replaceSelection("\n");
                        return;
                    }
                    Segment segment = new Segment();
                    int n10 = element2.getStartOffset();
                    int n11 = element2.getEndOffset();
                    editorDocument.getText(n10, n11 - n10, segment);
                    boolean bl2 = false;
                    int n12 = -1;
                    int n13 = -1;
                    if (n8 == n10) {
                        n5 = segment.array[segment.offset];
                        if (n5 == 32 || n5 == 9) {
                            if (bl) {
                                editorPane.replaceSelection("\n");
                            } else {
                                editorPane.insertChar("\n");
                            }
                            return;
                        }
                        for (n4 = n9 - 1; n4 >= 0; --n4) {
                            element2 = element.getElement(n4);
                            n10 = element2.getStartOffset();
                            n11 = element2.getEndOffset();
                            editorDocument.getText(n10, n11 - n10, segment);
                            n3 = 0;
                            for (n2 = segment.offset; n2 < segment.offset + segment.count; ++n2) {
                                n5 = segment.array[n2];
                                if (n5 != 32 && n5 != 9 && n5 != 10) {
                                    n13 = n3;
                                    break;
                                }
                                if (n5 == 9) {
                                    n3 += n6 - n3 % n6;
                                    continue;
                                }
                                ++n3;
                            }
                            if (n13 == -1) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        n5 = 0;
                        for (n4 = segment.offset; n4 < segment.offset + n8 - n10; ++n4) {
                            n3 = segment.array[n4];
                            if (n3 == 42 || n3 == 47) {
                                if (n3 == 47 && n4 < segment.offset + n8 - n10 - 1 && segment.array[n4 + 1] == '/') {
                                    n13 = n5;
                                    break;
                                }
                                bl2 = true;
                                n13 = n5;
                                break;
                            }
                            if (n3 != 32 && n3 != 9) {
                                n13 = n5;
                                break;
                            }
                            if (n3 == 9) {
                                n5 += n6 - n5 % n6;
                                continue;
                            }
                            ++n5;
                        }
                        if (EditorManager.isBooleanOptionValue("indentAfterBrace")) {
                            for (n4 = segment.offset + n8 - n10 - 1; n4 >= segment.offset && (n3 = segment.array[n4]) != 125; --n4) {
                                if (n3 != 123) continue;
                                if (n13 == -1) {
                                    n13 = n7;
                                    break;
                                }
                                n13 += n7 - n13 % n7;
                                break;
                            }
                        }
                        if (n13 == -1) {
                            n13 = n5;
                        }
                    }
                    String string = "\n";
                    if (n13 > 0) {
                        char[] cArray;
                        if (EditorManager.isBooleanOptionValue("useTabChar")) {
                            cArray = new char[n13 / n6 + n13 % n6];
                            for (n3 = 0; n3 < cArray.length; ++n3) {
                                cArray[n3] = n3 < n13 / n6 ? 9 : 32;
                            }
                        } else {
                            cArray = new char[n13];
                            for (n3 = 0; n3 < n13; ++n3) {
                                cArray[n3] = 32;
                            }
                        }
                        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(new String(cArray))));
                    }
                    String string2 = new String(string);
                    n3 = 1 + n13;
                    if (bl2) {
                        char[] cArray;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        int n18;
                        n2 = 0;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        for (n18 = segment.offset + n8 - n10 - 1; n18 >= segment.offset; --n18) {
                            n17 = segment.array[n18];
                            if (n17 == 47) {
                                if (bl3) {
                                    n15 = n16 = n18 + 3;
                                    n14 = 0;
                                    while (n16 < segment.offset + n8 - n10) {
                                        n17 = segment.array[n16];
                                        if (n17 == 9) {
                                            n15 += n6 - n15 % n6;
                                        } else if (n17 == 32) {
                                            ++n15;
                                        } else {
                                            n14 = 1;
                                            break;
                                        }
                                        ++n16;
                                    }
                                    cArray = n14 != 0 ? new char[3 + n15 - n18 - 3] : new char[3];
                                    cArray[0] = 32;
                                    cArray[1] = 42;
                                    for (n16 = 2; n16 < cArray.length; ++n16) {
                                        cArray[n16] = 32;
                                    }
                                    string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(new String(cArray))));
                                    bl2 = false;
                                    bl4 = true;
                                    break;
                                }
                                if (n2 == 42) {
                                    bl2 = false;
                                    break;
                                }
                                n2 = n17;
                                bl3 = false;
                                continue;
                            }
                            if (n17 == 42) {
                                if (n2 == 42) {
                                    bl3 = true;
                                    continue;
                                }
                                if (n2 == 47) {
                                    bl2 = false;
                                    break;
                                }
                                n2 = n17;
                                bl3 = false;
                                continue;
                            }
                            n2 = n17;
                            bl3 = false;
                        }
                        n18 = 1;
                        for (n17 = n8 - n10; n17 < n11 - n10 - 1; ++n17) {
                            if (segment.array[n17] == ' ' || segment.array[n17] == '\t') continue;
                            n18 = 0;
                            break;
                        }
                        if (bl4) {
                            n17 = n9;
                            for (n16 = n9; n16 < element.getElementCount(); ++n16) {
                                n2 = 0;
                                if (n17 != n16) {
                                    element2 = element.getElement(n16);
                                    n10 = element2.getStartOffset();
                                    n11 = element2.getEndOffset();
                                    editorDocument.getText(n10, n11 - n10, segment);
                                }
                                for (n15 = segment.offset + (n17 != n16 ? 0 : n8 - n10); n15 < segment.offset + segment.count; ++n15) {
                                    n14 = segment.array[n15];
                                    if (n14 == 47) {
                                        if (n2 == 42) {
                                            bl4 = false;
                                            break;
                                        }
                                        n2 = n14;
                                        continue;
                                    }
                                    if (n14 == 42) {
                                        if (n2 == 47) {
                                            string = this.a(editorDocument, n17, string);
                                            n12 = n8 + this.a(string);
                                            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(string2).append(" */").append(n18 == 1 ? "" : string2)));
                                            bl4 = false;
                                            break;
                                        }
                                        n2 = n14;
                                        continue;
                                    }
                                    n2 = n14;
                                }
                                if (!bl4) break;
                                if (n16 != element.getElementCount() - 1) continue;
                                string = this.a(editorDocument, n17, string);
                                n12 = n8 + this.a(string);
                                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(string2).append(" */").append(n18 == 1 ? "" : string2)));
                                break;
                            }
                        }
                        if (bl2) {
                            for (n17 = n9 - 1; n17 >= 0; --n17) {
                                n2 = 0;
                                bl3 = false;
                                element2 = element.getElement(n17);
                                n10 = element2.getStartOffset();
                                n11 = element2.getEndOffset();
                                editorDocument.getText(n10, n11 - n10, segment);
                                for (n16 = segment.offset + segment.count - 1; n16 >= segment.offset; --n16) {
                                    n15 = segment.array[n16];
                                    if (n15 == 47) {
                                        if (bl3) {
                                            n14 = EditorActions.a(n9, editorDocument);
                                            if (n14 != -1 && n14 - n3 + 1 > 0) {
                                                cArray = new char[n14 - n3 + 1];
                                                cArray[0] = 42;
                                                for (int i2 = 1; i2 < cArray.length; ++i2) {
                                                    cArray[i2] = 32;
                                                }
                                                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(new String(cArray))));
                                            } else {
                                                string = String.valueOf(String.valueOf(string)).concat("* ");
                                            }
                                            bl2 = false;
                                            break;
                                        }
                                        if (n2 == 42) {
                                            bl2 = false;
                                            break;
                                        }
                                        n2 = n15;
                                        bl3 = false;
                                        continue;
                                    }
                                    if (n15 == 42) {
                                        if (n2 == 42) {
                                            bl3 = true;
                                            continue;
                                        }
                                        if (n2 == 47) {
                                            bl2 = false;
                                            break;
                                        }
                                        n2 = n15;
                                        bl3 = false;
                                        continue;
                                    }
                                    n2 = n15;
                                    bl3 = false;
                                }
                                if (!bl2) break;
                            }
                        }
                    }
                    if (bl) {
                        editorPane.replaceSelection(string);
                    } else {
                        editorPane.startUndoSegment(1);
                        ((AbstractDocument)editorDocument).insertString(n8, string, null);
                        if (n12 != -1) {
                            editorPane.setCaretPosition(n12);
                        }
                        editorPane.endUndoSegment();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private int a(String string) {
            int n2;
            int n3 = string.indexOf("\n");
            if (n3 > -1 && string.length() > n3 + 1 && (n2 = string.substring(n3 + 1).indexOf("\n")) > -1) {
                return n3 + n2 + 1;
            }
            return string.length();
        }

        private String a(EditorDocument editorDocument, int n2, String string) {
            if (!JBuilderInfo.isProEnabled()) {
                return string;
            }
            Element element = editorDocument.getDefaultRootElement();
            Segment segment = new Segment();
            StringBuffer stringBuffer = new StringBuffer(1024);
            int n3 = Math.min(n2 + 20, element.getElementCount());
            try {
                SourceInfo sourceInfo;
                SourceInfo.Definition definition;
                String[] stringArray;
                Object object;
                for (int i2 = n2; i2 < n3; ++i2) {
                    int n4;
                    Element element2 = element.getElement(i2);
                    int n5 = element2.getStartOffset();
                    int n6 = element2.getEndOffset();
                    editorDocument.getText(n5, n6 - n5, segment);
                    object = segment.toString();
                    if (i2 == n2 && (n4 = ((String)object).indexOf((String)(stringArray = "/**"))) > -1 && ((String)object).length() > n4 + stringArray.length()) {
                        object = ((String)object).substring(n4 + stringArray.length());
                    }
                    stringBuffer.append((String)object);
                }
                String string2 = "";
                int n7 = string.indexOf("\n");
                if (n7 > -1 && string.length() > n7 + 1) {
                    string2 = string.substring(n7 + 1);
                }
                if ((definition = (sourceInfo = new SourceInfo(stringBuffer.toString())).getDefinition()) != null && definition instanceof SourceInfo.Class) {
                    object = Browser.getActiveBrowser().getActiveProject();
                    stringArray = TemplateEngine.getClassJavadoc((Project)object);
                    for (n7 = 0; n7 < stringArray.length; ++n7) {
                        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.a(string2, stringArray[n7]))));
                    }
                } else if (definition != null && definition instanceof SourceInfo.Method) {
                    object = (SourceInfo.Method)definition;
                    stringArray = ((SourceInfo.Method)object).getParameterNames();
                    for (n7 = 0; n7 < stringArray.length && !stringArray[n7].equals("<error>"); ++n7) {
                        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.a(string2, "@param ".concat(String.valueOf(String.valueOf(stringArray[n7])))))));
                    }
                    String string3 = ((SourceInfo.Method)object).getReturnType();
                    if (!(string3.equals("void") || string3.equals("<error>") || string3.equals("") || string3.equals("unknown"))) {
                        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.a(string2, "@return"))));
                    }
                    String[] stringArray2 = ((SourceInfo.Method)object).getExceptions();
                    for (n7 = 0; n7 < stringArray2.length && !stringArray2[n7].equals("<error>"); ++n7) {
                        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.a(string2, "@throws ".concat(String.valueOf(String.valueOf(stringArray2[n7])))))));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private String a(String string, String string2) {
            return String.valueOf(String.valueOf(new StringBuffer("\n").append(string).append(string2)));
        }

        public SmartIndentAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(278));
            this.putValue("ActionGroup", a.a(147));
        }
    }

    public static class OutdentBlockAction
    extends EditorAction {
        private int a;
        private int g;
        private int b;
        private int f;
        private int c;
        private Document e;
        private boolean d;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.getSelectionStart() != editorPane.getSelectionEnd()) {
                if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                    return;
                }
                boolean bl = false;
                try {
                    this.f = EditorManager.getBlockIndent();
                    this.e = editorPane.getDocument();
                    Element element = this.e.getDefaultRootElement();
                    Caret caret = editorPane.getCaret();
                    int n2 = caret.getDot();
                    int n3 = caret.getMark();
                    this.a = EditorManager.getTabSize();
                    int n4 = n2 < n3 ? n2 : n3;
                    int n5 = n2 > n3 ? n2 : n3;
                    int n6 = element.getElementIndex(n4);
                    int n7 = element.getElementIndex(n5);
                    Segment segment = new Segment();
                    Element element2 = element.getElement(n7);
                    this.b = element2.getStartOffset();
                    int n8 = n7;
                    if (n5 == this.b) {
                        --n8;
                    }
                    while (n8 >= n6) {
                        int n9;
                        element2 = element.getElement(n8);
                        this.b = element2.getStartOffset();
                        int n10 = element2.getEndOffset();
                        this.e.getText(this.b, n10 - this.b, segment);
                        this.c = 0;
                        this.g = segment.offset;
                        this.d = false;
                        int n11 = -1;
                        while (this.g < segment.offset + segment.count) {
                            if (this.g - segment.offset == n4 - this.b) {
                                n11 = this.c;
                            }
                            if ((n9 = segment.array[this.g]) == 9) {
                                this.d = true;
                                this.c += this.a - this.c % this.a;
                            } else {
                                if (n9 != 32) break;
                                ++this.c;
                            }
                            ++this.g;
                        }
                        this.g -= segment.offset;
                        if (this.c > 0) {
                            if (!bl) {
                                bl = true;
                                editorPane.startUndoGroup();
                            }
                            if (n8 == n7 && n5 < this.b + this.g) {
                                if (n2 > n3) {
                                    caret.moveDot(this.b + this.g);
                                } else {
                                    caret.setDot(this.b + this.g);
                                    caret.moveDot(n4);
                                }
                            }
                            this.a();
                            if (n8 == n6 && n4 < this.b + this.g && n11 >= 0) {
                                int n12;
                                int n13;
                                n9 = 0;
                                for (n13 = segment.offset; n13 < segment.offset + segment.count && n9 < n11; ++n13) {
                                    n12 = segment.array[n13];
                                    if (n12 == 9) {
                                        n9 += this.a - n9 % this.a;
                                        continue;
                                    }
                                    if (n12 != 32) break;
                                    ++n9;
                                }
                                n13 -= segment.offset;
                                if (n2 < n3) {
                                    caret.moveDot(this.b + n13);
                                } else {
                                    n12 = caret.getDot();
                                    caret.setDot(this.b + n13);
                                    caret.moveDot(n12);
                                }
                            }
                        }
                        --n8;
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                if (bl) {
                    editorPane.endUndoGroup();
                }
            }
        }

        private void a() {
            block7: {
                try {
                    char[] cArray;
                    if (!this.d) {
                        int n2 = Math.min(this.c, this.f);
                        this.e.remove(this.b, n2);
                        break block7;
                    }
                    this.e.remove(this.b, this.g);
                    this.c -= Math.min(this.c, this.f);
                    if (this.c <= 0) break block7;
                    int n3 = this.c / this.a + this.c % this.a;
                    if (EditorManager.isBooleanOptionValue("useTabChar")) {
                        cArray = new char[n3];
                        for (int i2 = 0; i2 < n3; ++i2) {
                            cArray[i2] = i2 < this.c / this.a ? 9 : 32;
                        }
                    } else {
                        cArray = new char[this.c];
                        for (int i3 = 0; i3 < this.c; ++i3) {
                            cArray[i3] = 32;
                        }
                    }
                    this.e.insertString(this.b, new String(cArray), null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public OutdentBlockAction(String string) {
            super(string);
            this.putValue("LongDescription", com.borland.primetime.editor.a.a(184));
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(147));
        }
    }

    public static class IndentBlockAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.getSelectionStart() != editorPane.getSelectionEnd()) {
                if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                    return;
                }
                editorPane.startUndoGroup();
                try {
                    String string;
                    Object object;
                    if (!EditorManager.isBooleanOptionValue("useTabChar")) {
                        object = new char[EditorManager.getBlockIndent()];
                        for (int i2 = 0; i2 < ((char[])object).length; ++i2) {
                            object[i2] = 32;
                        }
                        string = new String((char[])object);
                    } else {
                        string = new String("");
                    }
                    object = editorPane.getDocument();
                    Element element = object.getDefaultRootElement();
                    Caret caret = editorPane.getCaret();
                    int n2 = caret.getDot();
                    int n3 = caret.getMark();
                    int n4 = n2 < n3 ? n2 : n3;
                    int n5 = n2 > n3 ? n2 : n3;
                    int n6 = element.getElementIndex(n4);
                    int n7 = element.getElementIndex(n5);
                    Element element2 = element.getElement(n7);
                    int n8 = element2.getStartOffset();
                    if (n5 == n8) {
                        --n7;
                    }
                    Segment segment = new Segment();
                    int n9 = EditorManager.getBlockIndent();
                    int n10 = EditorManager.getTabSize();
                    for (int i3 = n7; i3 >= n6; --i3) {
                        int n11;
                        int n12;
                        char[] cArray;
                        int n13;
                        int n14;
                        element2 = element.getElement(i3);
                        n8 = element2.getStartOffset();
                        int n15 = element2.getEndOffset();
                        int n16 = n15 - n8;
                        object.getText(n8, n16, segment);
                        int n17 = 0;
                        int n18 = -1;
                        for (n14 = segment.offset; n14 < segment.offset + segment.count; ++n14) {
                            char c2;
                            if (i3 == n6 && n18 < 0 && n14 - segment.offset >= n4 - n8) {
                                n18 = n17;
                            }
                            if ((c2 = segment.array[n14]) == '\t') {
                                n17 += n10 - n17 % n10;
                                continue;
                            }
                            if (c2 != ' ') break;
                            ++n17;
                        }
                        n17 += n9;
                        if (EditorManager.isBooleanOptionValue("useTabChar")) {
                            n13 = n17 / n10 + n17 % n10;
                            cArray = new char[n13];
                            for (n12 = 0; n12 < n13; ++n12) {
                                cArray[n12] = n12 < n17 / n10 ? 9 : 32;
                            }
                        } else {
                            cArray = new char[n17];
                            for (n13 = 0; n13 < n17; ++n13) {
                                cArray[n13] = 32;
                            }
                        }
                        if ((n14 -= segment.offset) > 0) {
                            object.remove(n8, n14);
                        }
                        object.insertString(n8, new String(cArray), null);
                        if (i3 != n6 || n4 > n8 + n14 || n18 < 0) continue;
                        n13 = 0;
                        for (n12 = segment.offset; n12 < segment.offset + segment.count && n13 < n18; ++n12) {
                            n11 = segment.array[n12];
                            if (n11 == 9) {
                                n13 += n10 - n13 % n10;
                                continue;
                            }
                            if (n11 != 32) break;
                            ++n13;
                        }
                        n12 -= segment.offset;
                        if (n2 < n3) {
                            caret.moveDot(n8 + n12);
                            continue;
                        }
                        n11 = caret.getDot();
                        caret.setDot(n8 + n12);
                        caret.moveDot(n11);
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
                editorPane.endUndoGroup();
            }
        }

        public IndentBlockAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(149));
            this.putValue("ActionGroup", a.a(147));
        }
    }

    public static class ChangeWordCaseAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable() && editorPane.isEnabled()) {
                try {
                    Caret caret = editorPane.getCaret();
                    int n2 = caret.getDot();
                    int n3 = caret.getMark();
                    int n4 = TextUtilities.getPreviousWord(editorPane, n2);
                    int n5 = TextUtilities.getWordEnd(editorPane, n4);
                    Document document = editorPane.getDocument();
                    String string = editorPane.getText(n4, n5 - n4);
                    editorPane.startUndoGroup();
                    document.remove(n4, n5 - n4);
                    document.insertString(n4, this.a ? string.toUpperCase() : string.toLowerCase(), null);
                    if (n2 != n3) {
                        editorPane.setCaretPosition(n3);
                        editorPane.moveCaretPosition(n2);
                    } else {
                        editorPane.setCaretPosition(n2);
                    }
                    editorPane.endUndoGroup();
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public ChangeWordCaseAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            this.putValue("LongDescription", com.borland.primetime.editor.a.a(63));
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(60));
        }
    }

    public static class DeleteBeginWordAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                    return;
                }
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordStart(editorPane, n2);
                    int n4 = Utilities.getRowStart(editorPane, n2);
                    n3 = Math.max(n3, n4);
                    if (n3 < n2) {
                        Caret caret = editorPane.getCaret();
                        EditorDocument editorDocument = (EditorDocument)editorPane.getDocument();
                        editorPane.startUndoSegment(2);
                        editorDocument.remove(n3, n2 - n3);
                        caret.setDot(n3);
                        editorPane.endUndoSegment();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public DeleteBeginWordAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(84));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class DeleteWordAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                        return;
                    }
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordEnd(editorPane, n2);
                    if (n3 > n2) {
                        Caret caret = editorPane.getCaret();
                        EditorDocument editorDocument = (EditorDocument)editorPane.getDocument();
                        editorPane.startUndoSegment(2);
                        editorDocument.remove(n2, n3 - n2);
                        caret.setDot(n2);
                        editorPane.endUndoSegment();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public DeleteWordAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(90));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class DeleteEndLineAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                        return;
                    }
                    EditorDocument editorDocument = (EditorDocument)editorPane.getDocument();
                    Caret caret = editorPane.getCaret();
                    int n2 = editorPane.getCaretPosition();
                    int n3 = Utilities.getRowEnd(editorPane, n2);
                    if (n3 != n2) {
                        editorPane.startUndoSegment(2);
                        editorDocument.remove(n2, n3 - n2);
                        caret.setDot(n2);
                        editorPane.endUndoSegment();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public DeleteEndLineAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(85));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class DeleteBeginLineAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                        return;
                    }
                    EditorDocument editorDocument = (EditorDocument)editorPane.getDocument();
                    Caret caret = editorPane.getCaret();
                    int n2 = editorPane.getCaretPosition();
                    int n3 = Utilities.getRowStart(editorPane, n2);
                    if (n3 != n2) {
                        editorPane.startUndoSegment(2);
                        editorDocument.remove(n3, n2 - n3);
                        caret.setDot(n3);
                        editorPane.endUndoSegment();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public DeleteBeginLineAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(83));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class DeleteLineAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2;
                    if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                        return;
                    }
                    EditorDocument editorDocument = (EditorDocument)editorPane.getDocument();
                    Caret caret = editorPane.getCaret();
                    int n3 = editorPane.getCaretPosition();
                    Element element = TextUtilities.getLineElement(editorPane, n3);
                    int n4 = element.getStartOffset();
                    if (n4 != (n2 = Math.min(element.getEndOffset(), editorDocument.getLength()))) {
                        editorPane.startUndoSegment(2);
                        editorDocument.remove(n4, n2 - n4);
                        caret.setDot(n4);
                        editorPane.endUndoSegment();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public DeleteLineAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(86));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class DeleteSelectionAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                editorPane.replaceSelection(null);
            }
        }

        public DeleteSelectionAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(89));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class DeleteNextCharAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            boolean bl = true;
            if (editorPane != null && editorPane.isEditable() && editorPane.isEnabled()) {
                try {
                    Document document = editorPane.getDocument();
                    Caret caret = editorPane.getCaret();
                    int n2 = caret.getDot();
                    int n3 = caret.getMark();
                    if (n2 != n3) {
                        editorPane.replaceSelection(null);
                        bl = false;
                    } else if (n2 < document.getLength()) {
                        editorPane.deleteNextChar();
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public DeleteNextCharAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(87));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class DeletePrevCharAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            boolean bl = true;
            if (editorPane != null && editorPane.isEditable() && editorPane.isEnabled()) {
                try {
                    Document document = editorPane.getDocument();
                    Caret caret = editorPane.getCaret();
                    int n2 = caret.getDot();
                    int n3 = caret.getMark();
                    if (n2 != n3) {
                        editorPane.replaceSelection(null);
                        bl = false;
                    } else if (n2 > 0) {
                        editorPane.deletePrevChar();
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public DeletePrevCharAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(88));
            this.putValue("ActionGroup", a.a(82));
        }
    }

    public static class ToggleInsertModeAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            EditorManager.setInsertMode(!EditorManager.isInsertMode());
            if (editorPane != null) {
                Caret caret = editorPane.getCaret();
                caret.setVisible(false);
                caret.setVisible(true);
            }
        }

        public ToggleInsertModeAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(301));
            this.putValue("ActionGroup", a.a(175));
        }
    }

    public static class SelectAllAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                Document document = editorPane.getDocument();
                editorPane.setCaretPosition(0);
                editorPane.moveCaretPosition(document.getLength());
            }
        }

        public SelectAllAction() {
            super("select-all");
            this.putValue("LongDescription", a.a(249));
            this.putValue("ActionGroup", a.a(270));
        }
    }

    public static class SelectLineAction
    extends EditorAction {
        boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2;
                    ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
                    if (this.a && modeStateInfo != null) {
                        n2 = modeStateInfo.getMode();
                        if (n2 == 2 || n2 == 4 || n2 == 8) {
                            modeStateInfo.setMode(0);
                        } else if (n2 == 1) {
                            modeStateInfo.setMode(0);
                            editorPane.setCaretPosition(editorPane.getCaretPosition());
                            return;
                        }
                        modeStateInfo.setMode(1);
                    }
                    n2 = editorPane.getCaretPosition();
                    int n3 = Utilities.getRowStart(editorPane, n2);
                    int n4 = Utilities.getRowEnd(editorPane, n2);
                    editorPane.setCaretPosition(n3);
                    editorPane.moveCaretPosition(n4);
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public SelectLineAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(282));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(260));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
        }
    }

    public static class SelectWordAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordStart(editorPane, n2, false);
                    int n4 = TextUtilities.getWordEnd(editorPane, n3, false);
                    editorPane.setCaretPosition(n3);
                    editorPane.moveCaretPosition(n4);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public SelectWordAction() {
            super("select-word");
            this.putValue("LongDescription", a.a(268));
            this.putValue("ActionGroup", a.a(270));
        }
    }

    public static class PreviousBookmarkAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            BookmarkManager.previousBookmark(editorPane);
        }

        public PreviousBookmarkAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(196));
            this.putValue("ActionGroup", a.a(34));
        }
    }

    public static class NextBookmarkAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            BookmarkManager.nextBookmark(editorPane);
        }

        public NextBookmarkAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(176));
            this.putValue("ActionGroup", a.a(34));
        }
    }

    public static class GotoBookmarkAction
    extends EditorAction {
        private int a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            BookmarkManager.gotoBookmark(this.a, editorPane);
        }

        public GotoBookmarkAction(String string, int n2) {
            super(string);
            this.a = n2;
            this.putValue("LongDescription", com.borland.primetime.editor.a.a(140));
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(34));
        }
    }

    public static class ClearBookmarksAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            BookmarkManager.clearBookmarks(Browser.getActiveBrowser(), editorPane);
        }

        public ClearBookmarksAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(67));
            this.putValue("ActionGroup", a.a(34));
        }
    }

    public static class SetBookmarkAction
    extends EditorAction {
        private int a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            BookmarkManager.addBookmark(editorPane.getCaretPosition(), this.a, editorPane);
        }

        public SetBookmarkAction(String string, int n2) {
            super(string);
            this.a = n2;
            this.putValue("LongDescription", com.borland.primetime.editor.a.a(272));
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(34));
        }
    }

    public static class ToggleBookmarkAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            BookmarkManager.toggleBookmark(editorPane.getCaretPosition(), editorPane);
        }

        public ToggleBookmarkAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(299));
            this.putValue("ActionGroup", a.a(34));
        }
    }

    public static class GotoLineDialogAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                GotoLineDialog gotoLineDialog = new GotoLineDialog(editorPane);
                ((Component)gotoLineDialog).setVisible(true);
            }
        }

        public GotoLineDialogAction() {
            super("goto-line");
            this.putValue("LongDescription", a.a(142));
            this.putValue("ActionGroup", a.a(226));
        }
    }

    public static class ScrollDownAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                Rectangle rectangle = new Rectangle();
                editorPane.computeVisibleRect(rectangle);
                int n2 = editorPane.getScrollableUnitIncrement(rectangle, 1, 1);
                rectangle.y += n2;
                editorPane.scrollRectToVisible(rectangle);
                int n3 = editorPane.getCaretPosition();
                try {
                    if (n3 != -1) {
                        Rectangle rectangle2 = editorPane.modelToView(n3);
                        if (rectangle2.y < rectangle.y) {
                            Caret caret = editorPane.getCaret();
                            int n4 = caret.getDot();
                            Point point = caret.getMagicCaretPosition();
                            if (point == null) {
                                rectangle2 = editorPane.modelToView(n4);
                                point = new Point(rectangle2.x, rectangle2.y);
                                caret.setMagicCaretPosition(point);
                            }
                            n4 = Utilities.getPositionBelow((JTextComponent)editorPane, n4, point.x);
                            caret.setDot(n4);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public ScrollDownAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(223));
            this.putValue("ActionGroup", a.a(225));
        }
    }

    public static class ScrollUpAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                Rectangle rectangle = new Rectangle();
                editorPane.computeVisibleRect(rectangle);
                int n2 = editorPane.getScrollableUnitIncrement(rectangle, 1, -1);
                if (rectangle.y > 0) {
                    rectangle.y -= n2;
                }
                editorPane.scrollRectToVisible(rectangle);
                int n3 = editorPane.getCaretPosition();
                try {
                    if (n3 != -1) {
                        Rectangle rectangle2 = editorPane.modelToView(n3);
                        if (rectangle2.y >= rectangle.y + rectangle.height) {
                            Caret caret = editorPane.getCaret();
                            int n4 = caret.getDot();
                            Point point = caret.getMagicCaretPosition();
                            if (point == null) {
                                rectangle2 = editorPane.modelToView(n4);
                                point = new Point(rectangle2.x, rectangle2.y);
                                caret.setMagicCaretPosition(point);
                            }
                            n4 = Utilities.getPositionAbove((JTextComponent)editorPane, n4, point.x);
                            caret.setDot(n4);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public ScrollUpAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(224));
            this.putValue("ActionGroup", a.a(225));
        }
    }

    public static class EndAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            Document document = editorPane.getDocument();
            int n2 = document.getLength();
            ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
            if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                if (this.a) {
                    editorPane.moveCaretPosition(n2);
                } else {
                    editorPane.setCaretPosition(n2);
                }
                return;
            }
            try {
                int n3 = modeStateInfo.getMode();
                if (n3 != 1) {
                    if (this.a || n3 == 4 || n3 == 2 || n3 == 8) {
                        editorPane.moveCaretPosition(n2);
                    } else {
                        editorPane.setCaretPosition(n2);
                    }
                    return;
                }
                Caret caret = editorPane.getCaret();
                int n4 = caret.getMark();
                int n5 = caret.getDot();
                int n6 = Utilities.getRowStart(editorPane, n4);
                editorPane.moveCaretPosition(n2);
                int n7 = editorPane.getCaretPosition();
                if (n4 <= n5) {
                    n7 = Utilities.getRowEnd(editorPane, n7);
                    editorPane.moveCaretPosition(n7);
                    return;
                }
                if (caret.getDot() < n4) {
                    n7 = Utilities.getRowStart(editorPane, n7);
                    editorPane.moveCaretPosition(n7);
                    return;
                }
                editorPane.setCaretPosition(n6);
                n7 = Utilities.getRowEnd(editorPane, n7);
                editorPane.moveCaretPosition(n7);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        EndAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(256));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(108));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class BeginAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
            if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                if (this.a) {
                    editorPane.moveCaretPosition(0);
                } else {
                    editorPane.setCaretPosition(0);
                }
                return;
            }
            try {
                int n2 = modeStateInfo.getMode();
                if (n2 != 1) {
                    if (this.a || n2 == 4 || n2 == 2 || n2 == 8) {
                        editorPane.moveCaretPosition(0);
                    } else {
                        editorPane.setCaretPosition(0);
                    }
                    return;
                }
                Caret caret = editorPane.getCaret();
                int n3 = caret.getMark();
                int n4 = caret.getDot();
                int n5 = Utilities.getRowEnd(editorPane, n3);
                editorPane.moveCaretPosition(0);
                if (n4 <= n3) {
                    return;
                }
                int n6 = editorPane.getCaretPosition();
                if (caret.getDot() >= n3) {
                    n6 = Utilities.getRowEnd(editorPane, n6);
                    editorPane.moveCaretPosition(n6);
                    return;
                }
                editorPane.setCaretPosition(n5);
                n6 = Utilities.getRowStart(editorPane, n6);
                editorPane.moveCaretPosition(n6);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        BeginAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(251));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(23));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class PageRightAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                Rectangle rectangle = new Rectangle();
                editorPane.computeVisibleRect(rectangle);
                int n2 = editorPane.getScrollableBlockIncrement(rectangle, 0, 4);
                rectangle.x += n2;
                if (rectangle.x + rectangle.width > editorPane.getSize().width) {
                    rectangle.x = Math.max(0, editorPane.getSize().width - rectangle.width);
                }
                editorPane.scrollRectToVisible(rectangle);
            }
        }

        public PageRightAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(187));
            this.putValue("ActionGroup", a.a(225));
        }
    }

    public static class PageLeftAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                Rectangle rectangle = new Rectangle();
                editorPane.computeVisibleRect(rectangle);
                int n2 = editorPane.getScrollableBlockIncrement(rectangle, 0, 2);
                rectangle.x -= n2;
                if (rectangle.x < 0) {
                    rectangle.x = 0;
                }
                editorPane.scrollRectToVisible(rectangle);
            }
        }

        public PageLeftAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(186));
            this.putValue("ActionGroup", a.a(225));
        }
    }

    public static class PageDownAction
    extends EditorAction {
        private boolean a;

        public void realActionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                Rectangle rectangle = new Rectangle();
                editorPane.computeVisibleRect(rectangle);
                int n2 = rectangle.y;
                int n3 = editorPane.getScrollableBlockIncrement(rectangle, 1, 3);
                rectangle.y += (n3 -= editorPane.getScrollableUnitIncrement(rectangle, 1, 3));
                if (rectangle.y + n3 > editorPane.getHeight()) {
                    rectangle.y = editorPane.getHeight() - rectangle.height;
                }
                n2 = rectangle.y - n2;
                editorPane.scrollRectToVisible(rectangle);
                int n4 = editorPane.getCaretPosition();
                try {
                    if (n4 != -1) {
                        Document document = editorPane.getDocument();
                        Element element = document.getDefaultRootElement();
                        int n5 = element.getElementIndex(n4);
                        Element element2 = element.getElement(n5);
                        int n6 = element2.getStartOffset();
                        int n7 = n4 - n6;
                        int n8 = n3 / editorPane.getFontHeight();
                        n5 = Math.min(element.getElementCount() - 1, n5 + n8);
                        element2 = element.getElement(n5);
                        n6 = element2.getStartOffset();
                        int n9 = Math.min(n6 + n7, element2.getEndOffset() - 1);
                        if (this.a) {
                            editorPane.moveCaretPosition(n9);
                        } else {
                            editorPane.setCaretPosition(n9);
                        }
                    }
                }
                catch (Exception exception) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane == null) {
                    return;
                }
                ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
                if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                    this.realActionPerformed(actionEvent);
                    return;
                }
                boolean bl = this.a;
                int n2 = modeStateInfo.getMode();
                if (n2 != 1) {
                    if (n2 == 4 || n2 == 2 || n2 == 8) {
                        this.a = true;
                    }
                    this.realActionPerformed(actionEvent);
                    this.a = bl;
                    return;
                }
                Caret caret = editorPane.getCaret();
                int n3 = caret.getMark();
                int n4 = caret.getDot();
                int n5 = Utilities.getRowStart(editorPane, n3);
                this.a = true;
                this.realActionPerformed(actionEvent);
                this.a = bl;
                int n6 = editorPane.getCaretPosition();
                if (n3 <= n4) {
                    n6 = Utilities.getRowEnd(editorPane, n6);
                    editorPane.moveCaretPosition(n6);
                    return;
                }
                if (caret.getDot() < n3) {
                    return;
                }
                editorPane.setCaretPosition(n5);
                n6 = Utilities.getRowEnd(editorPane, n6);
                editorPane.moveCaretPosition(n6);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public PageDownAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(263));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(185));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(225));
            }
        }
    }

    public static class PageUpAction
    extends EditorAction {
        private boolean a;

        public void realActionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                Rectangle rectangle = new Rectangle();
                editorPane.computeVisibleRect(rectangle);
                int n2 = rectangle.y;
                int n3 = editorPane.getScrollableBlockIncrement(rectangle, 1, 1);
                rectangle.y -= (n3 -= editorPane.getScrollableUnitIncrement(rectangle, 1, 3));
                if (rectangle.y < 0) {
                    rectangle.y = 0;
                }
                n2 -= rectangle.y;
                editorPane.scrollRectToVisible(rectangle);
                int n4 = editorPane.getCaretPosition();
                try {
                    if (n4 != -1) {
                        Document document = editorPane.getDocument();
                        Element element = document.getDefaultRootElement();
                        int n5 = element.getElementIndex(n4);
                        Element element2 = element.getElement(n5);
                        int n6 = element2.getStartOffset();
                        int n7 = n4 - n6;
                        int n8 = n3 / editorPane.getFontHeight();
                        n5 = Math.max(0, n5 - n8);
                        element2 = element.getElement(n5);
                        n6 = element2.getStartOffset();
                        int n9 = Math.min(n6 + n7, element2.getEndOffset() - 1);
                        if (this.a) {
                            editorPane.moveCaretPosition(n9);
                        } else {
                            editorPane.setCaretPosition(n9);
                        }
                    }
                }
                catch (Exception exception) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane == null) {
                    return;
                }
                ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
                if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                    this.realActionPerformed(actionEvent);
                    return;
                }
                boolean bl = this.a;
                int n2 = modeStateInfo.getMode();
                if (n2 != 1) {
                    if (n2 == 4 || n2 == 2 || n2 == 8) {
                        this.a = true;
                    }
                    this.realActionPerformed(actionEvent);
                    this.a = bl;
                    return;
                }
                Caret caret = editorPane.getCaret();
                int n3 = caret.getMark();
                int n4 = caret.getDot();
                int n5 = Utilities.getRowEnd(editorPane, n3);
                this.a = true;
                this.realActionPerformed(actionEvent);
                this.a = bl;
                if (n4 <= n3) {
                    return;
                }
                int n6 = editorPane.getCaretPosition();
                if (caret.getDot() > n3) {
                    n6 = Utilities.getRowEnd(editorPane, n6);
                    editorPane.moveCaretPosition(n6);
                    return;
                }
                editorPane.setCaretPosition(n5);
                n6 = Utilities.getRowStart(editorPane, n6);
                editorPane.moveCaretPosition(n6);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public PageUpAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(264));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(188));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(225));
            }
        }
    }

    public static class BottomOfScreenAction
    extends EditorAction {
        private boolean a;

        public void realActionPerformed(ActionEvent actionEvent) {
            block3: {
                EditorPane editorPane = this.getEditorTarget(actionEvent);
                if (editorPane == null) break block3;
                Rectangle rectangle = new Rectangle();
                editorPane.computeVisibleRect(rectangle);
                int n2 = editorPane.getCaretPosition();
                try {
                    if (n2 == -1) break block3;
                    Rectangle rectangle2 = editorPane.modelToView(n2);
                    int n3 = editorPane.getHeight() % editorPane.getFontHeight();
                    n2 = editorPane.viewToModel(new Point(rectangle2.x, rectangle.y + rectangle.height - n3 - editorPane.getFontHeight() / 2));
                    if (this.a) {
                        editorPane.moveCaretPosition(n2);
                        break block3;
                    }
                    editorPane.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane == null) {
                    return;
                }
                ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
                if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                    this.realActionPerformed(actionEvent);
                    return;
                }
                boolean bl = this.a;
                int n2 = modeStateInfo.getMode();
                if (n2 != 1) {
                    if (this.a || n2 == 4 || n2 == 2 || n2 == 8) {
                        this.a = true;
                        this.realActionPerformed(actionEvent);
                        this.a = bl;
                        int n3 = editorPane.getCaretPosition();
                        editorPane.moveCaretPosition(Utilities.getRowEnd(editorPane, n3));
                    } else {
                        this.realActionPerformed(actionEvent);
                        int n4 = editorPane.getCaretPosition();
                        editorPane.setCaretPosition(Utilities.getRowEnd(editorPane, n4));
                    }
                    return;
                }
                Caret caret = editorPane.getCaret();
                int n5 = caret.getMark();
                int n6 = caret.getDot();
                int n7 = Utilities.getRowStart(editorPane, n5);
                this.a = true;
                this.realActionPerformed(actionEvent);
                this.a = bl;
                int n8 = editorPane.getCaretPosition();
                if (n5 <= n6) {
                    n8 = Utilities.getRowEnd(editorPane, n8);
                    editorPane.moveCaretPosition(n8);
                    return;
                }
                if (caret.getDot() < n5) {
                    n8 = Utilities.getRowStart(editorPane, n8);
                    editorPane.moveCaretPosition(n8);
                    return;
                }
                editorPane.setCaretPosition(n7);
                n8 = Utilities.getRowEnd(editorPane, n8);
                editorPane.moveCaretPosition(n8);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public BottomOfScreenAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(254));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(35));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class TopOfScreenAction
    extends EditorAction {
        private boolean a;

        public void realActionPerformed(ActionEvent actionEvent) {
            block3: {
                EditorPane editorPane = this.getEditorTarget(actionEvent);
                if (editorPane == null) break block3;
                Rectangle rectangle = new Rectangle();
                editorPane.computeVisibleRect(rectangle);
                int n2 = editorPane.getCaretPosition();
                try {
                    if (n2 == -1) break block3;
                    Rectangle rectangle2 = editorPane.modelToView(n2);
                    n2 = editorPane.viewToModel(new Point(rectangle2.x, rectangle.y));
                    if (this.a) {
                        editorPane.moveCaretPosition(n2);
                        break block3;
                    }
                    editorPane.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane == null) {
                    return;
                }
                ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
                if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                    this.realActionPerformed(actionEvent);
                    return;
                }
                boolean bl = this.a;
                int n2 = modeStateInfo.getMode();
                if (n2 != 1) {
                    if (n2 == 4 || n2 == 2 || n2 == 8) {
                        this.a = true;
                    }
                    this.realActionPerformed(actionEvent);
                    this.a = bl;
                    return;
                }
                Caret caret = editorPane.getCaret();
                int n3 = caret.getMark();
                int n4 = caret.getDot();
                int n5 = Utilities.getRowEnd(editorPane, n3);
                this.a = true;
                this.realActionPerformed(actionEvent);
                this.a = bl;
                if (n4 <= n3) {
                    return;
                }
                int n6 = editorPane.getCaretPosition();
                if (caret.getDot() > n3) {
                    n6 = Utilities.getRowEnd(editorPane, n6);
                    editorPane.moveCaretPosition(n6);
                    return;
                }
                editorPane.setCaretPosition(n5);
                n6 = Utilities.getRowStart(editorPane, n6);
                editorPane.moveCaretPosition(n6);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public TopOfScreenAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(266));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(302));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class EndLineAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            try {
                int n2;
                boolean bl = this.a;
                ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
                if (modeStateInfo != null && modeStateInfo.hasModalSelection) {
                    n2 = modeStateInfo.getMode();
                    if (n2 == 1) {
                        int n3 = editorPane.getCaretPosition();
                        if (Utilities.getRowEnd(editorPane, n3) == n3) {
                            return;
                        }
                        Document document = editorPane.getDocument();
                        Element element = document.getDefaultRootElement();
                        Caret caret = editorPane.getCaret();
                        int n4 = caret.getMark();
                        int n5 = caret.getDot();
                        if (element.getElementIndex(n4) == element.getElementIndex(n5)) {
                            int n6 = Utilities.getRowEnd(editorPane, n4);
                            editorPane.setCaretPosition(n6);
                            n6 = Utilities.getRowStart(editorPane, n5);
                            editorPane.moveCaretPosition(n6);
                        }
                        return;
                    }
                    if (n2 == 4 || n2 == 2 || n2 == 8) {
                        this.a = true;
                    }
                }
                n2 = editorPane.getCaretPosition();
                Document document = editorPane.getDocument();
                Element element = document.getDefaultRootElement();
                int n7 = element.getElementIndex(n2);
                Element element2 = element.getElement(n7);
                int n8 = element2.getStartOffset();
                int n9 = element2.getEndOffset();
                int n10 = n9 - n8;
                if (n10 <= 0) {
                    this.a = bl;
                    return;
                }
                int n11 = n9 - 1;
                if (EditorManager.isBooleanOptionValue("smartEnd")) {
                    Segment segment = new Segment();
                    document.getText(n8, n10, segment);
                    for (int i2 = segment.offset + n10 - 1; i2 >= segment.offset; --i2) {
                        char c2 = segment.array[i2];
                        if (c2 == ' ' || c2 == '\t' || c2 == '\n') continue;
                        int n12 = n8 + i2 - segment.offset + 1;
                        if (n2 == n12) break;
                        n11 = n12;
                        break;
                    }
                }
                if (this.a) {
                    editorPane.moveCaretPosition(n11);
                } else {
                    editorPane.setCaretPosition(n11);
                }
                this.a = bl;
            }
            catch (BadLocationException badLocationException) {
                editorPane.getToolkit().beep();
            }
        }

        public EndLineAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(257));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(109));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class BeginLineAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            try {
                int n2;
                boolean bl = this.a;
                ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
                if (modeStateInfo != null && modeStateInfo.hasModalSelection) {
                    n2 = modeStateInfo.getMode();
                    if (n2 == 1) {
                        int n3 = editorPane.getCaretPosition();
                        if (Utilities.getRowStart(editorPane, n3) == n3) {
                            return;
                        }
                        Document document = editorPane.getDocument();
                        Element element = document.getDefaultRootElement();
                        Caret caret = editorPane.getCaret();
                        int n4 = caret.getMark();
                        int n5 = caret.getDot();
                        if (element.getElementIndex(n4) == element.getElementIndex(n5)) {
                            int n6 = Utilities.getRowEnd(editorPane, n4);
                            editorPane.setCaretPosition(n6);
                            n6 = Utilities.getRowStart(editorPane, n5);
                            editorPane.moveCaretPosition(n6);
                        }
                        return;
                    }
                    if (n2 == 4 || n2 == 2 || n2 == 8) {
                        this.a = true;
                    }
                }
                n2 = editorPane.getCaretPosition();
                Document document = editorPane.getDocument();
                Element element = document.getDefaultRootElement();
                int n7 = element.getElementIndex(n2);
                Element element2 = element.getElement(n7);
                int n8 = element2.getStartOffset();
                int n9 = element2.getEndOffset();
                int n10 = n9 - n8;
                if (n10 <= 0) {
                    this.a = bl;
                    return;
                }
                int n11 = n8;
                if (EditorManager.isBooleanOptionValue("smartHome")) {
                    Segment segment = new Segment();
                    document.getText(n8, n10, segment);
                    for (int i2 = segment.offset; i2 < segment.offset + segment.count; ++i2) {
                        char c2 = segment.array[i2];
                        if (c2 == ' ' || c2 == '\t') continue;
                        int n12 = n8 + i2 - segment.offset;
                        if (n2 == n12) break;
                        n11 = n12;
                        break;
                    }
                }
                if (this.a) {
                    editorPane.moveCaretPosition(n11);
                } else {
                    editorPane.setCaretPosition(n11);
                }
                this.a = bl;
            }
            catch (BadLocationException badLocationException) {
                editorPane.getToolkit().beep();
            }
        }

        public BeginLineAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(252));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(24));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class NextWordAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    n2 = TextUtilities.getNextWord(editorPane, n2);
                    if (this.a) {
                        editorPane.moveCaretPosition(n2);
                    } else {
                        editorPane.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public NextWordAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(262));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(177));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class PreviousWordAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    n2 = TextUtilities.getPreviousWord(editorPane, n2);
                    if (this.a) {
                        editorPane.moveCaretPosition(n2);
                    } else {
                        editorPane.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public PreviousWordAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(265));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(199));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class EndWordAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordEnd(editorPane, n2);
                    if (this.a) {
                        editorPane.moveCaretPosition(n3);
                    } else {
                        editorPane.setCaretPosition(n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public EndWordAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(258));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(110));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class BeginWordAction
    extends EditorAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordStart(editorPane, n2);
                    if (this.a) {
                        editorPane.moveCaretPosition(n3);
                    } else {
                        editorPane.setCaretPosition(n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public BeginWordAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(253));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(270));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(25));
                this.putValue("ActionGroup", com.borland.primetime.editor.a.a(57));
            }
        }
    }

    public static class NextVisualPositionAction
    extends EditorAction {
        private int b;
        protected boolean select;

        public void actionPerformed(ActionEvent actionEvent) {
            block11: {
                EditorPane editorPane = this.getEditorTarget(actionEvent);
                if (editorPane == null) break block11;
                Caret caret = editorPane.getCaret();
                int n2 = caret.getDot();
                Position.Bias[] biasArray = new Position.Bias[1];
                try {
                    Point point = null;
                    switch (this.b) {
                        case 1: 
                        case 5: {
                            point = caret.getMagicCaretPosition();
                            if (point == null) {
                                Rectangle rectangle = editorPane.modelToView(n2);
                                point = new Point(rectangle.x, rectangle.y);
                            }
                            if (this.b == 1) {
                                if ((n2 = Utilities.getPositionAbove((JTextComponent)editorPane, n2, point.x)) >= 0) break;
                                n2 = 0;
                                break;
                            }
                            n2 = Utilities.getPositionBelow((JTextComponent)editorPane, n2, point.x);
                            break;
                        }
                        case 3: 
                        case 7: {
                            n2 = editorPane.getUI().getNextVisualPositionFrom(editorPane, n2, Position.Bias.Forward, this.b, biasArray);
                            break;
                        }
                    }
                    if (this.select) {
                        caret.moveDot(n2);
                    } else {
                        caret.setDot(n2);
                    }
                    if (this.b == 1 || this.b == 5) {
                        caret.setMagicCaretPosition(point);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public NextVisualPositionAction(String string, boolean bl, int n2) {
            super(string);
            this.select = bl;
            this.b = n2;
        }
    }

    public static class BackwardAction
    extends NextVisualPositionAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            Caret caret;
            int n3;
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
            if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                super.actionPerformed(actionEvent);
                return;
            }
            int n4 = modeStateInfo.getMode();
            if (n4 == 1) {
                modeStateInfo.setMode(0);
            } else if ((n4 == 8 || n4 == 2) && (n3 = (caret = editorPane.getCaret()).getMark()) + 1 == (n2 = caret.getDot())) {
                editorPane.setCaretPosition(n2);
                editorPane.moveCaretPosition(n3);
            }
            boolean bl = this.select;
            if (modeStateInfo.getMode() != 0) {
                this.select = true;
            }
            super.actionPerformed(actionEvent);
            this.select = bl;
        }

        public BackwardAction(String string, boolean bl) {
            super(string, bl, 7);
            if (bl) {
                this.putValue("LongDescription", a.a(250));
                this.putValue("ActionGroup", a.a(270));
            } else {
                this.putValue("LongDescription", a.a(19));
                this.putValue("ActionGroup", a.a(57));
            }
        }
    }

    public static class ForwardAction
    extends NextVisualPositionAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            Caret caret;
            int n3;
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
            if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                super.actionPerformed(actionEvent);
                return;
            }
            int n4 = modeStateInfo.getMode();
            if (n4 == 1) {
                modeStateInfo.setMode(0);
            } else if ((n4 == 2 || n4 == 8) && (n3 = (caret = editorPane.getCaret()).getMark()) == (n2 = caret.getDot()) + 1) {
                editorPane.setCaretPosition(n2);
                editorPane.moveCaretPosition(n3);
            }
            boolean bl = this.select;
            if (modeStateInfo.getMode() != 0) {
                this.select = true;
            }
            super.actionPerformed(actionEvent);
            this.select = bl;
        }

        public ForwardAction(String string, boolean bl) {
            super(string, bl, 3);
            this.select = bl;
            if (bl) {
                this.putValue("LongDescription", a.a(259));
                this.putValue("ActionGroup", a.a(270));
            } else {
                this.putValue("LongDescription", a.a(133));
                this.putValue("ActionGroup", a.a(57));
            }
        }
    }

    public static class DownAction
    extends NextVisualPositionAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
            if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                super.actionPerformed(actionEvent);
                return;
            }
            try {
                boolean bl = this.select;
                if (modeStateInfo.getMode() != 1) {
                    int n2 = modeStateInfo.getMode();
                    if (n2 == 4 || n2 == 2 || n2 == 8) {
                        this.select = true;
                    }
                    super.actionPerformed(actionEvent);
                    this.select = bl;
                    return;
                }
                Caret caret = editorPane.getCaret();
                int n3 = caret.getMark();
                int n4 = caret.getDot();
                int n5 = editorPane.getCaretPosition();
                int n6 = Utilities.getRowStart(editorPane, n5);
                int n7 = Utilities.getRowEnd(editorPane, n5);
                if (n4 == n6 && n3 == n7) {
                    editorPane.setCaretPosition(n6);
                    editorPane.moveCaretPosition(n7);
                    n4 = caret.getDot();
                    n3 = caret.getMark();
                }
                this.select = true;
                super.actionPerformed(actionEvent);
                this.select = bl;
                n5 = editorPane.getCaretPosition();
                if (n5 > n3) {
                    n7 = Utilities.getRowEnd(editorPane, n5);
                    editorPane.moveCaretPosition(n7);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public DownAction(String string, boolean bl) {
            super(string, bl, 5);
            if (bl) {
                this.putValue("LongDescription", a.a(255));
                this.putValue("ActionGroup", a.a(270));
            } else {
                this.putValue("LongDescription", a.a(101));
                this.putValue("ActionGroup", a.a(57));
            }
        }
    }

    public static class UpAction
    extends NextVisualPositionAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
            if (modeStateInfo == null || !modeStateInfo.hasModalSelection) {
                super.actionPerformed(actionEvent);
                return;
            }
            try {
                boolean bl = this.select;
                int n2 = modeStateInfo.getMode();
                if (n2 != 1) {
                    if (n2 == 4 || n2 == 2 || n2 == 8) {
                        this.select = true;
                    }
                    super.actionPerformed(actionEvent);
                    this.select = bl;
                    return;
                }
                Caret caret = editorPane.getCaret();
                int n3 = caret.getMark();
                int n4 = caret.getDot();
                int n5 = editorPane.getCaretPosition();
                int n6 = Utilities.getRowStart(editorPane, n5);
                int n7 = Utilities.getRowEnd(editorPane, n5);
                if (n4 == n7 && n3 == n6) {
                    editorPane.setCaretPosition(n7);
                    editorPane.moveCaretPosition(n6);
                    n4 = caret.getDot();
                    n3 = caret.getMark();
                }
                this.select = true;
                super.actionPerformed(actionEvent);
                this.select = bl;
                n5 = editorPane.getCaretPosition();
                if (n5 > n3) {
                    n7 = Utilities.getRowEnd(editorPane, n5);
                    editorPane.moveCaretPosition(n7);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public UpAction(String string, boolean bl) {
            super(string, bl, 1);
            if (bl) {
                this.putValue("LongDescription", a.a(267));
                this.putValue("ActionGroup", a.a(270));
            } else {
                this.putValue("LongDescription", a.a(312));
                this.putValue("ActionGroup", a.a(57));
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends EditorAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && actionEvent != null) {
                if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                    return;
                }
                try {
                    char c2;
                    String string = actionEvent.getActionCommand();
                    int n2 = actionEvent.getModifiers();
                    if (string != null && string.length() > 0 && ((n2 & 8) == 0 || Platform.MAC) && (n2 & 2) == 0 && (n2 & 4) == 0 && (c2 = string.charAt(0)) >= ' ' && c2 != '\u007f') {
                        int n3;
                        Caret caret = editorPane.getCaret();
                        int n4 = caret.getDot();
                        if (n4 != (n3 = caret.getMark())) {
                            editorPane.replaceSelection(string);
                        } else if (EditorManager.isInsertMode()) {
                            editorPane.insertChar(string);
                        } else {
                            int n5 = editorPane.getCaretPosition();
                            char c3 = editorPane.getText(n5, 1).charAt(0);
                            if (c3 != '\n') {
                                editorPane.overwriteChar(string);
                            } else {
                                editorPane.insertChar(string);
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("BadLocationException: p0: ").append(editorPane.getCaretPosition()).append(", length: ").append(editorPane.getText().length()))));
                }
            }
        }

        public DefaultKeyTypedAction() {
            super("default-typed");
            this.putValue("LongDescription", a.a(80));
            this.putValue("ActionGroup", a.a(175));
        }
    }

    public static interface KeymapSwitchAction {
    }
}

