/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.vfs;

import com.borland.primetime.editor.EditorPropertyGroup;
import com.borland.primetime.info.InfoStore;
import com.borland.primetime.teamdev.vcs.VCSUtils;
import com.borland.primetime.util.RegularExpression;
import com.borland.primetime.vfs.AbstractFilesystem;
import com.borland.primetime.vfs.Filesystem;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.ZipFilesystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class FileFilesystem
extends AbstractFilesystem
implements Filesystem {
    public static final FileFilesystem FILESYSTEM;
    public static final String PROTOCOL = "file";

    static {
        PROTOCOL = PROTOCOL;
        FILESYSTEM = new FileFilesystem();
    }

    public String getRelativePath(Url url, Url url2, int n2) {
        String string;
        if (url2.getFilesystem() instanceof ZipFilesystem) {
            url2 = new Url(this, url2.getHost(), url2.getFile().substring(1), url2.getAnchor());
        }
        if ((string = super.getRelativePath(url, url2, n2)) == null) {
            return null;
        }
        if (string.indexOf(93) != -1 && string.charAt(0) != '[') {
            string = String.valueOf(String.valueOf('[')).concat(String.valueOf(String.valueOf(string)));
        }
        return string;
    }

    public boolean isValid(Url url) {
        return url.getHost().length() == 0 && super.isValid(url);
    }

    public Url getRelativeUrl(Url url, String string) {
        if (string.length() >= 1 && string.charAt(0) == '[') {
            Url url2 = ZipFilesystem.FILESYSTEM.getAbsoluteUrl("", string);
            if (url2 != null) {
                return url2;
            }
            return super.getRelativeUrl(url, string.substring(1));
        }
        return super.getRelativeUrl(url, string);
    }

    public File getFileObject(Url url) {
        File file = (File)url.getFilesystemObject();
        if (file == null) {
            String string = String.valueOf(String.valueOf(url.getFile().replace('/', File.separatorChar))).concat(String.valueOf(String.valueOf(File.separatorChar)));
            file = new File(string);
            file = file.getAbsoluteFile();
            url.setFilesystemObject(file);
        }
        return file;
    }

    public String getName(Url url) {
        File file = this.getFileObject(url);
        if (file != null) {
            String string = file.getName();
            if (string.length() == 0) {
                return file.getAbsolutePath();
            }
            return string;
        }
        return file.getName();
    }

    public boolean fileEquals(Url url, Url url2) {
        File file = this.getFileObject(url);
        if (file == null) {
            return false;
        }
        return file.equals(this.getFileObject(url2));
    }

    public int fileHashCode(Url url) {
        return this.getFileObject(url).hashCode();
    }

    public Url getAbsoluteUrl(String string, String string2) {
        File file;
        if (string2.length() == 2 && string2.charAt(1) == ':') {
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(File.separatorChar)));
        }
        if ((file = new File(string2)).isAbsolute()) {
            return new Url(this, string, file.getAbsolutePath().replace(File.separatorChar, '/'), null);
        }
        return null;
    }

    public Url getParent(Url url) {
        File file = new File(url.getFile().replace('/', File.separatorChar));
        String string = file.getParent();
        if (string == null) {
            return null;
        }
        return new Url(this, url.getHost(), string.replace(File.separatorChar, '/'), null);
    }

    public Url getChild(Url url, String string) {
        String string2 = url.getFile();
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string2.endsWith("/") ? string : String.valueOf(String.valueOf('/')).concat(String.valueOf(String.valueOf(string))))));
        if (string.endsWith("]")) {
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf('/')));
            return new Url(ZipFilesystem.FILESYSTEM, url.getHost(), String.valueOf(String.valueOf('[')).concat(String.valueOf(String.valueOf(string2))), null);
        }
        return new Url(this, url.getHost(), string2, null);
    }

    public Url[] getChildren(Url url, RegularExpression[] regularExpressionArray, int n2) {
        File file = this.getFileObject(url);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return Url.EMPTY_ARRAY;
        }
        ArrayList<Url> arrayList = new ArrayList<Url>();
        if (regularExpressionArray == null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                if (n2 != 3 && new File(file, string).isDirectory() != (n2 == 1)) continue;
                arrayList.add(new Url(FILESYSTEM, "", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(url.getFile()))).append('/').append(string))), null));
            }
        } else {
            int n3 = regularExpressionArray.length;
            block1: for (int i3 = 0; i3 < stringArray.length; ++i3) {
                File file2 = new File(file, stringArray[i3]);
                boolean bl = file2.isDirectory();
                if (bl) {
                    if (n2 != 3 && n2 != 1) continue;
                    arrayList.add(new Url(file2));
                    continue;
                }
                String string = file2.getName();
                if (n2 != 3 && n2 != 2) continue;
                for (int i4 = 0; i4 < n3; ++i4) {
                    if (!regularExpressionArray[i4].exactMatch(string)) continue;
                    arrayList.add(new Url(file2));
                    continue block1;
                }
            }
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    public boolean isDirectory(Url url) {
        return this.getFileObject(url).isDirectory();
    }

    public void delete(Url url) throws IOException {
        File file = this.getFileObject(url);
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new IOException();
            }
            if (!file.delete()) {
                throw new IOException();
            }
        }
    }

    public boolean exists(Url url) {
        return this.getFileObject(url).exists();
    }

    public Url getCanonicalUrl(Url url) {
        try {
            url = new Url(url.getProtocol(), url.getHost(), this.getFileObject(url).getCanonicalPath().replace('\\', '/'), url.getAnchor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public boolean setLastModified(Url url, long l2) {
        return this.getFileObject(url).setLastModified(l2);
    }

    public long getLastModified(Url url) {
        long l2 = this.getFileObject(url).lastModified();
        return l2 == (long)0 ? Long.MIN_VALUE : l2;
    }

    public boolean isReadOnly(Url url) {
        File file = this.getFileObject(url);
        if (file.exists()) {
            return !file.canWrite();
        }
        return false;
    }

    public OutputStream getOutputStream(Url url) throws IOException {
        File file = this.getFileObject(url);
        Url url2 = url;
        if (file.exists()) {
            file.renameTo(new File(String.valueOf(String.valueOf(file.getAbsolutePath())).concat(String.valueOf(String.valueOf('~')))));
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(url.getFile());
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getFileObject(url).getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(url.getFile());
            return fileOutputStream;
        }
    }

    public OutputStream getOutputStream(Url url, boolean bl) throws IOException {
        File file = this.getFileObject(url);
        Url url2 = url;
        if (bl && file.exists()) {
            VCSUtils.makeLocalBackup(url, EditorPropertyGroup.BACKUP_LEVEL.getInteger());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(url.getFile());
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getFileObject(url).getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(url.getFile());
            return fileOutputStream;
        }
    }

    public InputStream getInputStream(Url url) throws IOException {
        return new FileInputStream(url.getFile());
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    private FileFilesystem() {
    }

    public static void initOpenTool(byte by, byte by2) {
        if (new InfoStore().equals(Boolean.TRUE)) {
            Url.registerFilesystem(FILESYSTEM);
        }
    }
}

