/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.vfs;

import com.borland.primetime.util.RegularExpression;
import com.borland.primetime.util.Streams;
import com.borland.primetime.util.WeakValueHashMap;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.Filesystem;
import com.borland.primetime.vfs.ReadOnlyException;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFSListener;
import com.borland.primetime.vfs.j;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public final class VFS {
    private static ArrayList a;
    private static HashMap b;

    static {
        b = new WeakValueHashMap();
    }

    public static synchronized void fireBufferConflict(Buffer buffer) {
        if (a != null) {
            Iterator iterator = ((AbstractList)((ArrayList)a.clone())).iterator();
            while (iterator.hasNext()) {
                ((VFSListener)iterator.next()).bufferConflict(buffer);
            }
        }
    }

    public static synchronized void removeVFSListener(VFSListener vFSListener) {
        if (a == null) {
            return;
        }
        ((AbstractCollection)a).remove(vFSListener);
        if (a.isEmpty()) {
            a = null;
        }
    }

    public static synchronized void addVFSListener(VFSListener vFSListener) {
        if (a == null) {
            a = new ArrayList(2);
        }
        a.add(vFSListener);
    }

    public static synchronized void copy(Url url, Url url2) throws IOException {
        Object object;
        Object object2;
        if (url.equals(url2)) {
            return;
        }
        if (!VFS.exists(url)) {
            throw new FileNotFoundException();
        }
        if (VFS.exists(url2)) {
            VFS.delete(url2);
        }
        Filesystem filesystem = url.getFilesystem();
        Filesystem filesystem2 = url2.getFilesystem();
        if (filesystem.exists(url)) {
            IOException iOException3;
            block20: {
                object2 = null;
                object = null;
                try {
                    object2 = filesystem.getInputStream(url);
                    object = filesystem2.getOutputStream(url2, false);
                    Streams.copy((InputStream)object2, (OutputStream)object);
                    Object var7_7 = null;
                    if (object == null) break block20;
                }
                catch (Throwable throwable) {
                    IOException iOException22;
                    Object var7_8 = null;
                    if (object != null) {
                        try {
                            ((OutputStream)object).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (object2 != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    ((OutputStream)object).close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                try {
                    ((InputStream)object2).close();
                }
                catch (IOException iOException3) {}
            }
        }
        if ((object2 = VFS.findBuffer(url)) != null && ((Buffer)object2).isModified()) {
            try {
                object = VFS.getBuffer(url2);
                ((Buffer)object).setContent(((Buffer)object2).getContent());
            }
            catch (ReadOnlyException readOnlyException) {}
        } else {
            object = VFS.findBuffer(url2);
            if (object != null) {
                ((Buffer)object).revert();
            }
        }
    }

    public static synchronized void rename(Url url, Url url2) throws IOException, FileNotFoundException, ReadOnlyException {
        if (VFS.isReadOnly(url)) {
            throw new ReadOnlyException();
        }
        if (url.equals(url2)) {
            InputStream inputStream;
            Filesystem filesystem = url.getFilesystem();
            try {
                byte[] byArray;
                inputStream = filesystem.getInputStream(url);
                try {
                    byArray = Streams.read(inputStream);
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                OutputStream outputStream = filesystem.getOutputStream(url2, true);
                outputStream.close();
                filesystem.delete(url);
                outputStream = filesystem.getOutputStream(url2, false);
                try {
                    outputStream.write(byArray);
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                {
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            inputStream = b.remove(url);
            if (inputStream != null) {
                b.put(url2, inputStream);
            }
            return;
        }
        VFS.copy(url, url2);
        VFS.delete(url);
    }

    public static void delete(Url url) throws IOException {
        url.getFilesystem().delete(url);
        Buffer buffer = VFS.findBuffer(url);
        if (buffer != null) {
            buffer.revert();
        }
    }

    public static Url[] getChildren(Url url, RegularExpression[] regularExpressionArray, int n2) {
        Filesystem filesystem = url.getFilesystem();
        Url[] urlArray = filesystem.getChildren(url, regularExpressionArray, n2);
        Url[] urlArray2 = Buffer.a(url, regularExpressionArray, n2);
        if (urlArray2 != null) {
            HashSet<Url> hashSet = new HashSet<Url>();
            hashSet.addAll(Arrays.asList(urlArray));
            hashSet.addAll(Arrays.asList(urlArray2));
            return ((AbstractCollection)hashSet).toArray(new Url[hashSet.size()]);
        }
        return urlArray;
    }

    public static Url[] getChildren(Url url, RegularExpression regularExpression, int n2) {
        return VFS.getChildren(url, new RegularExpression[]{regularExpression}, n2);
    }

    public static Url[] getChildren(Url url, int n2) {
        return VFS.getChildren(url, null, n2);
    }

    public static boolean isDirectory(Url url) {
        if (Buffer.a(url)) {
            return true;
        }
        return url.getFilesystem().isDirectory(url);
    }

    public static boolean exists(Url url) {
        Buffer buffer = VFS.findBuffer(url);
        if (buffer != null && buffer.b()) {
            return true;
        }
        return url.getFilesystem().exists(url);
    }

    public static Url getCanonicalUrl(Url url) {
        return url.getFilesystem().getCanonicalUrl(url);
    }

    public static long getLastModified(Url url) {
        Buffer buffer = VFS.findBuffer(url);
        if (buffer != null) {
            return buffer.getLastModified();
        }
        return url.getFilesystem().getLastModified(url);
    }

    public static boolean isReadOnly(Url url) {
        return url.getFilesystem().isReadOnly(url);
    }

    public static OutputStream getOutputStream(Url url) throws IOException {
        Buffer buffer = VFS.findBuffer(url);
        if (buffer != null) {
            return new j(buffer.getOutputStream(), url, buffer);
        }
        return url.getFilesystem().getOutputStream(url);
    }

    public static OutputStream getOutputStream(Url url, boolean bl) throws IOException {
        Buffer buffer = VFS.findBuffer(url);
        if (buffer != null) {
            return new j(buffer.getOutputStream(), url, buffer);
        }
        return url.getFilesystem().getOutputStream(url, bl);
    }

    public static InputStream getInputStream(Url url) throws IOException {
        Buffer buffer = VFS.findBuffer(url);
        if (buffer != null) {
            buffer.check();
            return buffer.getInputStream();
        }
        return url.getFilesystem().getInputStream(url);
    }

    public static synchronized Buffer findBuffer(Url url) {
        return (Buffer)b.get(url.withAnchor(null));
    }

    public static synchronized Buffer getBuffer(Url url) throws IOException {
        Buffer buffer = VFS.findBuffer(url);
        if (buffer != null) {
            return buffer;
        }
        url = url.withAnchor(null);
        buffer = new Buffer(url);
        b.put(url, buffer);
        return buffer;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        Streams.copy(inputStream, outputStream);
    }

    private VFS() {
    }
}

