/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.vfs.ui;

import com.borland.primetime.help.HelpTopic;
import com.borland.primetime.help.PrimetimeHelp;
import com.borland.primetime.util.Strings;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import com.borland.primetime.vfs.ui.UrlChooser;
import com.borland.primetime.vfs.ui.UrlExplorerIcons;
import com.borland.primetime.vfs.ui.UrlExplorerPage;
import com.borland.primetime.vfs.ui.UrlFilter;
import com.borland.primetime.vfs.ui.a;
import com.borland.primetime.vfs.ui.fb;
import com.borland.primetime.vfs.ui.gb;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;

public class UrlDirExplorerPage
extends UrlExplorerPage {
    private JTextField a = new JTextField();

    public HelpTopic getHelpTopic() {
        return PrimetimeHelp.TOPIC_DSelectDir;
    }

    public void okPressed(boolean bl) {
        Url[] urlArray = this.dirTree.getSelectedUrls();
        String string = this.a.getText().trim();
        if (!bl && string.length() > 0) {
            string = string.replace(File.separatorChar, '/');
            File file = new File(string);
            Url url = null;
            if (file.isAbsolute()) {
                url = new Url(file);
            } else if (urlArray != null && urlArray.length == 1) {
                url = urlArray[0].getRelativeUrl(string);
            }
            if (url != null) {
                if (urlArray != null && urlArray.length == 1 && urlArray[0].equals(url)) {
                    this.closeChooser(urlArray);
                    return;
                }
                if (!VFS.exists(url)) {
                    int n2 = JOptionPane.showConfirmDialog(this, Strings.format(com.borland.primetime.vfs.ui.a.a(33), url.getFullName()), com.borland.primetime.vfs.ui.a.a(34), 0);
                    if (n2 == 0) {
                        this.closeChooser(new Url[]{url});
                    }
                    return;
                }
                this.setDir(url);
                return;
            }
        }
        if (urlArray == null) {
            return;
        }
        if (urlArray != null && urlArray.length == 1 && VFS.isDirectory(urlArray[0]) && bl) {
            this.setDir(urlArray[0]);
            return;
        }
        if (urlArray.length > 0) {
            this.closeChooser(urlArray);
        }
    }

    public void okPressed() {
        this.okPressed(false);
    }

    public void setMultiSelectionEnabled(boolean bl) {
        this.dirTree.getSelectionModel().setSelectionMode(bl ? 4 : 1);
    }

    public void deleteSelection() {
        String string;
        Url[] urlArray = this.dirTree.getSelectedUrls();
        if (urlArray == null || urlArray.length == 0) {
            return;
        }
        String string2 = string = urlArray.length == 1 ? Strings.format(com.borland.primetime.vfs.ui.a.a(7), urlArray[0].getFile()) : com.borland.primetime.vfs.ui.a.a(5);
        if (JOptionPane.showConfirmDialog(this, string, com.borland.primetime.vfs.ui.a.a(8), 2) == 0) {
            for (int i2 = 0; i2 < urlArray.length; ++i2) {
                try {
                    VFS.delete(urlArray[i2]);
                    continue;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, Strings.format(com.borland.primetime.vfs.ui.a.a(41), urlArray[i2].getFile()), com.borland.primetime.vfs.ui.a.a(3), 0);
                }
            }
            this.refresh();
        }
    }

    public void dirSelectionChanged() {
        this.dirComboBox.setValue(this.dirTree.getSelectedNodes());
        this.a.setText("");
    }

    public UrlDirExplorerPage() {
        this.mainGroup.add(new fb(this, com.borland.primetime.vfs.ui.a.a(1), com.borland.primetime.vfs.ui.a.a(4).charAt(0), com.borland.primetime.vfs.ui.a.a(2), UrlExplorerIcons.ICON_DELETE));
        this.favoritesToolBar.setBorder(UIManager.getBorder("TextField.border"));
        this.add((Component)this.favoritesToolBar, new GridBagConstraints(0, 1, 1, 3, 0.0, 1.0, 10, 3, new Insets(0, 8, 8, 0), 0, 0));
        this.add((Component)this.dirScrollPane, new GridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
        JLabel jLabel = new JLabel(com.borland.primetime.vfs.ui.a.a(10));
        jLabel.setDisplayedMnemonic(com.borland.primetime.vfs.ui.a.a(11).charAt(0));
        jLabel.setLabelFor(this.a);
        this.add((Component)jLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 8, 8), 0, 0));
        this.add(this.a, new GridBagConstraints(2, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 8, 8), 0, 0), 0);
        this.refresh();
        this.setDir(new Url(new File(".")));
        this.dirTree.addKeyListener(this.navigateListener);
        this.dirTree.addMouseListener(this.navigateListener);
    }

    public Url getDir() {
        return this.dirTree.getSelectedUrl();
    }

    public void refresh() {
        this.dirTree.refresh();
    }

    public void setDir(Url url) {
        TreePath treePath = this.dirTree.getPath(url);
        if (treePath != null) {
            this.dirTree.expandPath(treePath);
        }
        this.dirTree.setSelectionPath(treePath);
        this.dirTree.scrollSelectionToVisible();
        if (treePath == null && url != null) {
            this.dirComboBox.setValue(new UrlExplorerPage.UrlTreeNode(this, url));
        }
    }

    public void setUrl(Url url) {
        this.setDir(url);
    }

    public void setUrlFilters(UrlFilter[] urlFilterArray) {
    }

    public static void initOpenTool(byte by, byte by2) {
        UrlChooser.registerUrlChooserPageFactory(new gb(com.borland.primetime.vfs.ui.a.a(16)));
    }
}

