/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.jb.util.VetoException;
import com.borland.jbcl.control.DatasetColumnView;
import com.borland.jbcl.control.GridControl_ColumnView;
import com.borland.jbcl.control.GridControl_DSRowHeaderManager;
import com.borland.jbcl.control.GridControl_FocusAdapter;
import com.borland.jbcl.control.GridControl_PopupSupport;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicMatrixContainer;
import com.borland.jbcl.model.BasicMatrixSelection;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ColumnMatrixSelection;
import com.borland.jbcl.model.CrossMatrixSelection;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.MatrixDataSetManager;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModel;
import com.borland.jbcl.model.MatrixSubfocusEvent;
import com.borland.jbcl.model.MatrixSubfocusListener;
import com.borland.jbcl.model.MultiColumnMatrixSelection;
import com.borland.jbcl.model.MultiRowMatrixSelection;
import com.borland.jbcl.model.RowMatrixSelection;
import com.borland.jbcl.model.SingleMatrixSelection;
import com.borland.jbcl.model.WritableMatrixModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.ColumnView;
import com.borland.jbcl.view.DefaultColumnHeaderManager;
import com.borland.jbcl.view.DefaultRowHeaderManager;
import com.borland.jbcl.view.FixedSizeVector;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.GridView;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.SizeVector;
import com.borland.jbcl.view.TextItemEditor;
import com.borland.jbcl.view.TextItemPainter;
import com.borland.jbcl.view.VariableSizeVector;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.beans.Beans;
import java.io.Serializable;

public class GridControl
extends GridView
implements MatrixSubfocusListener,
NavigationListener,
DataChangeListener,
AccessListener,
WritableMatrixModel,
DataSetAware,
BlackBox,
Serializable {
    private transient boolean dsNavigating = false;
    private transient SizeVector oldRSizes;
    private transient SizeVector oldCSizes;
    private StorageDataSet oldSDS;
    private MatrixLocation oldSubfocus;
    private ColumnView[] oldViews;
    private DataSet dataSet;
    private boolean generatedColumns = false;
    private boolean sortOnClick = true;
    private boolean navigateDataSet = false;
    private boolean userSetNavigate = true;
    private boolean selectRow = false;
    private boolean selectColumn = false;
    private boolean multiSelect = false;
    private boolean addNotifyCalled = false;
    private boolean autoInsert = true;
    private String[][] items = new String[1][1];
    protected String textureName;
    private GridControl_PopupSupport pop = new GridControl_PopupSupport(this);

    public GridControl() {
        this.buildStringGrid(null);
        this.resetSelection();
        this.addFocusListener(new GridControl_FocusAdapter(this));
        this.addSubfocusListener(this);
        this.addMouseListener(this.pop);
        this.addKeyListener(this.pop);
    }

    public void setModel(MatrixModel model) {
        if (model == this) {
            throw new IllegalArgumentException(Res.bundle.getString(76));
        }
        super.setModel(model);
    }

    public synchronized void setItems(String[][] newItems) {
        if (this.dataSet != null) {
            throw new IllegalStateException(Res.bundle.getString(75));
        }
        this.buildStringGrid(newItems);
    }

    public synchronized String[][] getItems() {
        MatrixModel mod = this.getModel();
        if (mod == null || mod instanceof MatrixDataSetManager) {
            return new String[0][0];
        }
        int rows = mod.getRowCount();
        int cols = mod.getColumnCount();
        String[][] items = new String[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                Object data = mod.get(r, c);
                items[r][c] = data != null ? data.toString() : "";
            }
        }
        return items;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i = ImageLoader.load(path, (Component)this);
            if (i == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i);
            this.textureName = path;
            this.setTexture(i);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public void setColumnViews(ColumnView[] newViews) {
        this.generatedColumns = false;
        super.setColumnViews(newViews);
        if (this.columnHeader != null) {
            DefaultColumnHeaderManager columnManager = new DefaultColumnHeaderManager(this);
            this.columnHeader.setModel(columnManager);
            this.columnHeader.setViewManager(columnManager);
        }
        this.resetSelection();
    }

    public void setColumnCaptions(String[] columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException();
        }
        ColumnView[] tempColumns = this.getColumnViews();
        if (tempColumns != null && tempColumns.length == columnNames.length) {
            this.setBatchMode(true);
            for (int i = 0; i < columnNames.length; ++i) {
                tempColumns[i].setCaption(columnNames[i]);
            }
            this.setBatchMode(false);
        } else {
            tempColumns = new ColumnView[columnNames.length];
            VariableSizeVector columnSizes = new VariableSizeVector();
            for (int i = 0; i < tempColumns.length; ++i) {
                tempColumns[i] = new ColumnView();
                tempColumns[i].setName(columnNames[i]);
                tempColumns[i].setAlignment(33);
                tempColumns[i].setWidth(this.getDefaultColumnWidth());
                tempColumns[i].setItemMargins(new Insets(0, 2, 0, 2));
                tempColumns[i].resetUserFlags();
                tempColumns[i].setCaption(columnNames[i]);
                columnSizes.setSize(i, tempColumns[i].getWidth());
            }
            this.setBatchMode(true);
            this.setColumnSizes(columnSizes);
            Object[][] items = new String[1][tempColumns.length];
            this.setModel(new BasicMatrixContainer(items));
            super.setColumnViews(tempColumns);
            this.generatedColumns = true;
            this.setBatchMode(false);
            this.validate();
        }
    }

    public String[] getColumnCaptions() {
        ColumnView[] tempColumns = this.getColumnViews();
        if (tempColumns == null || tempColumns.length == 0) {
            return new String[0];
        }
        String[] array = new String[tempColumns.length];
        for (int i = 0; i < tempColumns.length; ++i) {
            array[i] = tempColumns[i].getCaption();
        }
        return array;
    }

    public void setDataSet(DataSet newDataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeNavigationListener((NavigationListener)this);
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
        }
        this.openDataSet(newDataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addNavigationListener((NavigationListener)this);
            this.dataSet.addDataChangeListener((DataChangeListener)this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void openDataSet(DataSet newDataSet) {
        this.dataSet = newDataSet;
        if (this.dataSet == null) {
            this.buildStringGrid(null);
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
                this.buildStringGrid(null);
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    public void setSelectRow(boolean select) {
        if (this.selectRow != select) {
            this.selectRow = select;
            this.resetSelection();
        }
    }

    public boolean isSelectRow() {
        return this.selectRow;
    }

    public void setSelectColumn(boolean select) {
        if (this.selectColumn != select) {
            this.selectColumn = select;
            this.resetSelection();
        }
    }

    public boolean isSelectColumn() {
        return this.selectColumn;
    }

    public void setMultiSelect(boolean select) {
        if (this.multiSelect != select) {
            this.multiSelect = select;
            this.resetSelection();
        }
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    private void resetSelection() {
        if (this.multiSelect && this.selectRow && this.selectColumn) {
            this.setSelection(new CrossMatrixSelection(this.getRowCount(), this.getColumnCount(), this.getSubfocus()));
        } else if (this.multiSelect && this.selectRow) {
            this.setSelection(new MultiRowMatrixSelection(this.getColumnCount(), this.getSelection().getAll()));
        } else if (this.multiSelect && this.selectColumn) {
            this.setSelection(new MultiColumnMatrixSelection(this.getRowCount(), this.getSelection().getAll()));
        } else if (this.multiSelect) {
            this.setSelection(new BasicMatrixSelection(this.getSelection().getAll()));
        } else if (this.selectRow && this.selectColumn) {
            this.setSelection(new CrossMatrixSelection(this.getRowCount(), this.getColumnCount(), this.getSubfocus()));
        } else if (this.selectRow) {
            this.setSelection(new RowMatrixSelection(this.getColumnCount(), this.getSubfocus().row));
        } else if (this.selectColumn) {
            this.setSelection(new ColumnMatrixSelection(this.getRowCount(), this.getSubfocus().column));
        } else {
            this.setSelection(new SingleMatrixSelection(this.getSubfocus()));
        }
        this.repaint(100L);
    }

    public void setAutoInsert(boolean auto) {
        this.autoInsert = auto;
    }

    public boolean isAutoInsert() {
        return this.autoInsert;
    }

    public void setSortOnHeaderClick(boolean sort) {
        this.sortOnClick = sort;
    }

    public boolean isSortOnHeaderClick() {
        if (this.getModel() instanceof MatrixDataSetManager) {
            return this.sortOnClick;
        }
        return false;
    }

    public void setNavigateWithDataSet(boolean navigate) {
        this.userSetNavigate = navigate;
        if (this.userSetNavigate && this.navigateDataSet && this.dataSet != null && this.dataSet.isOpen()) {
            this.setSubfocus(this.dataSet.getRow(), this.getSubfocus().column);
        }
    }

    public boolean isNavigateWithDataSet() {
        return this.userSetNavigate;
    }

    public void setShowPopup(boolean show) {
        this.pop.setAlive(show);
    }

    public boolean isShowPopup() {
        return this.pop.isAlive();
    }

    private void buildStringGrid(String[][] newItems) {
        ColumnView[] oldColumns = this.getColumnViews();
        String[] captions = this.getColumnCaptions();
        if (newItems == null || newItems.length < 1 || newItems[0].length < 1) {
            oldColumns = null;
            captions = new String[1];
            newItems = new String[1][1];
        }
        this.navigateDataSet = false;
        ColumnView[] tempColumns = new ColumnView[newItems[0].length];
        VariableSizeVector columnSizes = new VariableSizeVector();
        for (int i = 0; i < tempColumns.length; ++i) {
            String name = "StringGridColumn".concat(String.valueOf(String.valueOf(i)));
            if (oldColumns != null && oldColumns.length > i && oldColumns[i].getName() == name) {
                tempColumns[i] = oldColumns[i];
            } else {
                tempColumns[i] = new ColumnView();
                tempColumns[i].setName(name);
                if (captions.length > i) {
                    tempColumns[i].setCaption(captions[i]);
                }
                tempColumns[i].setAlignment(33);
                tempColumns[i].setWidth(this.getDefaultColumnWidth());
                tempColumns[i].setItemMargins(new Insets(0, 2, 0, 2));
                tempColumns[i].resetUserFlags();
            }
            columnSizes.setSize(i, tempColumns[i].getWidth());
        }
        this.setColumnSizes(columnSizes);
        this.setModel(new BasicMatrixContainer(newItems));
        this.setViewManager(new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter(33))), new TextItemEditor(33)));
        super.setColumnViews(tempColumns);
        if (this.columnHeader != null) {
            DefaultColumnHeaderManager columnManager = new DefaultColumnHeaderManager(this);
            this.columnHeader.setModel(columnManager);
            this.columnHeader.setViewManager(columnManager);
            this.columnHeader.repaint(100L);
        }
        if (this.rowHeader != null) {
            DefaultRowHeaderManager rowManager = new DefaultRowHeaderManager(this);
            this.rowHeader.setModel(rowManager);
            this.rowHeader.setViewManager(rowManager);
            this.rowHeader.repaint(100L);
        }
        FixedSizeVector rowSizes = new FixedSizeVector(20);
        this.setRowSizes(rowSizes);
        this.setNavigateWithDataSet(false);
        this.setAutoAppend(false);
        this.resetSelection();
        this.generatedColumns = true;
        if (this.isShowing() && !this.isBatchMode()) {
            this.validate();
        }
    }

    public void subfocusChanging(MatrixSubfocusEvent e) throws VetoException {
        if (this.dataSet != null && this.dataSet.isOpen() && this.userSetNavigate && this.navigateDataSet) {
            try {
                try {
                    this.dataSet.setLastColumnVisited(this.getColumnView(e.getLocation().column).getName());
                    if (this.dataSet.getRow() != e.getLocation().row) {
                        this.dsNavigating = true;
                        if (!this.dataSet.goToRow(e.getLocation().row)) {
                            this.dsNavigating = false;
                            throw new VetoException();
                        }
                    }
                    Object var4_2 = null;
                    this.dsNavigating = false;
                }
                catch (DataSetException ex) {
                    DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
                    this.dsNavigating = false;
                    throw new VetoException();
                }
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.dsNavigating = false;
                throw throwable;
            }
        }
    }

    public void subfocusChanged(MatrixSubfocusEvent e) {
    }

    public void navigated(NavigationEvent e) {
        try {
            if (!this.dsNavigating && this.userSetNavigate && this.navigateDataSet && this.getSubfocus().row != this.dataSet.getRow() && this.dataSet.getRowCount() > this.dataSet.getRow()) {
                this.setSubfocus(this.dataSet.getRow(), this.getSubfocus().column);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dataChanged(DataChangeEvent e) {
    }

    public void postRow(DataChangeEvent e) throws Exception {
        this.endEdit();
    }

    public void accessChange(AccessEvent e) {
        switch (e.getID()) {
            case 2: {
                if (e.getReason() == 8 || e.getReason() == 9) {
                    this.setBatchMode(true);
                    this.oldSubfocus = new MatrixLocation(this.getSubfocus());
                }
                if (this.getModel() instanceof MatrixDataSetManager) {
                    this.oldRSizes = this.getRowSizes();
                    this.oldCSizes = this.getColumnSizes();
                    this.oldViews = this.getColumnViews();
                }
                this.safeEndEdit(false);
                this.buildStringGrid(null);
                break;
            }
            case 1: {
                DataSet nds = (DataSet)e.getSource();
                try {
                    this.openDataSet(nds);
                }
                catch (Exception ex) {
                    e.appendException(ex);
                }
                if (e.getReason() == 2) {
                    if (this.navigateDataSet && this.userSetNavigate) {
                        if (this.oldSubfocus != null) {
                            this.setSubfocus(this.dataSet.getRow(), this.oldSubfocus.column);
                        } else {
                            this.setSubfocus(this.dataSet.getRow(), 0);
                        }
                    }
                    if (this.oldViews != null) {
                        this.setColumnViews(this.oldViews);
                    }
                }
                if (e.getReason() == 1 && (this.getColumnViews() == null || this.getColumnViews().length == 0)) {
                    this.bindDataSet();
                }
                this.setBatchMode(false);
                this.oldRSizes = null;
                this.oldCSizes = null;
                this.oldViews = null;
                break;
            }
            default: {
                this.setBatchMode(false);
            }
        }
    }

    public void toggleColumnSort(int column) {
        String name;
        Column c;
        if (this.dataSet == null) {
            return;
        }
        if (this.dataSet.isEditing()) {
            try {
                this.dataSet.post();
            }
            catch (DataSetException x) {
                return;
            }
        }
        if ((c = this.dataSet.hasColumn(name = this.getColumnView(column).getName())) == null || !this.dataSet.isSortable(c)) {
            return;
        }
        try {
            this.dataSet.toggleViewOrder(name);
        }
        catch (Exception ex) {
            DataSetModel.handleException(ex);
        }
    }

    protected void columnHeaderClicked(int column) {
        if (this.isSortOnHeaderClick() && this.dataSet != null) {
            if (!this.isBatchMode()) {
                this.toggleColumnSort(column);
            }
        } else {
            super.columnHeaderClicked(column);
        }
    }

    private synchronized void bindDataSet() {
        boolean wasBatch = this.isBatchMode();
        if (this.dataSet != null && this.dataSet.getStorageDataSet() != null) {
            this.buildColumnViews(this.dataSet);
            this.setBatchMode(true);
            this.navigateDataSet = true;
            ColumnView[] columnViews = this.getColumnViews();
            Column[] columnList = new Column[columnViews.length];
            for (int index = 0; index < columnViews.length; ++index) {
                columnList[index] = this.dataSet.hasColumn(columnViews[index].getName());
            }
            if (this.columnHeader != null) {
                DefaultColumnHeaderManager columnManager = new DefaultColumnHeaderManager(this);
                this.columnHeader.setModel(columnManager);
                this.columnHeader.setViewManager(columnManager);
                this.columnHeader.repaint(100L);
            }
            if (this.rowHeader != null) {
                GridControl_DSRowHeaderManager rowManager = new GridControl_DSRowHeaderManager(this.dataSet);
                this.rowHeader.setModel(rowManager);
                this.rowHeader.setViewManager(rowManager);
                this.rowHeader.repaint(100L);
            }
            this.getModel();
            MatrixDataSetManager cursorManager = new MatrixDataSetManager(this.dataSet, columnList, this);
            this.setModel(cursorManager);
            this.setViewManager(cursorManager);
        }
        this.setNavigateWithDataSet(true);
        this.setAutoAppend(true);
        this.resetSelection();
        this.setSubfocus(this.dataSet.getRow(), this.getSubfocus().column);
        this.setBatchMode(wasBatch);
        if (this.isShowing() && !wasBatch) {
            this.validate();
        }
    }

    private int findOldView(String name) {
        if (this.oldViews != null) {
            for (int i = 0; i < this.oldViews.length; ++i) {
                if (!this.oldViews[i].getName().equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    protected void buildColumnViews(DataSet cursor) {
        ColumnView[] newViews = null;
        int[] newColumnSizes = null;
        int count = 0;
        int oldColumnsFound = 0;
        int index = 0;
        count = cursor.getColumnCount();
        newViews = new ColumnView[count];
        newColumnSizes = new int[count];
        for (int ordinal = 0; ordinal < count; ++ordinal) {
            try {
                Column column = cursor.getColumn(ordinal);
                if (column == null || !cursor.columnIsVisible(column.getColumnName())) continue;
                int oldOrdinal = this.findOldView(column.getColumnName());
                if (oldOrdinal >= 0) {
                    newViews[index] = new DatasetColumnView(column, this.oldViews[oldOrdinal]);
                    if (Beans.isDesignTime()) {
                        newColumnSizes[index] = this.widthCheck(newViews[index]).getWidth();
                    }
                    ++index;
                    ++oldColumnsFound;
                    continue;
                }
                newViews[index++] = new DatasetColumnView(column);
                continue;
            }
            catch (DataSetException column) {
                // empty catch block
            }
        }
        newViews = this.purgeViews(newViews);
        count = newViews.length;
        super.setColumnViews(newViews);
        for (index = 0; index < count; ++index) {
            if (newColumnSizes[index] != 0) continue;
            newColumnSizes[index] = newViews[index].getWidth();
        }
        VariableSizeVector columnSizeVector = new VariableSizeVector(newColumnSizes);
        this.setColumnSizes(columnSizeVector);
        int columnDiff = oldColumnsFound - count;
        if (this.oldRSizes != null && columnDiff >= -1 && columnDiff <= 1) {
            this.setRowSizes(this.oldRSizes);
        } else {
            FixedSizeVector rowSizeVector = new FixedSizeVector(20);
            this.setRowSizes(rowSizeVector);
        }
    }

    private ColumnView[] purgeViews(ColumnView[] views) {
        int size = views.length;
        for (int i = 0; i < views.length; ++i) {
            if (views[i] != null) continue;
            --size;
        }
        ColumnView[] newViews = new ColumnView[size];
        int v = 0;
        for (int i = 0; i < views.length; ++i) {
            if (views[i] == null) continue;
            newViews[v] = views[i];
            ++v;
        }
        return this.widthCheck(newViews);
    }

    private ColumnView[] widthCheck(ColumnView[] views) {
        for (int i = 0; i < views.length; ++i) {
            ColumnView cv = views[i];
            GridControl_ColumnView gccv = new GridControl_ColumnView(cv);
            if (gccv.getWidth() != 0 && gccv.getFlag(7)) continue;
            if (this.dataSet != null) {
                try {
                    FontMetrics fm;
                    Column c = this.dataSet.getColumn(gccv.getName());
                    Font f = gccv.getFont();
                    if (f == null) {
                        f = this.getFont();
                    }
                    if ((fm = this.getGraphics().getFontMetrics(f)) == null) continue;
                    int width = Math.max(fm.stringWidth("e") * c.getWidth(), fm.stringWidth(gccv.getCaption() != null ? gccv.getCaption() : "") + 10);
                    if (width > 0) {
                        gccv.setWidth(width < 500 ? width : 500);
                    } else {
                        gccv.setWidth(this.getDefaultColumnWidth());
                    }
                    gccv.setFlag(7, false);
                    views[i] = gccv;
                }
                catch (Exception x) {
                    gccv.setWidth(this.getDefaultColumnWidth());
                    gccv.setFlag(7, false);
                }
                continue;
            }
            gccv.setWidth(this.getDefaultColumnWidth());
            gccv.setFlag(7, false);
        }
        return views;
    }

    private ColumnView widthCheck(ColumnView cv) {
        GridControl_ColumnView gccv = new GridControl_ColumnView(cv);
        if (gccv.getWidth() == 0 || !gccv.getFlag(7)) {
            if (this.dataSet != null) {
                try {
                    FontMetrics fm;
                    Column c = this.dataSet.getColumn(gccv.getName());
                    Font f = gccv.getFont();
                    if (f == null) {
                        f = this.getFont();
                    }
                    if ((fm = this.getGraphics().getFontMetrics(f)) != null) {
                        int width = Math.max(fm.stringWidth("e") * c.getWidth(), fm.stringWidth(gccv.getCaption() != null ? gccv.getCaption() : "") + 10);
                        if (width > 0) {
                            gccv.setWidth(width < 500 ? width : 500);
                        } else {
                            gccv.setWidth(this.getDefaultColumnWidth());
                        }
                        gccv.setFlag(7, false);
                    }
                }
                catch (Exception x) {
                    gccv.setWidth(this.getDefaultColumnWidth());
                    gccv.setFlag(7, false);
                }
            } else {
                gccv.setWidth(this.getDefaultColumnWidth());
                gccv.setFlag(7, false);
            }
        }
        return gccv;
    }

    public Object get(int row, int column) {
        MatrixModel m = this.getModel();
        return m != null ? m.get(row, column) : null;
    }

    public MatrixLocation find(Object data) {
        MatrixModel m = this.getModel();
        return m != null ? m.find(data) : null;
    }

    public int getRowCount() {
        MatrixModel m = this.getModel();
        return m != null ? m.getRowCount() : 0;
    }

    public int getColumnCount() {
        MatrixModel m = this.getModel();
        return m != null ? m.getColumnCount() : 0;
    }

    public boolean canSet(int row, int column, boolean startEdit) {
        WritableMatrixModel m = this.getWriteModel();
        return m != null ? m.canSet(row, column, startEdit) : false;
    }

    public void set(int row, int column, Object data) {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.set(row, column, data);
        }
    }

    public void touched(int row, int column) {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.touched(row, column);
        }
    }

    public boolean isVariableRows() {
        WritableMatrixModel m = this.getWriteModel();
        return m != null ? m.isVariableRows() : false;
    }

    public void addRow() {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.addRow();
        }
    }

    public void addRow(int aheadOf) {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.addRow(aheadOf);
        }
    }

    public void removeRow(int row) {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.removeRow(row);
        }
    }

    public void removeAllRows() {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.removeAllRows();
        }
    }

    public boolean isVariableColumns() {
        WritableMatrixModel m = this.getWriteModel();
        return m != null ? m.isVariableColumns() : false;
    }

    public void addColumn() {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.addColumn();
        }
    }

    public void addColumn(int aheadOf) {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.addColumn(aheadOf);
        }
    }

    public void removeColumn(int column) {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.removeColumn(column);
        }
    }

    public void removeAllColumns() {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.removeAllColumns();
        }
    }

    public void enableModelEvents(boolean enable) {
        WritableMatrixModel m = this.getWriteModel();
        if (m != null) {
            m.enableModelEvents(enable);
        }
    }
}

