/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.BeanPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;

public class GroupBox
extends BeanPanel
implements Serializable {
    static final LayoutManager defaultLayout = new FlowLayout();
    protected String label;
    protected String textureName;

    public GroupBox() {
        super(defaultLayout);
        this.label = "";
        this.focusAware = false;
    }

    public GroupBox(String label) {
        super(defaultLayout);
        this.label = label;
        this.focusAware = false;
    }

    public Dimension getPreferredSize() {
        Font f;
        Dimension ps = super.getPreferredSize();
        if (this.label != null && !this.label.equals("") && (f = this.getFont()) != null) {
            FontMetrics fm = ((Component)this).getFontMetrics(f);
            ps.width = Math.max(ps.width, fm.stringWidth(this.label) + fm.getHeight() * 2);
        }
        return ps;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setLabel(String label) {
        this.label = label;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i = ImageLoader.load(path, (Component)this);
            if (i == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i);
            this.textureName = path;
            this.setTexture(i);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public Insets insets() {
        Font f = this.getFont();
        int inset = 0;
        if (f != null) {
            inset = ((Component)this).getFontMetrics(f).getHeight();
        }
        return new Insets(inset, inset, inset, inset);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Font of = g.getFont();
        Font f = this.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        int ascent = fm.getAscent();
        int ww = ascent / 2 + 1;
        Rectangle r = this.getBounds();
        if (r == null) {
            return;
        }
        int xs = ww;
        int ys = ww;
        int xe = r.width - ww - 1;
        int ye = r.height - ww - 1;
        g.setColor(this.getForeground());
        g.drawString(this.label, xs + xs, ascent);
        int tw = fm.stringWidth(this.label);
        for (int i = 1; i >= 0; --i) {
            g.setColor(i == 0 ? SystemColor.controlShadow : SystemColor.controlLtHighlight);
            g.drawLine(xs + xs - 1, ys + i, xs + i, ys + i);
            g.drawLine(xs + i, ys + i, xs + i, ye + i);
            g.drawLine(xs + i, ye + i, xe + i, ye + i);
            g.drawLine(xe + i, ye + i, xe + i, ys + i);
            g.drawLine(xe + i, ys + i, xs + xs + tw, ys + i);
        }
        g.setFont(of);
    }
}

