/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.JCLabelGenerator;
import com.klg.jclass.swing.gauge.JCScale;
import com.klg.jclass.swing.gauge.JCTick;
import com.klg.jclass.swing.gauge.JCTickStyle;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;

public abstract class JCAbstractTick
extends JComponent
implements JCTick,
Serializable {
    static final long serialVersionUID = 6997480289846291634L;
    protected JCScale scale;
    protected boolean automatic = true;
    protected double startValue;
    protected double stopValue;
    protected double incrementValue = 10.0;
    protected boolean precisionUseDefault = true;
    protected int precision = 0;
    protected double tickWidth = 2.0;
    protected boolean reversed = false;
    protected boolean drawLabels = true;
    protected boolean drawTicks = true;
    protected double labelExtent = 0.8;
    protected double innerExtent = 0.85;
    protected double outerExtent = 1.0;
    protected Color tickColor = Color.black;
    protected JCTickStyle tickStyle = JCTickStyle.LINE;
    protected Color fontColor = Color.black;
    protected JCLabelGenerator labelGenerator;

    public JCAbstractTick(JCScale jCScale, double d, double d2) {
        this.scale = jCScale;
        this.startValue = d;
        this.stopValue = d2;
    }

    public JCAbstractTick(JCScale jCScale, boolean bl, double d, double d2, double d3, boolean bl2, int n, double d4, boolean bl3, boolean bl4, double d5, double d6, double d7, Color color, JCTickStyle jCTickStyle, Font font, Color color2) {
        this.scale = jCScale;
        this.automatic = bl;
        this.startValue = d;
        this.stopValue = d2;
        this.incrementValue = d3;
        this.precisionUseDefault = bl2;
        this.precision = n;
        this.tickWidth = d4;
        this.drawLabels = bl3;
        this.drawTicks = bl4;
        this.labelExtent = d5;
        this.innerExtent = d6;
        this.outerExtent = d7;
        this.tickColor = color;
        this.tickStyle = jCTickStyle;
        this.fontColor = color2;
        this.setFont(font);
    }

    protected void calcPrecision(double d, double d2) {
        if (this.precisionUseDefault) {
            this.precision = d2 <= d ? JCNumberUtil.nicePrecision(Math.abs(d2)) : JCNumberUtil.nicePrecision(d2 - d);
        }
    }

    protected void calcTicks(Graphics graphics, int n) {
        int n2;
        double d = this.scale.getMin();
        double d2 = this.scale.getMax();
        this.calcPrecision(d, d2);
        d = JCNumberUtil.precFloor(this.precision, d);
        d2 = JCNumberUtil.precCeil(this.precision, d2);
        if (d2 <= d) {
            n2 = this.precision;
            do {
                d2 = d + Math.pow(10.0, -n2);
                --n2;
            } while (d2 <= d);
        }
        double d3 = d;
        double d4 = d2;
        int n3 = 0;
        double d5 = 0.0;
        Font font = this.getFont();
        if (font == null) {
            font = new Font("Helvetica", 0, 10);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        while (true) {
            int n4;
            int n5;
            d = JCNumberUtil.precFloor(this.precision, d);
            d2 = JCNumberUtil.precCeil(this.precision, d2);
            double d6 = d;
            double d7 = d2;
            double d8 = 0.5 * Math.pow(10.0, -this.precision - 1);
            double d9 = d2 - d;
            String string = JCNumberUtil.format(d2, this.precision);
            int n6 = fontMetrics.stringWidth(string);
            String string2 = JCNumberUtil.format(d, this.precision);
            int n7 = fontMetrics.stringWidth(string2);
            if (n7 > n6) {
                n6 = n7;
            }
            if ((n5 = (n4 = this.drawTicks && this.drawLabels ? Math.max((int)this.tickWidth, n6) : (this.drawTicks ? (int)this.tickWidth : (this.drawLabels ? n6 : 0))) == 0 ? 0 : n / n4) <= 0) {
                d5 = 0.0;
            } else {
                double d10 = d9 / (double)n5;
                n2 = JCNumberUtil.nicePrecision(d2 - d);
                n2 = Math.min(n2, this.precision);
                d5 = JCAbstractTick.niceNum(d10, -n2, false);
            }
            if (d5 != 0.0) {
                d = d5 * Math.floor(d / d5);
                d2 = d5 * Math.ceil(d2 / d5);
            } else if (Math.abs(d2 - d) < d8) {
                d2 = d + 1.0;
            }
            if (!(Math.abs(d - d6) > d8) && !(Math.abs(d2 - d7) > d8)) break;
            boolean bl = true;
            if (d2 - d5 >= d4) {
                d2 -= d5;
            } else {
                bl = false;
            }
            if (d + d5 <= d3) {
                d += d5;
            } else {
                bl = false;
            }
            if (bl || n3 >= 2) break;
            ++n3;
        }
        this.startValue = d;
        this.stopValue = d2;
        this.incrementValue = d5;
    }

    public boolean getAutomatic() {
        return this.automatic;
    }

    public boolean getDrawLabels() {
        return this.drawLabels;
    }

    public boolean getDrawTicks() {
        return this.drawTicks;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public double getIncrementValue() {
        return this.incrementValue;
    }

    public double getInnerExtent() {
        return this.innerExtent;
    }

    public double getLabelExtent() {
        return this.labelExtent;
    }

    public JCLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public double getOuterExtent() {
        return this.outerExtent;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean getPrecisionUseDefault() {
        return this.precisionUseDefault;
    }

    public JCScale getScale() {
        return this.scale;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public double getStopValue() {
        return this.stopValue;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public JCTickStyle getTickStyle() {
        return this.tickStyle;
    }

    public double getTickWidth() {
        return this.tickWidth;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public static double niceNum(double d, int n, boolean bl) {
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            d = -d;
        }
        double d2 = d / Math.pow(10.0, n);
        double d3 = bl ? (d2 < 1.5 ? 1.0 : (d2 < 3.0 ? 2.0 : (d2 < 7.0 ? 5.0 : 10.0))) : (d2 <= 1.0 ? 1.0 : (d2 <= 2.0 ? 2.0 : (d2 <= 5.0 ? 5.0 : 10.0)));
        return d3 * Math.pow(10.0, n);
    }

    public void paintChildren(Graphics graphics) {
        if (this.drawLabels) {
            super.paintChildren(graphics);
        }
    }

    public void redraw() {
        this.redraw(false);
    }

    public void redraw(boolean bl) {
    }

    public void redrawLabels() {
    }

    public void setAutomatic(boolean bl) {
        this.automatic = bl;
    }

    public void setDrawLabels(boolean bl) {
        this.drawLabels = bl;
        this.redraw();
    }

    public void setDrawTicks(boolean bl) {
        this.drawTicks = bl;
        this.redraw();
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
        this.redraw(true);
    }

    public void setIncrementValue(double d) {
        this.incrementValue = d;
        this.redraw(true);
    }

    public void setInnerExtent(double d) {
        this.innerExtent = d;
        this.redraw();
    }

    public void setLabelExtent(double d) {
        this.labelExtent = d;
        this.redraw(true);
    }

    public void setLabelGenerator(JCLabelGenerator jCLabelGenerator) {
        this.labelGenerator = jCLabelGenerator;
    }

    public void setOuterExtent(double d) {
        this.outerExtent = d;
        this.redraw();
    }

    public void setPrecision(int n) {
        this.precision = n;
        this.redraw();
    }

    public void setPrecisionUseDefault(boolean bl) {
        this.precisionUseDefault = bl;
        this.redraw();
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
        this.redraw();
    }

    public void setStartValue(double d) {
        this.startValue = d;
        this.redraw(true);
    }

    public void setStopValue(double d) {
        this.stopValue = d;
        this.redraw(true);
    }

    public void setTickColor(Color color) {
        this.tickColor = color;
        this.redraw();
    }

    public void setTickStyle(JCTickStyle jCTickStyle) {
        this.tickStyle = jCTickStyle;
        this.redraw();
    }

    public void setTickWidth(double d) {
        this.tickWidth = d;
        this.redraw();
    }
}

