/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model._Iterable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormLayoutManager
extends FormObject
implements _Iterable<Map.Entry<FormComponent, FormLayoutConstraints>> {
    private static final FormObject.EmptyIterator<Map.Entry<FormComponent, FormLayoutConstraints>> EMPTY_ITERATOR = new FormObject.EmptyIterator();
    private final Class<?> layoutClass;
    private FormContainer container;
    private HashMap<FormComponent, FormLayoutConstraints> constraintsMap;

    public FormLayoutManager(Class<?> managerClass) {
        this.layoutClass = managerClass;
    }

    FormLayoutManager(FormLayoutManager obj, int dummy) {
        super(obj, dummy);
        this.layoutClass = obj.layoutClass;
    }

    public Object clone() {
        return new FormLayoutManager(this, 0);
    }

    public Class<?> getLayoutClass() {
        return this.layoutClass;
    }

    public FormLayoutConstraints getConstraints(FormComponent comp) {
        return this.constraintsMap != null ? this.constraintsMap.get(comp) : null;
    }

    public FormLayoutConstraints setConstraints(FormComponent comp, FormLayoutConstraints constraints) {
        return this.setConstraints(comp, constraints, true);
    }

    FormLayoutConstraints setConstraints(FormComponent comp, FormLayoutConstraints constraints, boolean fireEvent) {
        FormLayoutConstraints oldConstraints;
        if (this.constraintsMap == null) {
            if (constraints == null) {
                return null;
            }
            this.constraintsMap = new HashMap();
        }
        if (constraints != null) {
            oldConstraints = this.constraintsMap.put(comp, constraints);
            constraints.setLayout(this);
            constraints.setComponent(comp);
        } else {
            oldConstraints = this.constraintsMap.remove(comp);
        }
        if (oldConstraints != null) {
            oldConstraints.setLayout(null);
            oldConstraints.setComponent(null);
        }
        if (fireEvent) {
            FormModel model;
            FormModel formModel = model = this.container != null ? this.container.getModel() : null;
            if (model != null && model.eventProvider != null) {
                model.eventProvider.fireConstraintsChanged(this, comp, oldConstraints, constraints);
            }
        }
        return oldConstraints;
    }

    public FormContainer getContainer() {
        return this.container;
    }

    void setContainer(FormContainer container) {
        if (this.container != null && container != null) {
            throw new IllegalStateException(new StringBuffer().append("Already attached (current=\"").append(this.container).append("\", new=\"").append(container).append("\").").toString());
        }
        this.container = container;
    }

    @Override
    public Iterator<Map.Entry<FormComponent, FormLayoutConstraints>> iterator() {
        return this.constraintsMap != null && this.constraintsMap.size() > 0 ? new FormObject.MyIterator<Map.Entry<FormComponent, FormLayoutConstraints>>(this.constraintsMap.entrySet().iterator()) : EMPTY_ITERATOR;
    }

    @Override
    void firePropertyChanged(String name, int index, Object oldValue, Object newValue) {
        FormModel model;
        FormModel formModel = model = this.container != null ? this.container.getModel() : null;
        if (model != null && model.eventProvider != null) {
            model.eventProvider.fireLayoutPropertyChanged(this, name, index, oldValue, newValue);
        }
    }

    @Override
    public String toString() {
        return new StringBuffer().append(FormLayoutManager.unqualifiedClassName(this.getClass())).append("[layoutClass=").append(FormLayoutManager.unqualifiedClassName(this.layoutClass)).append(",container=").append(this.container).append("] ").append(super.toString()).toString();
    }
}

