/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import java.awt.Component;
import java.awt.Container;
import javax.swing.LayoutFocusTraversalPolicy;

public class ArrayFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    private final Component[] components;

    public ArrayFocusTraversalPolicy(Component[] components) {
        this.components = components;
    }

    public Component getComponentAfter(Container container, Component component) {
        return this.nextComponent(component, 1);
    }

    public Component getComponentBefore(Container container, Component component) {
        return this.nextComponent(component, -1);
    }

    public Component getFirstComponent(Container container) {
        return this.nextComponent(this.components.length - 1, 1);
    }

    public Component getLastComponent(Container container) {
        return this.nextComponent(0, -1);
    }

    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    private Component nextComponent(Component component, int direction) {
        int index = this.indexOf(component);
        return index >= 0 ? this.nextComponent(index, direction) : null;
    }

    private Component nextComponent(int index, int direction) {
        int nextIndex;
        if (this.components.length == 0) {
            return null;
        }
        int initialIndex = nextIndex = this.nextIndex(index, direction);
        do {
            if (!this.accept(this.components[nextIndex])) continue;
            return this.components[nextIndex];
        } while ((nextIndex = this.nextIndex(nextIndex, direction)) != initialIndex);
        return null;
    }

    private int nextIndex(int index, int direction) {
        if ((index += direction) < 0) {
            index = this.components.length - 1;
        } else if (index >= this.components.length) {
            index = 0;
        }
        return index;
    }

    private int indexOf(Component component) {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] != component) continue;
            return i;
        }
        return -1;
    }
}

