/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormComponentVisitor;
import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.model.FormModel;
import java.util.ArrayList;

public class FormContainer
extends FormComponent {
    public static final String FIELD_MENU_BAR = "menuBar";
    private FormLayoutManager layout;
    private final ArrayList<FormComponent> components = new ArrayList();
    private FormContainer menuBar;
    private FormContainer menuBarOwner;

    public FormContainer(String className) {
        this(className, null);
    }

    public FormContainer(String className, FormLayoutManager layout) {
        super(className);
        this.setLayout(layout);
    }

    FormContainer(FormContainer obj, int dummy) {
        super(obj, dummy);
        if (obj.layout != null) {
            this.setLayout((FormLayoutManager)obj.layout.clone());
        }
        int count = obj.components.size();
        this.components.ensureCapacity(count);
        for (int i = 0; i < count; ++i) {
            FormComponent c = obj.getComponent(i);
            FormLayoutConstraints cons = null;
            if (obj.layout != null) {
                cons = obj.layout.getConstraints(c);
            }
            if (cons != null) {
                cons = (FormLayoutConstraints)cons.clone();
            }
            this.add((FormComponent)c.clone(), cons);
        }
        if (obj.menuBar != null) {
            this.setMenuBar((FormContainer)obj.menuBar.clone());
        }
    }

    public Object clone() {
        return new FormContainer(this, 0);
    }

    public FormLayoutManager getLayout() {
        return this.layout;
    }

    public void setLayout(FormLayoutManager layout) {
        if (this.layout == layout) {
            return;
        }
        FormLayoutManager oldLayout = this.layout;
        if (oldLayout != null) {
            oldLayout.setContainer(null);
        }
        this.layout = layout;
        if (layout != null) {
            layout.setContainer(this);
        }
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireLayoutChanged(this, oldLayout, layout);
        }
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public FormComponent getComponent(int index) {
        return this.components.get(index);
    }

    public FormComponent[] getComponents() {
        return this.components.toArray(new FormComponent[this.components.size()]);
    }

    public int getComponentIndex(FormComponent comp) {
        return this.components.indexOf(comp);
    }

    public void add(FormComponent comp) {
        this.add(comp, null);
    }

    public void add(FormComponent comp, int index) {
        this.add(comp, null, index);
    }

    public void add(FormComponent comp, FormLayoutConstraints constraints) {
        this.add(comp, constraints, -1);
    }

    public void add(FormComponent comp, FormLayoutConstraints constraints, int index) {
        if (comp == this) {
            throw new IllegalArgumentException();
        }
        FormContainer compParent = comp.getParent();
        if (compParent == this) {
            return;
        }
        if (compParent != null) {
            compParent.remove(comp);
        }
        if (index < 0 || index == this.components.size()) {
            index = this.components.size();
            this.components.add(comp);
        } else {
            this.components.add(index, comp);
        }
        comp.setParent(this);
        comp.setModel(this.model);
        if (this.layout != null) {
            this.layout.setConstraints(comp, constraints, false);
        }
        if (this.model != null) {
            if (this.model.nameRegistry != null) {
                this.model.nameRegistry.componentAdded(comp);
            }
            if (this.model.eventProvider != null) {
                this.model.eventProvider.fireComponentAdded(comp, this, index, constraints);
            }
        }
    }

    public void remove(FormComponent comp) {
        int index = this.components.indexOf(comp);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        FormComponent comp = this.components.remove(index);
        comp.setParent(null);
        comp.setModel(null);
        FormLayoutConstraints constraints = null;
        if (this.layout != null) {
            constraints = this.layout.setConstraints(comp, null, false);
        }
        if (this.model != null) {
            if (this.model.nameRegistry != null) {
                this.model.nameRegistry.componentRemoved(comp);
            }
            if (this.model.eventProvider != null) {
                this.model.eventProvider.fireComponentRemoved(comp, this, index, constraints);
            }
        }
    }

    public void remove(String name) {
        int count = this.components.size();
        for (int i = 0; i < count; ++i) {
            if (!name.equals(this.getComponent(i).getName())) continue;
            this.remove(i);
            break;
        }
    }

    public void removeAll() {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public FormContainer getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(FormContainer menuBar) {
        if (this.menuBar == menuBar) {
            return;
        }
        if (this.menuBar != null) {
            this.menuBar.menuBarOwner = null;
            this.menuBar.setModel(null);
        }
        FormContainer oldMenuBar = this.menuBar;
        this.menuBar = menuBar;
        if (menuBar != null) {
            menuBar.menuBarOwner = this;
            menuBar.setModel(this.model);
        }
        if (this.model != null) {
            if (this.model.nameRegistry != null) {
                this.model.nameRegistry.componentFieldChanged(this, FIELD_MENU_BAR, oldMenuBar, menuBar);
            }
            if (this.model.eventProvider != null) {
                this.model.eventProvider.fireComponentFieldChanged(this, FIELD_MENU_BAR, oldMenuBar, menuBar);
            }
        }
    }

    public FormContainer getMenuBarOwner() {
        return this.menuBarOwner;
    }

    void setModel(FormModel model) {
        super.setModel(model);
        if (this.menuBar != null) {
            this.menuBar.setModel(model);
        }
        int count = this.components.size();
        for (int i = 0; i < count; ++i) {
            this.components.get(i).setModel(model);
        }
    }

    public boolean accept(FormComponentVisitor visitor) {
        if (!super.accept(visitor)) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.accept(visitor)) {
            return false;
        }
        int count = this.components.size();
        for (int i = 0; i < count; ++i) {
            if (this.components.get(i).accept(visitor)) continue;
            return false;
        }
        return true;
    }

    public FormComponent[] getMenuBarAndComponents() {
        FormComponent[] comps = new FormComponent[this.components.size() + (this.menuBar != null ? 1 : 0)];
        this.components.toArray(comps);
        if (this.menuBar != null) {
            System.arraycopy(comps, 0, comps, 1, this.components.size());
            comps[0] = this.menuBar;
        }
        return comps;
    }

    void updateReferences(String oldName, String newName) {
        super.updateReferences(oldName, newName);
        if (this.menuBar != null) {
            this.menuBar.updateReferences(oldName, newName);
        }
        int count = this.components.size();
        for (int i = 0; i < count; ++i) {
            this.components.get(i).updateReferences(oldName, newName);
        }
    }
}

