/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormLayoutConstraints
extends FormObject {
    public static final String PROP_VALUE = "value";
    private final Class<?> constraintsClass;
    private FormLayoutManager layout;
    private FormComponent component;

    public FormLayoutConstraints(Class<?> constraintsClass) {
        this.constraintsClass = constraintsClass;
    }

    public FormLayoutConstraints(Class<?> constraintsClass, Object value) {
        this.constraintsClass = constraintsClass;
        this.setProperty(PROP_VALUE, value);
    }

    FormLayoutConstraints(FormLayoutConstraints obj, int dummy) {
        super(obj, dummy);
        this.constraintsClass = obj.constraintsClass;
    }

    public Object clone() {
        return new FormLayoutConstraints(this, 0);
    }

    public Class<?> getConstraintsClass() {
        return this.constraintsClass;
    }

    public FormLayoutManager getLayout() {
        return this.layout;
    }

    void setLayout(FormLayoutManager layout) {
        if (this.layout != null && layout != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.layout + "\", new=\"" + layout + "\").");
        }
        this.layout = layout;
    }

    public FormComponent getComponent() {
        return this.component;
    }

    void setComponent(FormComponent component) {
        if (this.component != null && component != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.component + "\", new=\"" + component + "\").");
        }
        this.component = component;
    }

    @Override
    void firePropertyChanged(String name, int index, Object oldValue, Object newValue) {
        FormModel model;
        FormContainer container = this.layout != null ? this.layout.getContainer() : null;
        FormModel formModel = model = container != null ? container.getModel() : null;
        if (model != null && model.eventProvider != null) {
            model.eventProvider.fireConstraintsPropertyChanged(this, name, index, oldValue, newValue);
        }
    }

    public boolean isEqual(FormLayoutConstraints constraints) {
        if (constraints == this) {
            return true;
        }
        return constraints.constraintsClass == this.constraintsClass && super.isEqual(constraints);
    }

    @Override
    public String toString() {
        return FormLayoutConstraints.unqualifiedClassName(this.getClass()) + "[constraintsClass=" + (this.constraintsClass != null ? FormLayoutConstraints.unqualifiedClassName(this.constraintsClass) : "null") + ",component=" + this.component + "] " + super.toString();
    }
}

