/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormBindingVisitor;
import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormComponentVisitor;
import com.jformdesigner.model.FormModelEventProvider;
import com.jformdesigner.model.FormNameRegistry;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormRoot;

public class FormModel
extends FormObject {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private String contentType;
    private FormRoot root;
    FormModelEventProvider eventProvider;
    private boolean undoRecording = true;
    FormNameRegistry nameRegistry;
    public String fileHeader;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void set_ClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public FormRoot getRoot() {
        return this.root;
    }

    public void setRoot(FormRoot root) {
        if (this.root == root) {
            return;
        }
        if (this.root != null) {
            this.root.setModel(null);
        }
        this.root = root;
        this.nameRegistry = null;
        if (root != null) {
            root.setModel(this);
        }
        if (this.eventProvider != null) {
            this.eventProvider.fireFormChanged();
        }
    }

    public FormComponent getFormComponent(String name) {
        if (this.nameRegistry == null) {
            this.nameRegistry = new FormNameRegistry(this);
        }
        return this.nameRegistry.getFormComponent(name);
    }

    public String[] getNames() {
        if (this.nameRegistry == null) {
            this.nameRegistry = new FormNameRegistry(this);
        }
        return this.nameRegistry.getNames();
    }

    public boolean accept(FormComponentVisitor visitor) {
        if (this.root == null) {
            return true;
        }
        return this.root.accept(visitor);
    }

    public boolean accept(FormBindingVisitor visitor) {
        if (this.root == null) {
            return true;
        }
        return this.root.accept(visitor);
    }

    void firePropertyChanged(String name, int index, Object oldValue, Object newValue) {
        if (this.eventProvider != null) {
            this.eventProvider.fireModelPropertyChanged(name, index, oldValue, newValue);
        }
    }

    public boolean isUndoRecording() {
        return this.undoRecording;
    }

    public boolean setUndoRecording(boolean undoRecording) {
        boolean oldUndoRecording = this.undoRecording;
        this.undoRecording = undoRecording;
        return oldUndoRecording;
    }

    void updateReferences(String oldName, String newName) {
        if (this.root != null && this.undoRecording) {
            this.root.updateReferences(oldName, newName);
        }
    }

    public FormModelEventProvider getEventProvider() {
        return this.eventProvider;
    }

    public void set_EventProvider(FormModelEventProvider eventProvider) {
        if (this.eventProvider != null) {
            throw new IllegalStateException();
        }
        this.eventProvider = eventProvider;
    }
}

