/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormBindingGroup;
import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormEvent;
import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.model.FormMessage;
import com.jformdesigner.model.FormMessageArray;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormNonVisual;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormReference;
import com.jformdesigner.model.FormRoot;
import com.jformdesigner.model.FormWindow;
import com.jformdesigner.model.SwingBorder;
import com.jformdesigner.model.SwingColor;
import com.jformdesigner.model.SwingDerivedFont;
import com.jformdesigner.model.SwingFont;
import com.jformdesigner.model.SwingIcon;
import com.jformdesigner.model.SwingResource;
import com.jformdesigner.model.SwingTableColumn;
import com.jformdesigner.model.SwingTableModel;
import com.jformdesigner.runtime.BeanInfoEx;
import com.jformdesigner.runtime.BeanProvider;
import com.jformdesigner.runtime.BindingCreator;
import com.jformdesigner.runtime.BindingCreatorRegistry;
import com.jformdesigner.runtime.ComponentProvider;
import com.jformdesigner.runtime.IntrospectorEx;
import com.jformdesigner.runtime.LayoutCreator;
import com.jformdesigner.runtime.LayoutCreatorRegistry;
import com.jformdesigner.runtime.NoSuchComponentException;
import com.jformdesigner.runtime.ObjectCloner;
import com.jformdesigner.runtime.RuntimeUtils;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.BeanDescriptor;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormCreator
implements ComponentProvider,
BeanProvider {
    private static final String PROP_I18N_BUNDLE_PACKAGE = "i18n.bundlePackage";
    private static final String PROP_I18N_BUNDLE_NAME = "i18n.bundleName";
    private static final String PROP_BUTTON_GROUP = "$buttonGroup";
    private static final String PROP_SET_COMPONENT_NAMES = "$setComponentNames";
    private static final String PROP_LOCATION_POLICY = "$locationPolicy";
    private static final String PROP_SIZE_POLICY = "$sizePolicy";
    private static final String CONTAINER_DELEGATE = "containerDelegate";
    private static final String DESIGNER_CONTAINER_DELEGATE = "designerContainerDelegate";
    private static final String CLIENT_PREFIX = "$client.";
    private static final String ACTION_PREFIX = "$action.";
    private static final String I18N_KEY_PREFIX = "i18nKey=";
    private final FormModel model;
    private final Locale locale;
    private ClassLoader loader;
    private boolean setComponentNames;
    private Object target;
    private final IdentityHashMap<FormComponent, Object> componentMap = new IdentityHashMap();
    private HashMap<String, ButtonGroup> buttonGroupMap;
    private HashMap<String, ResourceBundle> bundleMap;
    private ResourceBundle defaultBundle;
    private String defaultBaseName;

    public FormCreator(FormModel model) {
        this(model, null);
    }

    public FormCreator(FormModel model, ClassLoader classLoader) {
        this(model, null, classLoader);
    }

    public FormCreator(FormModel model, Locale locale, ClassLoader classLoader) {
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.model = model;
        this.locale = locale != null ? locale : Locale.getDefault();
        ClassLoader classLoader2 = this.loader = classLoader != null ? classLoader : this.getClass().getClassLoader();
        if (this.loader == null) {
            this.loader = ClassLoader.getSystemClassLoader();
        }
        if (this.loader == null) {
            throw new IllegalArgumentException("Unable to get class loader. getClass().getClassLoader() and ClassLoader.getSystemClassLoader() returned null");
        }
        this.setComponentNames = model.getRoot().getPropertyBoolean(PROP_SET_COMPONENT_NAMES);
    }

    public FormModel getModel() {
        return this.model;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        if (this.componentMap.size() > 0) {
            throw new IllegalStateException("Invoke setTarget() before creating components.");
        }
        this.target = target;
    }

    public boolean isSetComponentNames() {
        return this.setComponentNames;
    }

    public void setSetComponentNames(boolean setComponentNames) {
        this.setComponentNames = setComponentNames;
    }

    public void createAll() throws Exception {
        FormRoot root = this.model.getRoot();
        int count = root.getComponentCount();
        for (int i = 0; i < count; ++i) {
            this.create(root.getComponent(i));
        }
    }

    public Component create() throws Exception {
        FormComponent comp = this.getFirstVisualTopLevel();
        if (comp == null) {
            throw new IllegalStateException("Form does not have a top-level component.");
        }
        return (Component)this.create(comp);
    }

    public JPanel createPanel() throws Exception {
        return (JPanel)this.create();
    }

    public JDialog createDialog(Window owner) throws Exception {
        return (JDialog)this.createWindow(owner);
    }

    public Window createWindow(Window owner) throws Exception {
        FormComponent comp = this.getFirstVisualTopLevel();
        if (comp == null) {
            throw new IllegalStateException("Form does not have a top-level component.");
        }
        return (Window)this.create(comp, owner);
    }

    public Component create(String name) throws Exception {
        return this.create(name, null);
    }

    public Component create(String name, Window owner) throws Exception {
        FormComponent comp = this.model.getFormComponent(name);
        if (comp == null) {
            throw new NoSuchComponentException("Unknown component \"" + name + "\".");
        }
        return (Component)this.create(comp, owner);
    }

    Object create(FormComponent formComp) throws Exception {
        return this.create(formComp, null);
    }

    Object create(FormComponent formComp, Window owner) throws Exception {
        Object c = this.getComponent(formComp);
        if (c == null) {
            c = this.createComponents(formComp, owner);
            this.setReferences(formComp);
        }
        return c;
    }

    private FormComponent getFirstVisualTopLevel() {
        FormRoot root = this.model.getRoot();
        int count = root.getComponentCount();
        if (count == 0) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            FormComponent comp = root.getComponent(i);
            if (comp instanceof FormNonVisual) continue;
            return comp;
        }
        return null;
    }

    public Object[] createBindings() throws Exception {
        FormBindingGroup[] bindingGroups = this.model.getRoot().getBindingGroups();
        if (bindingGroups.length == 0) {
            return null;
        }
        Object[] groups = new Object[bindingGroups.length];
        for (int i = 0; i < bindingGroups.length; ++i) {
            BindingCreator<?, ?> bindingCreator = BindingCreatorRegistry.createBindingCreator(bindingGroups[i].getBindingGroupClass());
            bindingCreator.setFormCreator(this);
            Object group = bindingCreator.createBindingGroup(bindingGroups[i]);
            if (bindingGroups[i].getPropertyBoolean("bound", true)) {
                bindingCreator.bindGroup(group);
            }
            groups[i] = group;
        }
        return groups;
    }

    @Override
    public Component getComponent(String name) throws NoSuchComponentException {
        return (Component)this.getBean(name);
    }

    public Object getBean(String name) throws NoSuchComponentException {
        FormComponent formComp = this.model.getFormComponent(name);
        if (formComp == null) {
            throw new NoSuchComponentException("Unknown component \"" + name + "\".");
        }
        Object c = this.getComponent(formComp);
        if (c == null) {
            throw new NoSuchComponentException("Component \"" + name + "\" is not created.");
        }
        return c;
    }

    @Override
    public Object getBean(String name, boolean create) throws Exception {
        FormComponent formComp = this.model.getFormComponent(name);
        if (formComp == null) {
            throw new NoSuchComponentException("Unknown component \"" + name + "\".");
        }
        return this.create(formComp);
    }

    public JButton getButton(String name) throws NoSuchComponentException {
        return (JButton)this.getComponent(name);
    }

    public JCheckBox getCheckBox(String name) throws NoSuchComponentException {
        return (JCheckBox)this.getComponent(name);
    }

    public JCheckBoxMenuItem getCheckBoxMenuItem(String name) throws NoSuchComponentException {
        return (JCheckBoxMenuItem)this.getComponent(name);
    }

    public JComboBox getComboBox(String name) throws NoSuchComponentException {
        return (JComboBox)this.getComponent(name);
    }

    public JDialog getDialog(String name) throws NoSuchComponentException {
        return (JDialog)this.getComponent(name);
    }

    public JEditorPane getEditorPane(String name) throws NoSuchComponentException {
        return (JEditorPane)this.getComponent(name);
    }

    public JFormattedTextField getFormattedTextField(String name) throws NoSuchComponentException {
        return (JFormattedTextField)this.getComponent(name);
    }

    public JFrame getFrame(String name) throws NoSuchComponentException {
        return (JFrame)this.getComponent(name);
    }

    public JLabel getLabel(String name) throws NoSuchComponentException {
        return (JLabel)this.getComponent(name);
    }

    public JList getList(String name) throws NoSuchComponentException {
        return (JList)this.getComponent(name);
    }

    public JMenu getMenu(String name) throws NoSuchComponentException {
        return (JMenu)this.getComponent(name);
    }

    public JMenuBar getMenuBar(String name) throws NoSuchComponentException {
        return (JMenuBar)this.getComponent(name);
    }

    public JMenuItem getMenuItem(String name) throws NoSuchComponentException {
        return (JMenuItem)this.getComponent(name);
    }

    public JPanel getPanel(String name) throws NoSuchComponentException {
        return (JPanel)this.getComponent(name);
    }

    public JPasswordField getPasswordField(String name) throws NoSuchComponentException {
        return (JPasswordField)this.getComponent(name);
    }

    public JPopupMenu getPopupMenu(String name) throws NoSuchComponentException {
        return (JPopupMenu)this.getComponent(name);
    }

    public JProgressBar getProgressBar(String name) throws NoSuchComponentException {
        return (JProgressBar)this.getComponent(name);
    }

    public JRadioButton getRadioButton(String name) throws NoSuchComponentException {
        return (JRadioButton)this.getComponent(name);
    }

    public JRadioButtonMenuItem getRadioButtonMenuItem(String name) throws NoSuchComponentException {
        return (JRadioButtonMenuItem)this.getComponent(name);
    }

    public JScrollBar getScrollBar(String name) throws NoSuchComponentException {
        return (JScrollBar)this.getComponent(name);
    }

    public JScrollPane getScrollPane(String name) throws NoSuchComponentException {
        return (JScrollPane)this.getComponent(name);
    }

    public JSeparator getSeparator(String name) throws NoSuchComponentException {
        return (JSeparator)this.getComponent(name);
    }

    public JSlider getSlider(String name) throws NoSuchComponentException {
        return (JSlider)this.getComponent(name);
    }

    public JSpinner getSpinner(String name) throws NoSuchComponentException {
        return (JSpinner)this.getComponent(name);
    }

    public JSplitPane getSplitPane(String name) throws NoSuchComponentException {
        return (JSplitPane)this.getComponent(name);
    }

    public JTabbedPane getTabbedPane(String name) throws NoSuchComponentException {
        return (JTabbedPane)this.getComponent(name);
    }

    public JTable getTable(String name) throws NoSuchComponentException {
        return (JTable)this.getComponent(name);
    }

    public JTextArea getTextArea(String name) throws NoSuchComponentException {
        return (JTextArea)this.getComponent(name);
    }

    public JTextField getTextField(String name) throws NoSuchComponentException {
        return (JTextField)this.getComponent(name);
    }

    public JTextPane getTextPane(String name) throws NoSuchComponentException {
        return (JTextPane)this.getComponent(name);
    }

    public JToggleButton getToggleButton(String name) throws NoSuchComponentException {
        return (JToggleButton)this.getComponent(name);
    }

    public JToolBar getToolBar(String name) throws NoSuchComponentException {
        return (JToolBar)this.getComponent(name);
    }

    public JTree getTree(String name) throws NoSuchComponentException {
        return (JTree)this.getComponent(name);
    }

    public JWindow getWindow(String name) throws NoSuchComponentException {
        return (JWindow)this.getComponent(name);
    }

    private Object getComponent(FormComponent formComp) {
        return this.componentMap.get(formComp);
    }

    private Object createComponents(FormComponent formComp, Window owner) throws Exception {
        Object c = this.getComponent(formComp);
        if (c != null) {
            return c;
        }
        c = owner != null && formComp instanceof FormWindow ? this.createWindowComponent((FormWindow)formComp, owner) : this.createComponent(formComp);
        this.componentMap.put(formComp, c);
        Object groupRef = formComp.getProperty(PROP_BUTTON_GROUP);
        if (groupRef instanceof FormReference && c instanceof AbstractButton) {
            ButtonGroup buttonGroup;
            String buttonGroupName = ((FormReference)groupRef).getName();
            ButtonGroup buttonGroup2 = buttonGroup = this.buttonGroupMap != null ? this.buttonGroupMap.get(buttonGroupName) : null;
            if (buttonGroup == null) {
                FormComponent buttonGroupComp = this.model.getFormComponent(buttonGroupName);
                if (buttonGroupComp != null) {
                    buttonGroup = (ButtonGroup)this.componentMap.get(buttonGroupComp);
                    if (buttonGroup == null) {
                        buttonGroup = (ButtonGroup)this.createComponent(buttonGroupComp);
                        this.componentMap.put(buttonGroupComp, buttonGroup);
                    }
                } else {
                    buttonGroup = new ButtonGroup();
                }
                if (this.buttonGroupMap == null) {
                    this.buttonGroupMap = new HashMap();
                }
                this.buttonGroupMap.put(buttonGroupName, buttonGroup);
            }
            buttonGroup.add((AbstractButton)c);
        }
        if (formComp instanceof FormContainer) {
            Container container = this.getContainerDelegate((Container)c);
            FormContainer formCont = (FormContainer)formComp;
            this.createMenuBar(formCont, (Container)c);
            FormLayoutManager formLayout = formCont.getLayout();
            LayoutCreator layoutCreator = null;
            if (formLayout != null) {
                layoutCreator = LayoutCreatorRegistry.createLayoutCreator(formLayout.getLayoutClass());
                layoutCreator.setFormCreator(this);
                LayoutManager layout = layoutCreator.createLayoutManager(container, formLayout);
                if (layout != null) {
                    container.setLayout(layout);
                }
            }
            int count = formCont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                FormComponent fc = formCont.getComponent(i);
                FormLayoutConstraints formConstraints = null;
                Component c2 = (Component)this.createComponents(fc, null);
                Object constraints = null;
                if (formLayout != null && (formConstraints = formLayout.getConstraints(fc)) != null) {
                    constraints = this.createConstraints(layoutCreator, formConstraints);
                }
                if (layoutCreator != null) {
                    layoutCreator.addComponentToContainer(container, c2, constraints, -1, formConstraints);
                    continue;
                }
                container.add(c2, constraints);
            }
            if (layoutCreator != null) {
                layoutCreator.finishLayoutInitialization(container, formLayout);
            }
            if (formComp instanceof FormWindow && c instanceof Window) {
                Dimension size;
                FormLayoutConstraints formCons;
                Window w = (Window)c;
                int sizePolicy = formComp.getPropertyInt(PROP_SIZE_POLICY);
                if (sizePolicy == 0) {
                    w.pack();
                } else if (sizePolicy == 1 && (formCons = formComp.getConstraints()) != null && (size = (Dimension)formCons.getProperty("size")) != null) {
                    w.setSize(size);
                }
                int locationPolicy = formComp.getPropertyInt(PROP_LOCATION_POLICY);
                if (locationPolicy == 0) {
                    w.setLocationRelativeTo(w.getOwner());
                } else if (locationPolicy == 1) {
                    w.setLocationRelativeTo(null);
                }
            }
        }
        return c;
    }

    private void createMenuBar(FormContainer formCont, Component c) throws Exception {
        FormContainer menuBarComp = formCont.getMenuBar();
        if (menuBarComp == null) {
            return;
        }
        JMenuBar menuBar = (JMenuBar)this.createComponents(menuBarComp, null);
        Method setMethod = c.getClass().getMethod("setJMenuBar", JMenuBar.class);
        setMethod.invoke((Object)c, menuBar);
    }

    private Container getContainerDelegate(Container container) throws Exception {
        Class<?> containerClass = container.getClass();
        if (containerClass == JPanel.class || container instanceof JTabbedPane) {
            return container;
        }
        if (container instanceof JScrollPane) {
            return container;
        }
        String delegateMethodName = null;
        try {
            BeanDescriptor beanDesc;
            BeanInfoEx beanInfo = IntrospectorEx.getBeanInfoEx(containerClass);
            if (beanInfo != null && (beanDesc = beanInfo.getBeanDescriptor()) != null && (delegateMethodName = (String)beanDesc.getValue(CONTAINER_DELEGATE)) == null) {
                delegateMethodName = (String)beanDesc.getValue(DESIGNER_CONTAINER_DELEGATE);
            }
        }
        catch (IntrospectionException ex) {
            return container;
        }
        if (delegateMethodName == null && containerClass.getName().equals("com.jgoodies.uif_lite.panel.SimpleInternalFrame")) {
            delegateMethodName = "getContentPane";
        }
        if (delegateMethodName != null) {
            Method m = container.getClass().getMethod(delegateMethodName, null);
            return (Container)m.invoke((Object)container, (Object[])null);
        }
        if (container instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)container)).getContentPane();
        }
        if (container instanceof JRootPane) {
            return ((JRootPane)container).getContentPane();
        }
        return container;
    }

    private void setReferences(FormComponent formComp) throws Exception {
        int refCount = formComp.getReferenceCount();
        if (refCount > 0) {
            Object c = this.getComponent(formComp);
            FormModel model = formComp.getModel();
            BeanInfoEx beanInfo = IntrospectorEx.getBeanInfoEx(c.getClass());
            for (Map.Entry<String, Object> entry : formComp.properties()) {
                FormComponent refComp;
                String name = entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof FormReference) || (refComp = model.getFormComponent(((FormReference)value).getName())) == null) continue;
                Object ref = this.getComponent(refComp);
                if (ref == null) {
                    ref = this.create(refComp);
                }
                this.setObjectProperty(c, name, ref, beanInfo);
                if (--refCount > 0) continue;
                break;
            }
        }
        if (formComp instanceof FormContainer) {
            FormContainer formCont = (FormContainer)formComp;
            if (formCont.getMenuBar() != null) {
                this.setReferences(formCont.getMenuBar());
            }
            int count = formCont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.setReferences(formCont.getComponent(i));
            }
        }
    }

    private Object createComponent(FormComponent formComp) throws Exception {
        Object c;
        String className = formComp.getClassName();
        if (className.startsWith("com.jformdesigner.designer.wrapper.")) {
            c = this.createWrapperComponent(formComp);
        } else {
            Class<?> beanClass = this.loader.loadClass(className);
            c = beanClass == JComponent.class ? new JComponent(){} : (beanClass == AbstractAction.class ? new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                }
            } : this.newComponentInstance(beanClass, formComp.getName()));
            this.setObjectProperties(c, formComp, null, true);
        }
        if (this.setComponentNames && c instanceof Component && formComp.getProperty("name") == null) {
            ((Component)c).setName(formComp.getName());
        }
        this.addEventListeners(formComp, c);
        return c;
    }

    protected Object newComponentInstance(Class<?> beanClass, String compName) throws Exception {
        return beanClass.newInstance();
    }

    private Component createWindowComponent(FormWindow formComp, Window owner) throws Exception {
        Component c;
        String className = formComp.getClassName();
        Class<?> beanClass = this.loader.loadClass(className);
        if (owner instanceof Frame) {
            Constructor<?> constructor = beanClass.getConstructor(Frame.class);
            c = (Component)constructor.newInstance(owner);
        } else if (owner instanceof Dialog) {
            Constructor<?> constructor = beanClass.getConstructor(Dialog.class);
            c = (Component)constructor.newInstance(owner);
        } else {
            c = (Component)beanClass.newInstance();
        }
        this.setObjectProperties(c, formComp, null, true);
        if (this.setComponentNames && formComp.getProperty("name") == null) {
            c.setName(formComp.getName());
        }
        this.addEventListeners(formComp, c);
        return c;
    }

    private Component createWrapperComponent(FormComponent formComp) throws Exception {
        String className = formComp.getClassName();
        DefaultComponentFactory factory = DefaultComponentFactory.getInstance();
        if (className.equals("com.jformdesigner.designer.wrapper.JGoodiesFormsLabel")) {
            String text = this.getPropertyStringI18n(formComp, "textWithMnemonic", "");
            JLabel c = factory.createLabel(text);
            this.setObjectProperties(c, formComp, "textWithMnemonic", true);
            return c;
        }
        if (className.equals("com.jformdesigner.designer.wrapper.JGoodiesFormsSeparator")) {
            String text = this.getPropertyStringI18n(formComp, "text", "");
            int alignment = formComp.getPropertyInt("alignment", 2);
            return factory.createSeparator(text, alignment);
        }
        if (className.equals("com.jformdesigner.designer.wrapper.JGoodiesFormsTitle")) {
            String text = this.getPropertyStringI18n(formComp, "textWithMnemonic", "");
            JLabel c = factory.createTitle(text);
            this.setObjectProperties(c, formComp, "textWithMnemonic", true);
            return c;
        }
        if (className.equals("com.jformdesigner.designer.wrapper.HSpacer") || className.equals("com.jformdesigner.designer.wrapper.VSpacer")) {
            return new JPanel(null);
        }
        throw new ClassNotFoundException(className);
    }

    private Object createConstraints(LayoutCreator layoutCreator, FormLayoutConstraints formConstraints) throws Exception {
        Class<?> constraintsClass = formConstraints.getConstraintsClass();
        if (constraintsClass == null) {
            return formConstraints;
        }
        if (constraintsClass == String.class) {
            return formConstraints.getProperty("value");
        }
        Object constraints = layoutCreator.createLayoutConstraints(formConstraints);
        if (constraints == null) {
            constraints = constraintsClass.newInstance();
            this.setObjectProperties(constraints, formConstraints, null, false);
        }
        return constraints;
    }

    private void setObjectProperties(Object target, FormObject formObject, String exclude, boolean useBeanInfo) throws Exception {
        if (formObject.getPropertyCount() == 0) {
            return;
        }
        BeanInfoEx beanInfo = useBeanInfo ? IntrospectorEx.getBeanInfoEx(target.getClass()) : null;
        for (Map.Entry<String, Object> entry : formObject.properties()) {
            Object value;
            String name = entry.getKey();
            if (name.startsWith("$") && !name.startsWith(CLIENT_PREFIX) && !name.startsWith(ACTION_PREFIX) || exclude != null && name.equals(exclude) || (value = entry.getValue()) instanceof FormReference || value == null) continue;
            this.setObjectProperty(target, name, value, beanInfo);
        }
    }

    private void setObjectProperty(Object target, String name, Object value, BeanInfoEx beanInfo) throws Exception {
        PropertyDescriptor desc;
        int ch;
        if (name.startsWith("$")) {
            if (name.startsWith(CLIENT_PREFIX) && target instanceof JComponent) {
                String key = name.substring(CLIENT_PREFIX.length());
                if (value == FormObject.NULL_VALUE) {
                    value = null;
                }
                value = ObjectCloner.cloneObject(value);
                ((JComponent)target).putClientProperty(key, value);
            } else if (name.startsWith(ACTION_PREFIX) && target instanceof Action) {
                String key = name.substring(ACTION_PREFIX.length());
                if (value == FormObject.NULL_VALUE) {
                    value = null;
                } else if (value instanceof SwingIcon) {
                    value = ((SwingIcon)value).createIcon(this.loader);
                } else if (value instanceof KeyStroke) {
                    value = this.updateKeyStroke((KeyStroke)value);
                } else if (value instanceof FormMessage) {
                    value = this.getString((FormMessage)value);
                    boolean isMnemonicIndex = key.equals("SwingDisplayedMnemonicIndexKey");
                    if (key.equals("MnemonicKey") || isMnemonicIndex) {
                        value = this.convertI18nMnemonic(value, isMnemonicIndex);
                    }
                }
                value = ObjectCloner.cloneObject(value);
                ((Action)target).putValue(key, value);
            }
            return;
        }
        boolean isI18nValue = false;
        if (value == FormObject.NULL_VALUE) {
            value = null;
        } else if (value instanceof SwingBorder) {
            value = UIManager.getBorder(((SwingBorder)value).getKey());
        } else if (value instanceof SwingColor) {
            value = UIManager.getColor(((SwingColor)value).getKey());
        } else if (value instanceof SwingDerivedFont) {
            value = ((SwingDerivedFont)value).derive((Font)this.getObjectProperty(target, name, beanInfo));
        } else if (value instanceof SwingFont) {
            value = UIManager.getFont(((SwingFont)value).getKey());
        } else if (value instanceof SwingIcon) {
            value = ((SwingIcon)value).createIcon(this.loader);
        } else if (value instanceof Border) {
            value = this.updateBorder((Border)value);
        } else if (value instanceof KeyStroke) {
            value = this.updateKeyStroke((KeyStroke)value);
        } else if (value instanceof FormMessage) {
            value = this.getString((FormMessage)value);
            isI18nValue = true;
        } else if (value instanceof FormMessageArray) {
            FormMessageArray messages = (FormMessageArray)value;
            int length = messages.getLength();
            String[] strings = new String[length];
            for (int i = 0; i < length; ++i) {
                strings[i] = this.getString(messages.getMessage(i));
            }
            value = strings;
        } else if (value instanceof Integer && ("mnemonic".equals(name) || "displayedMnemonic".equals(name) || "approveButtonMnemonic".equals(name)) && (ch = ((Integer)value).intValue()) >= 97 && ch <= 122) {
            value = new Integer(ch - 32);
        }
        value = ObjectCloner.cloneObject(value);
        if (beanInfo != null && (desc = beanInfo.getPropertyDescriptor(name)) != null) {
            Method writeMethod;
            if (value instanceof ImageIcon && Image.class.isAssignableFrom(desc.getPropertyType())) {
                value = ((ImageIcon)value).getImage();
            }
            if (isI18nValue && value instanceof String && desc.getPropertyType() == Integer.TYPE) {
                value = this.convertI18nMnemonic(value, name.endsWith("Index"));
            }
            if ((writeMethod = desc.getWriteMethod()) != null) {
                writeMethod.invoke(target, value);
                this.postSetObjectProperty(target, name, value);
                return;
            }
        }
        StringBuffer setMethodName = new StringBuffer(3 + name.length());
        setMethodName.append("set").append(name);
        setMethodName.setCharAt(3, Character.toUpperCase(setMethodName.charAt(3)));
        Statement st = new Statement(target, setMethodName.toString(), new Object[]{value});
        try {
            st.execute();
        }
        catch (NoSuchMethodException ex) {
            try {
                Field field = target.getClass().getField(name);
                field.set(target, value);
            }
            catch (NoSuchFieldException ex2) {
                throw ex;
            }
        }
        this.postSetObjectProperty(target, name, value);
    }

    private Object getObjectProperty(Object target, String name, BeanInfoEx beanInfo) throws Exception {
        Method readMethod;
        PropertyDescriptor desc;
        if (beanInfo != null && (desc = beanInfo.getPropertyDescriptor(name)) != null && (readMethod = desc.getReadMethod()) != null) {
            return readMethod.invoke(target, (Object[])null);
        }
        return null;
    }

    private Border updateBorder(Border border) {
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            String title = titledBorder.getTitle();
            if (title.startsWith(I18N_KEY_PREFIX)) {
                String newTitle = this.getString(new FormMessage(null, title.substring(I18N_KEY_PREFIX.length())));
                return RuntimeUtils.cloneTitledBorder(titledBorder, newTitle);
            }
        } else if (border instanceof MatteBorder) {
            MatteBorder matteBorder = (MatteBorder)border;
            Icon tileIcon = matteBorder.getTileIcon();
            if (tileIcon instanceof SwingIcon) {
                return new MatteBorder(RuntimeUtils.getRawMatteBorderInsets(matteBorder), ((SwingIcon)tileIcon).createIcon(this.loader));
            }
        } else if (border instanceof CompoundBorder) {
            CompoundBorder compBorder = (CompoundBorder)border;
            Border outside = this.updateBorder(compBorder.getOutsideBorder());
            Border inside = this.updateBorder(compBorder.getInsideBorder());
            if (outside != compBorder.getOutsideBorder() || inside != compBorder.getInsideBorder()) {
                return new CompoundBorder(outside, inside);
            }
        }
        return border;
    }

    private KeyStroke updateKeyStroke(KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        if ((modifiers & 0x1000) == 0) {
            return keyStroke;
        }
        modifiers &= 0xFFFFEE79;
        return KeyStroke.getKeyStroke(keyStroke.getKeyCode(), modifiers |= Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), keyStroke.isOnKeyRelease());
    }

    private Integer convertI18nMnemonic(Object value, boolean isMnemonicIndex) {
        String str = (String)value;
        if (isMnemonicIndex) {
            return Integer.valueOf(str);
        }
        char ch = str.charAt(0);
        if (ch >= 'a' && ch <= 'z') {
            ch = (char)(ch - 32);
        }
        return new Integer(ch);
    }

    private void postSetObjectProperty(Object target, String name, Object value) {
        if (name.equals("model") && target instanceof JTable && value instanceof SwingTableModel) {
            this.applyColumnInfos((JTable)target, (SwingTableModel)value);
        }
    }

    private void applyColumnInfos(JTable table, SwingTableModel model) {
        TableColumnModel cm = table.getColumnModel();
        int columnCount = model.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            SwingTableColumn colInfo = model.getColumnInfo(i);
            if (colInfo == null) continue;
            TableColumn col = cm.getColumn(i);
            if (!colInfo.getResizable()) {
                col.setResizable(false);
            }
            if (colInfo.getMinWidth() != 0) {
                col.setMinWidth(colInfo.getMinWidth());
            }
            if (colInfo.getMaxWidth() != 0) {
                col.setMaxWidth(colInfo.getMaxWidth());
            }
            if (colInfo.getPreferredWidth() != 0) {
                col.setPreferredWidth(colInfo.getPreferredWidth());
            }
            Object[] values = colInfo.getValues();
            Class<?> type = model.getColumnClass(i);
            if (values == null || values.length <= 0 || type != Object.class && type != String.class) continue;
            col.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(new DefaultComboBoxModel<Object>(values))));
        }
    }

    String getPropertyStringI18n(FormObject formObject, String name, String def) {
        Object value = formObject.getProperty(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof FormMessage) {
            return this.getString((FormMessage)value);
        }
        return def;
    }

    String getString(FormMessage message) {
        ResourceBundle bundle;
        String baseName = message.getBaseName();
        String key = message.getKey();
        if (baseName == null) {
            if (this.defaultBundle == null) {
                String bundlePackage = this.model.getPropertyString(PROP_I18N_BUNDLE_PACKAGE);
                String bundleName = this.model.getPropertyString(PROP_I18N_BUNDLE_NAME);
                this.defaultBaseName = bundlePackage != null ? bundlePackage + '.' + bundleName : bundleName;
                this.defaultBundle = this.getI18nBundle(this.defaultBaseName, this.locale, this.loader);
            }
            return this.getI18nString(this.defaultBundle, this.defaultBaseName, key);
        }
        ResourceBundle resourceBundle = bundle = this.bundleMap != null ? this.bundleMap.get(baseName) : null;
        if (bundle == null) {
            bundle = this.getI18nBundle(baseName, this.locale, this.loader);
            if (this.bundleMap == null) {
                this.bundleMap = new HashMap();
            }
            this.bundleMap.put(baseName, bundle);
        }
        return this.getI18nString(bundle, baseName, key);
    }

    protected ResourceBundle getI18nBundle(String baseName, Locale locale, ClassLoader loader) {
        return ResourceBundle.getBundle(baseName, locale, loader);
    }

    protected String getI18nString(ResourceBundle bundle, String baseName, String key) {
        return bundle.getString(key);
    }

    void updateUIValues() {
        for (Map.Entry<FormComponent, Object> e : this.componentMap.entrySet()) {
            FormComponent formComp = e.getKey();
            Object bean = e.getValue();
            BeanInfoEx beanInfo = null;
            for (Map.Entry<String, Object> entry : formComp.properties()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof SwingResource)) continue;
                try {
                    if (beanInfo == null) {
                        beanInfo = IntrospectorEx.getBeanInfoEx(bean.getClass());
                    }
                    this.setObjectProperty(bean, name, value, beanInfo);
                }
                catch (Exception ex) {}
            }
        }
    }

    private void addEventListeners(FormComponent formComp, Object c) throws Exception {
        if (this.target == null) {
            return;
        }
        FormEvent[] events = formComp.getEvents();
        if (events.length == 0) {
            return;
        }
        BeanInfoEx beanInfo = IntrospectorEx.getBeanInfoEx(c.getClass());
        for (int i = 0; i < events.length; ++i) {
            Method addMethod;
            FormEvent event = events[i];
            Class<?> listenerClass = this.loader.loadClass(event.getListener());
            EventSetDescriptor eventSetDesc = beanInfo.getEventSetDescriptor(event.getListener());
            if (eventSetDesc == null) {
                throw new IllegalStateException("Component " + formComp.getName() + " (class " + formComp.getClassName() + ") does not support " + event.getListener() + ".");
            }
            Method listenerMethod = this.findListenerMethod(eventSetDesc, event.getListenerMethod());
            if (listenerMethod == null) {
                throw new IllegalStateException("Component " + formComp.getName() + ": Event listener " + event.getListener() + " does not have a " + event.getListenerMethod() + " method.");
            }
            HandlerInvoker handlerInvoker = new HandlerInvoker(this.target, listenerMethod, event.getHandler(), event.getPassParams());
            Object listener = Proxy.newProxyInstance(this.loader, new Class[]{listenerClass}, (InvocationHandler)handlerInvoker);
            if (listenerClass == PropertyChangeListener.class && event.getPropertyName() != null) {
                addMethod = c.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                addMethod.invoke(c, event.getPropertyName(), listener);
                continue;
            }
            addMethod = eventSetDesc.getAddListenerMethod();
            addMethod.invoke(c, listener);
        }
    }

    private Method findListenerMethod(EventSetDescriptor eventSetDesc, String listenerMethod) {
        Method[] methods = eventSetDesc.getListenerMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!listenerMethod.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerInvoker
    implements InvocationHandler {
        private final Object target;
        private final String listenerMethod;
        private final Method targetMethod;
        private final boolean passParams;

        HandlerInvoker(Object target, Method listenerMethod, String handler, boolean passParams) throws Exception {
            this.target = target;
            this.listenerMethod = listenerMethod.getName();
            Class<?> targetClass = target.getClass();
            Method targetMethod = null;
            if (passParams) {
                Class<?>[] paramTypes = listenerMethod.getParameterTypes();
                try {
                    targetMethod = HandlerInvoker.getDeclaredMethod(targetClass, handler, paramTypes);
                }
                catch (NoSuchMethodException ex) {
                    passParams = false;
                }
            }
            if (targetMethod == null) {
                targetMethod = HandlerInvoker.getDeclaredMethod(targetClass, handler, null);
            }
            targetMethod.setAccessible(true);
            this.targetMethod = targetMethod;
            this.passParams = passParams;
        }

        private static Method getDeclaredMethod(Class<?> targetClass, String name, Class<?>[] paramTypes) throws NoSuchMethodException, SecurityException {
            try {
                return targetClass.getDeclaredMethod(name, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                try {
                    Class<?> superclass = targetClass.getSuperclass();
                    if (superclass != Object.class && superclass != null) {
                        return HandlerInvoker.getDeclaredMethod(superclass, name, paramTypes);
                    }
                }
                catch (NoSuchMethodException ex2) {
                    // empty catch block
                }
                throw ex;
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() != Object.class) {
                if (this.listenerMethod.equals(method.getName())) {
                    return this.targetMethod.invoke(this.target, (Object[])(this.passParams ? args : null));
                }
            } else {
                if ("equals".equals(method.getName())) {
                    return proxy == args[0];
                }
                if ("hashCode".equals(method.getName())) {
                    return new Integer(this.hashCode());
                }
            }
            return null;
        }
    }
}

