/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.colors;

import com.jeta.forms.colormgr.ColorManager;
import com.jeta.forms.components.colors.ColorSelectorUtils;
import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.registry.JETARegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorDefinitionView
extends JETAPanel {
    private FormPanel m_view;
    private ColorProperty m_color_prop = new ColorProperty();
    private ColorDefinitionController m_controller;
    private JComboBox m_key_combo;
    private Component m_color_well;
    private JSpinner m_factor_spinner;
    private JSpinner m_bright_spinner;
    private static LinkedList m_color_cell_values;
    private static LookAndFeel m_look_and_feel;

    public ColorDefinitionView() {
        try {
            this.m_view = new FormPanel("com/jeta/forms/components/colors/colorSelection.jfrm");
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_view, "Center");
            this.m_color_well = this.m_view.getComponentByName("color.inkwell");
            this.m_key_combo = this.m_view.getComboBox("color.name.combo");
            this.m_key_combo.setRenderer(new ColorCellRenderer());
            this.m_key_combo.setName("color.name.combo");
            this.m_key_combo.removeAllItems();
            Collection collection = ColorDefinitionView.getColorCellValues();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.m_key_combo.addItem(iterator.next());
            }
            this.m_factor_spinner = this.m_view.getSpinner("brighter.factor");
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0.7, 0.05, 1.0, 0.05);
            this.m_factor_spinner.setModel(spinnerNumberModel);
            this.m_bright_spinner = this.m_view.getSpinner("brighter.value");
            spinnerNumberModel = new SpinnerNumberModel(0, -10, 10, 1);
            this.m_bright_spinner.setModel(spinnerNumberModel);
            this.m_controller = new ColorDefinitionController();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ColorProperty getColorProperty() {
        try {
            ColorProperty colorProperty = new ColorProperty();
            colorProperty.setConstantColor(ColorSelectorUtils.getColor(this.m_color_well));
            colorProperty.setColorKey(this.getSelectedColorKey());
            Double d = (Double)this.m_factor_spinner.getValue();
            colorProperty.setBrightnessFactor(d.floatValue());
            Integer n = (Integer)this.m_bright_spinner.getValue();
            colorProperty.setBrightness(n);
            return colorProperty;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.m_color_prop;
        }
    }

    private static Collection getColorCellValues() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (m_look_and_feel != lookAndFeel || m_color_cell_values == null) {
            if (m_color_cell_values == null) {
                m_color_cell_values = new LinkedList();
            }
            m_color_cell_values.clear();
            m_look_and_feel = lookAndFeel;
            ColorManager colorManager = (ColorManager)JETARegistry.lookup("jeta.color.manager");
            Collection collection = colorManager.getColorKeys();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                m_color_cell_values.add(new ColorCellValue(string, colorManager.getColor(string, null)));
            }
        }
        return m_color_cell_values;
    }

    public String getSelectedColorKey() {
        ColorCellValue colorCellValue = (ColorCellValue)this.m_key_combo.getSelectedItem();
        return colorCellValue.getName();
    }

    public void prependColor(String string, Color color) {
        if (string == null) {
            return;
        }
        this.m_key_combo.insertItemAt(new ColorCellValue(string, color), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorProperty(ColorProperty colorProperty) {
        try {
            this.m_controller.setSilent(true);
            this.m_color_prop.setValue(colorProperty);
            String string = colorProperty.getColorKey();
            this.setSelectedColor(string);
            ColorSelectorUtils.setColor(this.m_color_well, colorProperty.getColor());
            this.m_factor_spinner.setValue(new Double(colorProperty.getBrightnessFactor()));
            this.m_bright_spinner.setValue(new Integer(colorProperty.getBrightness()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.m_controller.setSilent(false);
        }
    }

    public void setSelectedColor(String string) {
        ComboBoxModel comboBoxModel = this.m_key_combo.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!comboBoxModel.getElementAt(i).equals(string)) continue;
            this.m_key_combo.setSelectedIndex(i);
            return;
        }
        this.m_key_combo.setSelectedIndex(0);
    }

    public static class ColorCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ColorCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ColorCellValue colorCellValue = (ColorCellValue)object;
            if (colorCellValue == null) {
                this.setIcon(null);
                this.setText("");
            } else {
                this.setIcon(colorCellValue.getIcon());
                this.setText(colorCellValue.getName());
            }
            if (bl) {
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("ComboBox.background"));
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            return this;
        }
    }

    public static class ColorCellValue {
        String m_color_name;
        Color m_color;
        ColorLookup m_color_key = new ColorLookup();
        private static HashMap m_color_icons = new HashMap();

        public ColorCellValue(String string, Color color) {
            this.m_color_name = string;
            this.m_color = color;
            if (this.m_color_name == null) {
                this.m_color_name = "constant";
            }
        }

        public boolean equals(Object object) {
            return this.m_color_name.equals(object.toString());
        }

        public String getName() {
            return this.m_color_name;
        }

        public Icon getIcon() {
            if (this.m_color == null) {
                return null;
            }
            this.m_color_key.key = this.m_color.getRGB();
            Icon icon = (Icon)m_color_icons.get(this.m_color_key);
            if (icon == null) {
                int n = 12;
                int n2 = 12;
                BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(this.m_color);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                graphics2D.dispose();
                icon = new ImageIcon(bufferedImage);
                m_color_icons.put(new Integer(this.m_color.getRGB()), icon);
            }
            return icon;
        }

        public String toString() {
            return this.m_color_name;
        }
    }

    public static class ColorLookup {
        int key;

        public int hashCode() {
            return this.key;
        }
    }

    private class ColorDefinitionController {
        private boolean m_silent = false;

        public ColorDefinitionController() {
            ColorDefinitionView.this.m_key_combo.addActionListener(new ComboChangedAction());
            ColorSelectorUtils.addActionListener(ColorDefinitionView.this.m_color_well, new ColorWellClicked());
            ColorDefinitionView.this.m_factor_spinner.addChangeListener(new ColorChangedAction());
            ColorDefinitionView.this.m_bright_spinner.addChangeListener(new ColorChangedAction());
        }

        public void setSilent(boolean bl) {
            this.m_silent = bl;
        }

        public class ColorWellClicked
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ColorDefinitionController.this.m_silent;
                if (!bl) {
                    ColorDefinitionController.this.setSilent(true);
                    ColorDefinitionView.this.m_key_combo.setSelectedIndex(0);
                    ColorDefinitionController.this.setSilent(bl);
                }
            }
        }

        public class ColorChangedAction
        implements ChangeListener {
            public void stateChanged(ChangeEvent changeEvent) {
            }
        }

        public class ComboChangedAction
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ColorDefinitionController.this.m_silent;
                if (!bl) {
                    ColorDefinitionController.this.setSilent(true);
                    ColorDefinitionView.this.m_color_prop.setColorKey(ColorDefinitionView.this.getSelectedColorKey());
                    if (!ColorDefinitionView.this.m_color_prop.isConstant()) {
                        ColorSelectorUtils.setColor(ColorDefinitionView.this.m_color_well, ColorDefinitionView.this.m_color_prop.getColor());
                    }
                    ColorDefinitionController.this.setSilent(bl);
                }
            }
        }
    }
}

