/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormRoot;
import java.util.HashMap;

final class FormNameRegistry {
    private final HashMap<String, FormComponent> namesMap = new HashMap();

    FormNameRegistry(FormModel formModel) {
        FormRoot formRoot = formModel.getRoot();
        if (formRoot != null) {
            this.addNames(formRoot);
        }
    }

    private void addNames(FormComponent formComponent) {
        String string = formComponent.getName();
        if (string != null) {
            this.namesMap.put(string, formComponent);
        }
        if (formComponent instanceof FormContainer) {
            FormContainer formContainer = (FormContainer)formComponent;
            if (formContainer.getMenuBar() != null) {
                this.addNames(formContainer.getMenuBar());
            }
            int n2 = formContainer.getComponentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.addNames(formContainer.getComponent(i2));
            }
        }
    }

    private void removeNames(FormComponent formComponent) {
        String string = formComponent.getName();
        if (string != null) {
            this.namesMap.remove(string);
        }
        if (formComponent instanceof FormContainer) {
            FormContainer formContainer = (FormContainer)formComponent;
            if (formContainer.getMenuBar() != null) {
                this.removeNames(formContainer.getMenuBar());
            }
            int n2 = formContainer.getComponentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.removeNames(formContainer.getComponent(i2));
            }
        }
    }

    FormComponent getFormComponent(String string) {
        return this.namesMap.get(string);
    }

    String[] getNames() {
        return this.namesMap.keySet().toArray(new String[this.namesMap.size()]);
    }

    void componentAdded(FormComponent formComponent) {
        this.addNames(formComponent);
    }

    void componentRemoved(FormComponent formComponent) {
        this.removeNames(formComponent);
    }

    void componentFieldChanged(FormComponent formComponent, String string, Object object, Object object2) {
        if (string == "name") {
            this.namesMap.remove(object);
            this.namesMap.put((String)object2, formComponent);
        } else if (string == "menuBar") {
            if (object != null) {
                this.removeNames((FormComponent)object);
            }
            if (object2 != null) {
                this.addNames((FormComponent)object2);
            }
        }
    }
}

