/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormObject$1;
import com.jformdesigner.model.FormObject$EmptyIterator;
import com.jformdesigner.model.FormObject$MyIterator;
import com.jformdesigner.model.FormReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormObject {
    public static final Object NULL_VALUE = new FormObject$1();
    private static final FormObject$EmptyIterator<Map.Entry<String, Object>> EMPTY_ITERATOR = new FormObject$EmptyIterator();
    private LinkedHashMap<String, Object> properties;
    private int referenceCount;

    FormObject() {
    }

    FormObject(FormObject formObject, int n2) {
        if (formObject.properties != null) {
            this.properties = new LinkedHashMap<String, Object>(formObject.properties);
        }
        this.referenceCount = formObject.referenceCount;
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public Object getProperty(String string, Object object) {
        Object object2 = this.getProperty(string);
        return object2 != null ? object2 : object;
    }

    public void setProperty(String string, Object object) {
        this.setProperty(string, -1, object);
    }

    public void setProperty(String string, int n2, Object object) {
        Object object2;
        if (this.properties == null) {
            this.properties = new LinkedHashMap(8);
        }
        int n3 = -1;
        if (object != null) {
            if (n2 < 0 || n2 >= this.properties.size() || this.properties.containsKey(string)) {
                object2 = this.properties.put(string, object);
            } else {
                this.properties = FormObject.insertAt(this.properties, string, n2, object);
                object2 = null;
            }
        } else {
            n3 = FormObject.getIndexOf(this.properties, string);
            object2 = this.properties.remove(string);
        }
        if (object2 instanceof FormReference) {
            --this.referenceCount;
        }
        if (object instanceof FormReference) {
            ++this.referenceCount;
        }
        this.firePropertyChanged(string, n3, object2, object);
    }

    private static LinkedHashMap<String, Object> insertAt(Map<String, Object> map, String string, int n2, Object object) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(Math.max(map.size() + 1, 16));
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            if (n3 == n2) {
                linkedHashMap.put(string, object);
            }
            Map.Entry<String, Object> entry = iterator.next();
            linkedHashMap.put(entry.getKey(), entry.getValue());
            ++n3;
        }
        return linkedHashMap;
    }

    private static int getIndexOf(Map<String, Object> map, String string) {
        Iterator<String> iterator = map.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            if (string.equals(iterator.next())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void setProperty(String string, Object object, Object object2) {
        this.setProperty(string, !object2.equals(object) ? object : null);
    }

    public String getPropertyString(String string) {
        return this.getPropertyString(string, null);
    }

    public String getPropertyString(String string, String string2) {
        Object object = this.getProperty(string);
        return object instanceof String ? (String)object : string2;
    }

    public void setPropertyString(String string, String string2) {
        this.setProperty(string, string2);
    }

    public int getPropertyInt(String string) {
        return this.getPropertyInt(string, 0);
    }

    public int getPropertyInt(String string, int n2) {
        Object object = this.getProperty(string);
        return object instanceof Integer ? (Integer)object : n2;
    }

    public void setPropertyInt(String string, int n2) {
        this.setProperty(string, new Integer(n2));
    }

    public void setPropertyInt(String string, int n2, int n3) {
        this.setProperty(string, n2 != n3 ? new Integer(n2) : null);
    }

    public double getPropertyDouble(String string) {
        return this.getPropertyDouble(string, 0.0);
    }

    public double getPropertyDouble(String string, double d2) {
        Object object = this.getProperty(string);
        return object instanceof Double ? (Double)object : d2;
    }

    public void setPropertyDouble(String string, double d2) {
        this.setProperty(string, new Double(d2));
    }

    public void setPropertyDouble(String string, double d2, double d3) {
        this.setProperty(string, d2 != d3 ? new Double(d2) : null);
    }

    public boolean getPropertyBoolean(String string) {
        return this.getPropertyBoolean(string, false);
    }

    public boolean getPropertyBoolean(String string, boolean bl2) {
        Object object = this.getProperty(string);
        return object instanceof Boolean ? (Boolean)object : bl2;
    }

    public void setPropertyBoolean(String string, boolean bl2) {
        this.setProperty(string, bl2);
    }

    public void setPropertyBoolean(String string, boolean bl2, boolean bl3) {
        this.setProperty(string, bl2 != bl3 ? Boolean.valueOf(bl2) : null);
    }

    public Iterable<Map.Entry<String, Object>> properties() {
        return this.properties != null && this.properties.size() > 0 ? new FormObject$MyIterator<Map.Entry<String, Object>>(this.properties.entrySet().iterator()) : EMPTY_ITERATOR;
    }

    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.properties().iterator();
    }

    public Iterable<String> propertyNames() {
        return this.properties != null && this.properties.size() > 0 ? new FormObject$MyIterator<String>(this.properties.keySet().iterator()) : new FormObject$EmptyIterator<String>();
    }

    public Iterator<String> getPropertyNames() {
        return this.propertyNames().iterator();
    }

    public int getPropertyCount() {
        return this.properties != null ? this.properties.size() : 0;
    }

    abstract void firePropertyChanged(String var1, int var2, Object var3, Object var4);

    boolean isEqual(FormObject formObject) {
        if (formObject == this) {
            return true;
        }
        return FormObject.safeEquals(this.properties, formObject.properties);
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    void updateReferences(String string, String string2) {
        if (this.properties == null || this.referenceCount == 0) {
            return;
        }
        int n2 = this.referenceCount;
        for (Map.Entry<String, Object> entry : this.properties()) {
            Object object = entry.getValue();
            if (!(object instanceof FormReference)) continue;
            if (string.equals(((FormReference)object).getName())) {
                this.setProperty(entry.getKey(), string2 != null ? new FormReference(string2) : null);
            }
            if (--n2 > 0) continue;
            break;
        }
    }

    public String toString() {
        return this.properties != null ? "properties=" + this.properties.toString() : "";
    }

    static String unqualifiedClassName(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    static boolean safeEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }
}

