/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormBindingGroup;
import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormEvent;
import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.model.FormMessage;
import com.jformdesigner.model.FormMessageArray;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormNonVisual;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormReference;
import com.jformdesigner.model.FormRoot;
import com.jformdesigner.model.FormWindow;
import com.jformdesigner.model.SwingBorder;
import com.jformdesigner.model.SwingColor;
import com.jformdesigner.model.SwingDerivedFont;
import com.jformdesigner.model.SwingFont;
import com.jformdesigner.model.SwingIcon;
import com.jformdesigner.model.SwingResource;
import com.jformdesigner.model.SwingTableColumn;
import com.jformdesigner.model.SwingTableModel;
import com.jformdesigner.runtime.BeanInfoEx;
import com.jformdesigner.runtime.BeanProvider;
import com.jformdesigner.runtime.BindingCreator;
import com.jformdesigner.runtime.BindingCreatorRegistry;
import com.jformdesigner.runtime.ComponentProvider;
import com.jformdesigner.runtime.FormCreator$1;
import com.jformdesigner.runtime.FormCreator$2;
import com.jformdesigner.runtime.FormCreator$HandlerInvoker;
import com.jformdesigner.runtime.IntrospectorEx;
import com.jformdesigner.runtime.LayoutCreator;
import com.jformdesigner.runtime.LayoutCreatorRegistry;
import com.jformdesigner.runtime.NoSuchComponentException;
import com.jformdesigner.runtime.ObjectCloner;
import com.jformdesigner.runtime.RuntimeUtils;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.BeanDescriptor;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormCreator
implements BeanProvider,
ComponentProvider {
    private static final String PROP_I18N_BUNDLE_PACKAGE = "i18n.bundlePackage";
    private static final String PROP_I18N_BUNDLE_NAME = "i18n.bundleName";
    private static final String PROP_BUTTON_GROUP = "$buttonGroup";
    private static final String PROP_SET_COMPONENT_NAMES = "$setComponentNames";
    private static final String PROP_LOCATION_POLICY = "$locationPolicy";
    private static final String PROP_SIZE_POLICY = "$sizePolicy";
    private static final String CONTAINER_DELEGATE = "containerDelegate";
    private static final String DESIGNER_CONTAINER_DELEGATE = "designerContainerDelegate";
    private static final String CLIENT_PREFIX = "$client.";
    private static final String ACTION_PREFIX = "$action.";
    private static final String I18N_KEY_PREFIX = "i18nKey=";
    private final FormModel model;
    private final Locale locale;
    private ClassLoader loader;
    private boolean setComponentNames;
    private Object target;
    private final IdentityHashMap<FormComponent, Object> componentMap = new IdentityHashMap();
    private HashMap<String, ButtonGroup> buttonGroupMap;
    private HashMap<String, ResourceBundle> bundleMap;
    private ResourceBundle defaultBundle;
    private String defaultBaseName;

    public FormCreator(FormModel formModel) {
        this(formModel, null);
    }

    public FormCreator(FormModel formModel, ClassLoader classLoader) {
        this(formModel, null, classLoader);
    }

    public FormCreator(FormModel formModel, Locale locale, ClassLoader classLoader) {
        if (formModel == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.model = formModel;
        this.locale = locale != null ? locale : Locale.getDefault();
        ClassLoader classLoader2 = this.loader = classLoader != null ? classLoader : this.getClass().getClassLoader();
        if (this.loader == null) {
            this.loader = ClassLoader.getSystemClassLoader();
        }
        if (this.loader == null) {
            throw new IllegalArgumentException("Unable to get class loader. getClass().getClassLoader() and ClassLoader.getSystemClassLoader() returned null");
        }
        this.setComponentNames = formModel.getRoot().getPropertyBoolean(PROP_SET_COMPONENT_NAMES);
    }

    public FormModel getModel() {
        return this.model;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object object) {
        if (this.componentMap.size() > 0) {
            throw new IllegalStateException("Invoke setTarget() before creating components.");
        }
        this.target = object;
    }

    public boolean isSetComponentNames() {
        return this.setComponentNames;
    }

    public void setSetComponentNames(boolean bl2) {
        this.setComponentNames = bl2;
    }

    public void createAll() {
        FormRoot formRoot = this.model.getRoot();
        int n2 = formRoot.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.create(formRoot.getComponent(i2));
        }
    }

    public Component create() {
        FormComponent formComponent = this.getFirstVisualTopLevel();
        if (formComponent == null) {
            throw new IllegalStateException("Form does not have a top-level component.");
        }
        return (Component)this.create(formComponent);
    }

    public JPanel createPanel() {
        return (JPanel)this.create();
    }

    public JDialog createDialog(Window window) {
        return (JDialog)this.createWindow(window);
    }

    public Window createWindow(Window window) {
        FormComponent formComponent = this.getFirstVisualTopLevel();
        if (formComponent == null) {
            throw new IllegalStateException("Form does not have a top-level component.");
        }
        return (Window)this.create(formComponent, window);
    }

    public Component create(String string) {
        return this.create(string, null);
    }

    public Component create(String string, Window window) {
        FormComponent formComponent = this.model.getFormComponent(string);
        if (formComponent == null) {
            throw new NoSuchComponentException("Unknown component \"" + string + "\".");
        }
        return (Component)this.create(formComponent, window);
    }

    Object create(FormComponent formComponent) {
        return this.create(formComponent, null);
    }

    Object create(FormComponent formComponent, Window window) {
        Object object = this.getComponent(formComponent);
        if (object == null) {
            object = this.createComponents(formComponent, window);
            this.setReferences(formComponent);
        }
        return object;
    }

    private FormComponent getFirstVisualTopLevel() {
        FormRoot formRoot = this.model.getRoot();
        int n2 = formRoot.getComponentCount();
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            FormComponent formComponent = formRoot.getComponent(i2);
            if (formComponent instanceof FormNonVisual) continue;
            return formComponent;
        }
        return null;
    }

    public Object[] createBindings() {
        FormBindingGroup[] formBindingGroupArray = this.model.getRoot().getBindingGroups();
        if (formBindingGroupArray.length == 0) {
            return null;
        }
        Object[] objectArray = new Object[formBindingGroupArray.length];
        for (int i2 = 0; i2 < formBindingGroupArray.length; ++i2) {
            BindingCreator<?, ?> bindingCreator = BindingCreatorRegistry.createBindingCreator(formBindingGroupArray[i2].getBindingGroupClass());
            bindingCreator.setFormCreator(this);
            Object obj = bindingCreator.createBindingGroup(formBindingGroupArray[i2]);
            if (formBindingGroupArray[i2].getPropertyBoolean("bound", true)) {
                bindingCreator.bindGroup(obj);
            }
            objectArray[i2] = obj;
        }
        return objectArray;
    }

    @Override
    public Component getComponent(String string) {
        return (Component)this.getBean(string);
    }

    public Object getBean(String string) {
        FormComponent formComponent = this.model.getFormComponent(string);
        if (formComponent == null) {
            throw new NoSuchComponentException("Unknown component \"" + string + "\".");
        }
        Object object = this.getComponent(formComponent);
        if (object == null) {
            throw new NoSuchComponentException("Component \"" + string + "\" is not created.");
        }
        return object;
    }

    @Override
    public Object getBean(String string, boolean bl2) {
        FormComponent formComponent = this.model.getFormComponent(string);
        if (formComponent == null) {
            throw new NoSuchComponentException("Unknown component \"" + string + "\".");
        }
        return this.create(formComponent);
    }

    public JButton getButton(String string) {
        return (JButton)this.getComponent(string);
    }

    public JCheckBox getCheckBox(String string) {
        return (JCheckBox)this.getComponent(string);
    }

    public JCheckBoxMenuItem getCheckBoxMenuItem(String string) {
        return (JCheckBoxMenuItem)this.getComponent(string);
    }

    public JComboBox getComboBox(String string) {
        return (JComboBox)this.getComponent(string);
    }

    public JDialog getDialog(String string) {
        return (JDialog)this.getComponent(string);
    }

    public JEditorPane getEditorPane(String string) {
        return (JEditorPane)this.getComponent(string);
    }

    public JFormattedTextField getFormattedTextField(String string) {
        return (JFormattedTextField)this.getComponent(string);
    }

    public JFrame getFrame(String string) {
        return (JFrame)this.getComponent(string);
    }

    public JLabel getLabel(String string) {
        return (JLabel)this.getComponent(string);
    }

    public JList getList(String string) {
        return (JList)this.getComponent(string);
    }

    public JMenu getMenu(String string) {
        return (JMenu)this.getComponent(string);
    }

    public JMenuBar getMenuBar(String string) {
        return (JMenuBar)this.getComponent(string);
    }

    public JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.getComponent(string);
    }

    public JPanel getPanel(String string) {
        return (JPanel)this.getComponent(string);
    }

    public JPasswordField getPasswordField(String string) {
        return (JPasswordField)this.getComponent(string);
    }

    public JPopupMenu getPopupMenu(String string) {
        return (JPopupMenu)this.getComponent(string);
    }

    public JProgressBar getProgressBar(String string) {
        return (JProgressBar)this.getComponent(string);
    }

    public JRadioButton getRadioButton(String string) {
        return (JRadioButton)this.getComponent(string);
    }

    public JRadioButtonMenuItem getRadioButtonMenuItem(String string) {
        return (JRadioButtonMenuItem)this.getComponent(string);
    }

    public JScrollBar getScrollBar(String string) {
        return (JScrollBar)this.getComponent(string);
    }

    public JScrollPane getScrollPane(String string) {
        return (JScrollPane)this.getComponent(string);
    }

    public JSeparator getSeparator(String string) {
        return (JSeparator)this.getComponent(string);
    }

    public JSlider getSlider(String string) {
        return (JSlider)this.getComponent(string);
    }

    public JSpinner getSpinner(String string) {
        return (JSpinner)this.getComponent(string);
    }

    public JSplitPane getSplitPane(String string) {
        return (JSplitPane)this.getComponent(string);
    }

    public JTabbedPane getTabbedPane(String string) {
        return (JTabbedPane)this.getComponent(string);
    }

    public JTable getTable(String string) {
        return (JTable)this.getComponent(string);
    }

    public JTextArea getTextArea(String string) {
        return (JTextArea)this.getComponent(string);
    }

    public JTextField getTextField(String string) {
        return (JTextField)this.getComponent(string);
    }

    public JTextPane getTextPane(String string) {
        return (JTextPane)this.getComponent(string);
    }

    public JToggleButton getToggleButton(String string) {
        return (JToggleButton)this.getComponent(string);
    }

    public JToolBar getToolBar(String string) {
        return (JToolBar)this.getComponent(string);
    }

    public JTree getTree(String string) {
        return (JTree)this.getComponent(string);
    }

    public JWindow getWindow(String string) {
        return (JWindow)this.getComponent(string);
    }

    private Object getComponent(FormComponent formComponent) {
        return this.componentMap.get(formComponent);
    }

    private Object createComponents(FormComponent formComponent, Window window) {
        FormObject formObject;
        Object object;
        Object object2;
        Object object3 = this.getComponent(formComponent);
        if (object3 != null) {
            return object3;
        }
        object3 = window != null && formComponent instanceof FormWindow ? this.createWindowComponent((FormWindow)formComponent, window) : this.createComponent(formComponent);
        this.componentMap.put(formComponent, object3);
        Object object4 = formComponent.getProperty(PROP_BUTTON_GROUP);
        if (object4 instanceof FormReference && object3 instanceof AbstractButton) {
            object2 = ((FormReference)object4).getName();
            Object object5 = object = this.buttonGroupMap != null ? this.buttonGroupMap.get(object2) : null;
            if (object == null) {
                formObject = this.model.getFormComponent((String)object2);
                if (formObject != null) {
                    object = (ButtonGroup)this.componentMap.get(formObject);
                    if (object == null) {
                        object = (ButtonGroup)this.createComponent((FormComponent)formObject);
                        this.componentMap.put((FormComponent)formObject, object);
                    }
                } else {
                    object = new ButtonGroup();
                }
                if (this.buttonGroupMap == null) {
                    this.buttonGroupMap = new HashMap();
                }
                this.buttonGroupMap.put((String)object2, (ButtonGroup)object);
            }
            ((ButtonGroup)object).add((AbstractButton)object3);
        }
        if (formComponent instanceof FormContainer) {
            Serializable serializable;
            FormLayoutConstraints formLayoutConstraints;
            object2 = this.getContainerDelegate((Container)object3);
            object = (FormContainer)formComponent;
            this.createMenuBar((FormContainer)object, (Container)object3);
            formObject = ((FormContainer)object).getLayout();
            LayoutCreator layoutCreator = null;
            if (formObject != null) {
                layoutCreator = LayoutCreatorRegistry.createLayoutCreator(((FormLayoutManager)formObject).getLayoutClass());
                layoutCreator.setFormCreator(this);
                LayoutManager layoutManager = layoutCreator.createLayoutManager((Container)object2, (FormLayoutManager)formObject);
                if (layoutManager != null) {
                    ((Container)object2).setLayout(layoutManager);
                }
            }
            int n2 = ((FormContainer)object).getComponentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                FormComponent formComponent2 = ((FormContainer)object).getComponent(i2);
                formLayoutConstraints = null;
                serializable = (Component)this.createComponents(formComponent2, null);
                Object object6 = null;
                if (formObject != null && (formLayoutConstraints = ((FormLayoutManager)formObject).getConstraints(formComponent2)) != null) {
                    object6 = this.createConstraints(layoutCreator, formLayoutConstraints);
                }
                if (layoutCreator != null) {
                    layoutCreator.addComponentToContainer((Container)object2, (Component)serializable, object6, -1, formLayoutConstraints);
                    continue;
                }
                ((Container)object2).add((Component)serializable, object6);
            }
            if (layoutCreator != null) {
                layoutCreator.finishLayoutInitialization((Container)object2, (FormLayoutManager)formObject);
            }
            if (formComponent instanceof FormWindow && object3 instanceof Window) {
                Window window2 = (Window)object3;
                int n3 = formComponent.getPropertyInt(PROP_SIZE_POLICY);
                if (n3 == 0) {
                    window2.pack();
                } else if (n3 == 1 && (formLayoutConstraints = formComponent.getConstraints()) != null && (serializable = (Dimension)formLayoutConstraints.getProperty("size")) != null) {
                    window2.setSize((Dimension)serializable);
                }
                int n4 = formComponent.getPropertyInt(PROP_LOCATION_POLICY);
                if (n4 == 0) {
                    window2.setLocationRelativeTo(window2.getOwner());
                } else if (n4 == 1) {
                    window2.setLocationRelativeTo(null);
                }
            }
        }
        return object3;
    }

    private void createMenuBar(FormContainer formContainer, Component component) {
        FormContainer formContainer2 = formContainer.getMenuBar();
        if (formContainer2 == null) {
            return;
        }
        JMenuBar jMenuBar = (JMenuBar)this.createComponents(formContainer2, null);
        Method method = component.getClass().getMethod("setJMenuBar", JMenuBar.class);
        method.invoke((Object)component, jMenuBar);
    }

    private Container getContainerDelegate(Container container) {
        Object object;
        Class<?> clazz = container.getClass();
        if (clazz == JPanel.class || container instanceof JTabbedPane) {
            return container;
        }
        if (container instanceof JScrollPane) {
            return container;
        }
        String string = null;
        try {
            BeanDescriptor beanDescriptor;
            object = IntrospectorEx.getBeanInfoEx(clazz);
            if (object != null && (beanDescriptor = ((BeanInfoEx)object).getBeanDescriptor()) != null && (string = (String)beanDescriptor.getValue(CONTAINER_DELEGATE)) == null) {
                string = (String)beanDescriptor.getValue(DESIGNER_CONTAINER_DELEGATE);
            }
        }
        catch (IntrospectionException introspectionException) {
            return container;
        }
        if (string == null && clazz.getName().equals("com.jgoodies.uif_lite.panel.SimpleInternalFrame")) {
            string = "getContentPane";
        }
        if (string != null) {
            object = container.getClass().getMethod(string, null);
            return (Container)((Method)object).invoke((Object)container, (Object[])null);
        }
        if (container instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)container)).getContentPane();
        }
        if (container instanceof JRootPane) {
            return ((JRootPane)container).getContentPane();
        }
        return container;
    }

    private void setReferences(FormComponent formComponent) {
        Object object;
        int n2 = formComponent.getReferenceCount();
        if (n2 > 0) {
            object = this.getComponent(formComponent);
            FormModel formModel = formComponent.getModel();
            BeanInfoEx beanInfoEx = IntrospectorEx.getBeanInfoEx(object.getClass());
            for (Map.Entry<String, Object> entry : formComponent.properties()) {
                FormComponent formComponent2;
                String string = entry.getKey();
                Object object2 = entry.getValue();
                if (!(object2 instanceof FormReference) || (formComponent2 = formModel.getFormComponent(((FormReference)object2).getName())) == null) continue;
                Object object3 = this.getComponent(formComponent2);
                if (object3 == null) {
                    object3 = this.create(formComponent2);
                }
                this.setObjectProperty(object, string, object3, beanInfoEx);
                if (--n2 > 0) continue;
                break;
            }
        }
        if (formComponent instanceof FormContainer) {
            object = (FormContainer)formComponent;
            if (((FormContainer)object).getMenuBar() != null) {
                this.setReferences(((FormContainer)object).getMenuBar());
            }
            int n3 = ((FormContainer)object).getComponentCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.setReferences(((FormContainer)object).getComponent(i2));
            }
        }
    }

    private Object createComponent(FormComponent formComponent) {
        Object object;
        String string = formComponent.getClassName();
        if (string.startsWith("com.jformdesigner.designer.wrapper.")) {
            object = this.createWrapperComponent(formComponent);
        } else {
            Class<?> clazz = this.loader.loadClass(string);
            object = clazz == JComponent.class ? new FormCreator$1(this) : (clazz == AbstractAction.class ? new FormCreator$2(this) : this.newComponentInstance(clazz, formComponent.getName()));
            this.setObjectProperties(object, formComponent, null, true);
        }
        if (this.setComponentNames && object instanceof Component && formComponent.getProperty("name") == null) {
            ((Component)object).setName(formComponent.getName());
        }
        this.addEventListeners(formComponent, object);
        return object;
    }

    protected Object newComponentInstance(Class<?> clazz, String string) {
        return clazz.newInstance();
    }

    private Component createWindowComponent(FormWindow formWindow, Window window) {
        Component component;
        String string = formWindow.getClassName();
        Class<?> clazz = this.loader.loadClass(string);
        if (window instanceof Frame) {
            Constructor<?> constructor = clazz.getConstructor(Frame.class);
            component = (Component)constructor.newInstance(window);
        } else if (window instanceof Dialog) {
            Constructor<?> constructor = clazz.getConstructor(Dialog.class);
            component = (Component)constructor.newInstance(window);
        } else {
            component = (Component)clazz.newInstance();
        }
        this.setObjectProperties(component, formWindow, null, true);
        if (this.setComponentNames && formWindow.getProperty("name") == null) {
            component.setName(formWindow.getName());
        }
        this.addEventListeners(formWindow, component);
        return component;
    }

    private Component createWrapperComponent(FormComponent formComponent) {
        String string = formComponent.getClassName();
        DefaultComponentFactory defaultComponentFactory = DefaultComponentFactory.getInstance();
        if (string.equals("com.jformdesigner.designer.wrapper.JGoodiesFormsLabel")) {
            String string2 = this.getPropertyStringI18n(formComponent, "textWithMnemonic", "");
            JLabel jLabel = defaultComponentFactory.createLabel(string2);
            this.setObjectProperties(jLabel, formComponent, "textWithMnemonic", true);
            return jLabel;
        }
        if (string.equals("com.jformdesigner.designer.wrapper.JGoodiesFormsSeparator")) {
            String string3 = this.getPropertyStringI18n(formComponent, "text", "");
            int n2 = formComponent.getPropertyInt("alignment", 2);
            return defaultComponentFactory.createSeparator(string3, n2);
        }
        if (string.equals("com.jformdesigner.designer.wrapper.JGoodiesFormsTitle")) {
            String string4 = this.getPropertyStringI18n(formComponent, "textWithMnemonic", "");
            JLabel jLabel = defaultComponentFactory.createTitle(string4);
            this.setObjectProperties(jLabel, formComponent, "textWithMnemonic", true);
            return jLabel;
        }
        if (string.equals("com.jformdesigner.designer.wrapper.HSpacer") || string.equals("com.jformdesigner.designer.wrapper.VSpacer")) {
            return new JPanel(null);
        }
        throw new ClassNotFoundException(string);
    }

    private Object createConstraints(LayoutCreator layoutCreator, FormLayoutConstraints formLayoutConstraints) {
        Class<?> clazz = formLayoutConstraints.getConstraintsClass();
        if (clazz == null) {
            return formLayoutConstraints;
        }
        if (clazz == String.class) {
            return formLayoutConstraints.getProperty("value");
        }
        Object object = layoutCreator.createLayoutConstraints(formLayoutConstraints);
        if (object == null) {
            object = clazz.newInstance();
            this.setObjectProperties(object, formLayoutConstraints, null, false);
        }
        return object;
    }

    private void setObjectProperties(Object object, FormObject formObject, String string, boolean bl2) {
        if (formObject.getPropertyCount() == 0) {
            return;
        }
        BeanInfoEx beanInfoEx = bl2 ? IntrospectorEx.getBeanInfoEx(object.getClass()) : null;
        for (Map.Entry<String, Object> entry : formObject.properties()) {
            Object object2;
            String string2 = entry.getKey();
            if (string2.startsWith("$") && !string2.startsWith(CLIENT_PREFIX) && !string2.startsWith(ACTION_PREFIX) || string != null && string2.equals(string) || (object2 = entry.getValue()) instanceof FormReference || object2 == null) continue;
            this.setObjectProperty(object, string2, object2, beanInfoEx);
        }
    }

    private void setObjectProperty(Object object, String string, Object object2, BeanInfoEx beanInfoEx) {
        PropertyDescriptor propertyDescriptor;
        int n2;
        if (string.startsWith("$")) {
            if (string.startsWith(CLIENT_PREFIX) && object instanceof JComponent) {
                String string2 = string.substring(CLIENT_PREFIX.length());
                if (object2 == FormObject.NULL_VALUE) {
                    object2 = null;
                }
                object2 = ObjectCloner.cloneObject(object2);
                ((JComponent)object).putClientProperty(string2, object2);
            } else if (string.startsWith(ACTION_PREFIX) && object instanceof Action) {
                String string3 = string.substring(ACTION_PREFIX.length());
                if (object2 == FormObject.NULL_VALUE) {
                    object2 = null;
                } else if (object2 instanceof SwingIcon) {
                    object2 = ((SwingIcon)object2).createIcon(this.loader);
                } else if (object2 instanceof KeyStroke) {
                    object2 = this.updateKeyStroke((KeyStroke)object2);
                } else if (object2 instanceof FormMessage) {
                    object2 = this.getString((FormMessage)object2);
                    boolean bl2 = string3.equals("SwingDisplayedMnemonicIndexKey");
                    if (string3.equals("MnemonicKey") || bl2) {
                        object2 = this.convertI18nMnemonic(object2, bl2);
                    }
                }
                object2 = ObjectCloner.cloneObject(object2);
                ((Action)object).putValue(string3, object2);
            }
            return;
        }
        boolean bl3 = false;
        if (object2 == FormObject.NULL_VALUE) {
            object2 = null;
        } else if (object2 instanceof SwingBorder) {
            object2 = UIManager.getBorder(((SwingBorder)object2).getKey());
        } else if (object2 instanceof SwingColor) {
            object2 = UIManager.getColor(((SwingColor)object2).getKey());
        } else if (object2 instanceof SwingDerivedFont) {
            object2 = ((SwingDerivedFont)object2).derive((Font)this.getObjectProperty(object, string, beanInfoEx));
        } else if (object2 instanceof SwingFont) {
            object2 = UIManager.getFont(((SwingFont)object2).getKey());
        } else if (object2 instanceof SwingIcon) {
            object2 = ((SwingIcon)object2).createIcon(this.loader);
        } else if (object2 instanceof Border) {
            object2 = this.updateBorder((Border)object2);
        } else if (object2 instanceof KeyStroke) {
            object2 = this.updateKeyStroke((KeyStroke)object2);
        } else if (object2 instanceof FormMessage) {
            object2 = this.getString((FormMessage)object2);
            bl3 = true;
        } else if (object2 instanceof FormMessageArray) {
            FormMessageArray formMessageArray = (FormMessageArray)object2;
            int n3 = formMessageArray.getLength();
            String[] stringArray = new String[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                stringArray[i2] = this.getString(formMessageArray.getMessage(i2));
            }
            object2 = stringArray;
        } else if (object2 instanceof Integer && ("mnemonic".equals(string) || "displayedMnemonic".equals(string) || "approveButtonMnemonic".equals(string)) && (n2 = ((Integer)object2).intValue()) >= 97 && n2 <= 122) {
            object2 = new Integer(n2 - 32);
        }
        object2 = ObjectCloner.cloneObject(object2);
        if (beanInfoEx != null && (propertyDescriptor = beanInfoEx.getPropertyDescriptor(string)) != null) {
            Method method;
            if (object2 instanceof ImageIcon && Image.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                object2 = ((ImageIcon)object2).getImage();
            }
            if (bl3 && object2 instanceof String && propertyDescriptor.getPropertyType() == Integer.TYPE) {
                object2 = this.convertI18nMnemonic(object2, string.endsWith("Index"));
            }
            if ((method = propertyDescriptor.getWriteMethod()) != null) {
                method.invoke(object, object2);
                this.postSetObjectProperty(object, string, object2);
                return;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(3 + string.length());
        stringBuffer.append("set").append(string);
        stringBuffer.setCharAt(3, Character.toUpperCase(stringBuffer.charAt(3)));
        Statement statement = new Statement(object, stringBuffer.toString(), new Object[]{object2});
        try {
            statement.execute();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Field field = object.getClass().getField(string);
                field.set(object, object2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw noSuchMethodException;
            }
        }
        this.postSetObjectProperty(object, string, object2);
    }

    private Object getObjectProperty(Object object, String string, BeanInfoEx beanInfoEx) {
        Method method;
        PropertyDescriptor propertyDescriptor;
        if (beanInfoEx != null && (propertyDescriptor = beanInfoEx.getPropertyDescriptor(string)) != null && (method = propertyDescriptor.getReadMethod()) != null) {
            return method.invoke(object, (Object[])null);
        }
        return null;
    }

    private Border updateBorder(Border border) {
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            String string = titledBorder.getTitle();
            if (string.startsWith(I18N_KEY_PREFIX)) {
                String string2 = this.getString(new FormMessage(null, string.substring(I18N_KEY_PREFIX.length())));
                return RuntimeUtils.cloneTitledBorder(titledBorder, string2);
            }
        } else if (border instanceof MatteBorder) {
            MatteBorder matteBorder = (MatteBorder)border;
            Icon icon = matteBorder.getTileIcon();
            if (icon instanceof SwingIcon) {
                return new MatteBorder(RuntimeUtils.getRawMatteBorderInsets(matteBorder), ((SwingIcon)icon).createIcon(this.loader));
            }
        } else if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            Border border2 = this.updateBorder(compoundBorder.getOutsideBorder());
            Border border3 = this.updateBorder(compoundBorder.getInsideBorder());
            if (border2 != compoundBorder.getOutsideBorder() || border3 != compoundBorder.getInsideBorder()) {
                return new CompoundBorder(border2, border3);
            }
        }
        return border;
    }

    private KeyStroke updateKeyStroke(KeyStroke keyStroke) {
        int n2 = keyStroke.getModifiers();
        if ((n2 & 0x1000) == 0) {
            return keyStroke;
        }
        n2 &= 0xFFFFEE79;
        return KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n2 |= Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), keyStroke.isOnKeyRelease());
    }

    private Integer convertI18nMnemonic(Object object, boolean bl2) {
        String string = (String)object;
        if (bl2) {
            return Integer.valueOf(string);
        }
        char c2 = string.charAt(0);
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 32);
        }
        return new Integer(c2);
    }

    private void postSetObjectProperty(Object object, String string, Object object2) {
        if (string.equals("model") && object instanceof JTable && object2 instanceof SwingTableModel) {
            this.applyColumnInfos((JTable)object, (SwingTableModel)object2);
        }
    }

    private void applyColumnInfos(JTable jTable, SwingTableModel swingTableModel) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = swingTableModel.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            SwingTableColumn swingTableColumn = swingTableModel.getColumnInfo(i2);
            if (swingTableColumn == null) continue;
            TableColumn tableColumn = tableColumnModel.getColumn(i2);
            if (!swingTableColumn.getResizable()) {
                tableColumn.setResizable(false);
            }
            if (swingTableColumn.getMinWidth() != 0) {
                tableColumn.setMinWidth(swingTableColumn.getMinWidth());
            }
            if (swingTableColumn.getMaxWidth() != 0) {
                tableColumn.setMaxWidth(swingTableColumn.getMaxWidth());
            }
            if (swingTableColumn.getPreferredWidth() != 0) {
                tableColumn.setPreferredWidth(swingTableColumn.getPreferredWidth());
            }
            Object[] objectArray = swingTableColumn.getValues();
            Class<?> clazz = swingTableModel.getColumnClass(i2);
            if (objectArray == null || objectArray.length <= 0 || clazz != Object.class && clazz != String.class) continue;
            tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(new DefaultComboBoxModel<Object>(objectArray))));
        }
    }

    String getPropertyStringI18n(FormObject formObject, String string, String string2) {
        Object object = formObject.getProperty(string);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof FormMessage) {
            return this.getString((FormMessage)object);
        }
        return string2;
    }

    String getString(FormMessage formMessage) {
        ResourceBundle resourceBundle;
        String string = formMessage.getBaseName();
        String string2 = formMessage.getKey();
        if (string == null) {
            if (this.defaultBundle == null) {
                String string3 = this.model.getPropertyString(PROP_I18N_BUNDLE_PACKAGE);
                String string4 = this.model.getPropertyString(PROP_I18N_BUNDLE_NAME);
                this.defaultBaseName = string3 != null ? string3 + '.' + string4 : string4;
                this.defaultBundle = this.getI18nBundle(this.defaultBaseName, this.locale, this.loader);
            }
            return this.getI18nString(this.defaultBundle, this.defaultBaseName, string2);
        }
        ResourceBundle resourceBundle2 = resourceBundle = this.bundleMap != null ? this.bundleMap.get(string) : null;
        if (resourceBundle == null) {
            resourceBundle = this.getI18nBundle(string, this.locale, this.loader);
            if (this.bundleMap == null) {
                this.bundleMap = new HashMap();
            }
            this.bundleMap.put(string, resourceBundle);
        }
        return this.getI18nString(resourceBundle, string, string2);
    }

    protected ResourceBundle getI18nBundle(String string, Locale locale, ClassLoader classLoader) {
        return ResourceBundle.getBundle(string, locale, classLoader);
    }

    protected String getI18nString(ResourceBundle resourceBundle, String string, String string2) {
        return resourceBundle.getString(string2);
    }

    void updateUIValues() {
        for (Map.Entry<FormComponent, Object> entry : this.componentMap.entrySet()) {
            FormComponent formComponent = entry.getKey();
            Object object = entry.getValue();
            BeanInfoEx beanInfoEx = null;
            for (Map.Entry<String, Object> entry2 : formComponent.properties()) {
                String string = entry2.getKey();
                Object object2 = entry2.getValue();
                if (!(object2 instanceof SwingResource)) continue;
                try {
                    if (beanInfoEx == null) {
                        beanInfoEx = IntrospectorEx.getBeanInfoEx(object.getClass());
                    }
                    this.setObjectProperty(object, string, object2, beanInfoEx);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void addEventListeners(FormComponent formComponent, Object object) {
        if (this.target == null) {
            return;
        }
        FormEvent[] formEventArray = formComponent.getEvents();
        if (formEventArray.length == 0) {
            return;
        }
        BeanInfoEx beanInfoEx = IntrospectorEx.getBeanInfoEx(object.getClass());
        for (int i2 = 0; i2 < formEventArray.length; ++i2) {
            Method method;
            FormEvent formEvent = formEventArray[i2];
            Class<?> clazz = this.loader.loadClass(formEvent.getListener());
            EventSetDescriptor eventSetDescriptor = beanInfoEx.getEventSetDescriptor(formEvent.getListener());
            if (eventSetDescriptor == null) {
                throw new IllegalStateException("Component " + formComponent.getName() + " (class " + formComponent.getClassName() + ") does not support " + formEvent.getListener() + ".");
            }
            Method method2 = this.findListenerMethod(eventSetDescriptor, formEvent.getListenerMethod());
            if (method2 == null) {
                throw new IllegalStateException("Component " + formComponent.getName() + ": Event listener " + formEvent.getListener() + " does not have a " + formEvent.getListenerMethod() + " method.");
            }
            FormCreator$HandlerInvoker formCreator$HandlerInvoker = new FormCreator$HandlerInvoker(this.target, method2, formEvent.getHandler(), formEvent.getPassParams());
            Object object2 = Proxy.newProxyInstance(this.loader, new Class[]{clazz}, (InvocationHandler)formCreator$HandlerInvoker);
            if (clazz == PropertyChangeListener.class && formEvent.getPropertyName() != null) {
                method = object.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                method.invoke(object, formEvent.getPropertyName(), object2);
                continue;
            }
            method = eventSetDescriptor.getAddListenerMethod();
            method.invoke(object, object2);
        }
    }

    private Method findListenerMethod(EventSetDescriptor eventSetDescriptor, String string) {
        Method[] methodArray = eventSetDescriptor.getListenerMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Method method = methodArray[i2];
            if (!string.equals(method.getName())) continue;
            return method;
        }
        return null;
    }
}

